/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.segment.Record;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Segment;

class ListRecord
extends Record {
    static final int LEVEL_SIZE = 255;
    static final int MAX_ELEMENTS = 16581375;
    private final int size;
    private final int bucketSize;

    ListRecord(RecordId id, int size) {
        super(id);
        Validate.checkArgument((size >= 0 ? 1 : 0) != 0, (String)"Negative list size: %s", (Object[])new Object[]{size});
        Validate.checkArgument((size <= 16581375 ? 1 : 0) != 0, (String)"Too many elements in list: %s", (Object[])new Object[]{size});
        this.size = size;
        int bs = 1;
        while (bs * 255 < size) {
            bs *= 255;
        }
        this.bucketSize = bs;
    }

    public int size() {
        return this.size;
    }

    public RecordId getEntry(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.size);
        if (this.size == 1) {
            return this.getRecordId();
        }
        int bucketIndex = index / this.bucketSize;
        int bucketOffset = index % this.bucketSize;
        Segment segment = this.getSegment();
        RecordId id = segment.readRecordId(this.getRecordNumber(), 0, bucketIndex);
        ListRecord bucket = new ListRecord(id, Math.min(this.bucketSize, this.size - bucketIndex * this.bucketSize));
        return bucket.getEntry(bucketOffset);
    }

    public List<RecordId> getEntries() {
        return this.getEntries(0, this.size);
    }

    public List<RecordId> getEntries(int index, int count) {
        if (index + count > this.size) {
            count = this.size - index;
        }
        if (count == 0) {
            return Collections.emptyList();
        }
        if (count == 1) {
            return Collections.singletonList(this.getEntry(index));
        }
        ArrayList<RecordId> ids = new ArrayList<RecordId>(count);
        this.getEntries(index, count, ids);
        return ids;
    }

    private void getEntries(int index, int count, List<RecordId> ids) {
        Preconditions.checkPositionIndexes((int)index, (int)(index + count), (int)this.size);
        Segment segment = this.getSegment();
        if (this.size == 1) {
            ids.add(this.getRecordId());
        } else if (this.bucketSize == 1) {
            for (int i = 0; i < count; ++i) {
                ids.add(segment.readRecordId(this.getRecordNumber(), 0, index + i));
            }
        } else {
            while (count > 0) {
                int bucketIndex = index / this.bucketSize;
                int bucketOffset = index % this.bucketSize;
                RecordId id = segment.readRecordId(this.getRecordNumber(), 0, bucketIndex);
                ListRecord bucket = new ListRecord(id, Math.min(this.bucketSize, this.size - bucketIndex * this.bucketSize));
                int n = Math.min(bucket.size() - bucketOffset, count);
                bucket.getEntries(bucketOffset, n, ids);
                index += n;
                count -= n;
            }
        }
    }
}

