/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.jetbrains.annotations.NotNull;

public class SegmentBufferMonitor {
    public static final String DIRECT_BUFFER_COUNT = "oak.segment.direct-buffer-count";
    public static final String DIRECT_BUFFER_CAPACITY = "oak.segment.direct-buffer-capacity";
    public static final String HEAP_BUFFER_COUNT = "oak.segment.heap-buffer-count";
    public static final String HEAP_BUFFER_CAPACITY = "oak.segment.heap-buffer-capacity";
    @NotNull
    private final Set<BufferReference> buffers = CollectionUtils.newConcurrentHashSet();
    @NotNull
    private final ReferenceQueue<Buffer> referenceQueue = new ReferenceQueue();
    @NotNull
    private final CounterStats directBufferCount;
    @NotNull
    private final CounterStats directBufferCapacity;
    @NotNull
    private final CounterStats heapBufferCount;
    @NotNull
    private final CounterStats heapBufferCapacity;

    public SegmentBufferMonitor(@NotNull StatisticsProvider statisticsProvider) {
        this.directBufferCount = statisticsProvider.getCounterStats(DIRECT_BUFFER_COUNT, StatsOptions.METRICS_ONLY);
        this.directBufferCapacity = statisticsProvider.getCounterStats(DIRECT_BUFFER_CAPACITY, StatsOptions.METRICS_ONLY);
        this.heapBufferCount = statisticsProvider.getCounterStats(HEAP_BUFFER_COUNT, StatsOptions.METRICS_ONLY);
        this.heapBufferCapacity = statisticsProvider.getCounterStats(HEAP_BUFFER_CAPACITY, StatsOptions.METRICS_ONLY);
    }

    public void trackAllocation(@NotNull Buffer buffer) {
        BufferReference reference = new BufferReference(buffer, this.referenceQueue);
        this.buffers.add(reference);
        this.allocated(reference);
        this.trackDeallocations();
    }

    private void trackDeallocations() {
        BufferReference reference = (BufferReference)this.referenceQueue.poll();
        while (reference != null) {
            this.buffers.remove(reference);
            this.deallocated(reference);
            reference = (BufferReference)this.referenceQueue.poll();
        }
    }

    private void allocated(@NotNull BufferReference reference) {
        if (reference.isDirect) {
            this.directBufferCount.inc();
            this.directBufferCapacity.inc((long)reference.capacity);
        } else {
            this.heapBufferCount.inc();
            this.heapBufferCapacity.inc((long)reference.capacity);
        }
    }

    private void deallocated(@NotNull BufferReference reference) {
        if (reference.isDirect) {
            this.directBufferCount.dec();
            this.directBufferCapacity.dec((long)reference.capacity);
        } else {
            this.heapBufferCount.dec();
            this.heapBufferCapacity.dec((long)reference.capacity);
        }
    }

    private static class BufferReference
    extends WeakReference<Buffer> {
        private final int capacity;
        private final boolean isDirect;

        public BufferReference(@NotNull Buffer buffer, @NotNull ReferenceQueue<Buffer> queue) {
            super(buffer, queue);
            this.capacity = buffer.capacity();
            this.isDirect = buffer.isDirect();
        }
    }
}

