/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.segment.ListRecord;
import org.apache.jackrabbit.oak.segment.MapEntry;
import org.apache.jackrabbit.oak.segment.MapRecord;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.Record;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Template {
    static final short ZERO_CHILD_NODES_TYPE = 0;
    static final short SINGLE_CHILD_NODE_TYPE = 1;
    static final short MANY_CHILD_NODES_TYPE = 2;
    static final String ZERO_CHILD_NODES = null;
    static final String MANY_CHILD_NODES = "";
    @NotNull
    private final SegmentReader reader;
    @Nullable
    private final PropertyState primaryType;
    @Nullable
    private final PropertyState mixinTypes;
    @NotNull
    private final PropertyTemplate[] properties;
    @Nullable
    private final String childName;

    Template(@NotNull SegmentReader reader, @Nullable PropertyState primaryType, @Nullable PropertyState mixinTypes, @Nullable PropertyTemplate[] properties, @Nullable String childName) {
        this.reader = Objects.requireNonNull(reader);
        this.primaryType = primaryType;
        this.mixinTypes = mixinTypes;
        if (properties != null) {
            this.properties = properties;
            Arrays.sort(this.properties);
        } else {
            this.properties = new PropertyTemplate[0];
        }
        this.childName = childName;
    }

    Template(@NotNull SegmentReader reader, @NotNull NodeState state) {
        this.reader = Objects.requireNonNull(reader);
        Objects.requireNonNull(state);
        PropertyState primary = null;
        PropertyState mixins = null;
        ArrayList<PropertyTemplate> templates = new ArrayList<PropertyTemplate>();
        for (PropertyState property : state.getProperties()) {
            String name = property.getName();
            Type type = property.getType();
            if ("jcr:primaryType".equals(name) && type == Type.NAME) {
                primary = property;
                continue;
            }
            if ("jcr:mixinTypes".equals(name) && type == Type.NAMES) {
                mixins = property;
                continue;
            }
            templates.add(new PropertyTemplate(property));
        }
        this.primaryType = primary;
        this.mixinTypes = mixins;
        this.properties = templates.toArray(new PropertyTemplate[templates.size()]);
        Arrays.sort(this.properties);
        long count = state.getChildNodeCount(2L);
        if (count == 0L) {
            this.childName = ZERO_CHILD_NODES;
        } else if (count == 1L) {
            this.childName = (String)state.getChildNodeNames().iterator().next();
            Validate.checkState((this.childName != null && !this.childName.equals(MANY_CHILD_NODES) ? 1 : 0) != 0);
        } else {
            this.childName = MANY_CHILD_NODES;
        }
    }

    @Nullable
    PropertyState getPrimaryType() {
        return this.primaryType;
    }

    @Nullable
    PropertyState getMixinTypes() {
        return this.mixinTypes;
    }

    PropertyTemplate[] getPropertyTemplates() {
        return this.properties;
    }

    PropertyTemplate getPropertyTemplate(String name) {
        int index;
        int hash = name.hashCode();
        for (index = 0; index < this.properties.length && this.properties[index].getName().hashCode() < hash; ++index) {
        }
        while (index < this.properties.length && this.properties[index].getName().hashCode() == hash) {
            if (name.equals(this.properties[index].getName())) {
                return this.properties[index];
            }
            ++index;
        }
        return null;
    }

    @Nullable
    String getChildName() {
        return this.childName;
    }

    SegmentPropertyState getProperty(RecordId recordId, int index) {
        Preconditions.checkElementIndex((int)index, (int)this.properties.length);
        Segment segment = Objects.requireNonNull(recordId).getSegment();
        int offset = 12;
        if (this.childName != ZERO_CHILD_NODES) {
            offset += 6;
        }
        RecordId lid = segment.readRecordId(recordId.getRecordNumber(), offset);
        ListRecord props = new ListRecord(lid, this.properties.length);
        RecordId rid = props.getEntry(index);
        return this.reader.readProperty(rid, this.properties[index]);
    }

    MapRecord getChildNodeMap(RecordId recordId) {
        Validate.checkState((this.childName != ZERO_CHILD_NODES ? 1 : 0) != 0);
        Segment segment = recordId.getSegment();
        RecordId childNodesId = segment.readRecordId(recordId.getRecordNumber(), 12);
        return this.reader.readMap(childNodesId);
    }

    public NodeState getChildNode(String name, RecordId recordId) {
        if (this.childName == ZERO_CHILD_NODES) {
            return EmptyNodeState.MISSING_NODE;
        }
        if (this.childName == MANY_CHILD_NODES) {
            MapRecord map = this.getChildNodeMap(recordId);
            MapEntry child = map.getEntry(name);
            if (child != null) {
                return child.getNodeState();
            }
            return EmptyNodeState.MISSING_NODE;
        }
        if (name.equals(this.childName)) {
            Segment segment = recordId.getSegment();
            RecordId childNodeId = segment.readRecordId(recordId.getRecordNumber(), 12);
            return this.reader.readNode(childNodeId);
        }
        return EmptyNodeState.MISSING_NODE;
    }

    Iterable<? extends ChildNodeEntry> getChildNodeEntries(RecordId recordId) {
        if (this.childName == ZERO_CHILD_NODES) {
            return Collections.emptyList();
        }
        if (this.childName == MANY_CHILD_NODES) {
            MapRecord map = this.getChildNodeMap(recordId);
            return map.getEntries();
        }
        Segment segment = recordId.getSegment();
        RecordId childNodeId = segment.readRecordId(recordId.getRecordNumber(), 12);
        return Collections.singletonList(new MemoryChildNodeEntry(this.childName, (NodeState)this.reader.readNode(childNodeId)));
    }

    public boolean compare(RecordId thisId, RecordId thatId) {
        MapRecord thatMap;
        Objects.requireNonNull(thisId);
        Objects.requireNonNull(thatId);
        for (int i = 0; i < this.properties.length; ++i) {
            SegmentPropertyState thatProperty;
            SegmentPropertyState thisProperty = this.getProperty(thisId, i);
            if (((Object)thisProperty).equals(thatProperty = this.getProperty(thatId, i))) continue;
            return false;
        }
        if (this.childName == ZERO_CHILD_NODES) {
            return true;
        }
        if (this.childName != MANY_CHILD_NODES) {
            NodeState thisChild = this.getChildNode(this.childName, thisId);
            NodeState thatChild = this.getChildNode(this.childName, thatId);
            return thisChild.equals(thatChild);
        }
        MapRecord thisMap = this.getChildNodeMap(thisId);
        if (Record.fastEquals((Object)thisMap, (Object)(thatMap = this.getChildNodeMap(thatId)))) {
            return true;
        }
        if (thisMap.size() != thatMap.size()) {
            return false;
        }
        for (MapEntry entry : thisMap.getEntries()) {
            String name = entry.getName();
            MapEntry thatEntry = thatMap.getEntry(name);
            if (thatEntry == null) {
                return false;
            }
            if (entry.getNodeState().equals(thatEntry.getNodeState())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Template) {
            Template that = (Template)object;
            return Objects.equals(this.primaryType, that.primaryType) && Objects.equals(this.mixinTypes, that.mixinTypes) && Arrays.equals(this.properties, that.properties) && Objects.equals(this.childName, that.childName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.primaryType, this.mixinTypes, Arrays.asList(this.properties), this.getTemplateType(), this.childName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        if (this.primaryType != null) {
            builder.append(this.primaryType);
            builder.append(", ");
        }
        if (this.mixinTypes != null) {
            builder.append(this.mixinTypes);
            builder.append(", ");
        }
        for (PropertyTemplate property : this.properties) {
            builder.append(property);
            builder.append(" = ?, ");
        }
        if (this.childName == ZERO_CHILD_NODES) {
            builder.append("<no children>");
        } else if (this.childName == MANY_CHILD_NODES) {
            builder.append("<many children>");
        } else {
            builder.append(this.childName + " = <node>");
        }
        builder.append(" }");
        return builder.toString();
    }

    short getTemplateType() {
        if (this.childName == ZERO_CHILD_NODES) {
            return 0;
        }
        if (this.childName == MANY_CHILD_NODES) {
            return 2;
        }
        return 1;
    }

    public int estimateMemoryUsage() {
        int size = 12;
        size += 48;
        size += StringUtils.estimateMemoryUsage((String)this.childName);
        size += Template.estimateMemoryUsage(this.mixinTypes);
        size += Template.estimateMemoryUsage(this.primaryType);
        for (PropertyTemplate property : this.properties) {
            size += property.estimateMemoryUsage();
        }
        return size;
    }

    private static int estimateMemoryUsage(PropertyState propertyState) {
        if (propertyState == null) {
            return 0;
        }
        int size = 12;
        size += StringUtils.estimateMemoryUsage((String)propertyState.getName());
        for (int k = 0; k < propertyState.count(); ++k) {
            String s = (String)propertyState.getValue(Type.STRING, k);
            size += StringUtils.estimateMemoryUsage((String)s);
        }
        return size;
    }
}

