/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentTracker;
import org.apache.jackrabbit.oak.segment.file.tar.CleanupContext;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultCleanupContext
implements CleanupContext {
    @NotNull
    private final SegmentTracker segmentTracker;
    @NotNull
    private final Predicate<GCGeneration> old;
    @Nullable
    private final UUID rootSegmentUUID;
    private boolean aheadOfRoot;

    DefaultCleanupContext(@NotNull SegmentTracker tracker, @NotNull Predicate<GCGeneration> old, @NotNull RecordId compactedRoot) {
        this.segmentTracker = tracker;
        this.old = old;
        if (compactedRoot.equals(RecordId.NULL)) {
            this.rootSegmentUUID = null;
            this.aheadOfRoot = false;
        } else {
            this.rootSegmentUUID = compactedRoot.getSegmentId().asUUID();
            this.aheadOfRoot = true;
        }
    }

    private boolean isUnreferencedBulkSegment(UUID id, boolean referenced) {
        return !SegmentId.isDataSegmentId(id.getLeastSignificantBits()) && !referenced;
    }

    private boolean isOldDataSegment(UUID id, GCGeneration generation) {
        return SegmentId.isDataSegmentId(id.getLeastSignificantBits()) && this.old.test(generation);
    }

    private boolean isDanglingFutureSegment(UUID id, GCGeneration generation) {
        return (this.aheadOfRoot &= !id.equals(this.rootSegmentUUID)) && generation.isCompacted();
    }

    public Set<UUID> initialReferences() {
        return this.segmentTracker.getReferencedSegmentIds().stream().filter(SegmentId::isBulkSegmentId).map(SegmentId::asUUID).collect(Collectors.toSet());
    }

    @Override
    public boolean shouldReclaim(UUID id, GCGeneration generation, boolean referenced) {
        return this.isDanglingFutureSegment(id, generation) || this.isUnreferencedBulkSegment(id, referenced) || this.isOldDataSegment(id, generation);
    }

    @Override
    public boolean shouldFollow(UUID from, UUID to) {
        return !SegmentId.isDataSegmentId(to.getLeastSignificantBits());
    }
}

