/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentCache;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentTracker;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.SegmentWriterFactory;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.CompactionResult;
import org.apache.jackrabbit.oak.segment.file.FileReaper;
import org.apache.jackrabbit.oak.segment.file.FileStoreStats;
import org.apache.jackrabbit.oak.segment.file.Flusher;
import org.apache.jackrabbit.oak.segment.file.GCJournal;
import org.apache.jackrabbit.oak.segment.file.GCListener;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.segment.file.GarbageCollectionStrategy;
import org.apache.jackrabbit.oak.segment.file.PrefixedGCListener;
import org.apache.jackrabbit.oak.segment.file.Reclaimers;
import org.apache.jackrabbit.oak.segment.file.SuccessfulCompactionListener;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.TarFiles;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.jetbrains.annotations.NotNull;

class GarbageCollector {
    private static final AtomicInteger GC_COUNT = new AtomicInteger(0);
    private static final long GC_BACKOFF = Integer.getInteger("oak.gc.backoff", 36000000).intValue();
    @NotNull
    private final SegmentGCOptions gcOptions;
    @NotNull
    private final PrefixedGCListener gcListener;
    @NotNull
    private final GCJournal gcJournal;
    private final AtomicBoolean sufficientMemory;
    private final FileReaper fileReaper;
    private final TarFiles tarFiles;
    private final SegmentTracker tracker;
    private final SegmentReader segmentReader;
    private final Supplier<Revisions> revisionsSupplier;
    private final BlobStore blobStore;
    private final SegmentCache segmentCache;
    private final SegmentWriter segmentWriter;
    private final FileStoreStats stats;
    private final Canceller cancel;
    private final Flusher flusher;
    private final SegmentWriterFactory segmentWriterFactory;
    private final GCNodeWriteMonitor compactionMonitor;
    private long lastSuccessfulGC;
    private SegmentGCOptions.GCType lastCompactionType = SegmentGCOptions.GCType.FULL;
    private volatile boolean cancelRequested;

    GarbageCollector(SegmentGCOptions gcOptions, GCListener gcListener, GCJournal gcJournal, AtomicBoolean sufficientMemory, FileReaper fileReaper, TarFiles tarFiles, SegmentTracker tracker, SegmentReader segmentReader, Supplier<Revisions> revisionsSupplier, BlobStore blobStore, SegmentCache segmentCache, SegmentWriter segmentWriter, FileStoreStats stats, Canceller canceller, Flusher flusher, SegmentWriterFactory segmentWriterFactory) {
        this.gcOptions = gcOptions;
        this.gcListener = new PrefixedGCListener(gcListener, GC_COUNT);
        this.gcJournal = gcJournal;
        this.sufficientMemory = sufficientMemory;
        this.fileReaper = fileReaper;
        this.tarFiles = tarFiles;
        this.tracker = tracker;
        this.segmentReader = segmentReader;
        this.revisionsSupplier = revisionsSupplier;
        this.blobStore = blobStore;
        this.segmentCache = segmentCache;
        this.segmentWriter = segmentWriter;
        this.stats = stats;
        this.cancel = canceller.withCondition("cancelled by user", () -> this.cancelRequested);
        this.flusher = flusher;
        this.segmentWriterFactory = segmentWriterFactory;
        this.compactionMonitor = new GCNodeWriteMonitor(gcOptions.getGcLogInterval(), gcListener);
    }

    private GCGeneration getGcGeneration() {
        return this.revisionsSupplier.get().getHead().getSegmentId().getGcGeneration();
    }

    GCNodeWriteMonitor getGCNodeWriteMonitor() {
        return this.compactionMonitor;
    }

    private GarbageCollectionStrategy.Context newGarbageCollectionContext(final int gcCount) {
        return new GarbageCollectionStrategy.Context(){

            @Override
            public SegmentGCOptions getGCOptions() {
                return GarbageCollector.this.gcOptions;
            }

            @Override
            public GCListener getGCListener() {
                return GarbageCollector.this.gcListener;
            }

            @Override
            public Revisions getRevisions() {
                return GarbageCollector.this.revisionsSupplier.get();
            }

            @Override
            public GCJournal getGCJournal() {
                return GarbageCollector.this.gcJournal;
            }

            @Override
            public SegmentTracker getSegmentTracker() {
                return GarbageCollector.this.tracker;
            }

            @Override
            public SegmentWriterFactory getSegmentWriterFactory() {
                return GarbageCollector.this.segmentWriterFactory;
            }

            @Override
            public GCNodeWriteMonitor getCompactionMonitor() {
                return GarbageCollector.this.compactionMonitor;
            }

            @Override
            public BlobStore getBlobStore() {
                return GarbageCollector.this.blobStore;
            }

            @Override
            public Canceller getCanceller() {
                return GarbageCollector.this.cancel;
            }

            @Override
            public long getLastSuccessfulGC() {
                return GarbageCollector.this.lastSuccessfulGC;
            }

            @Override
            public TarFiles getTarFiles() {
                return GarbageCollector.this.tarFiles;
            }

            @Override
            public AtomicBoolean getSufficientMemory() {
                return GarbageCollector.this.sufficientMemory;
            }

            @Override
            public FileReaper getFileReaper() {
                return GarbageCollector.this.fileReaper;
            }

            @Override
            public GarbageCollectionStrategy.SuccessfulGarbageCollectionListener getSuccessfulGarbageCollectionListener() {
                return () -> {
                    GarbageCollector.this.lastSuccessfulGC = System.currentTimeMillis();
                };
            }

            @Override
            public SuccessfulCompactionListener getSuccessfulCompactionListener() {
                return type -> {
                    GarbageCollector.this.lastCompactionType = type;
                };
            }

            @Override
            public Flusher getFlusher() {
                return GarbageCollector.this.flusher;
            }

            @Override
            public long getGCBackOff() {
                return GC_BACKOFF;
            }

            @Override
            public SegmentGCOptions.GCType getLastCompactionType() {
                return GarbageCollector.this.lastCompactionType;
            }

            @Override
            public int getGCCount() {
                return gcCount;
            }

            @Override
            public SegmentCache getSegmentCache() {
                return GarbageCollector.this.segmentCache;
            }

            @Override
            public FileStoreStats getFileStoreStats() {
                return GarbageCollector.this.stats;
            }

            @Override
            public SegmentReader getSegmentReader() {
                return GarbageCollector.this.segmentReader;
            }
        };
    }

    synchronized void run(GarbageCollectionStrategy strategy) throws IOException {
        this.cancelRequested = false;
        strategy.collectGarbage(this.newGarbageCollectionContext(GC_COUNT.incrementAndGet()));
    }

    synchronized void runFull(GarbageCollectionStrategy strategy) throws IOException {
        this.cancelRequested = false;
        strategy.collectFullGarbage(this.newGarbageCollectionContext(GC_COUNT.incrementAndGet()));
    }

    synchronized void runTail(GarbageCollectionStrategy strategy) throws IOException {
        this.cancelRequested = false;
        strategy.collectTailGarbage(this.newGarbageCollectionContext(GC_COUNT.incrementAndGet()));
    }

    synchronized CompactionResult compactFull(GarbageCollectionStrategy strategy) throws IOException {
        this.cancelRequested = false;
        return strategy.compactFull(this.newGarbageCollectionContext(GC_COUNT.get()));
    }

    synchronized CompactionResult compactTail(GarbageCollectionStrategy strategy) throws IOException {
        this.cancelRequested = false;
        return strategy.compactTail(this.newGarbageCollectionContext(GC_COUNT.get()));
    }

    synchronized List<String> cleanup(GarbageCollectionStrategy strategy) throws IOException {
        this.cancelRequested = false;
        return strategy.cleanup(this.newGarbageCollectionContext(GC_COUNT.get()));
    }

    synchronized void collectBlobReferences(Consumer<String> collector) throws IOException {
        this.segmentWriter.flush();
        this.tarFiles.collectBlobReferences(collector, Reclaimers.newOldReclaimer(this.lastCompactionType, this.getGcGeneration(), this.gcOptions.getRetainedGenerations()));
    }

    void cancel() {
        this.cancelRequested = true;
    }
}

