/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.jmx.StandbyStatusMBean;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyBlobReader;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyHeadReader;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyReferencesReader;
import org.apache.jackrabbit.oak.segment.standby.server.StandbySegmentReader;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyServer;
import org.apache.jackrabbit.oak.segment.standby.server.StateConsumer;
import org.apache.jackrabbit.oak.segment.standby.server.StoreProvider;
import org.apache.jackrabbit.oak.segment.standby.store.CommunicationObserver;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandbyServerSync
implements StandbyStatusMBean,
StateConsumer,
StoreProvider,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(StandbyServer.class);
    private final FileStore fileStore;
    private final CommunicationObserver observer;
    private final int port;
    private final String[] allowedClientIPRanges;
    private final boolean secure;
    private final int blobChunkSize;
    private volatile String state;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final StandbyBlobReader standbyBlobReader;
    private final StandbyHeadReader standbyHeadReader;
    private final StandbyReferencesReader standbyReferencesReader;
    private final StandbySegmentReader standbySegmentReader;
    private StandbyServer server;
    private final String sslKeyFile;
    private final String sslKeyPassword;
    private final String sslChainFile;
    private final boolean sslValidateClient;
    private final String sslSubjectPattern;

    public static Builder builder() {
        return new Builder();
    }

    private StandbyServerSync(Builder builder) {
        this.port = builder.port;
        this.fileStore = builder.fileStore;
        this.blobChunkSize = builder.blobChunkSize;
        this.allowedClientIPRanges = builder.allowedClientIPRanges;
        this.secure = builder.secure;
        this.standbyBlobReader = builder.standbyBlobReader;
        this.standbyHeadReader = builder.standbyHeadReader;
        this.standbyReferencesReader = builder.standbyReferencesReader;
        this.standbySegmentReader = builder.standbySegmentReader;
        this.sslKeyFile = builder.sslKeyFile;
        this.sslKeyPassword = builder.sslKeyPassword;
        this.sslChainFile = builder.sslChainFile;
        this.sslValidateClient = builder.sslValidateClient;
        this.sslSubjectPattern = builder.sslSubjectPattern;
        this.observer = new CommunicationObserver("primary");
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            jmxServer.registerMBean(new StandardMBean(this, StandbyStatusMBean.class), new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            log.error("can't register standby status mbean", (Throwable)e);
        }
    }

    @Override
    public void consumeState(String state) {
        this.state = state;
    }

    @Override
    public FileStore provideStore() {
        return this.fileStore;
    }

    @Override
    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.state = "starting";
        try {
            StandbyServer.Builder builder = StandbyServer.builder(this.port, this, this.blobChunkSize).secure(this.secure).allowIPRanges(this.allowedClientIPRanges).withStateConsumer(this).withObserver(this.observer).withStandbyBlobReader(this.standbyBlobReader).withStandbyHeadReader(this.standbyHeadReader).withStandbyReferencesReader(this.standbyReferencesReader).withStandbySegmentReader(this.standbySegmentReader).withSSLKeyFile(this.sslKeyFile).withSSLKeyPassword(this.sslKeyPassword).withSSLChainFile(this.sslChainFile).withSSLClientValidation(this.sslValidateClient).withSSLSubjectPattern(this.sslSubjectPattern);
            this.server = builder.build();
            this.server.start();
            this.state = "running";
            this.running.set(true);
        }
        catch (Exception e) {
            log.error("Server could not be started.", (Throwable)e);
            this.state = null;
            this.running.set(false);
        }
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
        this.running.set(false);
        this.state = "stopped";
    }

    @Override
    public void close() {
        this.stop();
        this.state = "closing";
        if (this.server != null) {
            this.server.close();
        }
        this.observer.unregister();
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            jmxServer.unregisterMBean(new ObjectName(this.getMBeanName()));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            log.error("can't unregister standby status mbean", (Throwable)e);
        }
        this.state = "closed";
    }

    @Override
    @NotNull
    public String getMode() {
        return "primary";
    }

    @Override
    public String getStatus() {
        return this.state == null ? "initializing" : this.state;
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    public String getMBeanName() {
        return "org.apache.jackrabbit.oak:name=Status,type=\"Standby\",id=" + this.port;
    }

    public static class Builder {
        private int port;
        private FileStore fileStore;
        private int blobChunkSize;
        private boolean secure;
        private String[] allowedClientIPRanges;
        private StandbyBlobReader standbyBlobReader;
        private StandbyHeadReader standbyHeadReader;
        private StandbyReferencesReader standbyReferencesReader;
        private StandbySegmentReader standbySegmentReader;
        private String sslKeyFile;
        private String sslChainFile;
        private boolean sslValidateClient;
        private String sslKeyPassword;
        private String sslSubjectPattern;

        private Builder() {
        }

        public Builder withPort(int port) {
            Validate.checkArgument((port > 0 ? 1 : 0) != 0, (String)"port");
            this.port = port;
            return this;
        }

        public Builder withFileStore(FileStore fileStore) {
            Validate.checkArgument((fileStore != null ? 1 : 0) != 0, (String)"fileStore");
            this.fileStore = fileStore;
            return this;
        }

        public Builder withBlobChunkSize(int blobChunkSize) {
            Validate.checkArgument((blobChunkSize > 0 ? 1 : 0) != 0, (String)"blobChunkSize");
            this.blobChunkSize = blobChunkSize;
            return this;
        }

        public Builder withSecureConnection(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder withAllowedClientIPRanges(String[] allowedClientIPRanges) {
            this.allowedClientIPRanges = allowedClientIPRanges;
            return this;
        }

        Builder withStandbyBlobReader(StandbyBlobReader standbyBlobReader) {
            Validate.checkArgument((standbyBlobReader != null ? 1 : 0) != 0, (String)"standbyBlobReader");
            this.standbyBlobReader = standbyBlobReader;
            return this;
        }

        Builder withStandbyHeadReader(StandbyHeadReader standbyHeadReader) {
            Validate.checkArgument((standbyHeadReader != null ? 1 : 0) != 0, (String)"standbyHeadReader");
            this.standbyHeadReader = standbyHeadReader;
            return this;
        }

        Builder withStandbyReferencesReader(StandbyReferencesReader standbyReferencesReader) {
            Validate.checkArgument((standbyReferencesReader != null ? 1 : 0) != 0, (String)"standbyReferencesReader");
            this.standbyReferencesReader = standbyReferencesReader;
            return this;
        }

        Builder withStandbySegmentReader(StandbySegmentReader standbySegmentReader) {
            Validate.checkArgument((standbySegmentReader != null ? 1 : 0) != 0, (String)"standbySegmentReader");
            this.standbySegmentReader = standbySegmentReader;
            return this;
        }

        public Builder withSSLKeyFile(String sslKeyFile) {
            this.sslKeyFile = sslKeyFile;
            return this;
        }

        public Builder withSSLKeyPassword(String sslKeyPassword) {
            this.sslKeyPassword = sslKeyPassword;
            return this;
        }

        public Builder withSSLChainFile(String sslChainFile) {
            this.sslChainFile = sslChainFile;
            return this;
        }

        public Builder withSSLClientValidation(boolean sslValidateClient) {
            this.sslValidateClient = sslValidateClient;
            return this;
        }

        public Builder withSSLSubjectPattern(String sslSubjectPattern) {
            this.sslSubjectPattern = sslSubjectPattern;
            return this;
        }

        public StandbyServerSync build() {
            Validate.checkArgument((this.port > 0 ? 1 : 0) != 0);
            Validate.checkArgument((this.fileStore != null ? 1 : 0) != 0);
            Validate.checkArgument((this.blobChunkSize > 0 ? 1 : 0) != 0);
            return new StandbyServerSync(this);
        }
    }
}

