/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.oak.commons.collections.ListUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.commons.json.JsonObject;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.JournalReader;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.file.tar.LocalJournalFile;
import org.apache.jackrabbit.oak.segment.file.tooling.BasicReadOnlyBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

public final class Utils {
    private static final boolean TAR_STORAGE_MEMORY_MAPPED = Boolean.getBoolean("tar.memoryMapped");
    private static final int TAR_SEGMENT_CACHE_SIZE = Integer.getInteger("cache", 256);

    private Utils() {
    }

    static ReadOnlyFileStore openReadOnlyFileStore(File path, BlobStore blobStore) throws IOException, InvalidFileStoreVersionException {
        return FileStoreBuilder.fileStoreBuilder(Utils.isValidFileStoreOrFail(path)).withSegmentCacheSize(TAR_SEGMENT_CACHE_SIZE).withMemoryMapping(TAR_STORAGE_MEMORY_MAPPED).withBlobStore(blobStore).buildReadOnly();
    }

    static ReadOnlyFileStore openReadOnlyFileStore(File path) throws IOException, InvalidFileStoreVersionException {
        return FileStoreBuilder.fileStoreBuilder(Utils.isValidFileStoreOrFail(path)).withSegmentCacheSize(TAR_SEGMENT_CACHE_SIZE).withMemoryMapping(TAR_STORAGE_MEMORY_MAPPED).buildReadOnly();
    }

    public static BlobStore newBasicReadOnlyBlobStore() {
        return new BasicReadOnlyBlobStore();
    }

    public static List<String> readRevisions(String path) {
        return Utils.readRevisions(new File(path));
    }

    public static List<String> readRevisions(File store) {
        LocalJournalFile journal = new LocalJournalFile(store, "journal.log");
        if (journal.exists()) {
            List list;
            JournalReader journalReader = new JournalReader(journal);
            try {
                Iterator revisionIterator = Iterators.transform((Iterator)((Object)journalReader), entry -> entry.getRevision());
                list = ListUtils.toList((Iterator)revisionIterator);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        journalReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            journalReader.close();
            return list;
        }
        return new ArrayList<String>();
    }

    private static File isValidFileStoreOrFail(File store) {
        Validate.checkArgument((boolean)Utils.isValidFileStore(store), (String)("Invalid FileStore directory " + store));
        return store;
    }

    private static boolean isValidFileStore(File store) {
        if (!store.exists()) {
            return false;
        }
        if (!store.isDirectory()) {
            return false;
        }
        String[] fileNames = store.list();
        if (fileNames == null) {
            return false;
        }
        for (String f : fileNames) {
            if (!"journal.log".equals(f)) continue;
            return true;
        }
        return false;
    }

    static Long parseSegmentInfoTimestamp(SegmentId segmentId) {
        long timestamp;
        String segmentInfo = segmentId.getSegment().getSegmentInfo();
        if (segmentInfo == null) {
            return null;
        }
        JsopTokenizer t = new JsopTokenizer(segmentInfo, 0);
        t.read(123);
        JsonObject object = JsonObject.create((JsopTokenizer)t);
        String timestampString = (String)object.getProperties().get("t");
        if (timestampString == null) {
            return null;
        }
        try {
            timestamp = Long.parseLong(timestampString);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return timestamp;
    }
}

