/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundExceptionListener;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreStatsMBean;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;
import org.jetbrains.annotations.NotNull;

public class FileStoreStats
implements FileStoreStatsMBean,
FileStoreMonitor,
SegmentNotFoundExceptionListener {
    public static final String SEGMENT_REPO_SIZE = "SEGMENT_REPO_SIZE";
    public static final String SEGMENT_WRITES = "SEGMENT_WRITES";
    public static final String JOURNAL_WRITES = "JOURNAL_WRITES";
    private static final String SNFE_COUNT = "SNFE_COUNT";
    private final StatisticsProvider statisticsProvider;
    private final FileStore store;
    private final MeterStats writeStats;
    private final CounterStats repoSize;
    private final MeterStats journalWriteStats;
    private final CounterStats snfeCountStats;

    public FileStoreStats(StatisticsProvider statisticsProvider, FileStore store, long initialSize) {
        this.statisticsProvider = statisticsProvider;
        this.store = store;
        this.writeStats = statisticsProvider.getMeter(SEGMENT_WRITES, StatsOptions.DEFAULT);
        this.repoSize = statisticsProvider.getCounterStats(SEGMENT_REPO_SIZE, StatsOptions.DEFAULT);
        this.journalWriteStats = statisticsProvider.getMeter(JOURNAL_WRITES, StatsOptions.DEFAULT);
        this.snfeCountStats = statisticsProvider.getCounterStats(SNFE_COUNT, StatsOptions.DEFAULT);
        this.repoSize.inc(initialSize);
    }

    public void init(long initialSize) {
        this.repoSize.inc(initialSize);
    }

    @Override
    public void notify(@NotNull SegmentId id, @NotNull SegmentNotFoundException snfe) {
        this.snfeCountStats.inc();
    }

    @Override
    public void written(long delta) {
        this.writeStats.mark(delta);
        this.repoSize.inc(delta);
    }

    @Override
    public void reclaimed(long size) {
        this.repoSize.dec(size);
    }

    @Override
    public void flushed() {
        this.journalWriteStats.mark();
    }

    @Override
    public long getApproximateSize() {
        return this.repoSize.getCount();
    }

    @Override
    public int getTarFileCount() {
        return this.store.readerCount() + 1;
    }

    @Override
    public int getSegmentCount() {
        return this.store.getSegmentCount();
    }

    @Override
    @NotNull
    public CompositeData getWriteStats() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(SEGMENT_WRITES), (String)SEGMENT_WRITES);
    }

    @Override
    @NotNull
    public CompositeData getRepositorySize() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(SEGMENT_REPO_SIZE), (String)SEGMENT_REPO_SIZE);
    }

    @Override
    public String fileStoreInfoAsString() {
        return String.format("Segment store size : %s%nNumber of tar files : %d", IOUtils.humanReadableByteCount((long)this.getApproximateSize()), this.getTarFileCount());
    }

    @Override
    public long getJournalWriteStatsAsCount() {
        return this.journalWriteStats.getCount();
    }

    @Override
    public CompositeData getJournalWriteStatsAsCompositeData() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(JOURNAL_WRITES), (String)JOURNAL_WRITES);
    }

    private TimeSeries getTimeSeries(String name) {
        return this.statisticsProvider.getStats().getTimeSeries(name, true);
    }
}

