/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.split;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.persistence.GCJournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.ManifestFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.RepositoryLock;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.split.SplitJournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.split.SplitSegmentArchiveManager;

public class SplitPersistence
implements SegmentNodeStorePersistence {
    private final SegmentNodeStorePersistence roPersistence;
    private final SegmentNodeStorePersistence rwPersistence;
    private final Optional<String> lastRoArchive;
    private final Optional<String> lastRoJournalEntry;

    public SplitPersistence(SegmentNodeStorePersistence roPersistence, SegmentNodeStorePersistence rwPersistence) throws IOException {
        this.roPersistence = roPersistence;
        this.rwPersistence = rwPersistence;
        ManifestFile manifest = rwPersistence.getManifestFile();
        if (!manifest.exists()) {
            this.initialize();
        }
        Properties properties = manifest.load();
        this.lastRoArchive = Optional.ofNullable(properties.getProperty("split.lastRoArchive"));
        this.lastRoJournalEntry = Optional.ofNullable(properties.getProperty("split.lastRoJournalEntry"));
    }

    private void initialize() throws IOException {
        Properties properties = this.roPersistence.getManifestFile().load();
        properties.setProperty("split.initialized", "true");
        try (JournalFileReader journalFileReader = this.roPersistence.getJournalFile().openJournalReader();){
            String journalLine = journalFileReader.readLine();
            if (journalLine != null) {
                properties.setProperty("split.lastRoJournalEntry", journalLine);
            }
        }
        Optional<String> lastArchive = this.getLastArchive();
        lastArchive.ifPresent(a -> properties.setProperty("split.lastRoArchive", (String)a));
        this.rwPersistence.getManifestFile().save(properties);
        GCJournalFile gcJournalFile = this.rwPersistence.getGCJournalFile();
        for (String line : this.roPersistence.getGCJournalFile().readLines()) {
            gcJournalFile.writeLine(line);
        }
    }

    private Optional<String> getLastArchive() throws IOException {
        SegmentArchiveManager manager = this.roPersistence.createArchiveManager(false, false, new IOMonitorAdapter(), new FileStoreMonitorAdapter(), new RemoteStoreMonitorAdapter());
        List<String> archives = manager.listArchives();
        if (archives.isEmpty()) {
            return Optional.empty();
        }
        Collections.sort(archives);
        return Optional.of(archives.get(archives.size() - 1));
    }

    @Override
    public SegmentArchiveManager createArchiveManager(boolean memoryMapping, boolean offHeapAccess, IOMonitor ioMonitor, FileStoreMonitor fileStoreMonitor, RemoteStoreMonitor remoteStoreMonitor) throws IOException {
        if (this.lastRoArchive.isPresent()) {
            return new SplitSegmentArchiveManager(this.roPersistence.createArchiveManager(memoryMapping, offHeapAccess, ioMonitor, fileStoreMonitor, remoteStoreMonitor), this.rwPersistence.createArchiveManager(memoryMapping, offHeapAccess, ioMonitor, fileStoreMonitor, new RemoteStoreMonitorAdapter()), this.lastRoArchive.get());
        }
        return this.rwPersistence.createArchiveManager(memoryMapping, offHeapAccess, ioMonitor, fileStoreMonitor, new RemoteStoreMonitorAdapter());
    }

    @Override
    public boolean segmentFilesExist() {
        return this.lastRoArchive.isPresent() || this.rwPersistence.segmentFilesExist();
    }

    @Override
    public JournalFile getJournalFile() {
        return new SplitJournalFile(this.roPersistence.getJournalFile(), this.rwPersistence.getJournalFile(), this.lastRoJournalEntry);
    }

    @Override
    public GCJournalFile getGCJournalFile() throws IOException {
        return this.rwPersistence.getGCJournalFile();
    }

    @Override
    public ManifestFile getManifestFile() throws IOException {
        return this.rwPersistence.getManifestFile();
    }

    @Override
    public RepositoryLock lockRepository() throws IOException {
        return this.rwPersistence.lockRepository();
    }
}

