/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.oak.segment.file.JournalEntry;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JournalReader
extends AbstractIterator<JournalEntry>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(JournalReader.class);
    private final JournalFileReader reader;

    public JournalReader(JournalFile journal) throws IOException {
        this.reader = journal.openJournalReader();
    }

    protected JournalEntry computeNext() {
        try {
            String line = null;
            while ((line = this.reader.readLine()) != null) {
                if (line.indexOf(32) != -1) {
                    List splits = Stream.of(line.split(" ", -1)).collect(Collectors.toList());
                    String revision = (String)splits.get(0);
                    long timestamp = -1L;
                    if (splits.size() > 2) {
                        try {
                            timestamp = Long.parseLong((String)splits.get(2));
                        }
                        catch (NumberFormatException e) {
                            LOG.warn("Ignoring malformed timestamp {} for revision {}", splits.get(2), (Object)revision);
                        }
                    } else {
                        LOG.warn("Timestamp information is missing for revision {}", (Object)revision);
                    }
                    return new JournalEntry(revision, timestamp);
                }
                LOG.warn("Skipping invalid journal entry: {}", (Object)line);
            }
        }
        catch (IOException e) {
            LOG.error("Error reading journal file", (Throwable)e);
        }
        return (JournalEntry)this.endOfData();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

