/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.AbstractCompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.CompactionResult;
import org.apache.jackrabbit.oak.segment.file.CompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class TailCompactionStrategy
extends AbstractCompactionStrategy {
    TailCompactionStrategy() {
    }

    @Override
    SegmentGCOptions.GCType getCompactionType() {
        return SegmentGCOptions.GCType.TAIL;
    }

    @Override
    GCGeneration partialGeneration(GCGeneration current) {
        return current.nextPartial();
    }

    @Override
    GCGeneration targetGeneration(GCGeneration current) {
        return current.nextTail();
    }

    @Override
    public CompactionResult compact(CompactionStrategy.Context context) {
        NodeState base = TailCompactionStrategy.getBase(context);
        if (base == null) {
            context.getGCListener().info("no base state available, tail compaction is not applicable", new Object[0]);
            return CompactionResult.notApplicable(context.getGCCount());
        }
        return this.compact(context, base);
    }

    private static NodeState getBase(CompactionStrategy.Context context) {
        RecordId id = TailCompactionStrategy.getLastCompactedRootId(context);
        if (RecordId.NULL.equals(id)) {
            return null;
        }
        try {
            NodeState node = TailCompactionStrategy.getLastCompactedRootNode(context);
            node.getPropertyCount();
            return node;
        }
        catch (SegmentNotFoundException e) {
            context.getGCListener().error("base state " + String.valueOf(id) + " is not accessible", (Exception)((Object)e));
            return null;
        }
    }

    private static String getLastCompactedRoot(CompactionStrategy.Context context) {
        return context.getGCJournal().read().getRoot();
    }

    private static RecordId getLastCompactedRootId(CompactionStrategy.Context context) {
        return RecordId.fromString(context.getSegmentTracker(), TailCompactionStrategy.getLastCompactedRoot(context));
    }

    private static NodeState getLastCompactedRootNode(CompactionStrategy.Context context) {
        return context.getSegmentReader().readNode(TailCompactionStrategy.getLastCompactedRootId(context));
    }
}

