/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.json.JsopDiff;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.tool.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class DebugSegments {
    private static final Pattern SEGMENT_REGEX = Pattern.compile("([0-9a-f-]+)|(([0-9a-f-]+:[0-9a-f]+)(-([0-9a-f-]+:[0-9a-f]+))?)?(/.*)?");
    private final File path;
    private final List<String> segments;

    public static Builder builder() {
        return new Builder();
    }

    private DebugSegments(Builder builder) {
        this.path = builder.path;
        this.segments = new ArrayList<String>(builder.segments);
    }

    public int run() {
        ReadOnlyFileStore store = Utils.openReadOnlyFileStore(this.path);
        try {
            this.debugSegments(store);
            int n = 0;
            if (store != null) {
                store.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (store != null) {
                    try {
                        store.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return 1;
            }
        }
    }

    private void debugSegments(ReadOnlyFileStore store) {
        for (String segment : this.segments) {
            DebugSegments.debugSegment(store, segment);
        }
    }

    private static void debugSegment(ReadOnlyFileStore store, String segment) {
        Matcher matcher = SEGMENT_REGEX.matcher(segment);
        if (!matcher.matches()) {
            System.err.println("Unknown argument: " + segment);
            return;
        }
        if (matcher.group(1) != null) {
            UUID uuid = UUID.fromString(matcher.group(1));
            SegmentId id = store.getSegmentIdProvider().newSegmentId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
            System.out.println(id.getSegment());
            return;
        }
        RecordId id1 = store.getRevisions().getHead();
        RecordId id2 = null;
        if (matcher.group(2) != null) {
            id1 = RecordId.fromString(store.getSegmentIdProvider(), matcher.group(3));
            if (matcher.group(4) != null) {
                id2 = RecordId.fromString(store.getSegmentIdProvider(), matcher.group(5));
            }
        }
        String path = "/";
        if (matcher.group(6) != null) {
            path = matcher.group(6);
        }
        if (id2 == null) {
            SegmentNodeState node = store.getReader().readNode(id1);
            System.out.println("/ (" + String.valueOf(id1) + ") -> " + String.valueOf(node));
            for (String name : PathUtils.elements((String)path)) {
                node = node.getChildNode(name);
                RecordId nid = null;
                if (node instanceof SegmentNodeState) {
                    nid = node.getRecordId();
                }
                System.out.println("  " + name + " (" + String.valueOf(nid) + ") -> " + String.valueOf(node));
            }
            return;
        }
        SegmentNodeState node1 = store.getReader().readNode(id1);
        SegmentNodeState node2 = store.getReader().readNode(id2);
        for (String name : PathUtils.elements((String)path)) {
            node1 = node1.getChildNode(name);
            node2 = node2.getChildNode(name);
        }
        System.out.println(JsopBuilder.prettyPrint((String)JsopDiff.diffToJsop((NodeState)node1, (NodeState)node2)));
    }

    public static class Builder {
        private File path;
        private final List<String> segments = new ArrayList<String>();

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        public Builder withSegment(String segment) {
            this.segments.add(Objects.requireNonNull(segment));
            return this;
        }

        public DebugSegments build() {
            Objects.requireNonNull(this.path);
            Validate.checkArgument((!this.segments.isEmpty() ? 1 : 0) != 0);
            return new DebugSegments(this);
        }
    }
}

