/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CommitsTracker {
    private final String[] threadGroups;
    private final int otherWritersLimit;
    private final ConcurrentMap<String, Commit> queuedWritersMap;
    private final Queue<Commit> commits = new ConcurrentLinkedQueue<Commit>();
    private volatile Commit currentCommit;

    CommitsTracker(String[] threadGroups, int otherWritersLimit) {
        this.threadGroups = threadGroups;
        this.otherWritersLimit = otherWritersLimit;
        this.queuedWritersMap = new ConcurrentHashMap<String, Commit>();
    }

    public void trackQueuedCommitOf(Thread thread, Supplier<GCGeneration> gcGeneration) {
        this.queuedWritersMap.put(thread.getName(), new Commit(thread, gcGeneration).queued());
    }

    public void trackDequedCommitOf(Thread thread) {
        this.currentCommit = (Commit)this.queuedWritersMap.remove(thread.getName());
        if (this.currentCommit != null) {
            this.currentCommit.dequeued();
        }
    }

    public void trackExecutedCommitOf(Thread thread) {
        long t = System.currentTimeMillis();
        Iterator it = this.commits.iterator();
        while (it.hasNext() && ((Commit)it.next()).getQueued() < t - 60000L) {
            it.remove();
        }
        if (this.currentCommit != null) {
            this.currentCommit.applied();
            this.commits.offer(this.currentCommit);
            this.currentCommit = null;
        }
    }

    public Map<String, Commit> getQueuedWritersMap() {
        return new HashMap<String, Commit>(this.queuedWritersMap);
    }

    @Nullable
    public Commit getCurrentWriter() {
        return this.currentCommit;
    }

    private String findGroupFor(String thread) {
        if (this.threadGroups == null) {
            return "other";
        }
        for (String group : this.threadGroups) {
            if (!thread.matches(group)) continue;
            return group;
        }
        return "other";
    }

    public Map<String, Long> getCommitsCountPerGroupLastMinute() {
        HashMap<String, Long> commitsPerGroup = new HashMap<String, Long>();
        long t = System.currentTimeMillis() - 60000L;
        for (Commit commit : this.commits) {
            String group;
            if (commit.getQueued() <= t || "other".equals(group = this.findGroupFor(commit.threadName))) continue;
            commitsPerGroup.compute(group, (k, v) -> v == null ? 1L : v + 1L);
        }
        return Collections.unmodifiableMap(commitsPerGroup);
    }

    public Map<String, Long> getCommitsCountOthersLastMinute() {
        LRUMap commitsOther = new LRUMap(this.otherWritersLimit);
        long t = System.currentTimeMillis() - 60000L;
        for (Commit commit : this.commits) {
            String group;
            if (commit.getQueued() <= t || !"other".equals(group = this.findGroupFor(commit.threadName))) continue;
            commitsOther.compute(commit.threadName, (k, v) -> v == null ? 1L : v + 1L);
        }
        return Collections.unmodifiableMap(commitsOther);
    }

    static final class Commit {
        private final String threadName;
        private final WeakReference<Thread> thread;
        private final Supplier<GCGeneration> gcGeneration;
        private long queued;
        private long dequeued;
        private long applied;

        Commit(Thread thread, Supplier<GCGeneration> gcGeneration) {
            this.threadName = thread.getName();
            this.gcGeneration = gcGeneration;
            this.thread = new WeakReference<Thread>(thread);
        }

        @NotNull
        Commit queued() {
            this.queued = System.currentTimeMillis();
            return this;
        }

        @NotNull
        Commit dequeued() {
            this.dequeued = System.currentTimeMillis();
            return this;
        }

        @NotNull
        Commit applied() {
            this.applied = System.currentTimeMillis();
            return this;
        }

        @Nullable
        StackTraceElement[] getStackTrace() {
            Thread t = (Thread)this.thread.get();
            return t == null ? null : t.getStackTrace();
        }

        @NotNull
        String getThreadName() {
            return this.threadName;
        }

        @Nullable
        GCGeneration getGCGeneration() {
            return this.gcGeneration.get();
        }

        long getQueued() {
            return this.queued;
        }

        long getDequeued() {
            return this.dequeued;
        }

        long getApplied() {
            return this.applied;
        }
    }
}

