/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.data.SegmentData;
import org.apache.jackrabbit.oak.segment.data.SegmentDataUtils;

class SegmentDataV12
implements SegmentData {
    private static final int HEADER_SIZE = 32;
    private static final int SIGNATURE_OFFSET = 0;
    private static final int SIGNATURE_LENGTH = 3;
    private static final int VERSION_OFFSET = 3;
    private static final int GENERATION_OFFSET = 10;
    private static final int SEGMENT_REFERENCES_COUNT_OFFSET = 14;
    private static final int SEGMENT_REFERENCE_LENGTH = 16;
    private static final int RECORD_REFERENCES_COUNT_OFFSET = 18;
    private static final int RECORD_REFERENCE_LENGTH = 9;
    private static final int SEGMENT_REFERENCE_MSB_OFFSET = 0;
    private static final int SEGMENT_REFERENCE_LSB_OFFSET = 8;
    private static final int RECORD_REFERENCE_NUMBER_OFFSET = 0;
    private static final int RECORD_REFERENCE_TYPE_OFFSET = 4;
    private static final int RECORD_REFERENCE_OFFSET_OFFSET = 5;
    final Buffer buffer;

    SegmentDataV12(Buffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public byte getVersion() {
        return this.buffer.get(3);
    }

    @Override
    public String getSignature() {
        byte[] signature = new byte[3];
        for (int i = 0; i < 3; ++i) {
            signature[i] = this.buffer.get(0 + i);
        }
        return new String(signature, StandardCharsets.UTF_8);
    }

    @Override
    public int getFullGeneration() {
        return this.getGeneration();
    }

    @Override
    public boolean isCompacted() {
        return true;
    }

    @Override
    public int getGeneration() {
        return this.buffer.getInt(10);
    }

    @Override
    public int getSegmentReferencesCount() {
        return this.buffer.getInt(14);
    }

    @Override
    public int getRecordReferencesCount() {
        return this.buffer.getInt(18);
    }

    private int getRecordReferenceBase(int i) {
        return 32 + this.getSegmentReferencesCount() * 16 + i * 9;
    }

    @Override
    public int getRecordReferenceNumber(int i) {
        return this.buffer.getInt(this.getRecordReferenceBase(i) + 0);
    }

    @Override
    public byte getRecordReferenceType(int i) {
        return this.buffer.get(this.getRecordReferenceBase(i) + 4);
    }

    @Override
    public int getRecordReferenceOffset(int i) {
        return this.buffer.getInt(this.getRecordReferenceBase(i) + 5);
    }

    private int getSegmentReferenceBase(int i) {
        return 32 + i * 16;
    }

    @Override
    public long getSegmentReferenceMsb(int i) {
        return this.buffer.getLong(this.getSegmentReferenceBase(i) + 0);
    }

    @Override
    public long getSegmentReferenceLsb(int i) {
        return this.buffer.getLong(this.getSegmentReferenceBase(i) + 8);
    }

    private int index(int recordReferenceOffset) {
        return SegmentDataUtils.index(this.buffer, recordReferenceOffset);
    }

    @Override
    public byte readByte(int recordReferenceOffset) {
        return this.buffer.get(this.index(recordReferenceOffset));
    }

    @Override
    public int readInt(int recordReferenceOffset) {
        return this.buffer.getInt(this.index(recordReferenceOffset));
    }

    @Override
    public short readShort(int recordReferenceOffset) {
        return this.buffer.getShort(this.index(recordReferenceOffset));
    }

    @Override
    public long readLong(int recordReferenceOffset) {
        return this.buffer.getLong(this.index(recordReferenceOffset));
    }

    @Override
    public Buffer readBytes(int recordReferenceOffset, int size) {
        return SegmentDataUtils.readBytes(this.buffer, this.index(recordReferenceOffset), size);
    }

    @Override
    public int size() {
        return this.buffer.remaining();
    }

    @Override
    public void hexDump(OutputStream stream) throws IOException {
        SegmentDataUtils.hexDump(this.buffer, stream);
    }

    @Override
    public void binDump(OutputStream stream) throws IOException {
        SegmentDataUtils.binDump(this.buffer, stream);
    }

    @Override
    public int estimateMemoryUsage() {
        return SegmentDataUtils.estimateMemoryUsage(this.buffer);
    }
}

