/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.jetbrains.annotations.NotNull;

public class GCNodeWriteMonitor {
    public static final GCNodeWriteMonitor EMPTY = new GCNodeWriteMonitor(-1L, GCMonitor.EMPTY);
    private final long gcProgressLog;
    private final GCMonitor gcMonitor;
    private long start = 0L;
    private long estimated = -1L;
    private long nodes;
    private long properties;
    private long binaries;
    private boolean running = false;

    public GCNodeWriteMonitor(long gcProgressLog, @NotNull GCMonitor gcMonitor) {
        this.gcProgressLog = gcProgressLog;
        this.gcMonitor = gcMonitor;
    }

    public synchronized void init(long prevSize, long prevCompactedNodes, long currentSize) {
        if (prevCompactedNodes > 0L) {
            this.estimated = (long)((double)currentSize / (double)prevSize * (double)prevCompactedNodes);
            this.gcMonitor.info("estimated number of nodes to compact is {}, based on {} nodes compacted to {} bytes on disk in previous compaction and current size of {} bytes on disk.", new Object[]{this.estimated, prevCompactedNodes, prevSize, currentSize});
        } else {
            this.gcMonitor.info("unable to estimate number of nodes for compaction, missing gc history.", new Object[0]);
        }
        this.nodes = 0L;
        this.properties = 0L;
        this.binaries = 0L;
        this.start = System.currentTimeMillis();
        this.running = true;
    }

    public synchronized void onNode() {
        ++this.nodes;
        if (this.gcProgressLog > 0L && this.nodes % this.gcProgressLog == 0L) {
            this.gcMonitor.info("compacted {} nodes, {} properties, {} binaries in {} ms. {}", new Object[]{this.nodes, this.properties, this.binaries, System.currentTimeMillis() - this.start, this.getPercentageDone()});
        }
    }

    public synchronized void onProperty() {
        ++this.properties;
    }

    public synchronized void onBinary() {
        ++this.binaries;
    }

    public synchronized void finished() {
        this.running = false;
    }

    public synchronized long getCompactedNodes() {
        return this.nodes;
    }

    public synchronized long getEstimatedTotal() {
        return this.estimated;
    }

    @NotNull
    private String getPercentageDone() {
        return this.estimated > 0L ? this.getEstimatedPercentage() + "% complete." : "";
    }

    public synchronized int getEstimatedPercentage() {
        if (this.estimated > 0L) {
            if (!this.running) {
                return 100;
            }
            return Math.min((int)(100.0 * ((double)this.nodes / (double)this.estimated)), 99);
        }
        return -1;
    }

    public synchronized boolean isCompactionRunning() {
        return this.running;
    }

    public long getGcProgressLog() {
        return this.gcProgressLog;
    }
}

