/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.migration.FilteringNodeState;
import org.apache.jackrabbit.oak.plugins.migration.report.LoggingReporter;
import org.apache.jackrabbit.oak.plugins.migration.report.Reporter;
import org.apache.jackrabbit.oak.plugins.migration.report.ReportingNodeState;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfo;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialContentMigrator {
    private static final int LOG_NODE_COPY = Integer.getInteger("oak.upgrade.logNodeCopy", 10000);
    private static final String CLUSTER_ID = System.getProperty("oak.composite.seed.clusterId", "1");
    private static final Set<String> DEFAULT_IGNORED_PATHS = ImmutableSet.of((Object)"/:clusterConfig");
    private static final Logger LOG = LoggerFactory.getLogger(InitialContentMigrator.class);
    private final NodeStore targetNodeStore;
    private final NodeStore seedNodeStore;
    private final Mount seedMount;
    private final Set<String> includePaths;
    private final Set<String> excludePaths;
    private final Set<String> fragmentPaths;
    private final Set<String> excludeFragments;

    public InitialContentMigrator(NodeStore targetNodeStore, NodeStore seedNodeStore, Mount seedMount) {
        this.targetNodeStore = targetNodeStore;
        this.seedNodeStore = seedNodeStore;
        this.seedMount = seedMount;
        this.includePaths = FilteringNodeState.ALL;
        this.excludeFragments = ImmutableSet.of((Object)seedMount.getPathFragmentName());
        if (seedMount instanceof MountInfo) {
            this.excludePaths = Sets.union((Set)((MountInfo)seedMount).getIncludedPaths(), DEFAULT_IGNORED_PATHS);
            this.fragmentPaths = new HashSet<String>();
            for (String p : ((MountInfo)seedMount).getPathsSupportingFragments()) {
                this.fragmentPaths.add(InitialContentMigrator.stripPatternCharacters(p));
            }
        } else {
            this.excludePaths = DEFAULT_IGNORED_PATHS;
            this.fragmentPaths = FilteringNodeState.ALL;
        }
    }

    private boolean isTargetInitialized() {
        return this.targetNodeStore.getRoot().hasChildNode(":composite");
    }

    private void waitForInitialization() throws IOException {
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        } while (!this.isTargetInitialized());
    }

    public void migrate() throws IOException, CommitFailedException {
        if (this.isTargetInitialized()) {
            LOG.info("The target is already initialized, no need to copy the seed mount");
        } else if (this.targetNodeStore instanceof Clusterable) {
            Clusterable dns = (Clusterable)this.targetNodeStore;
            String clusterId = dns.getInstanceId();
            LOG.info("The target isn't initialized and the cluster id = {}.", (Object)clusterId);
            if (CLUSTER_ID.equals(clusterId)) {
                LOG.info("This cluster id {} is configured to initialized the repository.", (Object)CLUSTER_ID);
                this.doMigrate();
            } else {
                LOG.info("Waiting until the repository is initialized by instance {}.", (Object)CLUSTER_ID);
                this.waitForInitialization();
            }
        } else {
            LOG.info("Initializing the default mount.");
            this.doMigrate();
        }
    }

    protected void doMigrate() throws CommitFailedException {
        NodeState initialRoot;
        LOG.info("Seed {}", (Object)this.seedMount.getName());
        LOG.info("Include: {}", this.includePaths);
        LOG.info("Exclude: {}", this.excludePaths);
        LOG.info("Exclude fragments: {} @ {}", this.excludeFragments, this.fragmentPaths);
        LinkedHashMap nameToRevision = new LinkedHashMap();
        LinkedHashMap<String, String> checkpointSegmentToDoc = new LinkedHashMap<String, String>();
        NodeState targetRoot = initialRoot = this.targetNodeStore.getRoot();
        NodeState previousRoot = initialRoot;
        for (String checkpointName : this.seedNodeStore.checkpoints()) {
            NodeState checkpointRoot = this.seedNodeStore.retrieve(checkpointName);
            Map checkpointInfo = this.seedNodeStore.checkpointInfo(checkpointName);
            if (previousRoot == initialRoot) {
                LOG.info("Migrating first checkpoint: {}", (Object)checkpointName);
            } else {
                LOG.info("Applying diff to {}", (Object)checkpointName);
            }
            LOG.info("Checkpoint metadata: {}", (Object)checkpointInfo);
            targetRoot = this.copyDiffToTarget(previousRoot, checkpointRoot, targetRoot);
            previousRoot = checkpointRoot;
            String newCheckpointName = this.targetNodeStore.checkpoint(Long.MAX_VALUE, checkpointInfo);
            if (checkpointInfo.containsKey("name")) {
                nameToRevision.put(checkpointInfo.get("name"), newCheckpointName);
            }
            checkpointSegmentToDoc.put(checkpointName, newCheckpointName);
        }
        NodeState sourceRoot = this.seedNodeStore.getRoot();
        if (previousRoot == initialRoot) {
            LOG.info("No checkpoints found; migrating head");
        } else {
            LOG.info("Applying diff to head");
        }
        targetRoot = this.copyDiffToTarget(previousRoot, sourceRoot, targetRoot);
        LOG.info("Rewriting checkpoint names in /:async {}", nameToRevision);
        NodeBuilder targetBuilder = targetRoot.builder();
        NodeBuilder async = targetBuilder.getChildNode(":async");
        for (Map.Entry e : nameToRevision.entrySet()) {
            async.setProperty((String)e.getKey(), e.getValue(), Type.STRING);
            PropertyState temp = async.getProperty((String)e.getKey() + "-temp");
            if (temp == null) continue;
            ArrayList tempValues = Lists.newArrayList((Iterable)((Iterable)temp.getValue(Type.STRINGS)));
            for (Map.Entry sToD : checkpointSegmentToDoc.entrySet()) {
                if (!tempValues.contains(sToD.getKey())) continue;
                tempValues.set(tempValues.indexOf(sToD.getKey()), sToD.getValue());
            }
            async.setProperty((String)e.getKey() + "-temp", (Object)tempValues, Type.STRINGS);
        }
        this.targetNodeStore.merge(targetBuilder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        this.markMigrationAsDone();
    }

    private void markMigrationAsDone() throws CommitFailedException {
        NodeState root = this.targetNodeStore.getRoot();
        NodeBuilder builder = root.builder();
        builder.child(":composite");
        this.targetNodeStore.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
    }

    private NodeState copyDiffToTarget(NodeState before, NodeState after, NodeState targetRoot) throws CommitFailedException {
        NodeBuilder targetBuilder = targetRoot.builder();
        NodeState currentRoot = this.wrapNodeState(after, true);
        NodeState baseRoot = this.wrapNodeState(before, false);
        currentRoot.compareAgainstBaseState(baseRoot, (NodeStateDiff)new ApplyDiff(targetBuilder));
        return this.targetNodeStore.merge(targetBuilder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
    }

    private NodeState wrapNodeState(NodeState nodeState, boolean logPaths) {
        NodeState wrapped = nodeState;
        wrapped = FilteringNodeState.wrap((String)"/", (NodeState)wrapped, this.includePaths, this.excludePaths, this.fragmentPaths, this.excludeFragments);
        if (logPaths) {
            wrapped = ReportingNodeState.wrap((NodeState)wrapped, (Reporter)new LoggingReporter(LOG, "Copying", LOG_NODE_COPY, -1));
        }
        return wrapped;
    }

    private static String stripPatternCharacters(String pathPattern) {
        int slashIndex;
        String result = pathPattern;
        result = InitialContentMigrator.substringBefore(result, '*');
        if (!(result = InitialContentMigrator.substringBefore(result, '$')).equals(pathPattern) && (slashIndex = result.lastIndexOf(47)) > 0) {
            result = result.substring(0, slashIndex);
        }
        return result;
    }

    private static String substringBefore(String subject, char stopCharacter) {
        int index = subject.indexOf(stopCharacter);
        if (index > -1) {
            return subject.substring(0, index);
        }
        return subject;
    }
}

