/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import org.apache.jackrabbit.oak.composite.CrossMountReferenceValidator;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ComponentPropertyType;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={ValidatorProvider.class, EditorProvider.class})
public class CrossMountReferenceValidatorProvider
extends ValidatorProvider {
    private boolean failOnDetection;
    private MountInfoProvider mountInfoProvider = Mounts.defaultMountInfoProvider();

    public CrossMountReferenceValidatorProvider() {
    }

    public CrossMountReferenceValidatorProvider(MountInfoProvider mountInfoProvider, boolean failOnDetection) {
        this.failOnDetection = failOnDetection;
        this.mountInfoProvider = mountInfoProvider;
    }

    @Activate
    private void activate(Config config) {
        this.failOnDetection = config.failOnDetection();
    }

    protected Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        return new CrossMountReferenceValidator(after, this.mountInfoProvider, this.failOnDetection);
    }

    CrossMountReferenceValidatorProvider with(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
        return this;
    }

    CrossMountReferenceValidatorProvider withFailOnDetection(boolean failOnDetection) {
        this.failOnDetection = failOnDetection;
        return this;
    }

    @Reference(name="mountInfoProvider")
    protected void bindMountInfoProvider(MountInfoProvider mip) {
        this.mountInfoProvider = mip;
    }

    protected void unbindMountInfoProvider(MountInfoProvider mip) {
        if (this.mountInfoProvider == mip) {
            this.mountInfoProvider = null;
        }
    }

    @ComponentPropertyType
    static @interface Config {
        @AttributeDefinition
        public String type() default "crossMountRefValidator";

        @AttributeDefinition(name="Fail when detecting commits cross-mount references", description="Commits will fail if set to true when detecting cross-mount references. If set to false the commit information is only logged.")
        public boolean failOnDetection() default true;
    }
}

