/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.bundlor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.bundlor.CompositeMatcher;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Include;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Matcher;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class DocumentBundlor {
    public static final String BUNDLOR_META_PROP_PREFIX = ":doc-";
    public static final String META_PROP_PATTERN = ":doc-pattern";
    public static final String META_PROP_BUNDLING_PATH = ":doc-self-path";
    public static final String HAS_CHILD_PROP_PREFIX = ":doc-has-child-";
    public static final String META_PROP_BUNDLED_CHILD = ":doc-has-child-bundled";
    public static final String META_PROP_NON_BUNDLED_CHILD = ":doc-has-child-non-bundled";
    public static final String PROP_DISABLED = "disabled";
    public static final String PROP_PATTERN = "pattern";
    private final List<Include> includes;

    public static DocumentBundlor from(NodeState nodeState) {
        Preconditions.checkArgument((boolean)nodeState.hasProperty(PROP_PATTERN), (String)"NodeState [%s] does not have required property [%s]", (Object[])new Object[]{nodeState, PROP_PATTERN});
        return DocumentBundlor.from(nodeState.getStrings(PROP_PATTERN));
    }

    public static DocumentBundlor from(Iterable<String> includeStrings) {
        ArrayList includes = Lists.newArrayList();
        for (String i : includeStrings) {
            includes.add(new Include(i));
        }
        return new DocumentBundlor(includes);
    }

    public static DocumentBundlor from(PropertyState prop) {
        Preconditions.checkArgument((boolean)META_PROP_PATTERN.equals(prop.getName()));
        return DocumentBundlor.from((Iterable)prop.getValue(Type.STRINGS));
    }

    private DocumentBundlor(List<Include> includes) {
        Preconditions.checkArgument((!includes.isEmpty() ? 1 : 0) != 0, (Object)"Include list cannot be empty");
        this.includes = ImmutableList.copyOf(includes);
    }

    public boolean isBundled(String relativePath) {
        Matcher m = this.createMatcher();
        for (String e : PathUtils.elements((String)relativePath)) {
            m = m.next(e);
        }
        return m.isMatch();
    }

    public PropertyState asPropertyState() {
        ArrayList<String> includePatterns = new ArrayList<String>(this.includes.size());
        for (Include i : this.includes) {
            includePatterns.add(i.getPattern());
        }
        return PropertyStates.createProperty((String)META_PROP_PATTERN, includePatterns, (Type)Type.STRINGS);
    }

    public Matcher createMatcher() {
        ArrayList matchers = Lists.newArrayListWithCapacity((int)this.includes.size());
        for (Include include : this.includes) {
            matchers.add(include.createMatcher());
        }
        return CompositeMatcher.compose(matchers);
    }

    public String toString() {
        return this.includes.toString();
    }
}

