/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.collect.AbstractIterator;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.blob.CachingBlobStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlob;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobCodec;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoBlobStore
extends CachingBlobStore {
    public static final String COLLECTION_BLOBS = "blobs";
    private static final Logger LOG = LoggerFactory.getLogger(MongoBlobStore.class);
    private static final int DUPLICATE_KEY_ERROR_CODE = 11000;
    private static final CodecRegistry CODEC_REGISTRY = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClient.getDefaultCodecRegistry(), CodecRegistries.fromCodecs((Codec[])new Codec[]{new MongoBlobCodec()})});
    private final ReadPreference defaultReadPreference;
    private final MongoCollection<MongoBlob> blobCollection;
    private long minLastModified;
    private final boolean readOnly;

    public MongoBlobStore(MongoDatabase db) {
        this(db, 0x1000000L, null);
    }

    public MongoBlobStore(MongoDatabase db, long cacheSize) {
        this(db, cacheSize, null);
    }

    public MongoBlobStore(@NotNull MongoDatabase db, long cacheSize, @Nullable DocumentNodeStoreBuilder<?> builder) {
        super(cacheSize);
        this.readOnly = builder == null ? false : builder.getReadOnlyMode();
        this.setBlockSize(2096128);
        this.defaultReadPreference = db.getReadPreference();
        this.blobCollection = this.initBlobCollection(db, this.readOnly);
    }

    protected void storeBlock(byte[] digest, int level, byte[] data) throws IOException {
        String id = StringUtils.convertBytesToHex((byte[])digest);
        this.cache.put((Object)id, (Object)data);
        BasicDBObject mongoBlob = new BasicDBObject("_id", (Object)id);
        mongoBlob.append("data", (Object)data);
        mongoBlob.append("level", (Object)level);
        BasicDBObject updateBlob = new BasicDBObject("lastMod", (Object)System.currentTimeMillis());
        BasicDBObject upsert = new BasicDBObject();
        upsert.append("$setOnInsert", (Object)mongoBlob).append("$set", (Object)updateBlob);
        try {
            Bson query = MongoBlobStore.getBlobQuery(id, -1L);
            UpdateOptions options = new UpdateOptions().upsert(true);
            UpdateResult result = this.getBlobCollection().updateOne(query, (Bson)upsert, options);
            if (result != null && result.getUpsertedId() == null) {
                LOG.trace("Block with id [{}] updated", (Object)id);
            } else {
                LOG.trace("Block with id [{}] created", (Object)id);
            }
        }
        catch (MongoException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId blockId) throws Exception {
        String id = StringUtils.convertBytesToHex((byte[])blockId.getDigest());
        byte[] data = (byte[])this.cache.get((Object)id);
        if (data == null) {
            long start = System.nanoTime();
            MongoBlob blobMongo = this.getBlob(id, 0L);
            if (blobMongo == null) {
                String message = "Did not find block " + id;
                LOG.error(message);
                throw new IOException(message);
            }
            data = blobMongo.getData();
            this.getStatsCollector().downloaded(id, System.nanoTime() - start, TimeUnit.NANOSECONDS, (long)data.length);
            this.cache.put((Object)id, (Object)data);
        }
        if (blockId.getPos() == 0L) {
            return data;
        }
        int len = (int)((long)data.length - blockId.getPos());
        if (len < 0) {
            return new byte[0];
        }
        byte[] d2 = new byte[len];
        System.arraycopy(data, (int)blockId.getPos(), d2, 0, len);
        return d2;
    }

    public void startMark() throws IOException {
        this.minLastModified = System.currentTimeMillis();
        this.markInUse();
    }

    protected boolean isMarkEnabled() {
        return this.minLastModified != 0L;
    }

    protected void mark(AbstractBlobStore.BlockId blockId) throws Exception {
        if (this.minLastModified == 0L) {
            return;
        }
        String id = StringUtils.convertBytesToHex((byte[])blockId.getDigest());
        Bson query = MongoBlobStore.getBlobQuery(id, this.minLastModified);
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject("lastMod", (Object)System.currentTimeMillis()));
        this.getBlobCollection().updateOne(query, (Bson)update);
    }

    public int sweep() throws IOException {
        Bson query = MongoBlobStore.getBlobQuery(null, this.minLastModified);
        long num = this.getBlobCollection().deleteMany(query).getDeletedCount();
        this.minLastModified = 0L;
        return (int)num;
    }

    private MongoCollection<MongoBlob> initBlobCollection(MongoDatabase db, boolean readOnly) {
        if (StreamSupport.stream(db.listCollectionNames().spliterator(), false).noneMatch(COLLECTION_BLOBS::equals)) {
            if (readOnly) {
                throw new RuntimeException("MongoBlobStore instantiated read-only, but collection blobs not present");
            }
            db.createCollection(COLLECTION_BLOBS);
        }
        return db.getCollection(COLLECTION_BLOBS, MongoBlob.class).withCodecRegistry(CODEC_REGISTRY).withReadPreference(ReadPreference.primary());
    }

    private MongoCollection<MongoBlob> getBlobCollection() {
        return this.blobCollection;
    }

    private MongoBlob getBlob(String id, long lastMod) {
        Bson query = MongoBlobStore.getBlobQuery(id, lastMod);
        BasicDBObject fields = new BasicDBObject("data", (Object)1);
        ArrayList result = new ArrayList(1);
        this.getBlobCollection().withReadPreference(this.defaultReadPreference).find(query).projection((Bson)fields).into(result);
        if (result.isEmpty()) {
            this.getBlobCollection().withReadPreference(ReadPreference.primary()).find(query).projection((Bson)fields).into(result);
        }
        return result.isEmpty() ? null : (MongoBlob)result.get(0);
    }

    private static Bson getBlobQuery(String id, long lastMod) {
        ArrayList<Bson> clauses = new ArrayList<Bson>(2);
        if (id != null) {
            clauses.add(Filters.eq((String)"_id", (Object)id));
        }
        if (lastMod > 0L) {
            clauses.add(Filters.lt((String)"lastMod", (Object)lastMod));
        }
        if (clauses.size() == 1) {
            return (Bson)clauses.get(0);
        }
        return Filters.and(clauses);
    }

    public long countDeleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        Document query = new Document();
        if (chunkIds != null) {
            query = Filters.in((String)"_id", chunkIds);
            if (maxLastModifiedTime > 0L) {
                query = Filters.and((Bson[])new Bson[]{query, Filters.lt((String)"lastMod", (Object)maxLastModifiedTime)});
            }
        }
        return this.getBlobCollection().deleteMany((Bson)query).getDeletedCount();
    }

    public Iterator<String> getAllChunkIds(long maxLastModifiedTime) throws Exception {
        BasicDBObject fields = new BasicDBObject("_id", (Object)1);
        Document query = new Document();
        if (maxLastModifiedTime != 0L && maxLastModifiedTime != -1L) {
            query = Filters.lte((String)"lastMod", (Object)maxLastModifiedTime);
        }
        final MongoCursor cur = this.getBlobCollection().find((Bson)query).projection((Bson)fields).hint((Bson)fields).iterator();
        return new AbstractIterator<String>(){

            protected String computeNext() {
                MongoBlob blob;
                if (cur.hasNext() && (blob = (MongoBlob)cur.next()) != null) {
                    return blob.getId();
                }
                return (String)this.endOfData();
            }
        };
    }
}

