/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBMissingLastRevSeeker
extends MissingLastRevSeeker {
    private static final Logger LOG;
    private static final int MODE;
    private static final int DEFAULTMODE = 2;
    private final RDBDocumentStore store;

    public RDBMissingLastRevSeeker(RDBDocumentStore store, Clock clock) {
        super(store, clock);
        this.store = store;
    }

    @Override
    @NotNull
    public Iterable<NodeDocument> getCandidates(long startTime) {
        LOG.debug("Running getCandidates() in mode " + MODE);
        if (MODE == 1) {
            return super.getCandidates(startTime);
        }
        List<RDBDocumentStore.QueryCondition> conditions = Collections.singletonList(new RDBDocumentStore.QueryCondition("_modified", ">=", NodeDocument.getModifiedInSecs(startTime)));
        return this.store.queryAsIterable(Collection.NODES, null, null, RDBDocumentStore.EMPTY_KEY_PATTERN, conditions, Integer.MAX_VALUE, null);
    }

    static {
        String value;
        LOG = LoggerFactory.getLogger(RDBMissingLastRevSeeker.class);
        String propName = "org.apache.jackrabbit.oak.plugins.document.rdb.RDBMissingLastRevSeeker.MODE";
        switch (value = System.getProperty(propName, "")) {
            case "": {
                MODE = 2;
                break;
            }
            case "1": {
                MODE = 1;
                break;
            }
            case "2": {
                MODE = 2;
                break;
            }
            default: {
                LOG.error("Ignoring unexpected value '" + value + "' for system property " + propName);
                MODE = 2;
            }
        }
        if (2 != MODE) {
            LOG.info("Strategy for " + RDBMissingLastRevSeeker.class.getName() + " set to " + MODE + " (via system property " + propName + ")");
        }
    }
}

