/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBVersionGCSupport
extends VersionGCSupport {
    private static final Logger LOG;
    private RDBDocumentStore store;
    private static final int MODE;
    private static final int DEFAULTMODE = 2;

    public RDBVersionGCSupport(RDBDocumentStore store) {
        super(store);
        this.store = store;
    }

    @Override
    public Iterable<NodeDocument> getPossiblyDeletedDocs(long fromModified, long toModified) {
        ArrayList<RDBDocumentStore.QueryCondition> conditions = new ArrayList<RDBDocumentStore.QueryCondition>();
        conditions.add(new RDBDocumentStore.QueryCondition("_deletedOnce", "=", 1L));
        conditions.add(new RDBDocumentStore.QueryCondition("_modified", "<", NodeDocument.getModifiedInSecs(toModified)));
        conditions.add(new RDBDocumentStore.QueryCondition("_modified", ">=", NodeDocument.getModifiedInSecs(fromModified)));
        if (MODE == 1) {
            return this.getIterator(RDBDocumentStore.EMPTY_KEY_PATTERN, conditions);
        }
        return this.store.queryAsIterable(Collection.NODES, null, null, RDBDocumentStore.EMPTY_KEY_PATTERN, conditions, Integer.MAX_VALUE, null);
    }

    @Override
    protected Iterable<NodeDocument> identifyGarbage(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp) {
        if (MODE == 1) {
            return this.identifyGarbageMode1(gcTypes, sweepRevs, oldestRevTimeStamp);
        }
        return this.identifyGarbageMode2(gcTypes, sweepRevs, oldestRevTimeStamp);
    }

    private Iterable<NodeDocument> getSplitDocuments() {
        List<RDBDocumentStore.QueryCondition> conditions = Collections.emptyList();
        List<String> excludeKeyPatterns = Arrays.asList("_:/%", "__:/%", "___:/%");
        return this.getIterator(excludeKeyPatterns, conditions);
    }

    private Iterable<NodeDocument> identifyGarbageMode1(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp) {
        return Iterables.filter(this.getSplitDocuments(), this.getGarbageCheckPredicate(gcTypes, sweepRevs, oldestRevTimeStamp));
    }

    private Predicate<NodeDocument> getGarbageCheckPredicate(final Set<NodeDocument.SplitDocType> gcTypes, final RevisionVector sweepRevs, final long oldestRevTimeStamp) {
        return new Predicate<NodeDocument>(){

            public boolean apply(NodeDocument doc) {
                return gcTypes.contains((Object)doc.getSplitDocType()) && doc.hasAllRevisionLessThan(oldestRevTimeStamp) && !RDBVersionGCSupport.isDefaultNoBranchSplitNewerThan(doc, sweepRevs);
            }
        };
    }

    private Iterable<NodeDocument> identifyGarbageMode2(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp) {
        String name2;
        Iterable<Object> it2;
        Iterable<NodeDocument> it1;
        String name1;
        List<String> excludeKeyPatterns = Arrays.asList("_:/%", "__:/%", "___:/%");
        try {
            ArrayList gcTypeCodes = Lists.newArrayList();
            for (NodeDocument.SplitDocType type : gcTypes) {
                gcTypeCodes.add(type.typeCode());
            }
            ArrayList<RDBDocumentStore.QueryCondition> conditions1 = new ArrayList<RDBDocumentStore.QueryCondition>();
            conditions1.add(new RDBDocumentStore.QueryCondition("_sdType", "in", gcTypeCodes));
            conditions1.add(new RDBDocumentStore.QueryCondition("_sdMaxRevTime", "<=", NodeDocument.getModifiedInSecs(oldestRevTimeStamp)));
            conditions1.add(new RDBDocumentStore.QueryCondition(RDBDocumentStore.VERSIONPROP, ">=", 2L));
            name1 = "version 2 query";
            it1 = this.store.queryAsIterable(Collection.NODES, null, null, Collections.emptyList(), conditions1, Integer.MAX_VALUE, null);
            ArrayList<RDBDocumentStore.QueryCondition> conditions2 = new ArrayList<RDBDocumentStore.QueryCondition>();
            conditions2.add(new RDBDocumentStore.QueryCondition(RDBDocumentStore.VERSIONPROP, "null or <", 2L));
            it2 = this.store.queryAsIterable(Collection.NODES, null, null, excludeKeyPatterns, conditions2, Integer.MAX_VALUE, null);
            name2 = "version <2 fallback on " + excludeKeyPatterns;
        }
        catch (RDBDocumentStore.UnsupportedIndexedPropertyException ex) {
            it1 = this.store.queryAsIterable(Collection.NODES, null, null, excludeKeyPatterns, Collections.emptyList(), Integer.MAX_VALUE, null);
            it2 = Collections.emptySet();
            name1 = "version <2 fallback on " + excludeKeyPatterns;
            name2 = "";
        }
        final Iterable<NodeDocument> fit1 = it1;
        final Set fit2 = it2;
        Predicate<NodeDocument> pred = this.getGarbageCheckPredicate(gcTypes, sweepRevs, oldestRevTimeStamp);
        final CountingPredicate<NodeDocument> cp1 = new CountingPredicate<NodeDocument>(name1, pred);
        final CountingPredicate<NodeDocument> cp2 = new CountingPredicate<NodeDocument>(name2, pred);
        return CloseableIterable.wrap(Iterables.concat((Iterable)Iterables.filter(fit1, cp1), (Iterable)Iterables.filter(fit2, cp2)), new Closeable(){

            @Override
            public void close() throws IOException {
                Utils.closeIfCloseable(fit1);
                Utils.closeIfCloseable(fit2);
                if (LOG.isDebugEnabled()) {
                    String stats1 = cp1.getStats();
                    String stats2 = cp2.getStats();
                    String message = "";
                    if (!stats1.isEmpty()) {
                        message = stats1;
                    }
                    if (!stats2.isEmpty()) {
                        if (!message.isEmpty()) {
                            message = message + ", ";
                        }
                        message = message + stats2;
                    }
                    if (!message.isEmpty()) {
                        LOG.debug(message);
                    }
                }
            }
        });
    }

    @Override
    public long getOldestDeletedOnceTimestamp(Clock clock, long precisionMs) {
        long modifiedMs = Long.MIN_VALUE;
        LOG.debug("getOldestDeletedOnceTimestamp() <- start");
        try {
            long modifiedSec = this.store.getMinValue(Collection.NODES, "_modified", null, null, RDBDocumentStore.EMPTY_KEY_PATTERN, Collections.singletonList(new RDBDocumentStore.QueryCondition("_deletedOnce", "=", 1L)));
            modifiedMs = TimeUnit.SECONDS.toMillis(modifiedSec);
        }
        catch (DocumentStoreException ex) {
            LOG.debug("getMinValue(MODIFIED)", (Throwable)ex);
        }
        if (modifiedMs > 0L) {
            LOG.debug("getOldestDeletedOnceTimestamp() -> {}", (Object)Utils.timestampToString(modifiedMs));
            return modifiedMs;
        }
        LOG.debug("getOldestDeletedOnceTimestamp() -> none found, return current time");
        return clock.getTime();
    }

    @Override
    public long getDeletedOnceCount() {
        return this.store.queryCount(Collection.NODES, null, null, RDBDocumentStore.EMPTY_KEY_PATTERN, Collections.singletonList(new RDBDocumentStore.QueryCondition("_deletedOnce", "=", 1L)));
    }

    private Iterable<NodeDocument> getIterator(final List<String> excludeKeyPatterns, final List<RDBDocumentStore.QueryCondition> conditions) {
        return new Iterable<NodeDocument>(){

            @Override
            public Iterator<NodeDocument> iterator() {
                return new AbstractIterator<NodeDocument>(){
                    private static final int BATCH_SIZE = 100;
                    private String startId = "0000000";
                    private Iterator<NodeDocument> batch = this.nextBatch();

                    protected NodeDocument computeNext() {
                        NodeDocument doc;
                        if (!this.batch.hasNext()) {
                            this.batch = this.nextBatch();
                        }
                        if (this.batch.hasNext()) {
                            doc = this.batch.next();
                            this.startId = doc.getId();
                        } else {
                            doc = (NodeDocument)this.endOfData();
                        }
                        return doc;
                    }

                    private Iterator<NodeDocument> nextBatch() {
                        List<NodeDocument> result = RDBVersionGCSupport.this.store.query(Collection.NODES, this.startId, ";", excludeKeyPatterns, conditions, 100);
                        return result.iterator();
                    }
                };
            }
        };
    }

    static {
        String value;
        LOG = LoggerFactory.getLogger(RDBVersionGCSupport.class);
        String propName = RDBVersionGCSupport.class.getName() + ".MODE";
        switch (value = System.getProperty(propName, "")) {
            case "": {
                MODE = 2;
                break;
            }
            case "1": {
                MODE = 1;
                break;
            }
            case "2": {
                MODE = 2;
                break;
            }
            default: {
                LOG.error("Ignoring unexpected value '" + value + "' for system property " + propName);
                MODE = 2;
            }
        }
        if (2 != MODE) {
            LOG.info("Strategy for " + RDBVersionGCSupport.class.getName() + " set to " + MODE + " (via system property " + propName + ")");
        }
    }

    private static class CountingPredicate<T>
    implements Predicate<T> {
        private final String name;
        private final Predicate<T> predicate;
        private int count;
        private int matches;

        public CountingPredicate(String name, Predicate<T> predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        public String getStats() {
            return this.count == 0 ? "" : "Predicate statistics for '" + this.name + "': " + this.matches + "/" + this.count;
        }

        public boolean apply(T doc) {
            ++this.count;
            boolean match = this.predicate.apply(doc);
            this.matches += match ? 1 : 0;
            return match;
        }
    }
}

