/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CloseableIterable<T>
implements Iterable<T>,
Closeable {
    private final Iterable<T> iterable;
    private final Closer closer = Closer.create();

    public static <T> CloseableIterable<T> wrap(Iterable<T> iterable, Closeable closeable) {
        return new CloseableIterable<T>(iterable, closeable);
    }

    public static <T> CloseableIterable<T> wrap(Iterable<T> iterable) {
        return new CloseableIterable<T>(iterable, null);
    }

    public CloseableIterable(Iterable<T> iterable, Closeable closeable) {
        this.iterable = iterable;
        if (closeable != null) {
            this.closer.register(closeable);
        }
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator<T> it = this.iterable.iterator();
        if (it instanceof Closeable) {
            this.closer.register((Closeable)((Object)it));
        }
        return it;
    }
}

