/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.collect.Iterables;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.apache.jackrabbit.oak.stats.Clock;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;

public class MongoMissingLastRevSeeker
extends MissingLastRevSeeker {
    private final MongoDocumentStore store;

    public MongoMissingLastRevSeeker(MongoDocumentStore store, Clock clock) {
        super(store, clock);
        this.store = store;
    }

    @NotNull
    public CloseableIterable<NodeDocument> getCandidates(long startTime) {
        Bson query = Filters.and((Bson[])new Bson[]{Filters.gte((String)"_modified", (Object)NodeDocument.getModifiedInSecs(startTime)), Filters.exists((String)"_sdType", (boolean)false)});
        BasicDBObject sortFields = new BasicDBObject("_modified", (Object)1);
        FindIterable cursor = this.getNodeCollection().find(query).sort((Bson)sortFields);
        return CloseableIterable.wrap(Iterables.transform((Iterable)cursor, input -> this.store.convertFromDBObject(Collection.NODES, (DBObject)input)));
    }

    @Override
    public boolean isRecoveryNeeded() {
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"state", (Object)ClusterNodeInfo.ClusterNodeState.ACTIVE.name()), Filters.or((Bson[])new Bson[]{Filters.lt((String)"leaseEnd", (Object)this.clock.getTime()), Filters.eq((String)"recoveryLock", (Object)ClusterNodeInfo.RecoverLockState.ACQUIRED.name())})});
        return this.getClusterNodeCollection().find(query).iterator().hasNext();
    }

    private MongoCollection<BasicDBObject> getNodeCollection() {
        return this.store.getDBCollection(Collection.NODES, ReadPreference.primary());
    }

    private MongoCollection<BasicDBObject> getClusterNodeCollection() {
        return this.store.getDBCollection(Collection.CLUSTER_NODES, ReadPreference.primary());
    }
}

