/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.secondary;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.secondary.SecondaryStoreCache;
import org.apache.jackrabbit.oak.plugins.document.secondary.SecondaryStoreObserver;
import org.apache.jackrabbit.oak.plugins.document.secondary.SecondaryStoreRootObserver;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;

public class SecondaryStoreBuilder {
    private final NodeStore store;
    private PathFilter pathFilter = new PathFilter(Collections.singletonList("/"), Collections.emptyList());
    private NodeStateDiffer differ = NodeStateDiffer.DEFAULT_DIFFER;
    private StatisticsProvider statsProvider = StatisticsProvider.NOOP;
    private List<String> metaPropNames = Collections.emptyList();

    public SecondaryStoreBuilder(NodeStore nodeStore) {
        this.store = nodeStore;
    }

    public SecondaryStoreBuilder pathFilter(PathFilter filter) {
        this.pathFilter = filter;
        return this;
    }

    public SecondaryStoreBuilder differ(NodeStateDiffer differ) {
        this.differ = differ;
        return this;
    }

    public SecondaryStoreBuilder statisticsProvider(StatisticsProvider statisticsProvider) {
        this.statsProvider = statisticsProvider;
        return this;
    }

    public SecondaryStoreBuilder metaPropNames(List<String> metaPropNames) {
        this.metaPropNames = ImmutableList.copyOf(metaPropNames);
        return this;
    }

    public SecondaryStoreCache buildCache() {
        return new SecondaryStoreCache(this.store, this.differ, this.pathFilter, this.statsProvider);
    }

    public SecondaryStoreObserver buildObserver() {
        return this.buildObserver(SecondaryStoreRootObserver.NOOP);
    }

    public SecondaryStoreObserver buildObserver(SecondaryStoreRootObserver secondaryStoreRootObserver) {
        return new SecondaryStoreObserver(this.store, this.metaPropNames, this.differ, this.pathFilter, this.statsProvider, secondaryStoreRootObserver);
    }
}

