/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.osgi.OsgiUtil;
import org.apache.jackrabbit.oak.plugins.document.Configuration;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

final class DocumentNodeStoreServiceConfiguration {
    private static final String DEFAULT_FWK_PREFIX = "oak.documentstore.";
    private static final String FWK_PROP_URI = "oak.mongo.uri";
    private static final String FWK_PROP_DB = "oak.mongo.db";
    private static final String FWK_PROP_SO_KEEP_ALIVE = "oak.mongo.socketKeepAlive";
    private static final String FWK_PROP_MONGO_LEASE_SO_TIMEOUT = "oak.mongo.leaseSocketTimeout";
    private static final String FWK_PROP_UPDATE_LIMIT = "update.limit";
    private static final String PROP_DB = "db";
    private static final String PROP_URI = "mongouri";
    private static final String PROP_HOME = "repository.home";
    static final String PROP_SO_KEEP_ALIVE = "socketKeepAlive";
    static final String PROP_LEASE_SO_TIMEOUT = "leaseSocketTimeout";
    static final String PROP_UPDATE_LIMIT = "updateLimit";
    private static final Map<String, String> FWK_PROP_MAPPING = new ImmutableMap.Builder().put((Object)"db", (Object)"oak.mongo.db").put((Object)"mongouri", (Object)"oak.mongo.uri").put((Object)"repository.home", (Object)"repository.home").put((Object)"socketKeepAlive", (Object)"oak.mongo.socketKeepAlive").put((Object)"leaseSocketTimeout", (Object)"oak.mongo.leaseSocketTimeout").put((Object)"updateLimit", (Object)"update.limit").build();

    private DocumentNodeStoreServiceConfiguration() {
    }

    static Configuration create(ComponentContext context, ConfigurationAdmin configurationAdmin, Configuration preset, Configuration configuration) throws IOException {
        return (Configuration)Proxy.newProxyInstance(DocumentNodeStoreServiceConfiguration.class.getClassLoader(), new Class[]{Configuration.class}, (InvocationHandler)new ConfigurationHandler(context, configurationAdmin, preset, configuration));
    }

    private static String frameworkPropertyNameFor(String propertyName) {
        Object fwkPropName = FWK_PROP_MAPPING.get(propertyName);
        if (fwkPropName == null) {
            fwkPropName = DEFAULT_FWK_PREFIX + propertyName;
        }
        return fwkPropName;
    }

    private static final class ConfigurationHandler
    implements InvocationHandler {
        private final ComponentContext context;
        private final Configuration preset;
        private final Configuration configuration;
        private final Set<String> configurationKeys;

        ConfigurationHandler(ComponentContext context, ConfigurationAdmin configurationAdmin, Configuration preset, Configuration configuration) throws IOException {
            this.context = (ComponentContext)Preconditions.checkNotNull((Object)context);
            this.preset = (Configuration)Preconditions.checkNotNull((Object)preset);
            this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
            this.configurationKeys = ConfigurationHandler.getConfigurationKeys((ConfigurationAdmin)Preconditions.checkNotNull((Object)configurationAdmin));
        }

        private static Set<String> getConfigurationKeys(ConfigurationAdmin configurationAdmin) throws IOException {
            HashSet<String> keys = new HashSet<String>();
            org.osgi.service.cm.Configuration c = configurationAdmin.getConfiguration("org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreService");
            for (Object k : Collections.list(c.getProperties().keys())) {
                keys.add(k.toString());
            }
            return keys;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName().replaceAll("_", ".");
            Configuration c = this.configurationKeys.contains(name) ? this.configuration : this.preset;
            Object value = method.invoke((Object)c, new Object[0]);
            String frameworkProp = OsgiUtil.lookup((BundleContext)this.context.getBundleContext(), (String)DocumentNodeStoreServiceConfiguration.frameworkPropertyNameFor(name));
            if (frameworkProp != null) {
                value = this.tryCoerce(frameworkProp, method.getReturnType(), value);
            }
            return value;
        }

        private Object tryCoerce(String value, Class<?> type, Object defaultValue) {
            Object obj;
            if (type == Boolean.class || type == Boolean.TYPE) {
                obj = Boolean.parseBoolean(value);
            } else if (type == Integer.class || type == Integer.TYPE) {
                try {
                    obj = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    obj = defaultValue;
                }
            } else if (type == Long.class || type == Long.TYPE) {
                try {
                    obj = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    obj = defaultValue;
                }
            } else {
                obj = type == String.class ? value : (type == String[].class ? String.valueOf(value).split("::") : defaultValue);
            }
            return obj;
        }
    }
}

