/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentStoreException
extends RuntimeException {
    private static final long serialVersionUID = 4135594565927443068L;
    private final Type type;

    public DocumentStoreException(String message) {
        this(message, null);
    }

    public DocumentStoreException(Throwable cause) {
        this(DocumentStoreException.getMessage(cause), cause);
    }

    public DocumentStoreException(String message, Throwable cause) {
        this(message, cause, Type.GENERIC);
    }

    public DocumentStoreException(String message, Throwable cause, Type type) {
        super(message, cause);
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
    }

    public static DocumentStoreException convert(@NotNull Throwable t) {
        return DocumentStoreException.convert(t, t.getMessage());
    }

    public static DocumentStoreException convert(@NotNull Throwable t, String msg) {
        return DocumentStoreException.asDocumentStoreException(msg, t, Type.GENERIC, Collections.emptyList());
    }

    public static DocumentStoreException convert(@NotNull Throwable t, Iterable<String> ids) {
        return DocumentStoreException.asDocumentStoreException(t.getMessage(), t, Type.GENERIC, ids);
    }

    public static DocumentStoreException asDocumentStoreException(String message, Throwable t, Type type, Iterable<String> ids) {
        Object msg = message;
        if (ids.iterator().hasNext()) {
            msg = (String)msg + " " + Lists.newArrayList(ids);
        }
        if (t instanceof DocumentStoreException) {
            return (DocumentStoreException)t;
        }
        return new DocumentStoreException((String)msg, t, type);
    }

    public Type getType() {
        return this.type;
    }

    @Nullable
    private static String getMessage(Throwable t) {
        return t == null ? null : t.toString();
    }

    public static enum Type {
        GENERIC,
        TRANSIENT;

    }
}

