/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.sort.StringSort;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.JournalPropertyHandler;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.observation.ChangeSet;
import org.apache.jackrabbit.oak.spi.observation.ChangeSetBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JournalEntry
extends Document {
    private static final Logger LOG = LoggerFactory.getLogger(JournalEntry.class);
    private static final String REVISION_FORMAT = "%d-%0" + Long.toHexString(Long.MAX_VALUE).length() + "x-%0" + Integer.toHexString(Integer.MAX_VALUE).length() + "x";
    private static final String CHANGES = "_c";
    private static final String CHANGE_SET = "_cs";
    static final String BRANCH_COMMITS = "_bc";
    private static final String INVALIDATE_ONLY = "_inv";
    public static final String MODIFIED = "_modified";
    private static final int READ_CHUNK_SIZE = 100;
    private static final int STRING_SORT_OVERFLOW_TO_DISK_THRESHOLD = Integer.getInteger("oak.overflowToDiskThreshold", 2048);
    private final DocumentStore store;
    private final ChangeSetBuilder changeSetBuilder;
    private final JournalPropertyHandler journalPropertyHandler;
    private volatile TreeNode changes = null;
    private volatile int numChangedNodes = 0;
    private boolean hasBranchCommits = false;
    private boolean concurrent;

    JournalEntry(DocumentStore store) {
        this(store, false, null, null);
    }

    JournalEntry(DocumentStore store, boolean concurrent, ChangeSetBuilder changeSetBuilder, JournalPropertyHandler journalPropertyHandler) {
        this.store = store;
        this.concurrent = concurrent;
        this.changeSetBuilder = changeSetBuilder;
        this.journalPropertyHandler = journalPropertyHandler;
    }

    static StringSort newSorter() {
        return new StringSort(STRING_SORT_OVERFLOW_TO_DISK_THRESHOLD, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg0.compareTo(arg1);
            }
        });
    }

    static void applyTo(@NotNull Iterable<String> changedPaths, @NotNull DiffCache diffCache, @NotNull Path path, @NotNull RevisionVector from, @NotNull RevisionVector to) throws IOException {
        LOG.debug("applyTo: starting for {} from {} to {}", new Object[]{path, from, to});
        LOG.debug("applyTo: sorting done.");
        DiffCache.Entry entry = ((DiffCache)Preconditions.checkNotNull((Object)diffCache)).newEntry(from, to, false);
        Iterator<String> it = changedPaths.iterator();
        if (!it.hasNext()) {
            entry.append(path, "");
            entry.done();
            return;
        }
        String previousPath = it.next();
        TreeNode node = new TreeNode();
        node = node.getOrCreatePath(previousPath);
        int totalCnt = 0;
        int deDuplicatedCnt = 0;
        while (it.hasNext()) {
            ++totalCnt;
            String currentPath = it.next();
            if (previousPath.equals(currentPath)) continue;
            TreeNode currentNode = node.getOrCreatePath(currentPath);
            while (node != null && !node.isAncestorOf(currentNode)) {
                if (JournalEntry.inScope(node, path)) {
                    entry.append(node.getPath(), JournalEntry.getChanges(node));
                }
                ++deDuplicatedCnt;
                node.children = TreeNode.NO_CHILDREN;
                node = node.parent;
            }
            if (node == null) {
                node = new TreeNode();
                node = node.getOrCreatePath(currentPath);
            } else {
                node = currentNode;
            }
            previousPath = currentPath;
        }
        while (node != null && JournalEntry.inScope(node, path)) {
            entry.append(node.getPath(), JournalEntry.getChanges(node));
            ++deDuplicatedCnt;
            node = node.parent;
        }
        entry.done();
        LOG.debug("applyTo: done. totalCnt: {}, deDuplicatedCnt: {}", (Object)totalCnt, (Object)deDuplicatedCnt);
    }

    private static boolean inScope(TreeNode node, Path path) {
        if (path.isRoot()) {
            return true;
        }
        Path p = node.getPath();
        int depthDiff = p.getDepth() - path.getDepth();
        return depthDiff >= 0 && Iterables.elementsEqual(path.elements(), p.getAncestor(depthDiff).elements());
    }

    static int fillExternalChanges(@NotNull StringSort externalChanges, @NotNull StringSort invalidate, @NotNull Revision from, @NotNull Revision to, @NotNull DocumentStore store) throws IOException {
        return JournalEntry.fillExternalChanges(externalChanges, invalidate, Path.ROOT, from, to, store, entry -> {}, null, null);
    }

    static int fillExternalChanges(@NotNull StringSort externalChanges, @Nullable StringSort invalidate, @NotNull Path path, @NotNull Revision from, @NotNull Revision to, @NotNull DocumentStore store, @NotNull Consumer<JournalEntry> journalEntryConsumer, @Nullable ChangeSetBuilder changeSetBuilder, @Nullable JournalPropertyHandler journalPropertyHandler) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((((Revision)Preconditions.checkNotNull((Object)from)).getClusterId() == ((Revision)Preconditions.checkNotNull((Object)to)).getClusterId() ? 1 : 0) != 0);
        if (from.compareRevisionTime(to) >= 0) {
            return 0;
        }
        String inclusiveToId = JournalEntry.asId(to);
        to = new Revision(to.getTimestamp(), to.getCounter() + 1, to.getClusterId(), to.isBranch());
        String toId = JournalEntry.asId(to);
        String fromId = JournalEntry.asId(from);
        int numEntries = 0;
        Document lastEntry = null;
        while (!fromId.equals(inclusiveToId)) {
            List<JournalEntry> partialResult = store.query(Collection.JOURNAL, fromId, toId, 100);
            numEntries += partialResult.size();
            if (!partialResult.isEmpty()) {
                lastEntry = partialResult.get(partialResult.size() - 1);
            }
            for (JournalEntry d : partialResult) {
                JournalEntry.fillFromJournalEntry(externalChanges, invalidate, path, changeSetBuilder, journalPropertyHandler, d, journalEntryConsumer);
            }
            if (partialResult.size() < 100) break;
            fromId = partialResult.get(partialResult.size() - 1).getId();
        }
        if (numEntries == 0 || lastEntry != null && !lastEntry.getId().equals(inclusiveToId)) {
            String maxId = JournalEntry.asId(new Revision(Long.MAX_VALUE, 0, to.getClusterId()));
            for (JournalEntry d : store.query(Collection.JOURNAL, inclusiveToId, maxId, 1)) {
                JournalEntry.fillFromJournalEntry(externalChanges, invalidate, path, changeSetBuilder, journalPropertyHandler, d, journalEntryConsumer);
                ++numEntries;
            }
        }
        return numEntries;
    }

    private static void fillFromJournalEntry(@NotNull StringSort externalChanges, @Nullable StringSort invalidate, @NotNull Path path, @Nullable ChangeSetBuilder changeSetBuilder, @Nullable JournalPropertyHandler journalPropertyHandler, @NotNull JournalEntry d, @NotNull Consumer<JournalEntry> journalEntryConsumer) throws IOException {
        d.addTo(externalChanges, path);
        if (invalidate != null) {
            d.addInvalidateOnlyTo(invalidate);
        }
        if (changeSetBuilder != null) {
            d.addTo(changeSetBuilder);
        }
        if (journalPropertyHandler != null) {
            journalPropertyHandler.readFrom(d);
        }
        journalEntryConsumer.accept(d);
    }

    long getRevisionTimestamp() {
        String[] parts = this.getId().split("-");
        return Long.parseLong(parts[1], 16);
    }

    void modified(Path path) {
        TreeNode node = this.getChanges();
        for (String name : path.elements()) {
            if (node.get(name) == null) {
                ++this.numChangedNodes;
            }
            node = node.getOrCreate(name);
        }
    }

    void modified(Iterable<Path> paths) {
        for (Path p : paths) {
            this.modified(p);
        }
    }

    void addChangeSet(@Nullable ChangeSet changeSet) {
        if (changeSet == null && LOG.isDebugEnabled()) {
            LOG.debug("Null changeSet found for caller. ChangeSetBuilder will be set to overflow mode", (Throwable)new Exception("call stack"));
        }
        this.changeSetBuilder.add(changeSet);
    }

    public void readFrom(CommitInfo info) {
        if (this.journalPropertyHandler != null) {
            this.journalPropertyHandler.readFrom(info);
        }
    }

    private void addTo(ChangeSetBuilder changeSetBuilder) {
        String cs = (String)this.get(CHANGE_SET);
        ChangeSet set = null;
        if (cs == null && this.getChanges().keySet().isEmpty()) {
            return;
        }
        if (cs != null) {
            set = ChangeSet.fromString((String)cs);
        } else {
            LOG.debug("Null changeSet found for JournalEntry {}. ChangeSetBuilder would be set to overflow mode", (Object)this.getId());
        }
        changeSetBuilder.add(set);
    }

    void branchCommit(@NotNull Iterable<Revision> revisions) {
        if (!revisions.iterator().hasNext()) {
            return;
        }
        Object branchCommits = (String)this.get(BRANCH_COMMITS);
        if (branchCommits == null) {
            branchCommits = "";
        }
        for (Revision r : revisions) {
            if (((String)branchCommits).length() > 0) {
                branchCommits = (String)branchCommits + ",";
            }
            branchCommits = (String)branchCommits + JournalEntry.asId(r.asBranchRevision());
            this.hasBranchCommits = true;
        }
        this.put(BRANCH_COMMITS, branchCommits);
    }

    UpdateOp asUpdateOp(@NotNull Revision revision) {
        String inv;
        String id = JournalEntry.asId(revision);
        UpdateOp op = new UpdateOp(id, true);
        op.set(CHANGES, this.getChanges().serialize());
        if (this.changeSetBuilder != null) {
            op.set(CHANGE_SET, this.changeSetBuilder.build().asString());
        }
        if (this.journalPropertyHandler != null) {
            this.journalPropertyHandler.addTo(op);
        }
        op.set(MODIFIED, revision.getTimestamp());
        String bc = (String)this.get(BRANCH_COMMITS);
        if (bc != null) {
            op.set(BRANCH_COMMITS, bc);
        }
        if ((inv = (String)this.get(INVALIDATE_ONLY)) != null) {
            op.set(INVALIDATE_ONLY, inv);
        }
        return op;
    }

    void invalidate(@NotNull Iterable<Revision> revisions) {
        Object value = (String)this.get(INVALIDATE_ONLY);
        if (value == null) {
            value = "";
        }
        for (Revision r : revisions) {
            if (((String)value).length() > 0) {
                value = (String)value + ",";
            }
            value = (String)value + JournalEntry.asId(r.asBranchRevision());
        }
        this.put(INVALIDATE_ONLY, value);
    }

    void addTo(final StringSort sort, Path path) throws IOException {
        TraversingVisitor v = new TraversingVisitor(){

            @Override
            public void node(TreeNode node, Path p) throws IOException {
                sort.add(p.toString());
            }
        };
        TreeNode n = this.getNode(path);
        if (n != null) {
            n.accept(v, path);
        }
        for (JournalEntry e : this.getBranchCommits()) {
            n = e.getNode(path);
            if (n == null) continue;
            n.accept(v, path);
        }
    }

    @NotNull
    Iterable<JournalEntry> getBranchCommits() {
        return this.getLinkedEntries(BRANCH_COMMITS);
    }

    int getNumChangedNodes() {
        return this.numChangedNodes;
    }

    boolean hasChanges() {
        return this.numChangedNodes > 0 || this.hasBranchCommits || this.hasInvalidateOnlyReferences();
    }

    private boolean hasInvalidateOnlyReferences() {
        String value = (String)this.get(INVALIDATE_ONLY);
        return value != null && !value.isEmpty();
    }

    private void addInvalidateOnlyTo(final StringSort sort) throws IOException {
        TraversingVisitor v = new TraversingVisitor(){

            @Override
            public void node(TreeNode node, Path path) throws IOException {
                sort.add(path.toString());
            }
        };
        for (JournalEntry e : this.getInvalidateOnly()) {
            e.getChanges().accept(v, Path.ROOT);
        }
    }

    @NotNull
    private Iterable<JournalEntry> getInvalidateOnly() {
        return this.getLinkedEntries(INVALIDATE_ONLY);
    }

    private Iterable<JournalEntry> getLinkedEntries(final String name) {
        final ArrayList ids = Lists.newArrayList();
        String bc = (String)this.get(name);
        if (bc != null) {
            for (String id : bc.split(",")) {
                if (id.length() == 0) continue;
                ids.add(id);
            }
        }
        return new Iterable<JournalEntry>(){

            @Override
            public Iterator<JournalEntry> iterator() {
                return new AbstractIterator<JournalEntry>(){
                    private final Iterator<String> it;
                    {
                        this.it = ids.iterator();
                    }

                    protected JournalEntry computeNext() {
                        if (!this.it.hasNext()) {
                            return (JournalEntry)this.endOfData();
                        }
                        String id = this.it.next();
                        JournalEntry d = JournalEntry.this.store.find(Collection.JOURNAL, id);
                        if (d == null) {
                            throw new IllegalStateException("Missing " + name + " entry for revision: " + id);
                        }
                        return d;
                    }
                };
            }
        };
    }

    private static String getChanges(TreeNode node) {
        JsopBuilder builder = new JsopBuilder();
        for (String name : node.keySet()) {
            builder.tag('^');
            builder.key(name);
            builder.object().endObject();
        }
        return builder.toString();
    }

    static String asId(@NotNull Revision revision) {
        Preconditions.checkNotNull((Object)revision);
        Object s = String.format(REVISION_FORMAT, revision.getClusterId(), revision.getTimestamp(), revision.getCounter());
        if (revision.isBranch()) {
            s = "b" + (String)s;
        }
        return s;
    }

    @Nullable
    private TreeNode getNode(Path path) {
        TreeNode node = this.getChanges();
        for (String name : path.elements()) {
            if ((node = node.get(name)) != null) continue;
            return null;
        }
        return node;
    }

    @NotNull
    private TreeNode getChanges() {
        if (this.changes == null) {
            TreeNode node = new TreeNode(this.concurrent);
            String c = (String)this.get(CHANGES);
            if (c != null) {
                node.parse((JsopReader)new JsopTokenizer(c));
            }
            this.changes = node;
        }
        return this.changes;
    }

    private static interface MapFactory {
        public static final MapFactory DEFAULT = new MapFactory(){

            @Override
            public Map<String, TreeNode> newMap() {
                return Maps.newHashMap();
            }
        };
        public static final MapFactory CONCURRENT = new MapFactory(){

            @Override
            public Map<String, TreeNode> newMap() {
                return Maps.newConcurrentMap();
            }
        };

        public Map<String, TreeNode> newMap();
    }

    private static interface TraversingVisitor {
        public void node(TreeNode var1, Path var2) throws IOException;
    }

    private static final class TreeNode {
        private static final Map<String, TreeNode> NO_CHILDREN = Collections.emptyMap();
        private Map<String, TreeNode> children = NO_CHILDREN;
        private final MapFactory mapFactory;
        private final TreeNode parent;
        private final String name;

        TreeNode() {
            this(false);
        }

        TreeNode(boolean concurrent) {
            this(concurrent ? MapFactory.CONCURRENT : MapFactory.DEFAULT, null, "");
        }

        TreeNode(MapFactory mapFactory, TreeNode parent, String name) {
            Preconditions.checkArgument((!name.contains("/") ? 1 : 0) != 0, (String)"name must not contain '/': {}", (Object[])new Object[]{name});
            this.mapFactory = mapFactory;
            this.parent = parent;
            this.name = name;
        }

        TreeNode getOrCreatePath(String path) {
            TreeNode n = this.getRoot();
            for (String name : PathUtils.elements((String)path)) {
                n = n.getOrCreate(name);
            }
            return n;
        }

        boolean isAncestorOf(TreeNode other) {
            TreeNode n = other;
            while (n.parent != null) {
                if (this == n.parent) {
                    return true;
                }
                n = n.parent;
            }
            return false;
        }

        @NotNull
        private TreeNode getRoot() {
            TreeNode n = this;
            while (n.parent != null) {
                n = n.parent;
            }
            return n;
        }

        private Path getPath() {
            Path p = this.parent != null ? new Path(this.parent.getPath(), this.name) : Path.ROOT;
            return p;
        }

        void parse(JsopReader reader) {
            reader.read(123);
            if (!reader.matches(125)) {
                do {
                    String name = Utils.unescapePropertyName(reader.readString());
                    reader.read(58);
                    this.getOrCreate(name).parse(reader);
                } while (reader.matches(44));
                reader.read(125);
            }
        }

        String serialize() {
            JsopBuilder builder = new JsopBuilder();
            builder.object();
            this.toJson(builder);
            builder.endObject();
            return builder.toString();
        }

        @NotNull
        Set<String> keySet() {
            return this.children.keySet();
        }

        @Nullable
        TreeNode get(String name) {
            return this.children.get(name);
        }

        void accept(TraversingVisitor visitor, Path path) throws IOException {
            visitor.node(this, path);
            for (Map.Entry<String, TreeNode> entry : this.children.entrySet()) {
                entry.getValue().accept(visitor, new Path(path, entry.getKey()));
            }
        }

        private void toJson(JsopBuilder builder) {
            for (Map.Entry<String, TreeNode> entry : this.children.entrySet()) {
                builder.key(Utils.escapePropertyName(entry.getKey()));
                builder.object();
                entry.getValue().toJson(builder);
                builder.endObject();
            }
        }

        @NotNull
        private TreeNode getOrCreate(String name) {
            TreeNode c;
            if (this.children == NO_CHILDREN) {
                this.children = this.mapFactory.newMap();
            }
            if ((c = this.children.get(name)) == null) {
                c = new TreeNode(this.mapFactory, this, name);
                this.children.put(name, c);
            }
            return c;
        }
    }
}

