/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.LastRevs;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.PropertyHistory;
import org.apache.jackrabbit.oak.plugins.document.Range;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.SplitOperations;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.ValueMap;
import org.apache.jackrabbit.oak.plugins.document.memory.MemoryDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.LogSilencer;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDocument
extends Document {
    public static final NodeDocument NULL = new NodeDocument(new MemoryDocumentStore());
    static final Logger LOG;
    private static final LogSilencer LOG_SILENCER;
    public static final String MIN_ID_VALUE = "0000000";
    public static final String MAX_ID_VALUE = ";";
    static final int SPLIT_CANDIDATE_THRESHOLD = 8192;
    static final int DOC_SIZE_THRESHOLD = 0x100000;
    static final int NUM_REVS_THRESHOLD = 100;
    static final int PREV_SPLIT_FACTOR = 10;
    public static final String COLLISIONS = "_collisions";
    public static final String MODIFIED_IN_SECS = "_modified";
    static final int MODIFIED_IN_SECS_RESOLUTION = 5;
    private static final NavigableMap<Revision, Range> EMPTY_RANGE_MAP;
    static final String COMMIT_ROOT = "_commitRoot";
    private static final String PREVIOUS = "_prev";
    private static final String DELETED = "_deleted";
    public static final String DELETED_ONCE = "_deletedOnce";
    static final String REVISIONS = "_revisions";
    private static final String LAST_REV = "_lastRev";
    private static final String CHILDREN_FLAG = "_children";
    public static final String PATH = "_path";
    public static final String HAS_BINARY_FLAG = "_bin";
    private static final String STALE_PREV = "_stalePrev";
    private static final String BRANCH_COMMITS = "_bc";
    static final String SWEEP_REV = "_sweepRev";
    public static final String SD_TYPE = "_sdType";
    public static final String SD_MAX_REV_TIME_IN_SECS = "_sdMaxRevTime";
    private static final Path PREVIOUS_PREFIX;
    public static final long HAS_BINARY_VAL = 1L;
    final DocumentStore store;
    private NavigableMap<Revision, Range> previous;
    private final AtomicLong lastCheckTime = new AtomicLong(Revision.getCurrentTimestamp());
    private final long creationTime;

    public static long getModifiedInSecs(long timestamp) {
        long timeInSec = TimeUnit.MILLISECONDS.toSeconds(timestamp);
        return timeInSec - timeInSec % 5L;
    }

    NodeDocument(@NotNull DocumentStore store) {
        this(store, Revision.getCurrentTimestamp());
    }

    public NodeDocument(@NotNull DocumentStore store, long creationTime) {
        this.store = (DocumentStore)Preconditions.checkNotNull((Object)store);
        this.creationTime = creationTime;
    }

    @NotNull
    public Map<Revision, String> getValueMap(@NotNull String key) {
        return ValueMap.create(this, key);
    }

    public long getCreated() {
        return this.creationTime;
    }

    @Nullable
    public Long getModified() {
        return (Long)this.get(MODIFIED_IN_SECS);
    }

    public boolean hasChildren() {
        Boolean childrenFlag = (Boolean)this.get(CHILDREN_FLAG);
        return childrenFlag != null && childrenFlag != false;
    }

    public boolean wasDeletedOnce() {
        Boolean deletedOnceFlag = (Boolean)this.get(DELETED_ONCE);
        return deletedOnceFlag != null && deletedOnceFlag != false;
    }

    public boolean hasBeenModifiedSince(long lastModifiedTime) {
        Long modified = (Long)this.get(MODIFIED_IN_SECS);
        return modified != null && modified > TimeUnit.MILLISECONDS.toSeconds(lastModifiedTime);
    }

    public boolean hasAllRevisionLessThan(long maxRevisionTime) {
        Long maxRevTimeStamp = (Long)this.get(SD_MAX_REV_TIME_IN_SECS);
        return maxRevTimeStamp != null && maxRevTimeStamp < TimeUnit.MILLISECONDS.toSeconds(maxRevisionTime);
    }

    public boolean isSplitDocument() {
        return this.getSplitDocType() != SplitDocType.NONE;
    }

    public SplitDocType getSplitDocType() {
        Object t = this.get(SD_TYPE);
        return t == null ? SplitDocType.valueOf((Integer)null) : SplitDocType.valueOf(((Number)t).intValue());
    }

    public void markUpToDate(long checkTime) {
        this.lastCheckTime.set(checkTime);
    }

    public long getLastCheckTime() {
        return this.lastCheckTime.get();
    }

    public boolean hasBinary() {
        Number flag = (Number)this.get(HAS_BINARY_FLAG);
        return flag != null && (long)flag.intValue() == 1L;
    }

    @NotNull
    public Path getMainPath() {
        String p = this.getPathString();
        if (p.startsWith("p")) {
            if ((p = PathUtils.getAncestorPath((String)p, (int)2)).length() == 1) {
                return Path.ROOT;
            }
            p = p.substring(1);
        }
        return Path.fromString(p);
    }

    @NotNull
    public Map<Integer, Revision> getLastRev() {
        HashMap map = Maps.newHashMap();
        SortedMap<Revision, String> valueMap = this.getLocalMap(LAST_REV);
        for (Map.Entry e : valueMap.entrySet()) {
            int clusterId = ((Revision)e.getKey()).getClusterId();
            Revision rev = Revision.fromString((String)e.getValue());
            map.put(clusterId, rev);
        }
        return map;
    }

    public boolean containsRevision(@NotNull Revision revision) {
        if (this.getLocalRevisions().containsKey(revision)) {
            return true;
        }
        for (NodeDocument prev : this.getPreviousDocs(REVISIONS, revision)) {
            if (!prev.containsRevision(revision)) continue;
            return true;
        }
        return false;
    }

    int purgeUncommittedRevisions(int clusterId, int batchSize, Predicate<Revision> olderThanLastWrittenRootRevPredicate) {
        SortedMap<Revision, String> localRevisions = this.getLocalRevisions();
        UpdateOp op = new UpdateOp(Objects.requireNonNull(this.getId()), false);
        HashSet<Revision> uniqueRevisions = new HashSet<Revision>();
        for (Map.Entry commit : localRevisions.entrySet()) {
            Revision r;
            if (!Utils.isCommitted((String)commit.getValue()) && (r = (Revision)commit.getKey()).getClusterId() == clusterId && olderThanLastWrittenRootRevPredicate.test(r)) {
                uniqueRevisions.add(r);
                NodeDocument.removeRevision(op, r);
            }
            if (op.getChanges().size() < batchSize) continue;
            this.store.findAndUpdate(Collection.NODES, op);
            op = new UpdateOp(Objects.requireNonNull(this.getId()), false);
        }
        if (op.hasChanges()) {
            this.store.findAndUpdate(Collection.NODES, op);
            op = new UpdateOp(Objects.requireNonNull(this.getId()), false);
        }
        for (Revision r : this.getLocalBranchCommits()) {
            String commitValue = (String)localRevisions.get(r);
            if (!Utils.isCommitted(commitValue) && r.getClusterId() == clusterId && olderThanLastWrittenRootRevPredicate.test(r)) {
                uniqueRevisions.add(r);
                NodeDocument.removeBranchCommit(op, r);
            }
            if (op.getChanges().size() < batchSize) continue;
            this.store.findAndUpdate(Collection.NODES, op);
            op = new UpdateOp(Objects.requireNonNull(this.getId()), false);
        }
        if (op.hasChanges()) {
            this.store.findAndUpdate(Collection.NODES, op);
        }
        return uniqueRevisions.size();
    }

    int purgeCollisionMarkers(int clusterId, int batchSize, Predicate<Revision> olderThanLastWrittenRootRevPredicate) {
        SortedMap<Revision, String> valueMap = this.getLocalMap(COLLISIONS);
        UpdateOp op = new UpdateOp(Objects.requireNonNull(this.getId()), false);
        int purgeCount = 0;
        for (Map.Entry commit : valueMap.entrySet()) {
            Revision r = (Revision)commit.getKey();
            if (r.getClusterId() == clusterId && olderThanLastWrittenRootRevPredicate.test(r)) {
                ++purgeCount;
                NodeDocument.removeCollision(op, r);
            }
            if (op.getChanges().size() < batchSize) continue;
            this.store.findAndUpdate(Collection.NODES, op);
            op = new UpdateOp(Objects.requireNonNull(this.getId()), false);
        }
        if (op.hasChanges()) {
            this.store.findAndUpdate(Collection.NODES, op);
        }
        return purgeCount;
    }

    @NotNull
    Set<Revision> getConflictsFor(@NotNull Iterable<Revision> changes) {
        Preconditions.checkNotNull(changes);
        HashSet conflicts = Sets.newHashSet();
        SortedMap<Revision, String> collisions = this.getLocalMap(COLLISIONS);
        for (Revision r : changes) {
            String value = (String)collisions.get(r.asTrunkRevision());
            if (value == null) continue;
            try {
                conflicts.add(Revision.fromString(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return conflicts;
    }

    @Nullable
    public Path getCommitRootPath(Revision revision) {
        String depth = this.getCommitRootDepth(revision);
        if (depth != null) {
            return this.getPathAtDepth(depth);
        }
        return null;
    }

    @Nullable
    Revision getNewestRevision(RevisionContext context, RevisionVector baseRev, Revision changeRev, Branch branch, Set<Revision> collisions) {
        Preconditions.checkArgument((!baseRev.isBranch() || branch != null ? 1 : 0) != 0, (Object)"Branch must be non-null if baseRev is a branch revision");
        RevisionVector head = context.getHeadRevision();
        RevisionVector lower = branch != null ? branch.getBase() : baseRev;
        HashSet clusterIds = Collections.emptySet();
        if (!this.getPreviousRanges().isEmpty()) {
            clusterIds = Sets.newHashSet();
            for (Revision prevRev : this.getPreviousRanges().keySet()) {
                if (!lower.isRevisionNewer(prevRev) && !com.google.common.base.Objects.equal((Object)prevRev, (Object)lower.getRevision(prevRev.getClusterId()))) continue;
                clusterIds.add(prevRev.getClusterId());
            }
            if (!clusterIds.isEmpty()) {
                for (Revision r : this.getLocalCommitRoot().keySet()) {
                    clusterIds.add(r.getClusterId());
                }
                for (Revision r : this.getLocalRevisions().keySet()) {
                    clusterIds.add(r.getClusterId());
                }
            }
        }
        boolean fullScan = true;
        Iterable changes = Iterables.mergeSorted((Iterable)ImmutableList.of(this.getLocalRevisions().keySet(), this.getLocalCommitRoot().keySet()), this.getLocalRevisions().comparator());
        if (!clusterIds.isEmpty()) {
            fullScan = false;
            changes = Iterables.mergeSorted((Iterable)ImmutableList.of((Object)changes, this.getChanges(REVISIONS, lower), this.getChanges(COMMIT_ROOT, lower)), this.getLocalRevisions().comparator());
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNewestRevision() with changeRev {} on {}, _revisions {}, _commitRoot {}", new Object[]{changeRev, this.getId(), this.getLocalRevisions(), this.getLocalCommitRoot()});
            }
        }
        HashMap newestRevs = Maps.newHashMap();
        HashMap validRevisions = Maps.newHashMap();
        for (Object r : changes) {
            if (((Revision)r).equals(changeRev)) continue;
            if (!fullScan && clusterIds.contains(((Revision)r).getClusterId()) && !lower.isRevisionNewer((Revision)r) && newestRevs.containsKey(((Revision)r).getClusterId())) {
                clusterIds.remove(((Revision)r).getClusterId());
                if (clusterIds.isEmpty()) break;
            }
            if (newestRevs.containsKey(((Revision)r).getClusterId())) {
                if (branch == null || branch.containsCommit((Revision)r) || !branch.getBase(changeRev).isRevisionNewer((Revision)r)) continue;
                collisions.add((Revision)r);
                continue;
            }
            if (this.isValidRevision(context, (Revision)r, null, baseRev, validRevisions)) {
                newestRevs.put(((Revision)r).getClusterId(), r);
                continue;
            }
            Revision commitRevision = null;
            String cv = context.getCommitValue((Revision)r, this);
            if (Utils.isCommitted(cv)) {
                commitRevision = Utils.resolveCommitRevision((Revision)r, cv);
            }
            if (commitRevision != null && head.isRevisionNewer(commitRevision)) {
                collisions.add((Revision)r);
                continue;
            }
            if (commitRevision != null && branch == null && baseRev.isRevisionNewer((Revision)r)) {
                newestRevs.put(((Revision)r).getClusterId(), r);
                continue;
            }
            collisions.add((Revision)r);
        }
        Revision newestRev = null;
        for (Revision r : newestRevs.values()) {
            newestRev = Utils.max(newestRev, r, StableRevisionComparator.INSTANCE);
        }
        if (newestRev == null) {
            return null;
        }
        SortedMap<Revision, String> deleted = this.getLocalDeleted();
        String value = (String)deleted.get(newestRev);
        if (value == null && deleted.headMap(newestRev).isEmpty()) {
            return newestRev;
        }
        if (value == null) {
            value = this.getDeleted().get(newestRev);
        }
        if ("true".equals(value)) {
            return null;
        }
        return newestRev;
    }

    private boolean isValidRevision(@NotNull RevisionContext context, @NotNull Revision rev, @Nullable String commitValue, @NotNull RevisionVector readRevision, @NotNull Map<Revision, String> validRevisions) {
        if (validRevisions.containsKey(rev)) {
            return true;
        }
        if (commitValue == null) {
            commitValue = context.getCommitValue(rev, this);
        }
        if (commitValue == null) {
            return false;
        }
        if (this.isVisible(context, rev, commitValue, readRevision)) {
            validRevisions.put(rev, commitValue);
            return true;
        }
        return false;
    }

    @Nullable
    public DocumentNodeState getNodeAtRevision(@NotNull DocumentNodeStore nodeStore, @NotNull RevisionVector readRevision, @Nullable Revision lastModified) {
        Branch branch;
        LastRevs lastRevs;
        HashMap validRevisions = Maps.newHashMap();
        Revision min = this.getLiveRevision(nodeStore, readRevision, validRevisions, lastRevs = this.createLastRevs(readRevision, nodeStore, branch = nodeStore.getBranches().getBranch(readRevision), lastModified));
        if (min == null) {
            return null;
        }
        Path path = this.getPath();
        ArrayList props = Lists.newArrayList();
        for (String key : this.keySet()) {
            Object local;
            if (!Utils.isPropertyName(key) || (local = this.getLocalMap(key)).isEmpty()) continue;
            Value value = this.getLatestValue(nodeStore, local.entrySet(), readRevision, validRevisions, lastRevs);
            if (value != null && !this.getPreviousRanges().isEmpty() && !this.isMostRecentCommitted((SortedMap<Revision, String>)local, value.revision, nodeStore)) {
                for (Revision prev : this.getPreviousRanges().keySet()) {
                    if (prev.compareRevisionTimeThenClusterId(value.revision) <= 0) continue;
                    value = null;
                    break;
                }
            }
            if (value == null && !this.getPreviousRanges().isEmpty()) {
                value = this.getLatestValue(nodeStore, this.getVisibleChanges(key, readRevision), readRevision, validRevisions, lastRevs);
            }
            String propertyName = Utils.unescapePropertyName(key);
            String v = value != null ? value.value : null;
            if (v == null) continue;
            props.add(nodeStore.createPropertyState(propertyName, v));
        }
        RevisionVector lastRevision = new RevisionVector(min);
        RevisionVector branchBase = null;
        if (branch != null) {
            branchBase = branch.getBase(readRevision.getBranchRevision());
        }
        for (Revision r : lastRevs) {
            Revision rev;
            if (readRevision.isRevisionNewer(r)) {
                rev = readRevision.getRevision(r.getClusterId());
                if (rev != null) {
                    lastRevision = lastRevision.update(rev);
                    continue;
                }
                lastRevision = lastRevision.remove(r.getClusterId());
                continue;
            }
            if (branchBase != null && branchBase.isRevisionNewer(r)) {
                rev = branchBase.getRevision(r.getClusterId());
                if (rev != null) {
                    lastRevision = lastRevision.update(rev);
                    continue;
                }
                lastRevision = lastRevision.remove(r.getClusterId());
                continue;
            }
            if (!lastRevision.isRevisionNewer(r)) continue;
            lastRevision = lastRevision.update(r);
        }
        if (branch != null) {
            lastRevs.updateBranch(branch.getUnsavedLastRevision(path, readRevision.getBranchRevision()));
            Revision r = lastRevs.getBranchRevision();
            if (r != null) {
                lastRevision = lastRevision.update(r);
            }
        }
        return new DocumentNodeState(nodeStore, path, readRevision, props, this.hasChildren(), lastRevision);
    }

    @Nullable
    public Revision getLiveRevision(RevisionContext context, RevisionVector readRevision, Map<Revision, String> validRevisions, LastRevs lastRevs) {
        Value value = this.getLatestValue(context, this.getLocalDeleted().entrySet(), readRevision, validRevisions, lastRevs);
        if (value == null && !this.getPreviousRanges().isEmpty()) {
            value = this.getLatestValue(context, this.getDeleted().entrySet(), readRevision, validRevisions, lastRevs);
        }
        return value != null && "false".equals(value.value) ? value.revision : null;
    }

    boolean isConflicting(@NotNull UpdateOp op, @NotNull RevisionVector baseRevision, @NotNull Revision commitRevision, boolean enableConcurrentAddRemove) {
        SortedMap<Revision, String> deleted = this.getLocalDeleted();
        boolean allowConflictingDeleteChange = enableConcurrentAddRemove && this.allowConflictingDeleteChange(op);
        for (Map.Entry entry : deleted.entrySet()) {
            if (((Revision)entry.getKey()).equals(commitRevision) || !baseRevision.isRevisionNewer((Revision)entry.getKey())) continue;
            boolean newerDeleted = Boolean.parseBoolean((String)entry.getValue());
            if (allowConflictingDeleteChange && op.isDelete() == newerDeleted) continue;
            return true;
        }
        for (Map.Entry<Object, Object> entry : op.getChanges().entrySet()) {
            if (((UpdateOp.Operation)entry.getValue()).type != UpdateOp.Operation.Type.SET_MAP_ENTRY) continue;
            String name = ((UpdateOp.Key)entry.getKey()).getName();
            if (DELETED.equals(name) && !allowConflictingDeleteChange) {
                return true;
            }
            if (!Utils.isPropertyName(name)) continue;
            for (Revision rev : this.getChanges(name, baseRevision)) {
                if (rev.equals(commitRevision) || !baseRevision.isRevisionNewer(rev)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean allowConflictingDeleteChange(UpdateOp op) {
        String path = this.getPathString();
        if (!Utils.isHiddenPath(path)) {
            return false;
        }
        if (!op.isNew() && !op.isDelete()) {
            return false;
        }
        for (UpdateOp.Key opKey : op.getChanges().keySet()) {
            String name = opKey.getName();
            if (!Utils.isPropertyName(name)) continue;
            return false;
        }
        for (String dataKey : this.keySet()) {
            if (!Utils.isPropertyName(dataKey)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Iterable<UpdateOp> split(@NotNull RevisionContext context, @NotNull RevisionVector head, @NotNull Function<String, Long> binarySize) {
        return SplitOperations.forDocument(this, context, head, binarySize, 100);
    }

    @NotNull
    NavigableMap<Revision, Range> getPreviousRanges() {
        return this.getPreviousRanges(false);
    }

    @NotNull
    NavigableMap<Revision, Range> getPreviousRanges(boolean includeStale) {
        if (includeStale) {
            return this.createPreviousRanges(true);
        }
        if (this.previous == null) {
            this.previous = this.createPreviousRanges(false);
        }
        return this.previous;
    }

    @NotNull
    private NavigableMap<Revision, Range> createPreviousRanges(boolean includeStale) {
        NavigableMap ranges;
        SortedMap<Revision, String> map = this.getLocalMap(PREVIOUS);
        if (map.isEmpty()) {
            ranges = EMPTY_RANGE_MAP;
        } else {
            Map stale = Collections.emptyMap();
            if (!includeStale) {
                stale = this.getLocalMap(STALE_PREV);
            }
            TreeMap<Revision, Range> transformed = new TreeMap<Revision, Range>(StableRevisionComparator.REVERSE);
            for (Map.Entry entry : map.entrySet()) {
                Range r = Range.fromEntry((Revision)entry.getKey(), (String)entry.getValue());
                if (String.valueOf(r.height).equals(stale.get(r.high))) continue;
                transformed.put(r.high, r);
            }
            ranges = Maps.unmodifiableNavigableMap(transformed);
        }
        return ranges;
    }

    @NotNull
    Iterable<NodeDocument> getPreviousDocs(final @NotNull String property, final @Nullable Revision revision) {
        if (this.getPreviousRanges().isEmpty()) {
            return Collections.emptyList();
        }
        if (revision == null) {
            return new PropertyHistory(this, property);
        }
        Path mainPath = this.getMainPath();
        Map.Entry<Revision, Range> entry = this.getPreviousRanges().floorEntry(revision);
        if (entry != null) {
            int h;
            Revision r = entry.getKey();
            String prevId = Utils.getPreviousIdFor(mainPath, r, h = entry.getValue().height);
            NodeDocument prev = this.getPreviousDocument(prevId);
            if (prev != null) {
                if (prev.getValueMap(property).containsKey(revision)) {
                    return Collections.singleton(prev);
                }
            } else {
                this.previousDocumentNotFound(prevId, revision);
            }
        }
        return Iterables.filter((Iterable)Iterables.transform(this.getPreviousRanges().headMap(revision).entrySet(), (Function)new Function<Map.Entry<Revision, Range>, NodeDocument>(){

            public NodeDocument apply(Map.Entry<Revision, Range> input) {
                if (input.getValue().includes(revision)) {
                    return NodeDocument.this.getPreviousDoc(input.getKey(), input.getValue());
                }
                return null;
            }
        }), (com.google.common.base.Predicate)new com.google.common.base.Predicate<NodeDocument>(){

            public boolean apply(@Nullable NodeDocument input) {
                return input != null && input.getValueMap(property).containsKey(revision);
            }
        });
    }

    NodeDocument getPreviousDocument(String prevId) {
        LOG.trace("get previous document {}", (Object)prevId);
        NodeDocument doc = this.store.find(Collection.NODES, prevId);
        if (doc == null) {
            doc = this.store.find(Collection.NODES, prevId, 0);
        }
        return doc;
    }

    @NotNull
    Iterator<NodeDocument> getAllPreviousDocs() {
        if (this.getPreviousRanges().isEmpty()) {
            return Collections.emptyIterator();
        }
        return new AbstractIterator<NodeDocument>(){
            private Queue<Map.Entry<Revision, Range>> previousRanges;
            {
                this.previousRanges = Queues.newArrayDeque(NodeDocument.this.getPreviousRanges().entrySet());
            }

            protected NodeDocument computeNext() {
                Map.Entry<Revision, Range> e;
                NodeDocument prev;
                if (!this.previousRanges.isEmpty() && (prev = NodeDocument.this.getPreviousDoc((e = this.previousRanges.remove()).getKey(), e.getValue())) != null) {
                    this.previousRanges.addAll(prev.getPreviousRanges().entrySet());
                    return prev;
                }
                return (NodeDocument)this.endOfData();
            }
        };
    }

    @NotNull
    Iterator<NodeDocument> getPreviousDocLeaves() {
        if (this.getPreviousRanges().isEmpty()) {
            return Collections.emptyIterator();
        }
        final TreeMap ranges = Maps.newTreeMap(this.getPreviousRanges());
        return new AbstractIterator<NodeDocument>(){

            protected NodeDocument computeNext() {
                NodeDocument next;
                while (true) {
                    Map.Entry topEntry;
                    if ((topEntry = ranges.pollFirstEntry()) == null) {
                        next = (NodeDocument)this.endOfData();
                        break;
                    }
                    NodeDocument prev = NodeDocument.this.getPreviousDoc((Revision)topEntry.getKey(), (Range)topEntry.getValue());
                    if (prev == null) continue;
                    if (((Range)topEntry.getValue()).getHeight() == 0) {
                        next = prev;
                        break;
                    }
                    ranges.putAll(prev.getPreviousRanges());
                }
                return next;
            }
        };
    }

    @Nullable
    private NodeDocument getPreviousDoc(Revision rev, Range range) {
        int h = range.height;
        String prevId = Utils.getPreviousIdFor(this.getMainPath(), rev, h);
        NodeDocument prev = this.getPreviousDocument(prevId);
        if (prev != null) {
            return prev;
        }
        this.previousDocumentNotFound(prevId, rev);
        return null;
    }

    @Nullable
    NodeDocument findPrevReferencingDoc(Revision revision, int height) {
        for (Range range : this.getPreviousRanges().values()) {
            if (range.getHeight() == height && range.high.equals(revision)) {
                return this;
            }
            if (!range.includes(revision)) continue;
            String prevId = Utils.getPreviousIdFor(this.getMainPath(), range.high, range.height);
            NodeDocument prev = this.store.find(Collection.NODES, prevId);
            if (prev == null) {
                LOG.warn("Split document {} does not exist anymore. Main document is {}", (Object)prevId, (Object)Utils.getIdFromPath(this.getMainPath()));
                continue;
            }
            NodeDocument doc = prev.findPrevReferencingDoc(revision, height);
            if (doc == null) continue;
            return doc;
        }
        return null;
    }

    Iterable<Revision> getAllChanges() {
        RevisionVector empty = new RevisionVector(new Revision[0]);
        return Iterables.mergeSorted((Iterable)ImmutableList.of(this.getChanges(REVISIONS, empty), this.getChanges(COMMIT_ROOT, empty)), StableRevisionComparator.REVERSE);
    }

    @NotNull
    Iterable<Revision> getChanges(@NotNull String property, final @NotNull RevisionVector min) {
        com.google.common.base.Predicate<Revision> p = new com.google.common.base.Predicate<Revision>(){

            public boolean apply(Revision input) {
                return min.isRevisionNewer(input);
            }
        };
        ArrayList changes = Lists.newArrayList();
        changes.add(Utils.abortingIterable(this.getLocalMap(property).keySet(), p));
        for (Map.Entry e : this.getPreviousRanges().entrySet()) {
            NodeDocument prev;
            if (!min.isRevisionNewer((Revision)e.getKey()) || (prev = this.getPreviousDoc((Revision)e.getKey(), (Range)e.getValue())) == null) continue;
            changes.add(Utils.abortingIterable(prev.getValueMap(property).keySet(), p));
        }
        if (changes.size() == 1) {
            return (Iterable)changes.get(0);
        }
        return Iterables.mergeSorted((Iterable)changes, StableRevisionComparator.REVERSE);
    }

    @NotNull
    Iterable<Map.Entry<Revision, String>> getVisibleChanges(@NotNull String property, final @NotNull RevisionVector readRevision) {
        com.google.common.base.Predicate<Map.Entry<Revision, String>> p = new com.google.common.base.Predicate<Map.Entry<Revision, String>>(){

            public boolean apply(Map.Entry<Revision, String> input) {
                return !readRevision.isRevisionNewer(input.getKey());
            }
        };
        ArrayList changes = Lists.newArrayList();
        SortedMap<Revision, String> localChanges = this.getLocalMap(property);
        if (!localChanges.isEmpty()) {
            changes.add(Iterables.filter(localChanges.entrySet(), (com.google.common.base.Predicate)p));
        }
        for (Revision r : readRevision) {
            this.collectVisiblePreviousChanges(property, r, changes);
        }
        if (changes.size() == 1) {
            return (Iterable)changes.get(0);
        }
        return Iterables.mergeSorted((Iterable)changes, ValueComparator.REVERSE);
    }

    private void collectVisiblePreviousChanges(@NotNull String property, @NotNull Revision readRevision, @NotNull List<Iterable<Map.Entry<Revision, String>>> changes) {
        ArrayList revs = Lists.newArrayList();
        RevisionVector readRV = new RevisionVector(readRevision);
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Range r : this.getPreviousRanges().values()) {
            if (r.low.getClusterId() != readRevision.getClusterId() || readRevision.compareRevisionTime(r.low) < 0) continue;
            ranges.add(r);
        }
        ArrayList<Range> batch = new ArrayList<Range>();
        while (!ranges.isEmpty()) {
            Range previous = null;
            Iterator it = ranges.iterator();
            while (it.hasNext()) {
                Range r = (Range)it.next();
                if (previous != null && r.high.compareRevisionTime(previous.low) >= 0) continue;
                batch.add(r);
                it.remove();
                previous = r;
            }
            revs.add(this.changesFor(batch, readRV, property));
            batch.clear();
        }
        if (revs.size() == 1) {
            changes.add((Iterable)revs.get(0));
        } else if (!revs.isEmpty()) {
            changes.add(Iterables.mergeSorted((Iterable)revs, ValueComparator.REVERSE));
        }
    }

    private Iterable<Map.Entry<Revision, String>> changesFor(List<Range> ranges, final RevisionVector readRev, final String property) {
        Iterable changes;
        if (ranges.isEmpty()) {
            return Collections.emptyList();
        }
        Function<Range, Iterable<Map.Entry<Revision, String>>> rangeToChanges = new Function<Range, Iterable<Map.Entry<Revision, String>>>(){

            public Iterable<Map.Entry<Revision, String>> apply(Range input) {
                NodeDocument doc = NodeDocument.this.getPreviousDoc(input.high, input);
                if (doc == null) {
                    return Collections.emptyList();
                }
                return doc.getVisibleChanges(property, readRev);
            }
        };
        if (ranges.size() == 1) {
            Range range = ranges.get(0);
            changes = new Iterable<Map.Entry<Revision, String>>((Function)rangeToChanges, range){
                final /* synthetic */ Function val$rangeToChanges;
                final /* synthetic */ Range val$range;
                {
                    this.val$rangeToChanges = function;
                    this.val$range = range;
                }

                @Override
                public Iterator<Map.Entry<Revision, String>> iterator() {
                    return ((Iterable)this.val$rangeToChanges.apply((Object)this.val$range)).iterator();
                }
            };
        } else {
            changes = Iterables.concat((Iterable)Iterables.transform((Iterable)ImmutableList.copyOf(ranges), (Function)rangeToChanges));
        }
        return Iterables.filter((Iterable)changes, (com.google.common.base.Predicate)new com.google.common.base.Predicate<Map.Entry<Revision, String>>(){

            public boolean apply(Map.Entry<Revision, String> input) {
                return !readRev.isRevisionNewer(input.getKey());
            }
        });
    }

    @NotNull
    SortedMap<Revision, String> getLocalMap(String key) {
        SortedMap<Revision, String> map = (SortedMap<Revision, String>)this.data.get(key);
        if (map == null) {
            map = ValueMap.EMPTY;
        }
        return map;
    }

    @NotNull
    SortedMap<Revision, String> getLocalRevisions() {
        return this.getLocalMap(REVISIONS);
    }

    @NotNull
    SortedMap<Revision, String> getLocalCommitRoot() {
        return this.getLocalMap(COMMIT_ROOT);
    }

    @NotNull
    SortedMap<Revision, String> getLocalDeleted() {
        return this.getLocalMap(DELETED);
    }

    @NotNull
    SortedMap<Revision, String> getStalePrev() {
        return this.getLocalMap(STALE_PREV);
    }

    @NotNull
    public Set<Revision> getLocalBranchCommits() {
        return this.getLocalMap(BRANCH_COMMITS).keySet();
    }

    @Nullable
    String resolveCommitValue(Revision revision) {
        NodeDocument commitRoot = this.getCommitRoot(revision);
        if (commitRoot == null) {
            return null;
        }
        return commitRoot.getCommitValue(revision);
    }

    @NotNull
    RevisionVector getSweepRevisions() {
        return new RevisionVector(Iterables.transform(this.getLocalMap(SWEEP_REV).values(), (Function)new Function<String, Revision>(){

            public Revision apply(String s) {
                return Revision.fromString(s);
            }
        }));
    }

    public static void setChildrenFlag(@NotNull UpdateOp op, boolean hasChildNode) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).set(CHILDREN_FLAG, hasChildNode);
    }

    public static void setModified(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).max(MODIFIED_IN_SECS, Long.valueOf(NodeDocument.getModifiedInSecs(((Revision)Preconditions.checkNotNull((Object)revision)).getTimestamp())));
    }

    public static void setRevision(@NotNull UpdateOp op, @NotNull Revision revision, @NotNull String commitValue) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(REVISIONS, (Revision)Preconditions.checkNotNull((Object)revision), (String)Preconditions.checkNotNull((Object)commitValue));
    }

    public static void unsetRevision(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).unsetMapEntry(REVISIONS, (Revision)Preconditions.checkNotNull((Object)revision));
    }

    public static boolean isRevisionsEntry(String name) {
        return REVISIONS.equals(name);
    }

    public static boolean isCommitRootEntry(String name) {
        return COMMIT_ROOT.equals(name);
    }

    public static boolean isDeletedEntry(String name) {
        return DELETED.equals(name);
    }

    public static boolean isLastRevEntry(String name) {
        return LAST_REV.equals(name);
    }

    public static void removeRevision(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(REVISIONS, (Revision)Preconditions.checkNotNull((Object)revision));
    }

    public static void addCollision(@NotNull UpdateOp op, @NotNull Revision revision, @NotNull Revision other) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(COLLISIONS, (Revision)Preconditions.checkNotNull((Object)revision), other.toString());
    }

    public static void removeCollision(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(COLLISIONS, (Revision)Preconditions.checkNotNull((Object)revision));
    }

    public static void setLastRev(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(LAST_REV, new Revision(0L, 0, revision.getClusterId()), revision.toString());
    }

    public static void setCommitRoot(@NotNull UpdateOp op, @NotNull Revision revision, int commitRootDepth) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(COMMIT_ROOT, (Revision)Preconditions.checkNotNull((Object)revision), String.valueOf(commitRootDepth));
    }

    public static void removeCommitRoot(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(COMMIT_ROOT, revision);
    }

    public static void unsetCommitRoot(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).unsetMapEntry(COMMIT_ROOT, revision);
    }

    public static void setDeleted(@NotNull UpdateOp op, @NotNull Revision revision, boolean deleted) {
        if (deleted) {
            NodeDocument.setDeletedOnce(op);
        }
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(DELETED, (Revision)Preconditions.checkNotNull((Object)revision), String.valueOf(deleted));
    }

    public static void setDeletedOnce(@NotNull UpdateOp op) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).set(DELETED_ONCE, Boolean.TRUE);
    }

    public static void removeDeleted(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(DELETED, revision);
    }

    public static void setPrevious(@NotNull UpdateOp op, @NotNull Range range) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(PREVIOUS, ((Range)Preconditions.checkNotNull((Object)range)).high, range.getLowValue());
    }

    public static void removePrevious(@NotNull UpdateOp op, @NotNull Range range) {
        NodeDocument.removePrevious(op, ((Range)Preconditions.checkNotNull((Object)range)).high);
    }

    public static void removePrevious(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(PREVIOUS, (Revision)Preconditions.checkNotNull((Object)revision));
    }

    public static void setStalePrevious(@NotNull UpdateOp op, @NotNull Revision revision, int height) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(STALE_PREV, (Revision)Preconditions.checkNotNull((Object)revision), String.valueOf(height));
    }

    public static void removeStalePrevious(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(STALE_PREV, (Revision)Preconditions.checkNotNull((Object)revision));
    }

    public static void setHasBinary(@NotNull UpdateOp op) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).set(HAS_BINARY_FLAG, 1L);
    }

    public static void setBranchCommit(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(BRANCH_COMMITS, revision, String.valueOf(true));
    }

    public static void removeBranchCommit(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).removeMapEntry(BRANCH_COMMITS, revision);
    }

    public static void setSweepRevision(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).setMapEntry(SWEEP_REV, new Revision(0L, 0, revision.getClusterId()), revision.toString());
    }

    public static void hasLastRev(@NotNull UpdateOp op, @NotNull Revision revision) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).equals(LAST_REV, new Revision(0L, 0, revision.getClusterId()), revision.toString());
    }

    private void previousDocumentNotFound(String prevId, Revision rev) {
        boolean logSilence = LOG_SILENCER.silence(prevId);
        if (!logSilence) {
            LOG.warn("Document with previous revisions not found: " + prevId + " (similar log silenced for a while)");
        } else {
            LOG.debug("Document with previous revisions not found: {}", (Object)prevId);
        }
        Path path = this.getMainPath();
        String id = Utils.getIdFromPath(path);
        NodeDocument doc = this.store.getIfCached(Collection.NODES, id);
        long now = Revision.getCurrentTimestamp();
        block0: while (doc != null && doc.getCreated() + TimeUnit.MINUTES.toMillis(1L) < now) {
            if (!logSilence) {
                LOG.info("Invalidated cached document {} -{}", (Object)id, (Object)" (similar log silenced for a while)");
            } else {
                LOG.debug("Invalidated cached document {}", (Object)id);
            }
            this.store.invalidateCache(Collection.NODES, id);
            java.util.Collection ranges = doc.getPreviousRanges().values();
            doc = null;
            for (Range range : ranges) {
                if (!range.includes(rev)) continue;
                id = Utils.getPreviousIdFor(path, range.high, range.height);
                doc = this.store.getIfCached(Collection.NODES, id);
                continue block0;
            }
        }
    }

    private LastRevs createLastRevs(@NotNull RevisionVector readRevision, @NotNull RevisionContext context, @Nullable Branch branch, @Nullable Revision pendingLastRev) {
        LastRevs lastRevs = new LastRevs(this.getLastRev(), readRevision, branch);
        lastRevs.update(pendingLastRev);
        TreeSet mostRecentChanges = Sets.newTreeSet(StableRevisionComparator.REVERSE);
        mostRecentChanges.addAll(this.getLocalRevisions().keySet());
        mostRecentChanges.addAll(this.getLocalCommitRoot().keySet());
        HashSet clusterIds = Sets.newHashSet();
        for (Revision r : this.getLocalRevisions().keySet()) {
            clusterIds.add(r.getClusterId());
        }
        for (Revision r : this.getLocalCommitRoot().keySet()) {
            clusterIds.add(r.getClusterId());
        }
        for (Revision r : mostRecentChanges) {
            Revision branchRev;
            String commitValue;
            if (!clusterIds.contains(r.getClusterId()) || (commitValue = context.getCommitValue(r, this)) == null) continue;
            Revision commitRev = Utils.resolveCommitRevision(r, commitValue);
            if (Utils.isCommitted(commitValue)) {
                lastRevs.update(commitRev);
                clusterIds.remove(r.getClusterId());
                continue;
            }
            if (branch == null || !branch.containsCommit(branchRev = commitRev.asBranchRevision())) continue;
            lastRevs.updateBranch(branchRev);
            clusterIds.remove(r.getClusterId());
        }
        return lastRevs;
    }

    private boolean isMostRecentCommitted(SortedMap<Revision, String> valueMap, Revision revision, RevisionContext context) {
        if (valueMap.isEmpty()) {
            return true;
        }
        Revision first = valueMap.firstKey();
        if (first.compareRevisionTimeThenClusterId(revision) <= 0) {
            return true;
        }
        for (Revision r : valueMap.keySet()) {
            String cv = context.getCommitValue(r, this);
            if (!Utils.isCommitted(cv)) continue;
            Revision c = Utils.resolveCommitRevision(r, cv);
            return c.compareRevisionTimeThenClusterId(revision) <= 0;
        }
        return true;
    }

    @Nullable
    private NodeDocument getCommitRoot(@NotNull Revision rev) {
        Path commitRootPath;
        if (this.getLocalRevisions().containsKey(rev)) {
            return this;
        }
        String depth = (String)this.getLocalCommitRoot().get(rev);
        if (depth != null) {
            commitRootPath = this.getPathAtDepth(depth);
        } else {
            if (this.containsRevision(rev)) {
                return this;
            }
            commitRootPath = this.getCommitRootPath(rev);
            if (commitRootPath == null) {
                return null;
            }
        }
        return this.store.find(Collection.NODES, Utils.getIdFromPath(commitRootPath));
    }

    @NotNull
    private Path getPathAtDepth(@NotNull String depth) {
        if (((String)Preconditions.checkNotNull((Object)depth)).equals("0")) {
            return Path.ROOT;
        }
        Path p = this.getPath();
        return p.getAncestor(p.getDepth() - Integer.parseInt(depth));
    }

    @Nullable
    private String getCommitRootDepth(@NotNull Revision revision) {
        String depth;
        block1: {
            NodeDocument prev;
            SortedMap<Revision, String> local = this.getLocalCommitRoot();
            depth = (String)local.get(revision);
            if (depth != null) break block1;
            Iterator<NodeDocument> iterator = this.getPreviousDocs(COMMIT_ROOT, revision).iterator();
            while (iterator.hasNext() && (depth = (prev = iterator.next()).getCommitRootDepth(revision)) == null) {
            }
        }
        return depth;
    }

    private boolean isVisible(@NotNull RevisionContext context, @NotNull Revision revision, @NotNull String commitValue, @NotNull RevisionVector readRevision) {
        if (Utils.isCommitted(commitValue)) {
            Branch b = context.getBranches().getBranch(readRevision);
            if (b == null) {
                return !readRevision.isRevisionNewer(revision = Utils.resolveCommitRevision(revision, commitValue));
            }
            RevisionVector baseRev = b.getBase(readRevision.getBranchRevision());
            return !baseRev.isRevisionNewer(revision = Utils.resolveCommitRevision(revision, commitValue));
        }
        RevisionVector branchCommit = RevisionVector.fromString(commitValue);
        if (branchCommit.getBranchRevision().getClusterId() != context.getClusterId()) {
            return false;
        }
        Branch b = context.getBranches().getBranch(readRevision);
        if (b == null) {
            return false;
        }
        if (b.containsCommit(revision)) {
            return !readRevision.isRevisionNewer(revision);
        }
        return false;
    }

    @Nullable
    private String getCommitValue(Revision revision) {
        String value;
        block1: {
            NodeDocument prev;
            value = (String)this.getLocalRevisions().get(revision);
            if (value != null) break block1;
            Iterator<NodeDocument> iterator = this.getPreviousDocs(REVISIONS, revision).iterator();
            while (iterator.hasNext() && (value = (prev = iterator.next()).getCommitValue(revision)) == null) {
            }
        }
        return value;
    }

    @Nullable
    private Value getLatestValue(@NotNull RevisionContext context, @NotNull Iterable<Map.Entry<Revision, String>> valueMap, @NotNull RevisionVector readRevision, @NotNull Map<Revision, String> validRevisions, @NotNull LastRevs lastRevs) {
        for (Map.Entry<Revision, String> entry : valueMap) {
            Revision propRev = entry.getKey();
            String commitValue = validRevisions.get(propRev);
            if (commitValue == null) {
                commitValue = context.getCommitValue(propRev, this);
            }
            if (commitValue == null) continue;
            Revision commitRev = Utils.resolveCommitRevision(propRev, commitValue);
            if (Utils.isCommitted(commitValue)) {
                lastRevs.update(commitRev);
            } else {
                lastRevs.updateBranch(commitRev.asBranchRevision());
            }
            if (!this.isValidRevision(context, propRev, commitValue, readRevision, validRevisions)) continue;
            return new Value(commitRev, entry.getValue());
        }
        return null;
    }

    @NotNull
    public Path getPath() {
        return Path.fromString(this.getPathString());
    }

    @NotNull
    private String getPathString() {
        String p = (String)this.get(PATH);
        if (p != null) {
            return p;
        }
        return Utils.getPathFromId(this.getId());
    }

    @NotNull
    Map<Revision, String> getDeleted() {
        return ValueMap.create(this, DELETED);
    }

    public String asString() {
        JsopBuilder json = new JsopBuilder();
        NodeDocument.toJson((JsopWriter)json, this.data);
        return json.toString();
    }

    private static void toJson(JsopWriter json, Map<?, Object> map) {
        for (Map.Entry<?, Object> e : map.entrySet()) {
            json.key(e.getKey().toString());
            Object value = e.getValue();
            if (value == null) {
                json.value(null);
                continue;
            }
            if (value instanceof Boolean) {
                json.value(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Long) {
                json.value(((Long)value).longValue());
                continue;
            }
            if (value instanceof Integer) {
                json.value((long)((Integer)value).intValue());
                continue;
            }
            if (value instanceof Map) {
                json.object();
                NodeDocument.toJson(json, (Map)value);
                json.endObject();
                continue;
            }
            if (value instanceof Revision) {
                json.value(value.toString());
                continue;
            }
            json.value((String)value);
        }
    }

    public static NodeDocument fromString(DocumentStore store, String s) {
        JsopTokenizer json = new JsopTokenizer(s);
        NodeDocument doc = new NodeDocument(store);
        while (!json.matches(0)) {
            String k = json.readString();
            json.read(58);
            if (json.matches(0)) break;
            doc.put(k, NodeDocument.fromJson(json));
            json.matches(44);
        }
        doc.seal();
        return doc;
    }

    private static Object fromJson(JsopTokenizer json) {
        switch (json.read()) {
            case 5: {
                return null;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
            case 2: {
                return Long.parseLong(json.getToken());
            }
            case 1: {
                return json.getToken();
            }
            case 123: {
                TreeMap<Revision, Object> map = new TreeMap<Revision, Object>(StableRevisionComparator.REVERSE);
                while (!json.matches(125)) {
                    String k = json.readString();
                    json.read(58);
                    map.put(Revision.fromString(k), NodeDocument.fromJson(json));
                    json.matches(44);
                }
                return map;
            }
        }
        throw new IllegalArgumentException(json.readRawValue());
    }

    static {
        NULL.seal();
        LOG = LoggerFactory.getLogger(NodeDocument.class);
        LOG_SILENCER = new LogSilencer();
        EMPTY_RANGE_MAP = Maps.unmodifiableNavigableMap(new TreeMap(StableRevisionComparator.REVERSE));
        PREVIOUS_PREFIX = new Path("p");
    }

    private static final class ValueComparator
    implements Comparator<Map.Entry<Revision, String>> {
        static final Comparator<Map.Entry<Revision, String>> INSTANCE = new ValueComparator();
        static final Comparator<Map.Entry<Revision, String>> REVERSE = Collections.reverseOrder(INSTANCE);
        private static final Ordering<String> STRING_ORDERING = Ordering.natural().nullsFirst();

        private ValueComparator() {
        }

        @Override
        public int compare(Map.Entry<Revision, String> o1, Map.Entry<Revision, String> o2) {
            int cmp = StableRevisionComparator.INSTANCE.compare(o1.getKey(), o2.getKey());
            if (cmp != 0) {
                return cmp;
            }
            return STRING_ORDERING.compare((Object)o1.getValue(), (Object)o2.getValue());
        }
    }

    private static final class Value {
        final Revision revision;
        final String value;

        Value(@NotNull Revision revision, @Nullable String value) {
            this.revision = (Revision)Preconditions.checkNotNull((Object)revision);
            this.value = value;
        }
    }

    public static enum SplitDocType {
        NONE(-1),
        DEFAULT(10),
        DEFAULT_NO_CHILD(20),
        PROP_COMMIT_ONLY(30),
        INTERMEDIATE(40),
        DEFAULT_LEAF(50),
        COMMIT_ROOT_ONLY(60),
        DEFAULT_NO_BRANCH(70);

        final int type;

        private SplitDocType(int type) {
            this.type = type;
        }

        public int typeCode() {
            return this.type;
        }

        static SplitDocType valueOf(Integer type) {
            if (type == null) {
                return NONE;
            }
            for (SplitDocType docType : SplitDocType.values()) {
                if (docType.type != type) continue;
                return docType;
            }
            throw new IllegalArgumentException("Not a valid SplitDocType :" + type);
        }
    }
}

