/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Suppliers;
import com.mongodb.MongoClient;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoClock;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDBConnection;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoMissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoStatus;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoVersionGCSupport;
import org.jetbrains.annotations.NotNull;

public abstract class MongoDocumentNodeStoreBuilderBase<T extends MongoDocumentNodeStoreBuilderBase<T>>
extends DocumentNodeStoreBuilder<T> {
    private final MongoClock mongoClock = new MongoClock();
    private boolean socketKeepAlive = true;
    private MongoStatus mongoStatus;
    private long maxReplicationLagMillis = TimeUnit.HOURS.toMillis(6L);
    private boolean clientSessionDisabled = false;
    private int leaseSocketTimeout = 0;
    private String uri;
    private String name;
    private String collectionCompressionType;

    public T setMongoDB(@NotNull String uri, @NotNull String name, int blobCacheSizeMB) {
        this.uri = uri;
        this.name = name;
        this.setMongoDB(this.createMongoDBClient(0), blobCacheSizeMB);
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoDB(@NotNull MongoClient client, @NotNull String dbName, int blobCacheSizeMB) {
        return this.setMongoDB(new MongoDBConnection(client, client.getDatabase(dbName), new MongoStatus(client, dbName), this.mongoClock), blobCacheSizeMB);
    }

    public T setMongoDB(@NotNull MongoClient client, @NotNull String dbName) {
        return this.setMongoDB(client, dbName, 16);
    }

    public T setSocketKeepAlive(boolean enable) {
        this.socketKeepAlive = enable;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public T setClientSessionDisabled(boolean b) {
        this.clientSessionDisabled = b;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    boolean isClientSessionDisabled() {
        return this.clientSessionDisabled;
    }

    public T setLeaseSocketTimeout(int timeoutMillis) {
        this.leaseSocketTimeout = timeoutMillis;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    int getLeaseSocketTimeout() {
        return this.leaseSocketTimeout;
    }

    public T setMaxReplicationLag(long duration, TimeUnit unit) {
        this.maxReplicationLagMillis = unit.toMillis(duration);
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setCollectionCompressionType(String compressionType) {
        this.collectionCompressionType = compressionType;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    @Override
    public VersionGCSupport createVersionGCSupport() {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof MongoDocumentStore) {
            return new MongoVersionGCSupport((MongoDocumentStore)store);
        }
        return super.createVersionGCSupport();
    }

    @Override
    public Iterable<ReferencedBlob> createReferencedBlobs(DocumentNodeStore ns) {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof MongoDocumentStore) {
            return () -> new MongoBlobReferenceIterator(ns, (MongoDocumentStore)store);
        }
        return super.createReferencedBlobs(ns);
    }

    @Override
    public MissingLastRevSeeker createMissingLastRevSeeker() {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof MongoDocumentStore) {
            return new MongoMissingLastRevSeeker((MongoDocumentStore)store, this.getClock());
        }
        return super.createMissingLastRevSeeker();
    }

    public String getCollectionCompressionType() {
        return this.collectionCompressionType;
    }

    MongoStatus getMongoStatus() {
        return this.mongoStatus;
    }

    long getMaxReplicationLagMillis() {
        return this.maxReplicationLagMillis;
    }

    MongoClock getMongoClock() {
        return this.mongoClock;
    }

    MongoDBConnection createMongoDBClient(int socketTimeout) {
        if (this.uri == null || this.name == null) {
            throw new IllegalStateException("Cannot create MongoDB client without 'uri' or 'name'");
        }
        return MongoDBConnection.newMongoDBConnection(this.uri, this.name, this.mongoClock, socketTimeout, this.socketKeepAlive);
    }

    private T setMongoDB(@NotNull MongoDBConnection client, int blobCacheSizeMB) {
        client.checkReadWriteConcern();
        this.mongoStatus = client.getStatus();
        this.documentStoreSupplier = Suppliers.memoize(() -> new MongoDocumentStore(client.getClient(), client.getDatabase(), this));
        if (this.blobStoreSupplier == null) {
            this.blobStoreSupplier = Suppliers.memoize(() -> new MongoBlobStore(client.getDatabase(), (long)(blobCacheSizeMB * 1024) * 1024L, this));
        }
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }
}

