/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.math.DoubleMath;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.Objects;
import org.apache.jackrabbit.oak.plugins.document.Throttler;
import org.jetbrains.annotations.NotNull;

public final class MongoThrottlerFactory {
    private MongoThrottlerFactory() {
    }

    public static Throttler exponentialThrottler(int threshold, AtomicDouble oplogWindow, long throttlingTime) {
        Objects.requireNonNull(oplogWindow);
        return new ExponentialThrottler(threshold, oplogWindow, throttlingTime);
    }

    public static Throttler noThrottler() {
        return Throttler.NO_THROTTLING;
    }

    private static class ExponentialThrottler
    implements Throttler {
        private final int threshold;
        @NotNull
        private final AtomicDouble oplogWindow;
        private final long throttlingTime;

        public ExponentialThrottler(int threshold, @NotNull AtomicDouble oplogWindow, long throttlingTime) {
            this.threshold = threshold;
            this.oplogWindow = oplogWindow;
            this.throttlingTime = throttlingTime;
        }

        @Override
        public long throttlingTime() {
            double threshold = this.threshold;
            double oplogWindow = this.oplogWindow.doubleValue();
            long throttleTime = this.throttlingTime;
            throttleTime = DoubleMath.fuzzyCompare((double)oplogWindow, (double)(threshold / 8.0), (double)0.001) <= 0 ? (throttleTime *= 8L) : (DoubleMath.fuzzyCompare((double)oplogWindow, (double)(threshold / 4.0), (double)0.001) <= 0 ? (throttleTime *= 4L) : (DoubleMath.fuzzyCompare((double)oplogWindow, (double)(threshold / 2.0), (double)0.001) <= 0 ? (throttleTime *= 2L) : (DoubleMath.fuzzyCompare((double)oplogWindow, (double)threshold, (double)0.001) <= 0 ? this.throttlingTime : 0L)));
            return throttleTime;
        }
    }
}

