/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.oak.plugins.document.CachingCommitValueResolver;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.LastRevRecoveryAgent;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.RecoveryContext;
import org.apache.jackrabbit.oak.plugins.document.RecoveryHandler;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RecoveryHandlerImpl
implements RecoveryHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveryHandlerImpl.class);
    private static final int COMMIT_VALUE_CACHE_SIZE = 10000;
    private long recoveryWaitTimeoutMS = Long.getLong("oak.recoveryWaitTimeoutMS", 60000L);
    private final DocumentStore store;
    private final Clock clock;
    private final MissingLastRevSeeker lastRevSeeker;

    RecoveryHandlerImpl(DocumentStore store, Clock clock, MissingLastRevSeeker lastRevSeeker) {
        this.store = store;
        this.clock = clock;
        this.lastRevSeeker = lastRevSeeker;
    }

    @Override
    public boolean recover(int clusterId) {
        try {
            return this.recoverInternal(clusterId);
        }
        catch (DocumentStoreException e) {
            LOG.warn("Recovery failed for cluster node {}", (Object)clusterId, (Object)e);
            return false;
        }
    }

    private boolean recoverInternal(int clusterId) throws DocumentStoreException {
        NodeDocument root = Utils.getRootDocument(this.store);
        RecoveryContext context = new RecoveryContext(root, this.clock, clusterId, new CachingCommitValueResolver(10000, (Supplier<RevisionVector>)((Supplier)root::getSweepRevisions)));
        LastRevRecoveryAgent agent = new LastRevRecoveryAgent(this.store, context, this.lastRevSeeker, id -> {});
        long timeout = context.getClock().getTime() + this.recoveryWaitTimeoutMS;
        int numRecovered = agent.recover(clusterId, timeout);
        if (numRecovered == -1) {
            ClusterNodeInfoDocument doc = this.store.find(Collection.CLUSTER_NODES, String.valueOf(clusterId));
            String otherId = "n/a";
            if (doc != null) {
                otherId = String.valueOf(doc.get("recoveryBy"));
            }
            String msg = "This cluster node (" + clusterId + ") requires _lastRev recovery which is currently performed by another cluster node (" + otherId + "). Recovery is still ongoing after " + this.recoveryWaitTimeoutMS + " ms.";
            LOG.info(msg);
            return false;
        }
        return true;
    }
}

