/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.commons.OakVersion;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.apache.jackrabbit.oak.spi.toggle.Feature;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static String MODULE_VERSION = null;
    private static final int REVISION_LENGTH = new Revision(System.currentTimeMillis(), 0, 0).toString().length();
    public static final int PATH_SHORT = Integer.getInteger("oak.pathShort", 165);
    public static final int PATH_LONG = Integer.getInteger("oak.pathLong", 350);
    public static final int NODE_NAME_LIMIT = Integer.getInteger("oak.nodeNameLimit", 150);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    public static final Predicate<String> PROPERTY_OR_DELETED = new Predicate<String>(){

        public boolean apply(@Nullable String input) {
            return Utils.isPropertyName(input) || NodeDocument.isDeletedEntry(input);
        }
    };
    public static final Predicate<String> PROPERTY_OR_DELETED_OR_COMMITROOT_OR_REVISIONS = new Predicate<String>(){

        public boolean apply(@Nullable String input) {
            return Utils.isPropertyName(input) || NodeDocument.isDeletedEntry(input) || NodeDocument.isCommitRootEntry(input) || NodeDocument.isRevisionsEntry(input);
        }
    };
    public static final Predicate<String> COMMITROOT_OR_REVISIONS = new Predicate<String>(){

        public boolean apply(@Nullable String input) {
            return NodeDocument.isCommitRootEntry(input) || NodeDocument.isRevisionsEntry(input);
        }
    };
    private static final int DEFAULT_BATCH_SIZE = 100;

    public static int pathDepth(String path) {
        if (path.equals("/")) {
            return 0;
        }
        int depth = 0;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '/') continue;
            ++depth;
        }
        return depth;
    }

    public static int getIdDepth(Path path) {
        int depth = path.getDepth();
        if (!path.isAbsolute()) {
            --depth;
        }
        return depth;
    }

    public static int estimateMemoryUsage(Map<?, Object> map) {
        if (map == null) {
            return 0;
        }
        long size = 0L;
        for (Map.Entry<?, Object> e : map.entrySet()) {
            size = e.getKey() instanceof Revision ? (size += 32L) : (size += (long)StringUtils.estimateMemoryUsage((String)e.getKey().toString()));
            Object o = e.getValue();
            if (o instanceof String) {
                size += (long)StringUtils.estimateMemoryUsage((String)((String)o));
                continue;
            }
            if (o instanceof Long) {
                size += 16L;
                continue;
            }
            if (o instanceof Boolean) {
                size += 8L;
                continue;
            }
            if (o instanceof Integer) {
                size += 8L;
                continue;
            }
            if (o instanceof Map) {
                size += 8L + (long)Utils.estimateMemoryUsage((Map)o);
                continue;
            }
            if (o == null) continue;
            throw new IllegalArgumentException("Can't estimate memory usage of " + o);
        }
        size += 112L;
        if ((size += (long)map.size() * 64L) > Integer.MAX_VALUE) {
            LOG.debug("Estimated memory footprint larger than Integer.MAX_VALUE: {}.", (Object)size);
            size = Integer.MAX_VALUE;
        }
        return (int)size;
    }

    public static String escapePropertyName(String propertyName) {
        int len = propertyName.length();
        if (len == 0) {
            return "_";
        }
        StringBuilder buff = null;
        char c = propertyName.charAt(0);
        int i = 0;
        if (c == '_' || c == '$') {
            buff = new StringBuilder(len + 1);
            buff.append('_').append(c);
            ++i;
        }
        while (i < len) {
            char rep;
            c = propertyName.charAt(i);
            switch (c) {
                case '.': {
                    rep = 'd';
                    break;
                }
                case '\\': {
                    rep = '\\';
                    break;
                }
                default: {
                    rep = '\u0000';
                }
            }
            if (rep != '\u0000') {
                if (buff == null) {
                    buff = new StringBuilder(propertyName.substring(0, i));
                }
                buff.append('\\').append(rep);
            } else if (buff != null) {
                buff.append(c);
            }
            ++i;
        }
        return buff == null ? propertyName : buff.toString();
    }

    public static String unescapePropertyName(String key) {
        int len = key.length();
        if (key.startsWith("_") && (key.startsWith("__") || key.startsWith("_$") || len == 1)) {
            key = key.substring(1);
            --len;
        }
        StringBuilder buff = null;
        for (int i = 0; i < len; ++i) {
            int c = key.charAt(i);
            if (c == 92) {
                if (buff == null) {
                    buff = new StringBuilder(key.substring(0, i));
                }
                if ((c = key.charAt(++i)) != 92 && c == 100) {
                    c = 46;
                }
                buff.append((char)c);
                continue;
            }
            if (buff == null) continue;
            buff.append((char)c);
        }
        return buff == null ? key : buff.toString();
    }

    public static boolean isPropertyName(String key) {
        return !key.startsWith("_") || key.startsWith("__") || key.startsWith("_$");
    }

    public static String getIdFromPath(@NotNull String path) {
        int depth = Utils.pathDepth(path);
        if (Utils.isLongPath(path)) {
            String parent = PathUtils.getParentPath((String)path);
            byte[] hash = Utils.createSHA256Digest(parent);
            return Utils.createHashedId(depth, hash, PathUtils.getName((String)path));
        }
        return depth + ":" + path;
    }

    public static String getIdFromPath(@NotNull Path path) {
        Preconditions.checkNotNull((Object)path);
        int depth = Utils.getIdDepth(path);
        Path parent = path.getParent();
        if (parent != null && Utils.isLongPath(path)) {
            byte[] hash = Utils.createSHA256Digest(parent.toString());
            return Utils.createHashedId(depth, hash, path.getName());
        }
        return depth + ":" + path;
    }

    private static String createHashedId(int depth, byte[] hash, String name) {
        StringBuilder sb = new StringBuilder(hash.length * 2 + name.length() + 6);
        sb.append(depth).append(":h");
        Utils.encodeHexString(hash, sb).append("/").append(name);
        return sb.toString();
    }

    private static byte[] createSHA256Digest(String input) {
        try {
            return MessageDigest.getInstance("SHA-256").digest(input.getBytes(UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static StringBuilder encodeHexString(byte[] data, StringBuilder sb) {
        for (byte b : data) {
            sb.append(HEX_DIGITS[b >> 4 & 0xF]);
            sb.append(HEX_DIGITS[b & 0xF]);
        }
        return sb;
    }

    @Nullable
    public static String getParentId(String id) {
        if (Utils.isIdFromLongPath(id)) {
            return null;
        }
        String path = Utils.getPathFromId(id);
        if (!PathUtils.isValid((String)path)) {
            return null;
        }
        if (PathUtils.denotesRoot((String)path)) {
            return null;
        }
        String parentPath = PathUtils.getParentPath((String)path);
        return Utils.getIdFromPath(parentPath);
    }

    private static boolean isLongPath(String path) {
        if (path.length() < PATH_SHORT) {
            return false;
        }
        byte[] parent = PathUtils.getParentPath((String)path).getBytes(UTF_8);
        return parent.length >= PATH_LONG;
    }

    public static boolean isNodeNameLong(Path path, int sizeLimit) {
        return Utils.isLongPath(path) && path.getName().getBytes(UTF_8).length > sizeLimit;
    }

    public static boolean isLongPath(Path path) {
        if (path.length() < PATH_SHORT) {
            return false;
        }
        Path parent = path.getParent();
        if (parent == null) {
            return false;
        }
        return parent.toString().getBytes(UTF_8).length >= PATH_LONG;
    }

    public static boolean isIdFromLongPath(String id) {
        int index = id.indexOf(58);
        return index != -1 && index < id.length() - 1 && id.charAt(index + 1) == 'h';
    }

    public static String getPathFromId(String id) {
        if (Utils.isIdFromLongPath(id)) {
            throw new IllegalArgumentException("Id is hashed: " + id);
        }
        int index = id.indexOf(58);
        return id.substring(index + 1);
    }

    public static int getDepthFromId(String id) throws IllegalArgumentException {
        try {
            int index = id.indexOf(58);
            if (index >= 0) {
                return Integer.parseInt(id.substring(0, index));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid id: " + id);
    }

    public static Path getPreviousPathFor(Path path, Revision r, int height) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("path must be absolute: " + path);
        }
        Path prev = new Path("p");
        for (String name : path.elements()) {
            prev = new Path(prev, name);
        }
        prev = new Path(prev, r.toString());
        return new Path(prev, String.valueOf(height));
    }

    public static String getPreviousIdFor(Path path, Revision r, int height) {
        return Utils.getIdFromPath(Utils.getPreviousPathFor(path, r, height));
    }

    public static boolean isPreviousDocId(String id) {
        int indexOfColon = id.indexOf(58);
        if (indexOfColon > 0 && indexOfColon < id.length() - 1) {
            return id.charAt(indexOfColon + 1) == 'p';
        }
        return false;
    }

    public static boolean isLeafPreviousDocId(String id) {
        return Utils.isPreviousDocId(id) && id.endsWith("/0");
    }

    public static <K> void deepCopyMap(Map<K, Object> source, Map<K, Object> target) {
        for (Map.Entry<K, Object> e : source.entrySet()) {
            TreeMap value = e.getValue();
            Comparator comparator = null;
            if (value instanceof SortedMap) {
                SortedMap map = value;
                comparator = map.comparator();
            }
            if (value instanceof Map) {
                Map old = value;
                TreeMap c = new TreeMap(comparator);
                Utils.deepCopyMap(old, c);
                value = c;
            }
            target.put(e.getKey(), value);
        }
    }

    public static String getKeyLowerLimit(Path path) {
        String from = Utils.getIdFromPath(new Path(path, "a"));
        from = from.substring(0, from.length() - 1);
        return from;
    }

    public static String getKeyUpperLimit(Path path) {
        Object to = Utils.getIdFromPath(new Path(path, "z"));
        to = ((String)to).substring(0, ((String)to).length() - 2) + "0";
        return to;
    }

    @Nullable
    public static String getParentIdFromLowerLimit(String fromKey) {
        if (((String)fromKey).endsWith("/")) {
            fromKey = (String)fromKey + "a";
        }
        return Utils.getParentId((String)fromKey);
    }

    public static boolean isCommitted(@Nullable String tag) {
        return tag != null && (tag.equals("c") || tag.startsWith("c-"));
    }

    @NotNull
    public static Revision resolveCommitRevision(@NotNull Revision rev, @NotNull String tag) {
        return ((String)Preconditions.checkNotNull((Object)tag)).startsWith("c-") ? Revision.fromString(tag.substring(2)) : rev;
    }

    public static void closeIfCloseable(Object obj) {
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (IOException e) {
                LOG.warn("Error occurred while closing {}", obj, (Object)e);
            }
        }
    }

    public static String timestampToString(long timestamp) {
        return (new Timestamp(timestamp) + "00").substring(0, 23);
    }

    @Nullable
    public static Revision max(@Nullable Revision a, @Nullable Revision b) {
        return Utils.max(a, b, StableRevisionComparator.INSTANCE);
    }

    @Nullable
    public static Revision max(@Nullable Revision a, @Nullable Revision b, @NotNull Comparator<Revision> c) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return c.compare(a, b) >= 0 ? a : b;
    }

    @Nullable
    public static Revision min(@Nullable Revision a, @Nullable Revision b) {
        return Utils.min(a, b, StableRevisionComparator.INSTANCE);
    }

    @Nullable
    public static Revision min(@Nullable Revision a, @Nullable Revision b, @NotNull Comparator<Revision> c) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return c.compare(a, b) <= 0 ? a : b;
    }

    public static Iterable<NodeDocument> getAllDocuments(DocumentStore store) {
        return Utils.internalGetSelectedDocuments(store, null, 0L, 100);
    }

    @NotNull
    public static NodeDocument getRootDocument(@NotNull DocumentStore store) {
        String rootId = Utils.getIdFromPath(Path.ROOT);
        NodeDocument root = store.find(Collection.NODES, rootId);
        if (root == null) {
            throw new IllegalStateException("missing root document");
        }
        return root;
    }

    public static Iterable<NodeDocument> getSelectedDocuments(DocumentStore store, String indexedProperty, long startValue, int batchSize) {
        return Utils.internalGetSelectedDocuments(store, indexedProperty, startValue, batchSize);
    }

    public static Iterable<NodeDocument> getSelectedDocuments(DocumentStore store, String indexedProperty, long startValue) {
        return Utils.internalGetSelectedDocuments(store, indexedProperty, startValue, 100);
    }

    private static Iterable<NodeDocument> internalGetSelectedDocuments(final DocumentStore store, final String indexedProperty, final long startValue, final int batchSize) {
        if (batchSize < 2) {
            throw new IllegalArgumentException("batchSize must be > 1");
        }
        return new Iterable<NodeDocument>(){

            @Override
            public Iterator<NodeDocument> iterator() {
                return new AbstractIterator<NodeDocument>(){
                    private String startId = "0000000";
                    private Iterator<NodeDocument> batch = this.nextBatch();

                    protected NodeDocument computeNext() {
                        NodeDocument doc;
                        if (!this.batch.hasNext()) {
                            this.batch = this.nextBatch();
                        }
                        if (this.batch.hasNext()) {
                            doc = this.batch.next();
                            this.startId = doc.getId();
                        } else {
                            doc = (NodeDocument)this.endOfData();
                        }
                        return doc;
                    }

                    private Iterator<NodeDocument> nextBatch() {
                        List<NodeDocument> result = indexedProperty == null ? store.query(Collection.NODES, this.startId, ";", batchSize) : store.query(Collection.NODES, this.startId, ";", indexedProperty, startValue, batchSize);
                        return result.iterator();
                    }
                };
            }
        };
    }

    public static boolean isHiddenPath(@NotNull String path) {
        return path.contains("/:");
    }

    public static Iterable<StringValue> asStringValueIterable(@NotNull Iterable<String> values) {
        return Iterables.transform(values, (Function)new Function<String, StringValue>(){

            public StringValue apply(String input) {
                return new StringValue(input);
            }
        });
    }

    public static Iterable<String> pathToId(@NotNull Iterable<String> paths) {
        return Iterables.transform(paths, input -> Utils.getIdFromPath(input));
    }

    public static long getMaxExternalTimestamp(Iterable<Revision> revisions, int localClusterId) {
        long maxTime = Long.MIN_VALUE;
        for (Revision r : revisions) {
            if (r.getClusterId() == localClusterId) continue;
            maxTime = Math.max(maxTime, r.getTimestamp());
        }
        return maxTime;
    }

    public static Long asLong(@Nullable Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Long) {
            return (Long)n;
        }
        return n.longValue();
    }

    @NotNull
    public static RevisionVector getStartRevisions(@NotNull Iterable<ClusterNodeInfoDocument> clusterNodes) {
        ArrayList<Revision> revs = new ArrayList<Revision>();
        for (ClusterNodeInfoDocument doc : clusterNodes) {
            revs.add(new Revision(doc.getStartTime(), 0, doc.getClusterId()));
        }
        return new RevisionVector(revs);
    }

    public static long getMinTimestampForDiff(@NotNull RevisionVector fromRev, @NotNull RevisionVector toRev, @NotNull RevisionVector minRevisions) {
        fromRev = fromRev.pmax(minRevisions);
        toRev = toRev.pmax(minRevisions);
        RevisionVector from = fromRev.difference(toRev);
        RevisionVector to = toRev.difference(fromRev);
        long min = Long.MAX_VALUE;
        for (Revision r : from) {
            min = Math.min(r.getTimestamp(), min);
        }
        for (Revision r : to) {
            min = Math.min(r.getTimestamp(), min);
        }
        return min;
    }

    public static boolean isThrottlingEnabled(DocumentNodeStoreBuilder<?> builder) {
        Feature docStoreThrottlingFeature = builder.getDocStoreThrottlingFeature();
        return builder.isThrottlingEnabled() || docStoreThrottlingFeature != null && docStoreThrottlingFeature.isEnabled();
    }

    public static boolean isGreaterOrEquals(@NotNull RevisionVector a, @NotNull RevisionVector b) {
        return a.pmax(b).equals(a);
    }

    public static boolean isLocalChange(@NotNull RevisionVector from, @NotNull RevisionVector to, int clusterId) {
        RevisionVector diff = to.difference(from);
        return diff.getDimensions() == 1 && diff.getRevision(clusterId) != null;
    }

    public static <T> CloseableIterable<T> abortingIterable(Iterable<T> iterable, final Predicate<T> p) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(p);
        return new CloseableIterable(() -> {
            final Iterator it = iterable.iterator();
            return new AbstractIterator<T>(){

                protected T computeNext() {
                    Object next;
                    if (it.hasNext() && p.apply(next = it.next())) {
                        return next;
                    }
                    return this.endOfData();
                }
            };
        }, () -> Utils.closeIfCloseable(iterable));
    }

    public static void alignWithExternalRevisions(@NotNull NodeDocument rootDoc, @NotNull Clock clock, int clusterId, long warnThresholdMillis) throws InterruptedException {
        long localTime;
        Map<Integer, Revision> lastRevMap = ((NodeDocument)Preconditions.checkNotNull((Object)rootDoc)).getLastRev();
        long externalTime = Utils.getMaxExternalTimestamp(lastRevMap.values(), clusterId);
        if (externalTime > (localTime = clock.getTime())) {
            long timeDiff = externalTime - localTime;
            double delay = ((double)externalTime - (double)localTime) / 1000.0;
            String fmt = "Background read will be delayed by %.1f seconds. Please check system time on cluster nodes.";
            if (timeDiff > warnThresholdMillis) {
                LOG.warn("Detected clock differences. Local time is '{}', while most recent external time is '{}'. Current _lastRev entries: {}", new Object[]{new Date(localTime), new Date(externalTime), lastRevMap.values()});
                String msg = String.format(fmt, delay);
                LOG.warn(msg);
            }
            while (localTime + 60000L < externalTime) {
                clock.waitUntil(localTime + 60000L);
                localTime = clock.getTime();
                delay = ((double)externalTime - (double)localTime) / 1000.0;
                LOG.warn(String.format(fmt, delay));
            }
            clock.waitUntil(externalTime + 1L);
        } else if (localTime == externalTime) {
            LOG.debug("Local and external time are equal. Waiting until localtime is more recent than external reported time.");
            clock.waitUntil(externalTime + 1L);
        }
    }

    public static void joinQuietly(Thread ... threads) {
        for (Thread t : threads) {
            try {
                if (t == null) continue;
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static String getModuleVersion() {
        String v = MODULE_VERSION;
        if (v == null) {
            MODULE_VERSION = v = OakVersion.getVersion((String)"oak-store-document", Utils.class);
        }
        return v;
    }

    public static void checkRevisionAge(DocumentStore store, ClusterNodeInfo info, Clock clock) throws DocumentStoreException {
        NodeDocument root = store.find(Collection.NODES, Utils.getIdFromPath(Path.ROOT));
        if (root == null) {
            return;
        }
        int clusterId = info.getId();
        Revision rev = root.getLastRev().get(clusterId);
        if (rev == null) {
            return;
        }
        long now = clock.getTime();
        if (rev.getTimestamp() > now) {
            String msg = String.format("Cluster id %d has a _lastRev %s (%s) newer than current time %s. Please check system time on cluster nodes.", clusterId, rev.toString(), Utils.timestampToString(rev.getTimestamp()), Utils.timestampToString(now));
            throw new DocumentStoreException(msg);
        }
    }

    public static long sum(long ... addends) {
        BigInteger result = BigInteger.ZERO;
        for (long value : addends) {
            result = result.add(BigInteger.valueOf(value));
        }
        result = result.max(BigInteger.valueOf(Long.MIN_VALUE));
        result = result.min(BigInteger.valueOf(Long.MAX_VALUE));
        return result.longValue();
    }

    public static String asISO8601(long ms) {
        return DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(ms));
    }
}

