/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Objects;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.commons.json.JsopStream;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Collision;
import org.apache.jackrabbit.oak.plugins.document.ConflictException;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.LastRevTracker;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.Rollback;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commit {
    private static final Logger LOG = LoggerFactory.getLogger(Commit.class);
    private static final String PROPERTY_NAME_CHILDORDER = ":childOrder";
    protected final DocumentNodeStore nodeStore;
    private final RevisionVector baseRevision;
    private final RevisionVector startRevisions;
    private final Revision revision;
    private final HashMap<Path, UpdateOp> operations = new LinkedHashMap<Path, UpdateOp>();
    private final Set<Revision> collisions = new LinkedHashSet<Revision>();
    private Branch b;
    private Rollback rollback = Rollback.NONE;
    private final HashSet<Path> modifiedNodes = new HashSet();
    private final HashSet<Path> addedNodes = new HashSet();
    private final HashSet<Path> removedNodes = new HashSet();
    private final HashSet<Path> nodesWithBinaries = new HashSet();
    private final HashMap<Path, Path> bundledNodes = new HashMap();
    private static final Function<UpdateOp.Key, String> KEY_TO_NAME = new Function<UpdateOp.Key, String>(){

        public String apply(UpdateOp.Key input) {
            return input.getName();
        }
    };

    Commit(@NotNull DocumentNodeStore nodeStore, @NotNull Revision revision, @Nullable RevisionVector baseRevision, @NotNull RevisionVector startRevisions) {
        this.nodeStore = (DocumentNodeStore)Preconditions.checkNotNull((Object)nodeStore);
        this.revision = (Revision)Preconditions.checkNotNull((Object)revision);
        this.baseRevision = baseRevision;
        this.startRevisions = startRevisions;
    }

    Commit(@NotNull DocumentNodeStore nodeStore, @NotNull Revision revision, @Nullable RevisionVector baseRevision, @NotNull RevisionVector startRevisions, @NotNull Map<Path, UpdateOp> operations, @NotNull Set<Path> addedNodes, @NotNull Set<Path> removedNodes, @NotNull Set<Path> nodesWithBinaries, @NotNull Map<Path, Path> bundledNodes) {
        this(nodeStore, revision, baseRevision, startRevisions);
        this.operations.putAll(operations);
        this.addedNodes.addAll(addedNodes);
        this.removedNodes.addAll(removedNodes);
        this.nodesWithBinaries.addAll(nodesWithBinaries);
        this.bundledNodes.putAll(bundledNodes);
    }

    UpdateOp getUpdateOperationForNode(Path path) {
        UpdateOp op = this.operations.get(path);
        if (op == null) {
            op = Commit.createUpdateOp(path, this.revision, this.isBranchCommit());
            this.operations.put(path, op);
        }
        return op;
    }

    static UpdateOp createUpdateOp(Path path, Revision revision, boolean isBranch) {
        String id = Utils.getIdFromPath(path);
        UpdateOp op = new UpdateOp(id, false);
        NodeDocument.setModified(op, revision);
        if (isBranch) {
            NodeDocument.setBranchCommit(op, revision);
        }
        return op;
    }

    @NotNull
    Revision getRevision() {
        return this.revision;
    }

    @Nullable
    RevisionVector getBaseRevision() {
        return this.baseRevision;
    }

    @NotNull
    Iterable<Path> getModifiedPaths() {
        return this.modifiedNodes;
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }

    boolean rollback() {
        boolean success = false;
        try {
            this.rollback.perform(this.nodeStore.getDocumentStore());
            success = true;
        }
        catch (Throwable t) {
            LOG.warn("Rollback failed", t);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply() throws ConflictException, DocumentStoreException {
        boolean success = false;
        RevisionVector baseRev = this.getBaseRevision();
        boolean isBranch = baseRev != null && baseRev.isBranch();
        Revision rev = this.getRevision();
        if (isBranch && !this.nodeStore.isDisableBranches()) {
            try {
                this.prepare(baseRev);
                success = true;
            }
            finally {
                if (!success) {
                    this.rollback();
                    Branch branch = this.getBranch();
                    if (branch != null) {
                        branch.removeCommit(rev.asBranchRevision());
                        if (!branch.hasCommits()) {
                            this.nodeStore.getBranches().remove(branch);
                        }
                    }
                }
            }
        } else {
            this.applyInternal();
        }
    }

    private void applyInternal() throws ConflictException, DocumentStoreException {
        if (!this.operations.isEmpty()) {
            this.updateParentChildStatus();
            this.updateBinaryStatus();
            this.applyToDocumentStore();
        }
    }

    private void prepare(RevisionVector baseRevision) throws ConflictException, DocumentStoreException {
        if (!this.operations.isEmpty()) {
            this.updateParentChildStatus();
            this.updateBinaryStatus();
            this.applyToDocumentStoreWithTiming(baseRevision);
        }
    }

    private void updateBinaryStatus() {
        for (Path path : this.nodesWithBinaries) {
            NodeDocument.setHasBinary(this.getUpdateOperationForNode(path));
        }
    }

    void applyToDocumentStore() throws ConflictException, DocumentStoreException {
        this.applyToDocumentStoreWithTiming(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyToDocumentStoreWithTiming(RevisionVector baseBranchRevision) throws ConflictException, DocumentStoreException {
        long start = System.nanoTime();
        try {
            this.applyToDocumentStore(baseBranchRevision);
        }
        finally {
            this.nodeStore.getStatsCollector().doneChangesApplied(TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyToDocumentStore(RevisionVector baseBranchRevision) throws ConflictException, DocumentStoreException {
        block28: {
            this.rollback = Rollback.FAILED;
            String commitValue = baseBranchRevision != null ? baseBranchRevision.getBranchRevision().toString() : "c";
            DocumentStore store = this.nodeStore.getDocumentStore();
            Path commitRootPath = null;
            if (baseBranchRevision != null) {
                commitRootPath = Path.ROOT;
            }
            ArrayList<UpdateOp> changedNodes = new ArrayList<UpdateOp>();
            ArrayList<UpdateOp> opLog = new ArrayList<UpdateOp>();
            for (Path p : this.operations.keySet()) {
                Path parent;
                this.markChanged(p);
                if (commitRootPath == null) {
                    commitRootPath = p;
                    continue;
                }
                while (!commitRootPath.isAncestorOf(p) && (parent = commitRootPath.getParent()) != null) {
                    commitRootPath = parent;
                }
            }
            commitRootPath = this.bundledNodes.getOrDefault(commitRootPath, commitRootPath);
            this.rollback = new Rollback(this.revision, opLog, Utils.getIdFromPath(commitRootPath), this.nodeStore.getCreateOrUpdateBatchSize());
            for (Path p : this.bundledNodes.keySet()) {
                this.markChanged(p);
            }
            if (baseBranchRevision != null) {
                JournalEntry doc = Collection.JOURNAL.newDocument(store);
                doc.modified(this.modifiedNodes);
                Revision r = this.revision.asBranchRevision();
                boolean success = store.create(Collection.JOURNAL, Collections.singletonList(doc.asUpdateOp(r)));
                if (!success) {
                    LOG.error("Failed to update journal for revision {}", (Object)r);
                    LOG.debug("Failed to update journal for revision {} with doc {}", (Object)r, (Object)doc.format());
                }
            }
            int commitRootDepth = commitRootPath.getDepth();
            boolean commitRootHasChanges = this.operations.containsKey(commitRootPath);
            for (UpdateOp op : this.operations.values()) {
                Branch localBranch;
                NodeDocument.setCommitRoot(op, this.revision, commitRootDepth);
                if (this.nodeStore.isChildOrderCleanupEnabled() && (localBranch = this.getBranch()) != null) {
                    TreeSet<Revision> commits = new TreeSet<Revision>(localBranch.getCommits());
                    boolean removePreviousSetOperations = false;
                    for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> change : op.getChanges().entrySet()) {
                        if (!PROPERTY_NAME_CHILDORDER.equals(change.getKey().getName()) || UpdateOp.Operation.Type.SET_MAP_ENTRY != ((UpdateOp.Operation)change.getValue()).type) continue;
                        removePreviousSetOperations = true;
                        commits.remove(((UpdateOp.Key)change.getKey()).getRevision().asBranchRevision());
                    }
                    if (removePreviousSetOperations && !commits.isEmpty()) {
                        Map.Entry<UpdateOp.Key, UpdateOp.Operation> change;
                        int countRemoves = 0;
                        change = commits.descendingSet().iterator();
                        while (change.hasNext()) {
                            Revision rev = (Revision)change.next();
                            op.removeMapEntry(PROPERTY_NAME_CHILDORDER, rev.asTrunkRevision());
                            if (++countRemoves < 256) continue;
                            LOG.debug("applyToDocumentStore : only cleaning up last {} branch commits.", (Object)countRemoves);
                            break;
                        }
                        LOG.debug("applyToDocumentStore : childOrder-edited op is: {}", (Object)op);
                    }
                }
                changedNodes.add(op);
            }
            UpdateOp commitRoot = this.getUpdateOperationForNode(commitRootPath);
            boolean success = false;
            try {
                opLog.addAll(changedNodes);
                if (this.conditionalCommit(changedNodes, commitValue)) {
                    success = true;
                } else {
                    int batchSize = this.nodeStore.getCreateOrUpdateBatchSize();
                    for (List updates : Lists.partition(changedNodes, (int)batchSize)) {
                        List<NodeDocument> oldDocs = store.createOrUpdate(Collection.NODES, updates);
                        this.checkConflicts(oldDocs, updates);
                        this.checkSplitCandidate(oldDocs);
                    }
                    NodeDocument.setRevision(commitRoot, this.revision, commitValue);
                    if (commitRootHasChanges) {
                        NodeDocument.removeCommitRoot(commitRoot, this.revision);
                    }
                    opLog.add(commitRoot);
                    if (baseBranchRevision == null) {
                        UpdateOp commit = commitRoot.copy();
                        commit.setNew(false);
                        commit.containsMapEntry("_collisions", this.revision, false);
                        NodeDocument before = this.nodeStore.updateCommitRoot(commit, this.revision);
                        if (before == null) {
                            String msg = "Conflicting concurrent change. Update operation failed: " + commit;
                            NodeDocument commitRootDoc = store.find(Collection.NODES, commit.getId());
                            if (commitRootDoc == null) {
                                throw new DocumentStoreException(msg);
                            }
                            throw new ConflictException(msg, commitRootDoc.getConflictsFor(Collections.singleton(this.revision)));
                        }
                        success = true;
                        this.checkConflicts(commitRoot, before);
                        this.checkSplitCandidate(before);
                    } else {
                        this.createOrUpdateNode(store, commitRoot);
                    }
                }
            }
            catch (Exception e) {
                if (success) {
                    LOG.error("Exception occurred after commit. Rollback will be suppressed.", (Throwable)e);
                    break block28;
                }
                if (e instanceof ConflictException) {
                    throw e;
                }
                throw DocumentStoreException.convert(e);
            }
            finally {
                if (success) {
                    this.rollback = Rollback.NONE;
                }
            }
        }
    }

    private boolean conditionalCommit(List<UpdateOp> changedNodes, String commitValue) throws DocumentStoreException {
        if (!Utils.isCommitted(commitValue) || changedNodes.size() != 1) {
            return false;
        }
        UpdateOp op = changedNodes.get(0);
        DocumentStore store = this.nodeStore.getDocumentStore();
        NodeDocument doc = store.getIfCached(Collection.NODES, op.getId());
        if (doc == null || doc.getModCount() == null) {
            return false;
        }
        try {
            this.checkConflicts(op, doc);
        }
        catch (ConflictException e) {
            this.removeCollisionMarker(op.getId());
            return false;
        }
        UpdateOp commit = op.copy();
        NodeDocument.unsetCommitRoot(commit, this.revision);
        NodeDocument.setRevision(commit, this.revision, commitValue);
        commit.equals("_modCount", doc.getModCount());
        NodeDocument before = this.nodeStore.updateCommitRoot(commit, this.revision);
        if (before != null) {
            this.checkSplitCandidate(before);
        }
        return before != null;
    }

    private void removeCollisionMarker(String id) {
        UpdateOp removeCollision = new UpdateOp(id, false);
        NodeDocument.removeCollision(removeCollision, this.revision);
        this.nodeStore.getDocumentStore().findAndUpdate(Collection.NODES, removeCollision);
    }

    private void updateParentChildStatus() {
        HashSet processedParents = Sets.newHashSet();
        for (Path path : this.addedNodes) {
            Path parentPath = path.getParent();
            if (parentPath == null || processedParents.contains(parentPath) || this.isBundled(parentPath)) continue;
            processedParents.add(parentPath);
            UpdateOp op = this.getUpdateOperationForNode(parentPath);
            NodeDocument.setChildrenFlag(op, true);
        }
    }

    private void createOrUpdateNode(DocumentStore store, UpdateOp op) throws ConflictException, DocumentStoreException {
        NodeDocument doc = store.createOrUpdate(Collection.NODES, op);
        this.checkConflicts(op, doc);
        this.checkSplitCandidate(doc);
    }

    private void checkSplitCandidate(Iterable<NodeDocument> docs) {
        for (NodeDocument doc : docs) {
            this.checkSplitCandidate(doc);
        }
    }

    private void checkSplitCandidate(@Nullable NodeDocument doc) {
        if (doc == null) {
            return;
        }
        if (doc.getMemory() > 8192 || doc.hasBinary()) {
            this.nodeStore.addSplitCandidate(doc.getId());
        }
    }

    private void checkConflicts(@NotNull UpdateOp op, @Nullable NodeDocument before) throws ConflictException {
        DocumentStore store = this.nodeStore.getDocumentStore();
        this.collisions.clear();
        if (this.baseRevision != null) {
            Revision newestRev = null;
            Branch branch = null;
            if (before != null) {
                RevisionVector base = this.baseRevision;
                if (this.nodeStore.isDisableBranches()) {
                    base = base.asTrunkRevision();
                }
                branch = this.getBranch();
                newestRev = before.getNewestRevision(this.nodeStore, base, this.revision, branch, this.collisions);
            }
            String conflictMessage = null;
            HashSet conflictRevisions = Sets.newHashSet();
            if (newestRev == null) {
                if (!(!op.isDelete() && op.isNew() || this.allowConcurrentAddRemove(before, op))) {
                    conflictMessage = "The node " + op.getId() + " does not exist or is already deleted at base revision " + this.baseRevision + ", branch: " + branch;
                    if (before != null && !before.getLocalDeleted().isEmpty()) {
                        conflictRevisions.add(before.getLocalDeleted().firstKey());
                    }
                }
            } else {
                conflictRevisions.add(newestRev);
                if (op.isNew() && !this.allowConcurrentAddRemove(before, op)) {
                    conflictMessage = "The node " + op.getId() + " already existed in revision\n" + this.formatConflictRevision(newestRev);
                } else if (this.baseRevision.isRevisionNewer(newestRev) && (op.isDelete() || this.isConflicting(before, op))) {
                    conflictMessage = "The node " + op.getId() + " was changed in revision\n" + this.formatConflictRevision(newestRev) + ", which was applied after the base revision\n" + this.baseRevision;
                }
            }
            if (conflictMessage == null && before != null) {
                boolean allowConflictingDeleteChange = this.allowConcurrentAddRemove(before, op);
                for (Revision r : this.collisions) {
                    Collision c = new Collision(before, r, op, this.revision, this.nodeStore, this.startRevisions);
                    if (!c.isConflicting() || allowConflictingDeleteChange || !c.mark(store).equals(this.revision) || this.baseRevision.isBranch()) continue;
                    conflictMessage = "The node " + op.getId() + " was changed in revision\n" + this.formatConflictRevision(r) + ", which was applied after the base revision\n" + this.baseRevision;
                    conflictRevisions.add(r);
                }
            }
            if (conflictMessage != null) {
                conflictMessage = conflictMessage + ", commit revision: " + this.revision;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(conflictMessage + "; document:\n" + (before == null ? "" : before.format()));
                }
                throw new ConflictException(conflictMessage, conflictRevisions);
            }
        }
    }

    private void checkConflicts(List<NodeDocument> oldDocs, List<UpdateOp> updates) throws ConflictException {
        int i = 0;
        ArrayList<ConflictException> exceptions = new ArrayList<ConflictException>();
        HashSet<Revision> revisions = new HashSet<Revision>();
        for (NodeDocument doc : oldDocs) {
            UpdateOp op = updates.get(i++);
            try {
                this.checkConflicts(op, doc);
            }
            catch (ConflictException e) {
                exceptions.add(e);
                Iterables.addAll(revisions, e.getConflictRevisions());
            }
        }
        if (!exceptions.isEmpty()) {
            throw new ConflictException("Following exceptions occurred during the bulk update operations: " + exceptions, revisions);
        }
    }

    private String formatConflictRevision(Revision r) {
        if (this.nodeStore.getHeadRevision().isRevisionNewer(r)) {
            return r + " (not yet visible)";
        }
        if (this.baseRevision != null && !this.baseRevision.isRevisionNewer(r) && !Objects.equal((Object)this.baseRevision.getRevision(r.getClusterId()), (Object)r)) {
            return r + " (older than base " + this.baseRevision + ")";
        }
        return r.toString();
    }

    private boolean isConflicting(@Nullable NodeDocument doc, @NotNull UpdateOp op) {
        if (this.baseRevision == null || doc == null) {
            return false;
        }
        return doc.isConflicting(op, this.baseRevision, this.revision, this.nodeStore.getEnableConcurrentAddRemove());
    }

    private boolean allowConcurrentAddRemove(@Nullable NodeDocument before, @NotNull UpdateOp op) {
        return this.nodeStore.getEnableConcurrentAddRemove() && !this.isConflicting(before, op);
    }

    @Nullable
    private Branch getBranch() {
        if (this.baseRevision == null || !this.baseRevision.isBranch()) {
            return null;
        }
        if (this.b == null) {
            this.b = this.nodeStore.getBranches().getBranch(new RevisionVector(this.revision.asBranchRevision()));
        }
        return this.b;
    }

    private boolean isBranchCommit() {
        return this.baseRevision != null && this.baseRevision.isBranch();
    }

    void applyLastRevUpdates(boolean isBranchCommit) {
        LastRevTracker tracker = this.nodeStore.createTracker(this.revision, isBranchCommit);
        for (Path path : this.modifiedNodes) {
            UpdateOp op = this.operations.get(path);
            if (op != null && Commit.hasContentChanges(op) && !path.isRoot() || this.isBundled(path)) continue;
            tracker.track(path);
        }
    }

    public void applyToCache(RevisionVector before, boolean isBranchCommit) {
        HashMap<Path, ArrayList> nodesWithChangedChildren = new HashMap<Path, ArrayList>();
        for (Path p : this.modifiedNodes) {
            if (p.isRoot()) continue;
            Path parent = p.getParent();
            ArrayList list = nodesWithChangedChildren.computeIfAbsent(parent, k -> new ArrayList());
            list.add(p);
        }
        Revision rev = isBranchCommit ? this.revision.asBranchRevision() : this.revision;
        RevisionVector after = before.update(rev);
        DiffCache.Entry cacheEntry = this.nodeStore.getDiffCache().newEntry(before, after, true);
        ArrayList<Path> added = new ArrayList<Path>();
        ArrayList<Path> removed = new ArrayList<Path>();
        ArrayList<Path> changed = new ArrayList<Path>();
        for (Path path : this.modifiedNodes) {
            added.clear();
            removed.clear();
            changed.clear();
            ArrayList changes = (ArrayList)nodesWithChangedChildren.get(path);
            if (changes != null) {
                for (Path s : changes) {
                    if (this.addedNodes.contains(s)) {
                        added.add(s);
                        continue;
                    }
                    if (this.removedNodes.contains(s)) {
                        removed.add(s);
                        continue;
                    }
                    changed.add(s);
                }
            }
            UpdateOp op = this.operations.get(path);
            if (!this.isBundled(path)) {
                boolean isNew = op != null && op.isNew();
                this.nodeStore.applyChanges(before, after, rev, path, isNew, added, removed, changed);
            }
            this.addChangesToDiffCacheEntry(path, added, removed, changed, cacheEntry);
        }
        cacheEntry.done();
    }

    void markChanged(Path path) {
        while (this.modifiedNodes.add(path) && (path = path.getParent()) != null) {
        }
    }

    @NotNull
    RevisionVector getStartRevisions() {
        return this.startRevisions;
    }

    private void addChangesToDiffCacheEntry(Path path, List<Path> added, List<Path> removed, List<Path> changed, DiffCache.Entry cacheEntry) {
        JsopStream w = new JsopStream();
        for (Path p : added) {
            w.tag('+').key(p.getName()).object().endObject();
        }
        for (Path p : removed) {
            w.tag('-').value(p.getName());
        }
        for (Path p : changed) {
            w.tag('^').key(p.getName()).object().endObject();
        }
        cacheEntry.append(path, w.toString());
    }

    private boolean isBundled(Path path) {
        return this.bundledNodes.containsKey(path);
    }

    private static boolean hasContentChanges(UpdateOp op) {
        return Iterables.filter((Iterable)Iterables.transform(op.getChanges().keySet(), KEY_TO_NAME), Utils.PROPERTY_OR_DELETED).iterator().hasNext();
    }
}

