/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.document.FullGCStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;

class FullGCStatsCollectorImpl
implements FullGCStatsCollector {
    static final String FULL_GC = "FullGC";
    static final String READ_DOC = "READ_DOC";
    static final String DELETED_ORPHAN_NODE = "DELETED_ORPHAN_NODE";
    static final String DELETED_PROPERTY = "DELETED_PROPERTY";
    static final String DELETED_UNMERGED_BC = "DELETED_UNMERGED_BC";
    static final String UPDATED_DOC = "UPDATED_DOC";
    static final String SKIPPED_DOC = "SKIPPED_DOC";
    static final String FULL_GC_ACTIVE_TIMER = "FULL_GC_ACTIVE_TIMER";
    static final String FULL_GC_TIMER = "FULL_GC_TIMER";
    static final String COLLECT_FULL_GC_TIMER = "COLLECT_FULL_GC_TIMER";
    static final String COLLECT_ORPHAN_NODES_TIMER = "COLLECT_ORPHAN_NODES_TIMER";
    static final String COLLECT_DELETED_PROPS_TIMER = "COLLECT_DELETED_PROPS_TIMER";
    static final String COLLECT_DELETED_OLD_REVS_TIMER = "COLLECT_DELETED_OLD_REVS_TIMER";
    static final String COLLECT_UNMERGED_BC_TIMER = "COLLECT_UNMERGED_BC_TIMER";
    static final String DELETE_FULL_GC_DOCS_TIMER = "DELETE_FULL_GC_DOCS_TIMER";
    static final String COUNTER = "COUNTER";
    static final String FAILURE_COUNTER = "FAILURE";
    private final MeterStats readDoc;
    private final MeterStats deletedOrphanNode;
    private final MeterStats deletedProperty;
    private final MeterStats deletedUnmergedBC;
    private final MeterStats updatedDoc;
    private final MeterStats skippedDoc;
    private final TimerStats fullGCActiveTimer;
    private final TimerStats fullGCTimer;
    private final TimerStats collectFullGCTimer;
    private final TimerStats collectOrphanNodesTimer;
    private final TimerStats collectDeletedPropsTimer;
    private final TimerStats collectDeletedOldRevsTimer;
    private final TimerStats collectUnmergedBCTimer;
    private final TimerStats deleteFullGCDocsTimer;
    private final CounterStats counter;
    private final CounterStats failureCounter;

    FullGCStatsCollectorImpl(StatisticsProvider provider) {
        this.readDoc = FullGCStatsCollectorImpl.meter(provider, READ_DOC);
        this.deletedOrphanNode = FullGCStatsCollectorImpl.meter(provider, DELETED_ORPHAN_NODE);
        this.deletedProperty = FullGCStatsCollectorImpl.meter(provider, DELETED_PROPERTY);
        this.deletedUnmergedBC = FullGCStatsCollectorImpl.meter(provider, DELETED_UNMERGED_BC);
        this.updatedDoc = FullGCStatsCollectorImpl.meter(provider, UPDATED_DOC);
        this.skippedDoc = FullGCStatsCollectorImpl.meter(provider, SKIPPED_DOC);
        this.fullGCActiveTimer = FullGCStatsCollectorImpl.timer(provider, FULL_GC_ACTIVE_TIMER);
        this.fullGCTimer = FullGCStatsCollectorImpl.timer(provider, FULL_GC_TIMER);
        this.collectFullGCTimer = FullGCStatsCollectorImpl.timer(provider, COLLECT_FULL_GC_TIMER);
        this.collectOrphanNodesTimer = FullGCStatsCollectorImpl.timer(provider, COLLECT_ORPHAN_NODES_TIMER);
        this.collectDeletedPropsTimer = FullGCStatsCollectorImpl.timer(provider, COLLECT_DELETED_PROPS_TIMER);
        this.collectDeletedOldRevsTimer = FullGCStatsCollectorImpl.timer(provider, COLLECT_DELETED_OLD_REVS_TIMER);
        this.collectUnmergedBCTimer = FullGCStatsCollectorImpl.timer(provider, COLLECT_UNMERGED_BC_TIMER);
        this.deleteFullGCDocsTimer = FullGCStatsCollectorImpl.timer(provider, DELETE_FULL_GC_DOCS_TIMER);
        this.counter = FullGCStatsCollectorImpl.counter(provider, COUNTER);
        this.failureCounter = FullGCStatsCollectorImpl.counter(provider, FAILURE_COUNTER);
    }

    @Override
    public void documentRead() {
        this.readDoc.mark();
    }

    @Override
    public void orphanNodesDeleted(long numNodes) {
        this.deletedOrphanNode.mark(numNodes);
    }

    @Override
    public void propertiesDeleted(long numProps) {
        this.deletedProperty.mark(numProps);
    }

    @Override
    public void unmergedBranchCommitsDeleted(long numCommits) {
        this.deletedUnmergedBC.mark(numCommits);
    }

    @Override
    public void documentsUpdated(long numDocs) {
        this.updatedDoc.mark(numDocs);
    }

    @Override
    public void documentsUpdateSkipped(long numDocs) {
        this.skippedDoc.mark(numDocs);
    }

    @Override
    public void started() {
        this.counter.inc();
    }

    @Override
    public void finished(VersionGarbageCollector.VersionGCStats stats) {
        this.fullGCActiveTimer.update(stats.fullGCActiveElapsed, TimeUnit.MICROSECONDS);
        this.fullGCTimer.update(stats.fullGCDocsElapsed, TimeUnit.MICROSECONDS);
        this.collectFullGCTimer.update(stats.collectFullGCElapsed, TimeUnit.MICROSECONDS);
        this.collectOrphanNodesTimer.update(stats.collectOrphanNodesElapsed, TimeUnit.MICROSECONDS);
        this.collectDeletedPropsTimer.update(stats.collectDeletedPropsElapsed, TimeUnit.MICROSECONDS);
        this.collectDeletedOldRevsTimer.update(stats.collectDeletedOldRevsElapsed, TimeUnit.MICROSECONDS);
        this.collectUnmergedBCTimer.update(stats.collectUnmergedBCElapsed, TimeUnit.MICROSECONDS);
        this.deleteFullGCDocsTimer.update(stats.deleteFullGCDocsElapsed, TimeUnit.MICROSECONDS);
        if (!stats.success) {
            this.failureCounter.inc();
        }
    }

    private static MeterStats meter(StatisticsProvider provider, String name) {
        return provider.getMeter(FullGCStatsCollectorImpl.qualifiedName(name), StatsOptions.DEFAULT);
    }

    private static TimerStats timer(StatisticsProvider provider, String name) {
        return provider.getTimer(FullGCStatsCollectorImpl.qualifiedName(name), StatsOptions.METRICS_ONLY);
    }

    private static CounterStats counter(StatisticsProvider provider, String name) {
        return provider.getCounterStats(FullGCStatsCollectorImpl.qualifiedName(name), StatsOptions.METRICS_ONLY);
    }

    private static String qualifiedName(String metricName) {
        return "FullGC." + metricName;
    }
}

