/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.cache.Cache;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryDiffCache
extends DiffCache {
    static final int CACHE_VALUE_LIMIT = Integer.getInteger("oak.memoryDiffCache.limit", 0x800000);
    private static final Logger LOG = LoggerFactory.getLogger(MemoryDiffCache.class);
    protected final Cache<CacheValue, StringValue> diffCache;
    protected final CacheStats diffCacheStats;

    protected MemoryDiffCache(DocumentNodeStoreBuilder<?> builder) {
        this.diffCache = builder.buildMemoryDiffCache();
        this.diffCacheStats = new CacheStats(this.diffCache, "Document-MemoryDiff", builder.getWeigher(), builder.getMemoryDiffCacheSize());
    }

    @Override
    @Nullable
    public String getChanges(final @NotNull RevisionVector from, final @NotNull RevisionVector to, final @NotNull Path path, final @Nullable DiffCache.Loader loader) {
        StringValue diff;
        Key key = new Key(path, from, to);
        if (loader == null) {
            diff = (StringValue)this.diffCache.getIfPresent((Object)key);
            if (diff == null && this.isUnchanged(from, to, path)) {
                diff = StringValue.EMPTY;
            }
        } else {
            try {
                diff = (StringValue)this.diffCache.get((Object)key, (Callable)new Callable<StringValue>(){

                    @Override
                    public StringValue call() throws Exception {
                        if (MemoryDiffCache.this.isUnchanged(from, to, path)) {
                            return StringValue.EMPTY;
                        }
                        return new StringValue(loader.call());
                    }
                });
            }
            catch (ExecutionException e) {
                diff = new StringValue(loader.call());
            }
        }
        return diff != null ? diff.toString() : null;
    }

    @Override
    @NotNull
    public DiffCache.Entry newEntry(@NotNull RevisionVector from, @NotNull RevisionVector to, boolean local) {
        return new MemoryEntry(from, to);
    }

    @Override
    @NotNull
    public Iterable<CacheStats> getStats() {
        return Collections.singleton(this.diffCacheStats);
    }

    @Override
    public void invalidateAll() {
        this.diffCache.invalidateAll();
    }

    private boolean isUnchanged(@NotNull RevisionVector from, @NotNull RevisionVector to, @NotNull Path path) {
        Path parent = path.getParent();
        return parent != null && this.isChildUnchanged(from, to, parent, path.getName());
    }

    private boolean isChildUnchanged(@NotNull RevisionVector from, @NotNull RevisionVector to, @NotNull Path parent, final @NotNull String name) {
        Key parentKey = new Key(parent, from, to);
        StringValue parentCachedEntry = (StringValue)this.diffCache.getIfPresent((Object)parentKey);
        boolean unchanged = parentCachedEntry == null ? (parent.getParent() == null ? false : this.isChildUnchanged(from, to, parent.getParent(), parent.getName())) : MemoryDiffCache.parseJsopDiff(parentCachedEntry.asString(), new DiffCache.Diff(){

            @Override
            public boolean childNodeAdded(String n) {
                return !name.equals(n);
            }

            @Override
            public boolean childNodeChanged(String n) {
                return !name.equals(n);
            }

            @Override
            public boolean childNodeDeleted(String n) {
                return !name.equals(n);
            }
        });
        return unchanged;
    }

    public static final class Key
    implements CacheValue,
    Comparable<Key> {
        private final Path path;
        private final RevisionVector from;
        private final RevisionVector to;

        public Key(@NotNull Path path, @NotNull RevisionVector from, @NotNull RevisionVector to) {
            this.path = (Path)Preconditions.checkNotNull((Object)path);
            this.from = (RevisionVector)Preconditions.checkNotNull((Object)from);
            this.to = (RevisionVector)Preconditions.checkNotNull((Object)to);
        }

        @NotNull
        public Path getPath() {
            return this.path;
        }

        @NotNull
        public RevisionVector getFromRevision() {
            return this.from;
        }

        @NotNull
        public RevisionVector getToRevision() {
            return this.to;
        }

        public String asString() {
            return this.toString();
        }

        public static Key fromString(@NotNull String s) {
            int idx1 = s.indexOf(47);
            int idx2 = s.lastIndexOf(64);
            if (idx1 == -1 || idx2 == -1) {
                throw new IllegalArgumentException("Malformed " + Key.class.getSimpleName() + ": " + s);
            }
            return new Key(Path.fromString(s.substring(idx1, idx2)), RevisionVector.fromString(s.substring(0, idx1)), RevisionVector.fromString(s.substring(idx2 + 1)));
        }

        public int getMemory() {
            return 32 + this.path.getMemory() + this.from.getMemory() + this.to.getMemory();
        }

        @Override
        public int compareTo(@NotNull Key other) {
            if (this == other) {
                return 0;
            }
            int compare = this.from.compareTo(other.from);
            if (compare != 0) {
                return compare;
            }
            compare = this.path.compareTo(other.path);
            if (compare != 0) {
                return compare;
            }
            return this.to.compareTo(other.to);
        }

        public String toString() {
            int dim = this.from.getDimensions() + this.to.getDimensions();
            StringBuilder sb = new StringBuilder(this.path.length() + (Revision.REV_STRING_APPROX_SIZE + 1) * dim);
            this.from.toStringBuilder(sb);
            this.path.toStringBuilder(sb).append('@');
            this.to.toStringBuilder(sb);
            return sb.toString();
        }

        public int hashCode() {
            int h = 17;
            h = 37 * h + this.path.hashCode();
            h = 37 * h + this.from.hashCode();
            h = 37 * h + this.to.hashCode();
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.from.equals(other.from) && this.to.equals(other.to) && this.path.equals(other.path);
            }
            return false;
        }
    }

    protected class MemoryEntry
    implements DiffCache.Entry {
        private final RevisionVector from;
        private final RevisionVector to;

        protected MemoryEntry(RevisionVector from, RevisionVector to) {
            this.from = (RevisionVector)Preconditions.checkNotNull((Object)from);
            this.to = (RevisionVector)Preconditions.checkNotNull((Object)to);
        }

        @Override
        public void append(@NotNull Path path, @NotNull String changes) {
            Key key = new Key(path, this.from, this.to);
            if (changes.length() > CACHE_VALUE_LIMIT) {
                LOG.warn("Not caching entry for {} from {} to {}. Length of changes is {}.", new Object[]{path, this.from, this.to, changes.length()});
            } else {
                LOG.debug("Adding cache entry for {} from {} to {}", new Object[]{path, this.from, this.to});
                MemoryDiffCache.this.diffCache.put((Object)key, (Object)new StringValue(changes));
            }
        }

        @Override
        public boolean done() {
            return true;
        }
    }
}

