/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Joiner;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.StandardSystemProperty;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.guava.common.collect.UnmodifiableIterator;
import org.apache.jackrabbit.guava.common.util.concurrent.Atomics;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.TimeDurationFormatter;
import org.apache.jackrabbit.oak.commons.sort.StringSort;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.FullGCStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.FullGCStatsCollectorImpl;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.NodeDocumentIdComparator;
import org.apache.jackrabbit.oak.plugins.document.NodeDocumentRevisionCleaner;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Range;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionGCStats;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.VersionGCOptions;
import org.apache.jackrabbit.oak.plugins.document.VersionGCRecommendations;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.util.TimeInterval;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.gc.DelegatingGCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class VersionGarbageCollector {
    private static final int DELETE_BATCH_SIZE = 450;
    private static final int UPDATE_BATCH_SIZE = 450;
    private static final int PROGRESS_BATCH_SIZE = 10000;
    private static final int FULL_GC_BATCH_SIZE = 1000;
    private static final int FULL_GC_MISSING_DOCS_TYPE_CACHE_SIZE = 64;
    private static final String STATUS_IDLE = "IDLE";
    private static final String STATUS_INITIALIZING = "INITIALIZING";
    private static final Logger log = LoggerFactory.getLogger(VersionGarbageCollector.class);
    private static final Logger AUDIT_LOG = LoggerFactory.getLogger((String)(VersionGarbageCollector.class.getName() + ".auditDGC"));
    private static final Set<NodeDocument.SplitDocType> GC_TYPES = EnumSet.of(NodeDocument.SplitDocType.DEFAULT_LEAF, NodeDocument.SplitDocType.COMMIT_ROOT_ONLY, NodeDocument.SplitDocType.DEFAULT_NO_BRANCH);
    static final String SETTINGS_COLLECTION_ID = "versionGC";
    static final String SETTINGS_COLLECTION_OLDEST_TIMESTAMP_PROP = "lastOldestTimeStamp";
    static final String SETTINGS_COLLECTION_REC_INTERVAL_PROP = "recommendedIntervalMs";
    static final String SETTINGS_COLLECTION_FULL_GC_TIMESTAMP_PROP = "fullGCTimeStamp";
    static final String SETTINGS_COLLECTION_FULL_GC_DOCUMENT_ID_PROP = "fullGCId";
    static final String SETTINGS_COLLECTION_FULL_GC_DRY_RUN_TIMESTAMP_PROP = "fullGCDryRunTimeStamp";
    static final String SETTINGS_COLLECTION_FULL_GC_DRY_RUN_DOCUMENT_ID_PROP = "fullGCDryRunId";
    private static FullGCMode fullGcMode = FullGCMode.GAP_ORPHANS_EMPTYPROPS;
    private final DocumentNodeStore nodeStore;
    private final DocumentStore ds;
    private final boolean fullGCEnabled;
    private final boolean isFullGCDryRun;
    private final boolean embeddedVerification;
    private Set<String> fullGCIncludePaths = Collections.emptySet();
    private Set<String> fullGCExcludePaths = Collections.emptySet();
    private final VersionGCSupport versionStore;
    private final AtomicReference<GCJob> collector = Atomics.newReference();
    private VersionGCOptions options;
    private GCMonitor gcMonitor = GCMonitor.EMPTY;
    private RevisionGCStats gcStats = new RevisionGCStats(StatisticsProvider.NOOP);
    private FullGCStatsCollector fullGCStats = new FullGCStatsCollectorImpl(StatisticsProvider.NOOP);
    private static final Predicate<Range> FIRST_LEVEL = new Predicate<Range>(){

        public boolean apply(@Nullable Range input) {
            return input != null && input.height == 0;
        }
    };

    static FullGCMode getFullGcMode() {
        return fullGcMode;
    }

    static void setFullGcMode(int fullGcMode) {
        switch (fullGcMode) {
            case 0: {
                VersionGarbageCollector.fullGcMode = FullGCMode.NONE;
                break;
            }
            case 2: {
                VersionGarbageCollector.fullGcMode = FullGCMode.GAP_ORPHANS;
                break;
            }
            case 3: {
                VersionGarbageCollector.fullGcMode = FullGCMode.GAP_ORPHANS_EMPTYPROPS;
                break;
            }
            default: {
                log.warn("Unsupported full GC mode configuration value: {}. Resetting to NONE", (Object)fullGcMode);
                VersionGarbageCollector.fullGcMode = FullGCMode.NONE;
            }
        }
    }

    VersionGarbageCollector(DocumentNodeStore nodeStore, VersionGCSupport gcSupport, boolean fullGCEnabled, boolean isFullGCDryRun, boolean embeddedVerification) {
        this(nodeStore, gcSupport, fullGCEnabled, isFullGCDryRun, embeddedVerification, 0);
    }

    VersionGarbageCollector(DocumentNodeStore nodeStore, VersionGCSupport gcSupport, boolean fullGCEnabled, boolean isFullGCDryRun, boolean embeddedVerification, int fullGCMode) {
        this.nodeStore = nodeStore;
        this.versionStore = gcSupport;
        this.ds = gcSupport.getDocumentStore();
        this.fullGCEnabled = fullGCEnabled;
        this.isFullGCDryRun = isFullGCDryRun;
        this.embeddedVerification = embeddedVerification;
        this.options = new VersionGCOptions();
        VersionGarbageCollector.setFullGcMode(fullGCMode);
        AUDIT_LOG.info("<init> VersionGarbageCollector created with fullGcMode = {}", (Object)fullGcMode);
    }

    void setFullGCPaths(@NotNull Set<String> includes, @NotNull Set<String> excludes) {
        this.fullGCIncludePaths = Objects.requireNonNull(includes);
        this.fullGCExcludePaths = Objects.requireNonNull(excludes);
    }

    void setStatisticsProvider(StatisticsProvider provider) {
        this.gcStats = new RevisionGCStats(provider);
        this.fullGCStats = new FullGCStatsCollectorImpl(provider);
    }

    @NotNull
    RevisionGCStats getRevisionGCStats() {
        return this.gcStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionGCStats gc(long maxRevisionAge, TimeUnit unit) throws IOException {
        GCJob job;
        long maxRevisionAgeInMillis = unit.toMillis(maxRevisionAge);
        TimeInterval maxRunTime = new TimeInterval(this.nodeStore.getClock().getTime(), Long.MAX_VALUE);
        if (this.options.maxDurationMs > 0L) {
            maxRunTime = maxRunTime.startAndDuration(this.options.maxDurationMs);
        }
        if (this.collector.compareAndSet(null, job = new GCJob(maxRevisionAgeInMillis, this.options, this.gcMonitor))) {
            VersionGCStats versionGCStats;
            VersionGCStats overall = new VersionGCStats();
            overall.active.start();
            this.gcStats.started();
            if (this.fullGCEnabled) {
                this.fullGCStats.started();
            }
            boolean success = false;
            try {
                long averageDurationMs = 0L;
                while (maxRunTime.contains(this.nodeStore.getClock().getTime() + averageDurationMs)) {
                    this.gcMonitor.info("Start {}. run (avg duration {} sec)", new Object[]{overall.iterationCount + 1, (double)averageDurationMs / 1000.0});
                    VersionGCStats stats = job.run();
                    overall.addRun(stats);
                    if (this.options.maxIterations > 0 && overall.iterationCount >= this.options.maxIterations || !overall.needRepeat) break;
                    averageDurationMs = (averageDurationMs * (long)(overall.iterationCount - 1) + stats.active.elapsed(TimeUnit.MILLISECONDS)) / (long)overall.iterationCount;
                }
                success = true;
                versionGCStats = overall;
            }
            catch (Throwable throwable) {
                overall.active.stop();
                this.collector.set(null);
                overall.success = success;
                this.gcStats.finished(overall);
                if (this.fullGCEnabled) {
                    this.fullGCStats.finished(overall);
                }
                if (overall.iterationCount > 1) {
                    this.gcMonitor.info("Revision garbage collection finished after {} iterations - aggregate statistics: {}", new Object[]{overall.iterationCount, overall});
                }
                throw throwable;
            }
            overall.active.stop();
            this.collector.set(null);
            overall.success = success;
            this.gcStats.finished(overall);
            if (this.fullGCEnabled) {
                this.fullGCStats.finished(overall);
            }
            if (overall.iterationCount > 1) {
                this.gcMonitor.info("Revision garbage collection finished after {} iterations - aggregate statistics: {}", new Object[]{overall.iterationCount, overall});
            }
            return versionGCStats;
        }
        throw new IOException("Revision garbage collection is already running");
    }

    public void cancel() {
        GCJob job = this.collector.get();
        if (job != null) {
            job.cancel();
        }
    }

    public String getStatus() {
        GCJob job = this.collector.get();
        if (job == null) {
            return STATUS_IDLE;
        }
        return job.getStatus();
    }

    public void setGCMonitor(@NotNull GCMonitor gcMonitor) {
        this.gcMonitor = Objects.requireNonNull(gcMonitor);
    }

    public VersionGCOptions getOptions() {
        return this.options;
    }

    public void setOptions(VersionGCOptions options) {
        this.options = options;
    }

    public void reset() {
        this.ds.remove(Collection.SETTINGS, SETTINGS_COLLECTION_ID);
    }

    public void resetFullGC() {
        UpdateOp op = new UpdateOp(SETTINGS_COLLECTION_ID, false);
        op.remove(SETTINGS_COLLECTION_FULL_GC_DOCUMENT_ID_PROP);
        op.remove(SETTINGS_COLLECTION_FULL_GC_TIMESTAMP_PROP);
        this.ds.findAndUpdate(Collection.SETTINGS, op);
    }

    public void resetDryRun() {
        UpdateOp op = new UpdateOp(SETTINGS_COLLECTION_ID, false);
        op.remove(SETTINGS_COLLECTION_FULL_GC_DRY_RUN_TIMESTAMP_PROP);
        op.remove(SETTINGS_COLLECTION_FULL_GC_DRY_RUN_DOCUMENT_ID_PROP);
        this.ds.findAndUpdate(Collection.SETTINGS, op);
    }

    public VersionGCInfo getInfo(long maxRevisionAge, TimeUnit unit) throws IOException {
        long maxRevisionAgeInMillis = unit.toMillis(maxRevisionAge);
        long now = this.nodeStore.getClock().getTime();
        VersionGCRecommendations rec = new VersionGCRecommendations(maxRevisionAgeInMillis, this.nodeStore.getCheckpoints(), !this.nodeStore.isReadOnlyMode(), this.nodeStore.getClock(), this.versionStore, this.options, this.gcMonitor, this.fullGCEnabled, this.isFullGCDryRun);
        int estimatedIterations = -1;
        if (rec.suggestedIntervalMs > 0L) {
            estimatedIterations = (int)Math.ceil((double)(now - rec.scope.toMs) / (double)rec.suggestedIntervalMs);
        }
        return new VersionGCInfo(rec.lastOldestTimestamp, rec.scope.fromMs, rec.deleteCandidateCount, rec.maxCollect, rec.suggestedIntervalMs, rec.scope.toMs, estimatedIterations, rec.scopeFullGC.fromMs);
    }

    private void delayOnModifications(long durationMs, AtomicBoolean cancel) {
        long delayMs = Math.round((double)durationMs * this.options.delayFactor);
        if (!cancel.get() && delayMs > 0L) {
            try {
                Clock clock = this.nodeStore.getClock();
                clock.waitUntil(clock.getTime() + delayMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void collectGarbageOnDocument(DocumentNodeStore store, NodeDocument doc, boolean verbose) {
        VersionGCStats stats = new VersionGCStats();
        stats.active.start();
        AtomicBoolean cancel = new AtomicBoolean();
        GCPhases phases = new GCPhases(cancel, stats, this.gcMonitor);
        LinkedHashMap<Path, Boolean> missingDocsTypes = new LinkedHashMap<Path, Boolean>();
        RevisionVector headRevision = store.getHeadRevision();
        try (FullGC gc = new FullGC(headRevision, 0L, missingDocsTypes, this.gcMonitor, cancel);){
            if (phases.start(GCPhase.FULL_GC_COLLECT_GARBAGE)) {
                gc.collectGarbage(doc, phases);
                phases.stop(GCPhase.FULL_GC_COLLECT_GARBAGE);
            }
            if (verbose) {
                this.gcMonitor.info("GarbageCollector will run [{}] operations", new Object[]{gc.updateOpList.size()});
                for (UpdateOp update : gc.updateOpList) {
                    this.gcMonitor.info(update.toString(), new Object[0]);
                }
            }
            if (gc.hasGarbage() && phases.start(GCPhase.FULL_GC_CLEANUP)) {
                gc.removeGarbage(phases.stats);
                phases.stop(GCPhase.FULL_GC_CLEANUP);
            }
        }
    }

    @NotNull
    private StringSort newStringSort(VersionGCOptions options) {
        return new StringSort(options.overflowToDiskThreshold, NodeDocumentIdComparator.INSTANCE);
    }

    private static final class LimitExceededException
    extends Exception {
        private static final long serialVersionUID = 6578586397629516408L;

        private LimitExceededException() {
        }
    }

    private static class GCMessageTracker
    extends GCMonitor.Empty
    implements Supplier<String> {
        private volatile String lastMessage = "INITIALIZING";

        private GCMessageTracker() {
        }

        public void info(String message, Object ... arguments) {
            this.lastMessage = MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage();
        }

        public void warn(String message, Object ... arguments) {
            this.lastMessage = MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage();
        }

        public void error(String message, Exception e) {
            this.lastMessage = message + " (" + e.getMessage() + ")";
        }

        public String get() {
            return this.lastMessage;
        }
    }

    private class DeletedDocsGC
    implements Closeable {
        private final RevisionVector headRevision;
        private final AtomicBoolean cancel;
        private final List<String> leafDocIdsToDelete = Lists.newArrayList();
        private final List<String> resurrectedIds = Lists.newArrayList();
        private final StringSort docIdsToDelete;
        private final StringSort prevDocIdsToDelete;
        private final Set<String> exclude = Sets.newHashSet();
        private boolean sorted = false;
        private final Stopwatch timer;
        private final VersionGCOptions options;
        private final GCMonitor monitor;

        public DeletedDocsGC(@NotNull RevisionVector headRevision, @NotNull AtomicBoolean cancel, @NotNull VersionGCOptions options, GCMonitor monitor) {
            this.headRevision = Objects.requireNonNull(headRevision);
            this.cancel = Objects.requireNonNull(cancel);
            this.timer = Stopwatch.createUnstarted();
            this.options = options;
            this.monitor = monitor;
            this.docIdsToDelete = VersionGarbageCollector.this.newStringSort(options);
            this.prevDocIdsToDelete = VersionGarbageCollector.this.newStringSort(options);
        }

        long getNumDocuments() {
            return this.docIdsToDelete.getSize() + (long)this.leafDocIdsToDelete.size();
        }

        boolean possiblyDeleted(NodeDocument doc) throws IOException {
            VersionGarbageCollector.this.gcStats.documentRead();
            String id = doc.getId() + "/" + doc.getModified();
            try {
                Utils.getDepthFromId(id);
            }
            catch (IllegalArgumentException e) {
                this.monitor.warn("Invalid GC id {} for document {}", new Object[]{id, doc});
                return false;
            }
            if (doc.getNodeAtRevision(VersionGarbageCollector.this.nodeStore, this.headRevision, null) == null) {
                Iterator<String> previousDocs = this.previousDocIdsFor(doc);
                if (!doc.hasChildren() && !previousDocs.hasNext()) {
                    this.addLeafDocument(id);
                } else {
                    this.addDocument(id);
                    this.addPreviousDocuments(previousDocs, doc.getId());
                }
                return true;
            }
            this.addNonDeletedDocument(id);
            return false;
        }

        void removeDocuments(VersionGCStats stats) throws IOException {
            this.removeLeafDocuments(stats);
            stats.deletedDocGCCount += this.removeDeletedDocuments(this.getDocIdsToDelete(), this.getDocIdsToDeleteSize(), false, "(other)");
            stats.splitDocGCCount += this.removeDeletedPreviousDocuments();
        }

        boolean hasLeafBatch() {
            return this.leafDocIdsToDelete.size() >= 450;
        }

        boolean hasRescurrectUpdateBatch() {
            return this.resurrectedIds.size() >= 450;
        }

        void removeLeafDocuments(VersionGCStats stats) throws IOException {
            int removeCount = this.removeDeletedDocuments(this.getLeafDocIdsToDelete(), this.getLeafDocIdsToDeleteSize(), true, "(leaf)");
            this.leafDocIdsToDelete.clear();
            stats.deletedLeafDocGCCount += removeCount;
            stats.deletedDocGCCount += removeCount;
        }

        void updateResurrectedDocuments(VersionGCStats stats) throws IOException {
            if (this.resurrectedIds.isEmpty()) {
                return;
            }
            int updateCount = this.resetDeletedOnce(this.resurrectedIds);
            this.resurrectedIds.clear();
            stats.updateResurrectedGCCount += updateCount;
        }

        @Override
        public void close() {
            try {
                this.docIdsToDelete.close();
            }
            catch (IOException e) {
                this.monitor.warn("Failed to close docIdsToDelete: {}", new Object[]{e});
            }
            try {
                this.prevDocIdsToDelete.close();
            }
            catch (IOException e) {
                this.monitor.warn("Failed to close prevDocIdsToDelete: {}", new Object[]{e});
            }
        }

        private Iterator<String> previousDocIdsFor(NodeDocument doc) {
            NavigableMap<Revision, Range> prevRanges = doc.getPreviousRanges(true);
            if (prevRanges.isEmpty()) {
                return Collections.emptyIterator();
            }
            if (Iterables.all(prevRanges.values(), FIRST_LEVEL)) {
                final Path path = doc.getPath();
                return Iterators.transform(prevRanges.entrySet().iterator(), (Function)new Function<Map.Entry<Revision, Range>, String>(){

                    public String apply(Map.Entry<Revision, Range> input) {
                        int h = input.getValue().getHeight();
                        return Utils.getPreviousIdFor(path, input.getKey(), h);
                    }
                });
            }
            return Iterators.transform(doc.getAllPreviousDocs(), (Function)new Function<NodeDocument, String>(){

                public String apply(NodeDocument input) {
                    return input.getId();
                }
            });
        }

        private void addDocument(String id) throws IOException {
            this.docIdsToDelete.add(id);
        }

        private void addLeafDocument(String id) throws IOException {
            this.leafDocIdsToDelete.add(id);
        }

        private void addNonDeletedDocument(String id) throws IOException {
            this.resurrectedIds.add(id);
        }

        private long getNumPreviousDocuments() {
            return this.prevDocIdsToDelete.getSize() - (long)this.exclude.size();
        }

        private void addPreviousDocuments(Iterator<String> ids, String mainDocId) throws IOException {
            while (ids.hasNext()) {
                String id = ids.next();
                if (id != null) {
                    this.prevDocIdsToDelete.add(id);
                    continue;
                }
                log.debug("addPreviousDocuments: null id found via mainDocId={}", (Object)mainDocId);
            }
        }

        private Iterator<String> getDocIdsToDelete() throws IOException {
            this.ensureSorted();
            return this.docIdsToDelete.getIds();
        }

        private long getDocIdsToDeleteSize() {
            return this.docIdsToDelete.getSize();
        }

        private Iterator<String> getLeafDocIdsToDelete() throws IOException {
            return this.leafDocIdsToDelete.iterator();
        }

        private long getLeafDocIdsToDeleteSize() {
            return this.leafDocIdsToDelete.size();
        }

        private void concurrentModification(NodeDocument doc) {
            Iterator<NodeDocument> it = doc.getAllPreviousDocs();
            while (it.hasNext()) {
                this.exclude.add(it.next().getId());
            }
        }

        private Iterator<String> getPrevDocIdsToDelete() throws IOException {
            this.ensureSorted();
            return Iterators.filter((Iterator)this.prevDocIdsToDelete.getIds(), (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return !DeletedDocsGC.this.exclude.contains(input);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int removeDeletedDocuments(Iterator<String> docIdsToDelete, long numDocuments, boolean leaves, String label) throws IOException {
            if (numDocuments == 0L) {
                return 0;
            }
            this.monitor.info("Proceeding to delete [{}] documents [{}]", new Object[]{numDocuments, label});
            UnmodifiableIterator idListItr = Iterators.partition(docIdsToDelete, (int)450);
            int deletedCount = 0;
            int lastLoggedCount = 0;
            int recreatedCount = 0;
            while (idListItr.hasNext() && !this.cancel.get()) {
                LinkedHashMap deletionBatch = Maps.newLinkedHashMap();
                for (String s : (List)idListItr.next()) {
                    Map.Entry<String, Long> parsed;
                    try {
                        parsed = this.parseEntry(s);
                    }
                    catch (IllegalArgumentException e) {
                        this.monitor.warn("Invalid _modified suffix for {}", new Object[]{s});
                        continue;
                    }
                    deletionBatch.put(parsed.getKey(), parsed.getValue());
                }
                if (log.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder("Performing batch deletion of documents with following ids. \n");
                    Joiner.on((String)StandardSystemProperty.LINE_SEPARATOR.value()).appendTo(sb, deletionBatch.keySet());
                    log.trace(sb.toString());
                }
                this.timer.reset().start();
                try {
                    int nRemoved = VersionGarbageCollector.this.ds.remove(Collection.NODES, deletionBatch);
                    if (nRemoved < deletionBatch.size()) {
                        for (String id : deletionBatch.keySet()) {
                            NodeDocument d = VersionGarbageCollector.this.ds.find(Collection.NODES, id);
                            if (d == null) continue;
                            this.concurrentModification(d);
                        }
                        recreatedCount += deletionBatch.size() - nRemoved;
                    }
                    log.debug("Deleted [{}] documents so far", (Object)(deletedCount += nRemoved));
                    if (leaves) {
                        VersionGarbageCollector.this.gcStats.leafDocumentsDeleted(deletedCount);
                    } else {
                        VersionGarbageCollector.this.gcStats.documentsDeleted(deletedCount);
                    }
                    if (deletedCount + recreatedCount - lastLoggedCount < 10000) continue;
                    lastLoggedCount = deletedCount + recreatedCount;
                    double progress = (double)lastLoggedCount * 1.0 / (double)this.getNumDocuments() * 100.0;
                    String msg = String.format("Deleted %d (%1.2f%%) documents so far", deletedCount, progress);
                    this.monitor.info(msg, new Object[0]);
                }
                finally {
                    VersionGarbageCollector.this.delayOnModifications(this.timer.stop().elapsed(TimeUnit.MILLISECONDS), this.cancel);
                }
            }
            return deletedCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int resetDeletedOnce(List<String> resurrectedDocuments) throws IOException {
            this.monitor.info("Proceeding to reset [{}] _deletedOnce flags", new Object[]{resurrectedDocuments.size()});
            int updateCount = 0;
            this.timer.reset().start();
            try {
                for (String s : resurrectedDocuments) {
                    if (this.cancel.get()) continue;
                    try {
                        Map.Entry<String, Long> parsed = this.parseEntry(s);
                        UpdateOp up = new UpdateOp(parsed.getKey(), false);
                        up.equals("_modified", parsed.getValue());
                        up.remove("_deletedOnce");
                        NodeDocument r = VersionGarbageCollector.this.ds.findAndUpdate(Collection.NODES, up);
                        if (r == null) continue;
                        ++updateCount;
                        VersionGarbageCollector.this.gcStats.deletedOnceFlagReset();
                    }
                    catch (IllegalArgumentException ex) {
                        this.monitor.warn("Invalid _modified suffix for {}", new Object[]{s});
                    }
                    catch (DocumentStoreException ex) {
                        this.monitor.warn("updating {}: {}", new Object[]{s, ex.getMessage()});
                    }
                }
            }
            finally {
                VersionGarbageCollector.this.delayOnModifications(this.timer.stop().elapsed(TimeUnit.MILLISECONDS), this.cancel);
            }
            return updateCount;
        }

        private int removeDeletedPreviousDocuments() throws IOException {
            long num = this.getNumPreviousDocuments();
            if (num == 0L) {
                return 0;
            }
            this.monitor.info("Proceeding to delete [{}] previous documents", new Object[]{num});
            int deletedCount = 0;
            int lastLoggedCount = 0;
            UnmodifiableIterator idListItr = Iterators.partition(this.getPrevDocIdsToDelete(), (int)450);
            while (idListItr.hasNext() && !this.cancel.get()) {
                List deletionBatch = (List)idListItr.next();
                deletedCount += deletionBatch.size();
                if (log.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder("Performing batch deletion of previous documents with following ids. \n");
                    Joiner.on((String)StandardSystemProperty.LINE_SEPARATOR.value()).appendTo(sb, (Iterable)deletionBatch);
                    log.debug(sb.toString());
                }
                VersionGarbageCollector.this.ds.remove(Collection.NODES, deletionBatch);
                log.debug("Deleted [{}] previous documents so far", (Object)deletedCount);
                VersionGarbageCollector.this.gcStats.splitDocumentsDeleted(deletedCount);
                if (deletedCount - lastLoggedCount < 10000) continue;
                lastLoggedCount = deletedCount;
                double progress = (double)deletedCount * 1.0 / (double)(this.prevDocIdsToDelete.getSize() - (long)this.exclude.size()) * 100.0;
                String msg = String.format("Deleted %d (%1.2f%%) previous documents so far", deletedCount, progress);
                this.monitor.info(msg, new Object[0]);
            }
            return deletedCount;
        }

        private void ensureSorted() throws IOException {
            if (!this.sorted) {
                this.docIdsToDelete.sort();
                this.prevDocIdsToDelete.sort();
                this.sorted = true;
            }
        }

        private Map.Entry<String, Long> parseEntry(String entry) throws IllegalArgumentException {
            long modified;
            int idx = entry.lastIndexOf(47);
            if (idx == -1) {
                throw new IllegalArgumentException(entry);
            }
            String id = entry.substring(0, idx);
            try {
                modified = Long.parseLong(entry.substring(idx + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(entry);
            }
            return Maps.immutableEntry((Object)id, (Object)modified);
        }
    }

    private class FullGC
    implements Closeable {
        private final long toModifiedMs;
        private final GCMonitor monitor;
        private final AtomicBoolean cancel;
        private final Stopwatch timer;
        private final List<UpdateOp> updateOpList;
        private final Map<String, Long> orphanOrDeletedRemovalMap;
        private final Map<String, Path> orphanOrDeletedRemovalPathMap;
        private final Map<String, Integer> deletedPropsCountMap;
        private final Map<String, Integer> deletedInternalPropsCountMap;
        private final Map<String, Integer> deletedPropRevsCountMap;
        private final Map<String, Integer> deletedInternalPropRevsCountMap;
        private final Set<Revision> deletedUnmergedBCSet;
        private int garbageDocsCount;
        private int totalGarbageDocsCount;
        private final Revision revisionForModified;
        private final DocumentNodeState root;
        private final LinkedHashMap<Path, Boolean> missingDocsTypes;

        public FullGC(RevisionVector headRevision, long toModifiedMs, @NotNull LinkedHashMap<Path, Boolean> missingDocsTypes, @NotNull GCMonitor monitor, AtomicBoolean cancel) {
            this.toModifiedMs = toModifiedMs;
            this.missingDocsTypes = missingDocsTypes;
            this.monitor = monitor;
            this.cancel = cancel;
            this.updateOpList = new ArrayList<UpdateOp>();
            this.orphanOrDeletedRemovalMap = new HashMap<String, Long>();
            this.orphanOrDeletedRemovalPathMap = new HashMap<String, Path>();
            this.deletedPropsCountMap = new HashMap<String, Integer>();
            this.deletedInternalPropsCountMap = new HashMap<String, Integer>();
            this.deletedPropRevsCountMap = new HashMap<String, Integer>();
            this.deletedInternalPropRevsCountMap = new HashMap<String, Integer>();
            this.deletedUnmergedBCSet = new HashSet<Revision>();
            this.timer = Stopwatch.createUnstarted();
            this.revisionForModified = Revision.newRevision(0);
            this.root = VersionGarbageCollector.this.nodeStore.getRoot(headRevision);
        }

        public void collectGarbage(NodeDocument doc, GCPhases phases) {
            if (fullGcMode == FullGCMode.NONE) {
                this.monitor.warn("Skipping FullGC. No Mode has been selected.", new Object[0]);
                return;
            }
            VersionGarbageCollector.this.fullGCStats.documentRead();
            this.monitor.info("Collecting Full Garbage for doc [{}]", new Object[]{doc.getId()});
            if (AUDIT_LOG.isTraceEnabled()) {
                AUDIT_LOG.trace("<Collecting> Garbage in doc [{}]", (Object)doc.getId());
            }
            UpdateOp op = new UpdateOp(Objects.requireNonNull(doc.getId()), false);
            DocumentNodeState traversedState = this.root;
            Path greatestExistingAncestorOrSelf = this.root.getPath();
            for (String name : doc.getPath().elements()) {
                if (!(traversedState = traversedState.getChildNode(name)).exists()) continue;
                greatestExistingAncestorOrSelf = new Path(greatestExistingAncestorOrSelf, name);
            }
            if (!this.isDeletedOrOrphanedNode((NodeState)traversedState, greatestExistingAncestorOrSelf, phases, doc)) {
                switch (fullGcMode) {
                    case NONE: {
                        return;
                    }
                    case GAP_ORPHANS: {
                        break;
                    }
                    case GAP_ORPHANS_EMPTYPROPS: 
                    case ALL_ORPHANS_EMPTYPROPS: {
                        this.collectDeletedProperties(doc, phases, op, (NodeState)traversedState);
                        break;
                    }
                    case ORPHANS_EMPTYPROPS_KEEP_ONE_ALL_PROPS: {
                        this.collectDeletedProperties(doc, phases, op, (NodeState)traversedState);
                        this.collectUnusedPropertyRevisions(doc, phases, op, traversedState, false);
                        this.combineInternalPropRemovals(doc, op);
                        break;
                    }
                    case ORPHANS_EMPTYPROPS_KEEP_ONE_USER_PROPS: {
                        this.collectDeletedProperties(doc, phases, op, (NodeState)traversedState);
                        this.collectUnusedPropertyRevisions(doc, phases, op, traversedState, true);
                        this.combineInternalPropRemovals(doc, op);
                        break;
                    }
                    case ORPHANS_EMPTYPROPS_UNMERGED_BC: {
                        this.collectDeletedProperties(doc, phases, op, (NodeState)traversedState);
                        this.collectUnmergedBranchCommits(doc, phases, op, this.toModifiedMs);
                        break;
                    }
                    case ORPHANS_EMPTYPROPS_BETWEEN_CHECKPOINTS_WITH_UNMERGED_BC: {
                        this.collectDeletedProperties(doc, phases, op, (NodeState)traversedState);
                        this.collectUnmergedBranchCommits(doc, phases, op, this.toModifiedMs);
                        this.collectRevisionsOlderThan24hAndBetweenCheckpoints(doc, this.toModifiedMs, phases, op);
                        break;
                    }
                    case ORPHANS_EMPTYPROPS_BETWEEN_CHECKPOINTS_NO_UNMERGED_BC: {
                        this.collectDeletedProperties(doc, phases, op, (NodeState)traversedState);
                        this.collectRevisionsOlderThan24hAndBetweenCheckpoints(doc, this.toModifiedMs, phases, op);
                    }
                }
                if (op.hasChanges()) {
                    op.equals("_modified", doc.getModified());
                    ++this.garbageDocsCount;
                    ++this.totalGarbageDocsCount;
                    this.monitor.info("Collected [{}] garbage count in [{}]", new Object[]{op.getChanges().size(), doc.getId()});
                    AUDIT_LOG.info("<Collected> [{}] garbage count  in [{}]", (Object)op.getChanges().size(), (Object)doc.getId());
                    this.updateOpList.add(op);
                }
            }
            if (log.isTraceEnabled() && op.hasChanges()) {
                log.trace("UpdateOp for [{}] is [{}]", (Object)doc.getId(), (Object)op);
            }
        }

        private void combineInternalPropRemovals(NodeDocument doc, UpdateOp op) {
            if (op.hasChanges()) {
                int deletedSystemPropsCount = this.getSystemRemoveMapEntryCounts(op).entrySet().stream().filter(e -> this.filterEmptyProps(doc, (String)e.getKey(), (Integer)e.getValue())).mapToInt(e -> {
                    String prop = (String)e.getKey();
                    int countBefore = op.getChanges().entrySet().size();
                    boolean removed = op.getChanges().entrySet().removeIf(opEntry -> Objects.equals(prop, ((UpdateOp.Key)opEntry.getKey()).getName()));
                    int countAfter = op.getChanges().entrySet().size();
                    if (removed) {
                        if (prop.startsWith("_")) {
                            this.deletedInternalPropRevsCountMap.merge(doc.getId(), countAfter - countBefore, Integer::sum);
                        } else {
                            this.deletedPropRevsCountMap.merge(doc.getId(), countAfter - countBefore, Integer::sum);
                        }
                    }
                    op.remove(prop);
                    return 1;
                }).sum();
                int totalDeletedSystemPropsCount = this.deletedInternalPropsCountMap.merge(doc.getId(), deletedSystemPropsCount, Integer::sum);
                if (AUDIT_LOG.isDebugEnabled()) {
                    AUDIT_LOG.debug("<Collected> [{}] internal prop revs in [{}] mode [{}]", new Object[]{totalDeletedSystemPropsCount, doc.getId(), fullGcMode});
                }
            }
        }

        private boolean isDeletedOrOrphanedNode(NodeState traversedState, Path greatestExistingAncestorOrSelf, GCPhases phases, NodeDocument doc) {
            boolean isOrphan;
            if (!phases.start(GCPhase.FULL_GC_COLLECT_ORPHAN_NODES)) {
                return false;
            }
            boolean bl = isOrphan = !traversedState.exists();
            if (!isOrphan) {
                phases.stop(GCPhase.FULL_GC_COLLECT_ORPHAN_NODES);
                return false;
            }
            if (fullGcMode == FullGCMode.GAP_ORPHANS || fullGcMode == FullGCMode.GAP_ORPHANS_EMPTYPROPS) {
                Path docPath = doc.getPath();
                Path geaChildPath = docPath.getAncestor(docPath.getDepth() - greatestExistingAncestorOrSelf.getDepth() - 1);
                Boolean missingType = this.missingDocsTypes.get(geaChildPath);
                if (missingType == null) {
                    missingType = VersionGarbageCollector.this.versionStore.getDocument(Utils.getIdFromPath(geaChildPath), List.of("_id")).isEmpty();
                    this.missingDocsTypes.put(geaChildPath, missingType);
                }
                if (!missingType.booleanValue()) {
                    phases.stop(GCPhase.FULL_GC_COLLECT_ORPHAN_NODES);
                    return true;
                }
            }
            ++this.garbageDocsCount;
            ++this.totalGarbageDocsCount;
            this.monitor.info("Deleted orphaned or deleted doc [{}]", new Object[]{doc.getId()});
            this.orphanOrDeletedRemovalMap.put(doc.getId(), doc.getModified());
            this.orphanOrDeletedRemovalPathMap.put(doc.getId(), doc.getPath());
            if (AUDIT_LOG.isDebugEnabled()) {
                AUDIT_LOG.debug("<Collected> [{}] orphaned node", (Object)doc.getId());
            }
            phases.stop(GCPhase.FULL_GC_COLLECT_ORPHAN_NODES);
            return true;
        }

        private boolean hasGarbage() {
            return this.garbageDocsCount > 0;
        }

        private void collectDeletedProperties(NodeDocument doc, GCPhases phases, UpdateOp updateOp, NodeState traversedState) {
            if (phases.start(GCPhase.FULL_GC_COLLECT_PROPS)) {
                Set<String> properties = doc.getPropertyNames();
                Set retainPropSet = Optional.ofNullable(traversedState instanceof DocumentNodeState ? (DocumentNodeState)traversedState : null).map(DocumentNodeState::getAllBundledProperties).map(Map::keySet).map(p -> p.stream().map(Utils::escapePropertyName).collect(Collectors.toSet())).orElse(Collections.emptySet());
                int deletedPropsCount = properties.stream().filter(p -> !retainPropSet.contains(p)).mapToInt(x -> {
                    updateOp.remove((String)x);
                    return 1;
                }).sum();
                this.deletedPropsCountMap.put(doc.getId(), deletedPropsCount);
                if (AUDIT_LOG.isDebugEnabled() && deletedPropsCount > 0) {
                    AUDIT_LOG.debug("<Collected> [{}] deleted props in [{}]", (Object)deletedPropsCount, (Object)doc.getId());
                }
                phases.stop(GCPhase.FULL_GC_COLLECT_PROPS);
            }
        }

        private void collectUnmergedBranchCommits(NodeDocument doc, GCPhases phases, UpdateOp updateOp, long toModifiedMs) {
            if (!phases.start(GCPhase.FULL_GC_COLLECT_UNMERGED_BC)) {
                return;
            }
            Set<Revision> olderUnmergedBranchCommits = doc.getLocalBranchCommits().stream().filter(bcRevision -> this.isRevisionOlderThan((Revision)bcRevision, toModifiedMs)).filter(bcRevision -> !Utils.isCommitted(VersionGarbageCollector.this.nodeStore.getCommitValue((Revision)bcRevision, doc))).collect(Collectors.toSet());
            if (olderUnmergedBranchCommits.isEmpty()) {
                phases.stop(GCPhase.FULL_GC_COLLECT_UNMERGED_BC);
                return;
            }
            olderUnmergedBranchCommits.forEach(bcRevision -> this.removeUnmergedBCRevision((Revision)bcRevision, doc, updateOp));
            this.deletedUnmergedBCSet.addAll(olderUnmergedBranchCommits);
            if (AUDIT_LOG.isDebugEnabled()) {
                AUDIT_LOG.debug("<Collected> [{}] unmerged branch commits in [{}]", (Object)olderUnmergedBranchCommits.size(), (Object)doc.getId());
            }
            if (updateOp.hasChanges()) {
                int deletedSystemPropsCount = this.getSystemRemoveMapEntryCounts(updateOp).entrySet().stream().filter(e -> this.filterEmptyProps(doc, (String)e.getKey(), (Integer)e.getValue())).mapToInt(e -> {
                    String prop = (String)e.getKey();
                    int origCount = updateOp.getChanges().size();
                    updateOp.getChanges().entrySet().removeIf(opEntry -> Objects.equals(prop, ((UpdateOp.Key)opEntry.getKey()).getName()));
                    int diff = origCount - updateOp.getChanges().size();
                    if (diff > 0) {
                        this.deletedInternalPropRevsCountMap.merge(doc.getId(), -diff, Integer::sum);
                    }
                    updateOp.remove(prop);
                    return 1;
                }).sum();
                int totalDeletedSystemPropsCount = this.deletedInternalPropsCountMap.merge(doc.getId(), deletedSystemPropsCount, Integer::sum);
                if (AUDIT_LOG.isDebugEnabled()) {
                    AUDIT_LOG.debug("<Collected> [{}] internal prop revs in [{}] mode [{}]", new Object[]{totalDeletedSystemPropsCount, doc.getId(), fullGcMode});
                }
            }
            phases.stop(GCPhase.FULL_GC_COLLECT_UNMERGED_BC);
        }

        private boolean filterEmptyProps(NodeDocument doc, String prop, int value) {
            Object d = doc.data.get(prop);
            if (d instanceof Map) {
                Map m = (Map)d;
                return m.size() == value;
            }
            log.error("collectUnmergedBranchCommitDocument: property without sub-document as expected. id={}, prop={}", (Object)doc.getId(), (Object)prop);
            return false;
        }

        private Map<String, Integer> getSystemRemoveMapEntryCounts(UpdateOp updateOp) {
            HashMap<String, Integer> propMap = new HashMap<String, Integer>();
            updateOp.getChanges().entrySet().stream().filter(e -> ((UpdateOp.Operation)e.getValue()).type == UpdateOp.Operation.Type.REMOVE_MAP_ENTRY).map(e -> ((UpdateOp.Key)e.getKey()).getName()).filter(propName -> propName.startsWith("_")).forEach(propName -> propMap.merge((String)propName, 1, Integer::sum));
            return propMap;
        }

        private boolean isRevisionOlderThan(Revision revision, long toModifiedMillis) {
            long time = revision.getTimestamp();
            return time <= toModifiedMillis;
        }

        private void removeUnmergedBCRevision(Revision unmergedBCRevision, NodeDocument doc, UpdateOp updateOp) {
            int internalRevEntriesCount = 0;
            int revEntriesCount = 0;
            if (doc.getLocalBranchCommits().contains(unmergedBCRevision)) {
                ++internalRevEntriesCount;
            }
            NodeDocument.removeBranchCommit(updateOp, unmergedBCRevision);
            String unmergedDeleted = (String)doc.getLocalDeleted().get(unmergedBCRevision);
            if (unmergedDeleted != null) {
                ++internalRevEntriesCount;
                NodeDocument.removeDeleted(updateOp, unmergedBCRevision);
                if ("false".equals(unmergedDeleted)) {
                    if (!doc.wasDeletedOnce()) {
                        NodeDocument.setDeletedOnce(updateOp);
                    }
                    NodeDocument.setModified(updateOp, this.revisionForModified);
                }
            }
            if (doc.getLocalCommitRoot().containsKey(unmergedBCRevision)) {
                ++internalRevEntriesCount;
                NodeDocument.removeCommitRoot(updateOp, unmergedBCRevision);
            }
            if (doc.getLocalRevisions().containsKey(unmergedBCRevision)) {
                ++internalRevEntriesCount;
                NodeDocument.removeRevision(updateOp, unmergedBCRevision);
            }
            if (doc.getLocalMap("_collisions").containsKey(unmergedBCRevision)) {
                ++internalRevEntriesCount;
                NodeDocument.removeCollision(updateOp, unmergedBCRevision);
            }
            for (String propName : doc.getPropertyNames()) {
                UpdateOp.Operation op = updateOp.getChanges().get(new UpdateOp.Key(propName, null));
                if (op != null && op.type == UpdateOp.Operation.Type.REMOVE || !doc.getLocalMap(propName).containsKey(unmergedBCRevision)) continue;
                updateOp.removeMapEntry(propName, unmergedBCRevision);
                ++revEntriesCount;
            }
            if (internalRevEntriesCount > 0) {
                this.deletedInternalPropRevsCountMap.merge(doc.getId(), internalRevEntriesCount, Integer::sum);
            }
            if (revEntriesCount > 0) {
                this.deletedPropRevsCountMap.merge(doc.getId(), revEntriesCount, Integer::sum);
            }
            if (AUDIT_LOG.isDebugEnabled()) {
                AUDIT_LOG.debug("<Collected> [{}] prop revs, [{}] internal prop revs in [{}] mode [{}]", new Object[]{this.deletedPropRevsCountMap.get(doc.getId()), this.deletedInternalPropRevsCountMap.get(doc.getId()), doc.getId(), fullGcMode});
            }
        }

        private void collectRevisionsOlderThan24hAndBetweenCheckpoints(NodeDocument doc, long toModifiedMs, GCPhases phases, UpdateOp updateOp) {
            if (phases.start(GCPhase.FULL_GC_COLLECT_OLD_REVS)) {
                int intRevsDiff;
                NodeDocumentRevisionCleaner cleaner = new NodeDocumentRevisionCleaner(VersionGarbageCollector.this.nodeStore, doc, toModifiedMs);
                int beforeRevs = this.countRevs(updateOp, false);
                int beforeIntRevs = this.countRevs(updateOp, true);
                cleaner.collectOldRevisions(updateOp);
                int revsDiff = this.countRevs(updateOp, false) - beforeRevs;
                if (revsDiff > 0) {
                    this.deletedPropRevsCountMap.merge(doc.getId(), revsDiff, Integer::sum);
                }
                if ((intRevsDiff = this.countRevs(updateOp, true) - beforeIntRevs) > 0) {
                    this.deletedInternalPropRevsCountMap.merge(doc.getId(), intRevsDiff, Integer::sum);
                }
                if (AUDIT_LOG.isDebugEnabled()) {
                    AUDIT_LOG.debug("<Collected> [{}] prop revs, [{}] internal prop revs in [{}] mode [{}]", new Object[]{this.deletedPropRevsCountMap.get(doc.getId()), this.deletedInternalPropRevsCountMap.get(doc.getId()), doc.getId(), fullGcMode});
                }
                phases.stop(GCPhase.FULL_GC_COLLECT_OLD_REVS);
            }
        }

        private int countRevs(UpdateOp updateOp, boolean internalProps) {
            return updateOp.getChanges().entrySet().stream().filter(e -> ((UpdateOp.Operation)e.getValue()).type == UpdateOp.Operation.Type.REMOVE_MAP_ENTRY).filter(e -> ((UpdateOp.Key)e.getKey()).getName().startsWith("_") == internalProps).mapToInt(x -> 1).sum();
        }

        private void collectUnusedPropertyRevisions(NodeDocument doc, GCPhases phases, UpdateOp updateOp, DocumentNodeState traversedMainNode, boolean ignoreInternalProperties) {
            int deletedTotalRevsCount;
            if (!phases.start(GCPhase.FULL_GC_COLLECT_OLD_REVS)) {
                return;
            }
            HashSet<Revision> allKeepRevs = new HashSet<Revision>();
            int deletedUserRevsCount = deletedTotalRevsCount = this.collectUnusedUserPropertyRevisions(doc, updateOp, traversedMainNode, allKeepRevs);
            if (!ignoreInternalProperties) {
                deletedTotalRevsCount = this.collectUnusedInternalPropertyRevisions(doc, updateOp, allKeepRevs, deletedTotalRevsCount);
            }
            int deletedInternalRevsCount = deletedTotalRevsCount - deletedUserRevsCount;
            if (deletedUserRevsCount != 0) {
                this.deletedPropRevsCountMap.merge(doc.getId(), deletedUserRevsCount, Integer::sum);
            }
            if (deletedInternalRevsCount != 0) {
                this.deletedInternalPropRevsCountMap.merge(doc.getId(), deletedInternalRevsCount, Integer::sum);
            }
            if (AUDIT_LOG.isDebugEnabled()) {
                AUDIT_LOG.debug("<Collected> [{}] prop revs, [{}] internal prop revs in [{}] mode [{}]", new Object[]{this.deletedPropRevsCountMap.get(doc.getId()), this.deletedInternalPropRevsCountMap.get(doc.getId()), doc.getId(), fullGcMode});
            }
            phases.stop(GCPhase.FULL_GC_COLLECT_OLD_REVS);
        }

        private int collectUnusedUserPropertyRevisions(NodeDocument doc, UpdateOp updateOp, DocumentNodeState traversedMainNode, Set<Revision> allKeepRevs) {
            int deletedRevsCount = StreamSupport.stream(traversedMainNode.getProperties().spliterator(), false).map(p -> Utils.escapePropertyName(p.getName())).mapToInt(p -> this.removeUnusedPropertyEntries(doc, traversedMainNode, updateOp, (String)p, r -> updateOp.removeMapEntry((String)p, (Revision)r), allKeepRevs)).sum();
            Map bundledNodeStates = StreamSupport.stream(traversedMainNode.getAllBundledNodesStates().spliterator(), false).collect(Collectors.toMap(DocumentNodeState::getPath, java.util.function.Function.identity()));
            for (String propName : traversedMainNode.getAllBundledProperties().keySet()) {
                int lastSlash = propName.lastIndexOf("/");
                if (lastSlash == -1) continue;
                String escapedPropName = Utils.escapePropertyName(propName);
                String unbundledSubtreeName = propName.substring(0, lastSlash);
                String unbundledPropName = propName.substring(lastSlash + 1);
                String unbundledPath = traversedMainNode.getPath().toString() + "/" + unbundledSubtreeName;
                DocumentNodeState traversedNode = (DocumentNodeState)((Object)bundledNodeStates.get(Path.fromString(unbundledPath)));
                if (traversedNode == null) {
                    log.error("collectUnusedPropertyRevisions : could not find traversed node for bundled key [{}] unbundledPath [{}] in doc [{}]", new Object[]{propName, unbundledPath, doc.getId()});
                    continue;
                }
                PropertyState traversedProperty = traversedNode.getProperty(unbundledPropName);
                if (traversedProperty == null) {
                    log.error("collectUnusedPropertyRevisions : could not get property [{}] from traversed node [{}]", (Object)unbundledPropName, (Object)traversedNode.getPath());
                    continue;
                }
                deletedRevsCount += this.removeUnusedPropertyEntries(doc, traversedNode, updateOp, escapedPropName, r -> updateOp.removeMapEntry(escapedPropName, (Revision)r), allKeepRevs);
            }
            int numDeleted = this.removeUnusedPropertyEntries(doc, traversedMainNode, updateOp, "_deleted", r -> NodeDocument.removeDeleted(updateOp, r), allKeepRevs);
            return deletedRevsCount += numDeleted;
        }

        private int collectUnusedInternalPropertyRevisions(NodeDocument doc, UpdateOp updateOp, Set<Revision> toKeepUserPropRevs, int deletedRevsCount) {
            boolean hasUnmergedBranchCommits = doc.getLocalBranchCommits().stream().anyMatch(r -> !Utils.isCommitted(VersionGarbageCollector.this.nodeStore.getCommitValue((Revision)r, doc)));
            if (deletedRevsCount == 0 && !hasUnmergedBranchCommits) {
                return deletedRevsCount;
            }
            HashSet<Revision> allRequiredRevs = new HashSet<Revision>(toKeepUserPropRevs);
            deletedRevsCount += this.getDeletedRevsCount(doc.getLocalMap("_collisions").keySet(), updateOp, allRequiredRevs, "_collisions", NodeDocument::removeCollision);
            for (Map.Entry<Revision, String> e : doc.getLocalRevisions().entrySet()) {
                UpdateOp.Operation has;
                Revision revision = e.getKey();
                if (allRequiredRevs.contains(revision)) continue;
                boolean isRoot = doc.getId().equals(Utils.getIdFromPath(Path.ROOT));
                boolean isBC = doc.getLocalBranchCommits().contains(revision);
                boolean newerThanSweep = VersionGarbageCollector.this.nodeStore.getSweepRevisions().isRevisionNewer(revision);
                if (newerThanSweep && !isBC) {
                    allRequiredRevs.add(revision);
                    continue;
                }
                boolean isCommitted = Utils.isCommitted(VersionGarbageCollector.this.nodeStore.getCommitValue(revision, doc));
                if (isCommitted) {
                    if (isRoot) {
                        allRequiredRevs.add(revision);
                        continue;
                    }
                    if (!isBC) {
                        allRequiredRevs.add(revision);
                        continue;
                    }
                }
                if ((has = updateOp.getChanges().get(new UpdateOp.Key("_revisions", revision))) != null) continue;
                NodeDocument.removeRevision(updateOp, revision);
                ++deletedRevsCount;
            }
            deletedRevsCount += this.getDeletedRevsCount(doc.getLocalCommitRoot().keySet(), updateOp, allRequiredRevs, "_commitRoot", NodeDocument::removeCommitRoot);
            return deletedRevsCount += this.getDeletedRevsCount(doc.getLocalBranchCommits(), updateOp, allRequiredRevs, "_bc", NodeDocument::removeBranchCommit);
        }

        private int getDeletedRevsCount(Set<Revision> revisionSet, UpdateOp updateOp, Set<Revision> allRequiredRevs, String updateOpKey, BiConsumer<UpdateOp, Revision> op) {
            return revisionSet.stream().filter(r -> !allRequiredRevs.contains(r)).mapToInt(r -> {
                UpdateOp.Operation has = updateOp.getChanges().get(new UpdateOp.Key(updateOpKey, (Revision)r));
                if (has != null) {
                    return 0;
                }
                op.accept(updateOp, (Revision)r);
                return 1;
            }).sum();
        }

        private int removeUnusedPropertyEntries(NodeDocument doc, DocumentNodeState traversedMainNode, UpdateOp updateOp, String propertyKey, Consumer<Revision> removeRevision, Set<Revision> allKeepRevs) {
            Revision keepCommitRev = doc.localCommitRevisionOfProperty(VersionGarbageCollector.this.nodeStore, traversedMainNode.getLastRevision(), propertyKey);
            if (keepCommitRev == null) {
                if (AUDIT_LOG.isTraceEnabled()) {
                    AUDIT_LOG.trace("<remove> : [0] visible revision for property [{}] in [{}]", (Object)propertyKey, (Object)doc.getId());
                }
                return 0;
            }
            SortedMap<Revision, String> localMap = doc.getLocalMap(propertyKey);
            if (!localMap.containsKey(keepCommitRev)) {
                log.error("removeUnusedPropertyEntries : revision [{}] for property [{}] not found in doc [{}]", new Object[]{keepCommitRev, propertyKey, doc.getId()});
                return 0;
            }
            int count = 0;
            for (Revision localRev : localMap.keySet()) {
                UpdateOp.Operation c;
                if (keepCommitRev.equals(localRev) || (c = updateOp.getChanges().get(new UpdateOp.Key(propertyKey, localRev))) != null) continue;
                if (AUDIT_LOG.isTraceEnabled()) {
                    AUDIT_LOG.trace("<remove> : property key [{}] revision [{}] in [{}]", new Object[]{propertyKey, localRev, doc.getId()});
                }
                removeRevision.accept(localRev);
                ++count;
            }
            allKeepRevs.add(keepCommitRev);
            return count;
        }

        int getGarbageCount() {
            return this.totalGarbageDocsCount;
        }

        @Override
        public void close() {
            this.totalGarbageDocsCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeGarbage(VersionGCStats stats) {
            if (this.updateOpList.isEmpty() && this.orphanOrDeletedRemovalMap.isEmpty()) {
                if (log.isDebugEnabled() || VersionGarbageCollector.this.isFullGCDryRun) {
                    log.debug("Skipping removal of Full garbage, cause no garbage detected");
                }
                return;
            }
            this.monitor.info("Proceeding to update [{}] documents", new Object[]{this.updateOpList.size()});
            if (AUDIT_LOG.isDebugEnabled() || VersionGarbageCollector.this.isFullGCDryRun) {
                String updateIds = this.updateOpList.stream().map(UpdateOp::getId).collect(Collectors.joining(", "));
                String orphanIds = String.join((CharSequence)", ", this.orphanOrDeletedRemovalMap.keySet());
                log.debug("Performing batch update of ids [{}] and removal of orphan ids [{}]", (Object)updateIds, (Object)orphanIds);
            }
            if (this.cancel.get()) {
                log.info("Aborting the removal of Full garbage since RGC had been cancelled");
                return;
            }
            this.timer.reset().start();
            try {
                if (VersionGarbageCollector.this.embeddedVerification) {
                    Iterator<UpdateOp> it = this.updateOpList.iterator();
                    while (it.hasNext()) {
                        UpdateOp update = it.next();
                        NodeDocument nodeDocument = VersionGarbageCollector.this.ds.find(Collection.NODES, update.getId());
                        if (nodeDocument == null) {
                            log.error("removeGarbage.verify : no document found for update with id [{}]", (Object)update.getId());
                            continue;
                        }
                        DocumentNodeState traversedParent = null;
                        DocumentNodeState traversedState = this.root;
                        for (String name : nodeDocument.getPath().elements()) {
                            traversedParent = traversedState;
                            traversedState = traversedState.getChildNode(name);
                        }
                        NodeDocument newDoc = Collection.NODES.newDocument(VersionGarbageCollector.this.ds);
                        nodeDocument.deepCopy(newDoc);
                        UpdateUtils.applyChanges(newDoc, update);
                        if (this.verifyViaTraversedState((NodeState)traversedState, (NodeState)traversedParent, newDoc)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("removeGarbage.verify : verifyViaTraversedState failed for [{}]", (Object)newDoc.getId());
                        }
                        it.remove();
                        ++stats.skippedFullGCDocsCount;
                    }
                    for (Map.Entry entry : this.orphanOrDeletedRemovalMap.entrySet()) {
                        DocumentNodeState traversedState = this.root;
                        String id = (String)entry.getKey();
                        Path path = this.orphanOrDeletedRemovalPathMap.get(id);
                        if (path == null) {
                            log.error("removeGarbage.verify : no path available for id : [{}]", (Object)id);
                            it.remove();
                            ++stats.skippedFullGCDocsCount;
                            continue;
                        }
                        for (String name : path.elements()) {
                            traversedState = traversedState.getChildNode(name);
                        }
                        if (this.verifyDeletion((NodeState)traversedState)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("removeGarbage.verify : verifyDeletion failed for [{}]", entry.getKey());
                        }
                        it.remove();
                        ++stats.skippedFullGCDocsCount;
                    }
                }
                if (!VersionGarbageCollector.this.isFullGCDryRun) {
                    if (!this.orphanOrDeletedRemovalMap.isEmpty()) {
                        int removedSize = VersionGarbageCollector.this.ds.remove(Collection.NODES, this.orphanOrDeletedRemovalMap);
                        stats.updatedFullGCDocsCount += removedSize;
                        stats.deletedDocGCCount += removedSize;
                        stats.deletedOrphanNodesCount += removedSize;
                        if (AUDIT_LOG.isDebugEnabled()) {
                            AUDIT_LOG.debug("<delete> [{}] documents (from intended {})", (Object)removedSize, (Object)this.orphanOrDeletedRemovalMap.size());
                        }
                        VersionGarbageCollector.this.fullGCStats.documentsUpdated(removedSize);
                        VersionGarbageCollector.this.fullGCStats.orphanNodesDeleted(removedSize);
                        VersionGarbageCollector.this.gcStats.documentsDeleted(removedSize);
                        VersionGarbageCollector.this.fullGCStats.documentsUpdateSkipped((long)this.orphanOrDeletedRemovalMap.size() - (long)removedSize);
                    }
                    if (!this.updateOpList.isEmpty()) {
                        List<NodeDocument> oldDocs = VersionGarbageCollector.this.ds.findAndUpdate(Collection.NODES, this.updateOpList);
                        int deletedProps = oldDocs.stream().filter(Objects::nonNull).mapToInt(d -> this.deletedPropsCountMap.getOrDefault(d.getId(), 0)).sum();
                        int n = oldDocs.stream().filter(Objects::nonNull).mapToInt(d -> this.deletedInternalPropsCountMap.getOrDefault(d.getId(), 0)).sum();
                        int deletedRevEntriesCount = oldDocs.stream().filter(Objects::nonNull).mapToInt(d -> this.deletedPropRevsCountMap.getOrDefault(d.getId(), 0)).sum();
                        int deletedInternalRevEntriesCount = oldDocs.stream().filter(Objects::nonNull).mapToInt(d -> this.deletedInternalPropRevsCountMap.getOrDefault(d.getId(), 0)).sum();
                        int updatedDocs = (int)oldDocs.stream().filter(Objects::nonNull).count();
                        stats.updatedFullGCDocsCount += updatedDocs;
                        stats.deletedPropsCount += deletedProps;
                        stats.deletedInternalPropsCount += n;
                        stats.deletedPropRevsCount += deletedRevEntriesCount;
                        stats.deletedInternalPropRevsCount += deletedInternalRevEntriesCount;
                        stats.deletedUnmergedBCCount += this.deletedUnmergedBCSet.size();
                        if (log.isDebugEnabled()) {
                            log.debug("Updated [{}] docs, deleted [{}] props, deleted [{}] unmergedBCs, deleted [{}] internal Props, deleted [{}] prop revs, deleted [{}] internal prop revs", new Object[]{updatedDocs, deletedProps, this.deletedUnmergedBCSet.size(), n, deletedRevEntriesCount, deletedInternalRevEntriesCount});
                        }
                        VersionGarbageCollector.this.fullGCStats.propertiesDeleted(deletedProps);
                        VersionGarbageCollector.this.fullGCStats.unmergedBranchCommitsDeleted(this.deletedUnmergedBCSet.size());
                        VersionGarbageCollector.this.fullGCStats.documentsUpdated(updatedDocs);
                        VersionGarbageCollector.this.fullGCStats.documentsUpdateSkipped((long)oldDocs.size() - (long)updatedDocs);
                    }
                } else {
                    stats.updatedFullGCDocsCount += this.updateOpList.size();
                    stats.deletedPropsCount += this.deletedPropsCountMap.values().stream().reduce(0, Integer::sum).intValue();
                    stats.deletedInternalPropsCount += this.deletedInternalPropsCountMap.values().stream().reduce(0, Integer::sum).intValue();
                    stats.deletedPropRevsCount += this.deletedPropRevsCountMap.values().stream().reduce(0, Integer::sum).intValue();
                    stats.deletedInternalPropRevsCount += this.deletedInternalPropRevsCountMap.values().stream().reduce(0, Integer::sum).intValue();
                    stats.deletedUnmergedBCCount += this.deletedUnmergedBCSet.size();
                    stats.updatedFullGCDocsCount += this.orphanOrDeletedRemovalMap.size();
                    stats.deletedDocGCCount += this.orphanOrDeletedRemovalMap.size();
                    stats.deletedOrphanNodesCount += this.orphanOrDeletedRemovalMap.size();
                }
            }
            finally {
                this.updateOpList.clear();
                this.orphanOrDeletedRemovalMap.clear();
                this.orphanOrDeletedRemovalPathMap.clear();
                this.deletedPropsCountMap.clear();
                this.deletedInternalPropsCountMap.clear();
                this.deletedPropRevsCountMap.clear();
                this.deletedInternalPropRevsCountMap.clear();
                this.deletedUnmergedBCSet.clear();
                this.garbageDocsCount = 0;
                VersionGarbageCollector.this.delayOnModifications(this.timer.stop().elapsed(TimeUnit.MILLISECONDS), this.cancel);
            }
        }

        private boolean verifyViaTraversedState(NodeState traversedState, NodeState traversedParent, NodeDocument newDoc) {
            RevisionVector lastRev;
            Path path = newDoc.getPath();
            Revision lastRevision = VersionGarbageCollector.this.nodeStore.getPendingModifications().get(path);
            if (traversedParent == null && !newDoc.getPath().isRoot()) {
                log.error("verify : no parent but not root for path : [{}]", (Object)newDoc.getPath());
                return false;
            }
            if (traversedParent == null && newDoc.getPath().isRoot()) {
                if (!(traversedState instanceof DocumentNodeState)) {
                    log.error("verify : traversedState not a DocumentNodeState : [{}]", traversedState.getClass());
                    return false;
                }
                lastRev = ((DocumentNodeState)traversedState).getLastRevision();
            } else {
                if (!traversedParent.exists()) {
                    log.error("verify : no parent but not marked for removal for path : {}", (Object)newDoc.getPath());
                    return false;
                }
                if (!(traversedParent instanceof DocumentNodeState)) {
                    log.error("verify : traversedParent not a DocumentNodeState : {}", traversedParent.getClass());
                    return false;
                }
                lastRev = ((DocumentNodeState)traversedParent).getLastRevision();
            }
            DocumentNodeState actual = newDoc.getNodeAtRevision(VersionGarbageCollector.this.nodeStore, lastRev, lastRevision);
            return Objects.nonNull((Object)actual) && AbstractNodeState.equals((NodeState)traversedState, (NodeState)actual);
        }

        private boolean verifyDeletion(NodeState traversedState) {
            return !traversedState.exists();
        }
    }

    private class GCJob {
        private final long maxRevisionAgeMillis;
        private final VersionGCOptions options;
        private final AtomicBoolean cancel = new AtomicBoolean();
        private final GCMonitor monitor;
        private final Supplier<String> status;

        GCJob(long maxRevisionAgeMillis, VersionGCOptions options, GCMonitor gcMonitor) {
            GCMessageTracker vgcm;
            this.maxRevisionAgeMillis = maxRevisionAgeMillis;
            this.options = options;
            this.status = vgcm = new GCMessageTracker();
            this.monitor = new DelegatingGCMonitor((java.util.Collection)Lists.newArrayList((Object[])new GCMonitor[]{vgcm, gcMonitor}));
            this.monitor.updateStatus(VersionGarbageCollector.STATUS_INITIALIZING);
        }

        VersionGCStats run() throws IOException {
            try {
                VersionGCStats versionGCStats = this.gc(this.maxRevisionAgeMillis);
                return versionGCStats;
            }
            finally {
                this.monitor.updateStatus(VersionGarbageCollector.STATUS_IDLE);
            }
        }

        void cancel() {
            this.monitor.info("Canceling revision garbage collection.", new Object[0]);
            this.cancel.set(true);
        }

        String getStatus() {
            return (String)this.status.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VersionGCStats gc(long maxRevisionAgeInMillis) throws IOException {
            VersionGCStats stats = new VersionGCStats();
            stats.active.start();
            VersionGCRecommendations rec = new VersionGCRecommendations(maxRevisionAgeInMillis, VersionGarbageCollector.this.nodeStore.getCheckpoints(), !VersionGarbageCollector.this.nodeStore.isReadOnlyMode(), VersionGarbageCollector.this.nodeStore.getClock(), VersionGarbageCollector.this.versionStore, this.options, VersionGarbageCollector.this.gcMonitor, VersionGarbageCollector.this.fullGCEnabled, VersionGarbageCollector.this.isFullGCDryRun);
            GCPhases phases = new GCPhases(this.cancel, stats, VersionGarbageCollector.this.gcMonitor);
            try {
                RevisionVector headRevision;
                if (!VersionGarbageCollector.this.isFullGCDryRun) {
                    if (rec.ignoreDueToCheckPoint) {
                        phases.stats.ignoredGCDueToCheckPoint = true;
                        this.monitor.skipped("Checkpoint prevented revision garbage collection", new Object[0]);
                    } else {
                        headRevision = VersionGarbageCollector.this.nodeStore.getHeadRevision();
                        RevisionVector sweepRevisions = VersionGarbageCollector.this.nodeStore.getSweepRevisions();
                        this.monitor.info("Looking at revisions in {}", new Object[]{rec.scope});
                        this.collectDeletedDocuments(phases, headRevision, rec);
                        this.collectSplitDocuments(phases, sweepRevisions, rec);
                    }
                } else {
                    phases.stats.fullGCDryRunMode = true;
                }
                if (VersionGarbageCollector.this.fullGCEnabled) {
                    stats.fullGCActive.start();
                    if (rec.ignoreFullGCDueToCheckPoint) {
                        phases.stats.ignoredFullGCDueToCheckPoint = true;
                        this.monitor.skipped("Checkpoint prevented Full garbage collection", new Object[0]);
                    } else {
                        headRevision = VersionGarbageCollector.this.nodeStore.getHeadRevision();
                        this.monitor.info("Looking at revisions in {} for full GC", new Object[]{rec.scopeFullGC});
                        this.collectFullGC(phases, headRevision, rec);
                    }
                }
                if ((!VersionGarbageCollector.this.fullGCEnabled || rec.ignoreFullGCDueToCheckPoint) && rec.ignoreDueToCheckPoint) {
                    this.cancel.set(true);
                }
            }
            catch (LimitExceededException ex) {
                stats.limitExceeded = true;
            }
            finally {
                phases.close();
                stats.canceled = this.cancel.get();
            }
            rec.evaluate(stats);
            this.monitor.info("Revision garbage collection finished in {}. {}", new Object[]{TimeDurationFormatter.forLogging().format(phases.elapsed.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), stats});
            if (VersionGarbageCollector.this.fullGCEnabled && stats.fullGCActive.isRunning()) {
                stats.fullGCActive.stop();
            }
            stats.active.stop();
            return stats;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collectFullGC(GCPhases phases, RevisionVector headRevision, VersionGCRecommendations rec) {
            block23: {
                long oldestModifiedMs = rec.scopeFullGC.fromMs;
                long toModifiedMs = rec.scopeFullGC.toMs;
                String oldestModifiedDocId = rec.fullGCId;
                int docsTraversed = 0;
                boolean foundDoc = true;
                long oldModifiedMs = oldestModifiedMs;
                LinkedHashMap<Path, Boolean> missingDocsTypes = new LinkedHashMap<Path, Boolean>(){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Path, Boolean> eldest) {
                        return this.size() > 64;
                    }
                };
                try (FullGC gc = new FullGC(headRevision, toModifiedMs, missingDocsTypes, this.monitor, this.cancel);){
                    long fromModifiedMs = oldestModifiedMs;
                    String fromId = Optional.ofNullable(oldestModifiedDocId).orElse("0000000");
                    if (!phases.start(GCPhase.FULL_GC)) break block23;
                    while (foundDoc && fromModifiedMs < toModifiedMs && docsTraversed < 10000) {
                        foundDoc = false;
                        NodeDocument lastDoc = null;
                        if (log.isDebugEnabled()) {
                            log.debug("Fetching docs from [{}] to [{}] with Id starting from [{}]", new Object[]{Utils.timestampToString(fromModifiedMs), Utils.timestampToString(toModifiedMs), fromId});
                        }
                        Iterable<NodeDocument> itr = VersionGarbageCollector.this.versionStore.getModifiedDocs(fromModifiedMs, toModifiedMs, 1000, fromId, VersionGarbageCollector.this.fullGCIncludePaths, VersionGarbageCollector.this.fullGCExcludePaths);
                        try {
                            for (NodeDocument doc : itr) {
                                Long modified;
                                foundDoc = true;
                                if (this.cancel.get()) {
                                    foundDoc = false;
                                    AUDIT_LOG.info("<Terminating> Received GC cancel call");
                                    break;
                                }
                                if (++docsTraversed % 100 == 0) {
                                    this.monitor.info("Iterated through {} documents so far. {} had Full garbage", new Object[]{docsTraversed, gc.getGarbageCount()});
                                }
                                lastDoc = doc;
                                if (phases.start(GCPhase.FULL_GC_COLLECT_GARBAGE)) {
                                    if (Utils.isIncluded(doc.getPath(), Collections.emptySet(), VersionGarbageCollector.this.fullGCExcludePaths)) {
                                        gc.collectGarbage(doc, phases);
                                    }
                                    phases.stop(GCPhase.FULL_GC_COLLECT_GARBAGE);
                                }
                                if ((modified = lastDoc.getModified()) == null) {
                                    this.monitor.warn("collectFullGC : document has no _modified property : {}", new Object[]{doc.getId()});
                                    continue;
                                }
                                if (TimeUnit.SECONDS.toMillis(modified) >= fromModifiedMs) continue;
                                this.monitor.warn("collectFullGC : document has older _modified than query boundary : {} (from: {}, to: {})", new Object[]{modified, Utils.timestampToString(fromModifiedMs), Utils.timestampToString(toModifiedMs)});
                            }
                            if (gc.hasGarbage() && phases.start(GCPhase.FULL_GC_CLEANUP)) {
                                gc.removeGarbage(phases.stats);
                                phases.stop(GCPhase.FULL_GC_CLEANUP);
                            }
                            if (lastDoc != null) {
                                fromModifiedMs = lastDoc.getModified() == null ? oldModifiedMs : TimeUnit.SECONDS.toMillis(lastDoc.getModified());
                                fromId = lastDoc.getId();
                            }
                        }
                        finally {
                            Utils.closeIfCloseable(itr);
                            phases.stats.oldestModifiedDocTimeStamp = fromModifiedMs;
                            phases.stats.oldestModifiedDocId = fromId;
                            oldModifiedMs = fromModifiedMs;
                            if (log.isDebugEnabled()) {
                                log.debug("Fetched docs till [{}] with Id [{}]", (Object)Utils.timestampToString(fromModifiedMs), (Object)fromId);
                            }
                        }
                        if (foundDoc || Objects.equals(fromId, "0000000")) continue;
                        fromId = "0000000";
                        fromModifiedMs += TimeUnit.SECONDS.toMillis(5L);
                        foundDoc = true;
                    }
                    phases.stop(GCPhase.FULL_GC);
                }
                finally {
                    if (docsTraversed < 10000) {
                        phases.stats.oldestModifiedDocTimeStamp = toModifiedMs;
                        phases.stats.oldestModifiedDocId = "0000000";
                    }
                }
            }
        }

        private void collectSplitDocuments(GCPhases phases, RevisionVector sweepRevisions, VersionGCRecommendations rec) {
            if (phases.start(GCPhase.SPLITS_CLEANUP)) {
                int splitDocGCCount = phases.stats.splitDocGCCount;
                int intermediateSplitDocGCCount = phases.stats.intermediateSplitDocGCCount;
                VersionGarbageCollector.this.versionStore.deleteSplitDocuments(GC_TYPES, sweepRevisions, rec.scope.toMs, phases.stats);
                VersionGarbageCollector.this.gcStats.splitDocumentsDeleted(phases.stats.splitDocGCCount - splitDocGCCount);
                VersionGarbageCollector.this.gcStats.intermediateSplitDocumentsDeleted(phases.stats.intermediateSplitDocGCCount - intermediateSplitDocGCCount);
                phases.stop(GCPhase.SPLITS_CLEANUP);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collectDeletedDocuments(GCPhases phases, RevisionVector headRevision, VersionGCRecommendations rec) throws IOException, LimitExceededException {
            int docsTraversed = 0;
            try (DeletedDocsGC gc = new DeletedDocsGC(headRevision, this.cancel, this.options, this.monitor);){
                if (phases.start(GCPhase.COLLECTING)) {
                    Iterable<NodeDocument> itr = VersionGarbageCollector.this.versionStore.getPossiblyDeletedDocs(rec.scope.fromMs, rec.scope.toMs);
                    try {
                        for (NodeDocument doc : itr) {
                            if (this.cancel.get()) {
                                break;
                            }
                            if (++docsTraversed % 10000 == 0) {
                                this.monitor.info("Iterated through {} documents so far. {} found to be deleted", new Object[]{docsTraversed, gc.getNumDocuments()});
                            }
                            if (phases.start(GCPhase.CHECKING)) {
                                gc.possiblyDeleted(doc);
                                phases.stop(GCPhase.CHECKING);
                            }
                            if (rec.maxCollect > 0L && gc.docIdsToDelete.getSize() > rec.maxCollect) {
                                throw new LimitExceededException();
                            }
                            if (gc.hasLeafBatch() && phases.start(GCPhase.DELETING)) {
                                gc.removeLeafDocuments(phases.stats);
                                phases.stop(GCPhase.DELETING);
                            }
                            if (!gc.hasRescurrectUpdateBatch() || !phases.start(GCPhase.UPDATING)) continue;
                            gc.updateResurrectedDocuments(phases.stats);
                            phases.stop(GCPhase.UPDATING);
                        }
                    }
                    finally {
                        Utils.closeIfCloseable(itr);
                    }
                    phases.stop(GCPhase.COLLECTING);
                }
                if (gc.getNumDocuments() != 0L) {
                    if (phases.start(GCPhase.DELETING)) {
                        gc.removeLeafDocuments(phases.stats);
                        phases.stop(GCPhase.DELETING);
                    }
                    if (phases.start(GCPhase.SORTING)) {
                        gc.ensureSorted();
                        phases.stop(GCPhase.SORTING);
                    }
                    if (phases.start(GCPhase.DELETING)) {
                        gc.removeDocuments(phases.stats);
                        phases.stop(GCPhase.DELETING);
                    }
                }
                if (phases.start(GCPhase.UPDATING)) {
                    gc.updateResurrectedDocuments(phases.stats);
                    phases.stop(GCPhase.UPDATING);
                }
            }
        }
    }

    private static class GCPhases {
        final VersionGCStats stats;
        final Stopwatch elapsed;
        private final GCMonitor monitor;
        private final List<GCPhase> phases = Lists.newArrayList();
        private final Map<GCPhase, Stopwatch> watches = Maps.newHashMap();
        private final AtomicBoolean canceled;

        GCPhases(AtomicBoolean canceled, VersionGCStats stats, GCMonitor monitor) {
            this.stats = stats;
            this.monitor = monitor;
            this.elapsed = Stopwatch.createStarted();
            this.watches.put(GCPhase.NONE, Stopwatch.createStarted());
            this.watches.put(GCPhase.COLLECTING, stats.collectDeletedDocs);
            this.watches.put(GCPhase.CHECKING, stats.checkDeletedDocs);
            this.watches.put(GCPhase.DELETING, stats.deleteDeletedDocs);
            this.watches.put(GCPhase.SORTING, stats.sortDocIds);
            this.watches.put(GCPhase.SPLITS_CLEANUP, stats.collectAndDeleteSplitDocs);
            this.watches.put(GCPhase.UPDATING, stats.updateResurrectedDocuments);
            this.watches.put(GCPhase.FULL_GC, stats.fullGCDocs);
            this.watches.put(GCPhase.FULL_GC_COLLECT_GARBAGE, stats.collectFullGC);
            this.watches.put(GCPhase.FULL_GC_COLLECT_ORPHAN_NODES, stats.collectOrphanNodes);
            this.watches.put(GCPhase.FULL_GC_COLLECT_PROPS, stats.collectDeletedProps);
            this.watches.put(GCPhase.FULL_GC_COLLECT_OLD_REVS, stats.collectDeletedOldRevs);
            this.watches.put(GCPhase.FULL_GC_COLLECT_UNMERGED_BC, stats.collectUnmergedBC);
            this.watches.put(GCPhase.FULL_GC_CLEANUP, stats.deleteFullGCDocs);
            this.canceled = canceled;
        }

        public boolean start(GCPhase started) {
            if (this.canceled.get()) {
                return false;
            }
            this.suspend(this.currentWatch());
            this.phases.add(started);
            this.updateStatus();
            this.resume(this.currentWatch());
            return true;
        }

        public void stop(GCPhase phase) {
            if (!this.phases.isEmpty() && phase == this.phases.get(this.phases.size() - 1)) {
                this.suspend(this.currentWatch());
                this.phases.remove(this.phases.size() - 1);
                this.updateStatus();
                this.resume(this.currentWatch());
            }
        }

        public void close() {
            while (!this.phases.isEmpty()) {
                this.suspend(this.currentWatch());
                this.phases.remove(this.phases.size() - 1);
                this.updateStatus();
            }
            this.elapsed.stop();
        }

        private GCPhase current() {
            return this.phases.isEmpty() ? GCPhase.NONE : this.phases.get(this.phases.size() - 1);
        }

        private Stopwatch currentWatch() {
            return this.watches.get((Object)this.current());
        }

        private void resume(Stopwatch w) {
            if (!w.isRunning()) {
                w.start();
            }
        }

        private void suspend(Stopwatch w) {
            if (w.isRunning()) {
                w.stop();
            }
        }

        private void updateStatus() {
            GCPhase p = this.current();
            if (p != GCPhase.NONE) {
                this.monitor.updateStatus(p.name());
            }
        }
    }

    private static enum GCPhase {
        NONE,
        COLLECTING,
        CHECKING,
        DELETING,
        SORTING,
        SPLITS_CLEANUP,
        FULL_GC,
        FULL_GC_COLLECT_GARBAGE,
        FULL_GC_COLLECT_ORPHAN_NODES,
        FULL_GC_COLLECT_PROPS,
        FULL_GC_COLLECT_OLD_REVS,
        FULL_GC_COLLECT_UNMERGED_BC,
        FULL_GC_CLEANUP,
        UPDATING;

    }

    public static class VersionGCStats {
        boolean ignoredGCDueToCheckPoint;
        boolean fullGCDryRunMode;
        boolean ignoredFullGCDueToCheckPoint;
        boolean canceled;
        boolean success = true;
        boolean limitExceeded;
        boolean needRepeat;
        int iterationCount;
        int deletedDocGCCount;
        int deletedLeafDocGCCount;
        int splitDocGCCount;
        int intermediateSplitDocGCCount;
        int updateResurrectedGCCount;
        long oldestModifiedDocTimeStamp;
        String oldestModifiedDocId;
        int updatedFullGCDocsCount;
        int skippedFullGCDocsCount;
        int deletedPropsCount;
        int deletedInternalPropsCount;
        int deletedPropRevsCount;
        int deletedInternalPropRevsCount;
        int deletedUnmergedBCCount;
        int deletedOrphanNodesCount;
        final TimeDurationFormatter df = TimeDurationFormatter.forLogging();
        final Stopwatch active = Stopwatch.createUnstarted();
        final Stopwatch fullGCActive = Stopwatch.createUnstarted();
        final Stopwatch collectDeletedDocs = Stopwatch.createUnstarted();
        final Stopwatch checkDeletedDocs = Stopwatch.createUnstarted();
        final Stopwatch deleteDeletedDocs = Stopwatch.createUnstarted();
        final Stopwatch collectAndDeleteSplitDocs = Stopwatch.createUnstarted();
        final Stopwatch deleteSplitDocs = Stopwatch.createUnstarted();
        final Stopwatch sortDocIds = Stopwatch.createUnstarted();
        final Stopwatch updateResurrectedDocuments = Stopwatch.createUnstarted();
        final Stopwatch fullGCDocs = Stopwatch.createUnstarted();
        final Stopwatch deleteFullGCDocs = Stopwatch.createUnstarted();
        final Stopwatch collectFullGC = Stopwatch.createUnstarted();
        final Stopwatch collectOrphanNodes = Stopwatch.createUnstarted();
        final Stopwatch collectDeletedProps = Stopwatch.createUnstarted();
        final Stopwatch collectDeletedOldRevs = Stopwatch.createUnstarted();
        final Stopwatch collectUnmergedBC = Stopwatch.createUnstarted();
        long activeElapsed;
        long fullGCActiveElapsed;
        long collectDeletedDocsElapsed;
        long checkDeletedDocsElapsed;
        long deleteDeletedDocsElapsed;
        long collectAndDeleteSplitDocsElapsed;
        long deleteSplitDocsElapsed;
        long sortDocIdsElapsed;
        long updateResurrectedDocumentsElapsed;
        long fullGCDocsElapsed;
        long collectFullGCElapsed;
        long collectOrphanNodesElapsed;
        long collectDeletedPropsElapsed;
        long deleteFullGCDocsElapsed;
        long collectDeletedOldRevsElapsed;
        long collectUnmergedBCElapsed;

        public String toString() {
            String timings;
            String fmt = "timeToCollectDeletedDocs=%s, timeToCheckDeletedDocs=%s, timeToSortDocIds=%s, timeTakenToUpdateResurrectedDocs=%s, timeTakenToDeleteDeletedDocs=%s, timeTakenToCollectAndDeleteSplitDocs=%s%s, timeToRunFullGC=%s, which includes [timeToDeleteFullGC=%s and timeToCollectFullGC=%s, (of which timeToCollectOrphanNodes=%s timeToCollectDeletedProps=%s, timeToCollectOldRevs=%s, timeToCollectUnmergedBranchCommits=%s)]";
            if (this.iterationCount > 0) {
                String timeDeletingSplitDocs = "";
                if (this.deleteSplitDocsElapsed > 0L) {
                    timeDeletingSplitDocs = String.format(" (of which %s deleting)", this.df.format(this.deleteSplitDocsElapsed, TimeUnit.MICROSECONDS));
                }
                timings = String.format(fmt, this.df.format(this.collectDeletedDocsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.checkDeletedDocsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.sortDocIdsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.updateResurrectedDocumentsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.deleteDeletedDocsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.collectAndDeleteSplitDocsElapsed, TimeUnit.MICROSECONDS), timeDeletingSplitDocs, this.df.format(this.fullGCDocsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.deleteFullGCDocsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.collectFullGCElapsed, TimeUnit.MICROSECONDS), this.df.format(this.collectOrphanNodesElapsed, TimeUnit.MICROSECONDS), this.df.format(this.collectDeletedPropsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.collectDeletedOldRevsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.collectUnmergedBCElapsed, TimeUnit.MICROSECONDS));
            } else {
                String timeDeletingSplitDocs = "";
                if (this.deleteSplitDocs.elapsed(TimeUnit.MICROSECONDS) > 0L) {
                    timeDeletingSplitDocs = String.format(" (of which %s deleting)", this.df.format(this.deleteSplitDocs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS));
                }
                timings = String.format(fmt, this.df.format(this.collectDeletedDocs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.checkDeletedDocs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.sortDocIds.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.updateResurrectedDocuments.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.deleteDeletedDocs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.collectAndDeleteSplitDocs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), timeDeletingSplitDocs, this.df.format(this.fullGCDocs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.deleteFullGCDocs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.collectFullGC.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.collectOrphanNodes.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.collectDeletedProps.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.collectDeletedOldRevs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.collectUnmergedBC.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS));
            }
            return "VersionGCStats{ignoredGCDueToCheckPoint=" + this.ignoredGCDueToCheckPoint + ", fullGCDryRunMode=" + this.fullGCDryRunMode + ", ignoredFullGCDueToCheckPoint=" + this.ignoredFullGCDueToCheckPoint + ", canceled=" + this.canceled + ", deletedDocGCCount=" + this.deletedDocGCCount + " (of which leaf: " + this.deletedLeafDocGCCount + "), updateResurrectedGCCount=" + this.updateResurrectedGCCount + ", splitDocGCCount=" + this.splitDocGCCount + ", intermediateSplitDocGCCount=" + this.intermediateSplitDocGCCount + ", oldestModifiedDocId=" + this.oldestModifiedDocId + ", oldestModifiedDocTimeStamp=" + Utils.timestampToString(this.oldestModifiedDocTimeStamp) + ", updatedFullGCDocsCount=" + this.updatedFullGCDocsCount + ", skippedFullGCDocsCount=" + this.skippedFullGCDocsCount + ", deletedPropsCount=" + this.deletedPropsCount + ", deletedInternalPropsCount=" + this.deletedInternalPropsCount + ", deletedPropRevsCount=" + this.deletedPropRevsCount + ", deletedInternalPropRevsCount=" + this.deletedInternalPropRevsCount + ", deletedUnmergedBCCount=" + this.deletedUnmergedBCCount + ", deletedOrphanNodesCount=" + this.deletedOrphanNodesCount + ", iterationCount=" + this.iterationCount + ", timeFullGCActive=" + this.df.format(this.fullGCActiveElapsed, TimeUnit.MICROSECONDS) + ", timeActive=" + this.df.format(this.activeElapsed, TimeUnit.MICROSECONDS) + ", " + timings + "}";
        }

        void addRun(VersionGCStats run) {
            ++this.iterationCount;
            this.ignoredGCDueToCheckPoint = run.ignoredGCDueToCheckPoint;
            this.fullGCDryRunMode = run.fullGCDryRunMode;
            this.ignoredFullGCDueToCheckPoint = run.ignoredFullGCDueToCheckPoint;
            this.canceled = run.canceled;
            this.success = run.success;
            this.limitExceeded = run.limitExceeded;
            this.needRepeat = run.needRepeat;
            this.deletedDocGCCount += run.deletedDocGCCount;
            this.deletedLeafDocGCCount += run.deletedLeafDocGCCount;
            this.splitDocGCCount += run.splitDocGCCount;
            this.intermediateSplitDocGCCount += run.intermediateSplitDocGCCount;
            this.updateResurrectedGCCount += run.updateResurrectedGCCount;
            this.oldestModifiedDocTimeStamp = run.oldestModifiedDocTimeStamp;
            this.oldestModifiedDocId = run.oldestModifiedDocId;
            this.updatedFullGCDocsCount += run.updatedFullGCDocsCount;
            this.skippedFullGCDocsCount += run.skippedFullGCDocsCount;
            this.deletedPropsCount += run.deletedPropsCount;
            this.deletedInternalPropsCount += run.deletedInternalPropsCount;
            this.deletedPropRevsCount += run.deletedPropRevsCount;
            this.deletedInternalPropRevsCount += run.deletedInternalPropRevsCount;
            this.deletedUnmergedBCCount += run.deletedUnmergedBCCount;
            this.deletedOrphanNodesCount += run.deletedOrphanNodesCount;
            if (run.iterationCount > 0) {
                this.activeElapsed += run.activeElapsed;
                this.fullGCActiveElapsed += run.fullGCActiveElapsed;
                this.collectDeletedDocsElapsed += run.collectDeletedDocsElapsed;
                this.checkDeletedDocsElapsed += run.checkDeletedDocsElapsed;
                this.deleteDeletedDocsElapsed += run.deleteDeletedDocsElapsed;
                this.collectAndDeleteSplitDocsElapsed += run.collectAndDeleteSplitDocsElapsed;
                this.deleteSplitDocsElapsed += run.deleteSplitDocsElapsed;
                this.sortDocIdsElapsed += run.sortDocIdsElapsed;
                this.updateResurrectedDocumentsElapsed += run.updateResurrectedDocumentsElapsed;
                this.fullGCDocsElapsed += run.fullGCDocsElapsed;
                this.deleteFullGCDocsElapsed += run.deleteFullGCDocsElapsed;
                this.collectFullGCElapsed += run.collectFullGCElapsed;
                this.collectOrphanNodesElapsed += run.collectOrphanNodesElapsed;
                this.collectDeletedPropsElapsed += run.collectDeletedPropsElapsed;
                this.collectDeletedOldRevsElapsed += run.collectDeletedOldRevsElapsed;
                this.collectUnmergedBCElapsed += run.collectUnmergedBCElapsed;
            } else {
                this.activeElapsed += run.active.elapsed(TimeUnit.MICROSECONDS);
                this.fullGCActiveElapsed += run.fullGCActive.elapsed(TimeUnit.MICROSECONDS);
                this.collectDeletedDocsElapsed += run.collectDeletedDocs.elapsed(TimeUnit.MICROSECONDS);
                this.checkDeletedDocsElapsed += run.checkDeletedDocs.elapsed(TimeUnit.MICROSECONDS);
                this.deleteDeletedDocsElapsed += run.deleteDeletedDocs.elapsed(TimeUnit.MICROSECONDS);
                this.collectAndDeleteSplitDocsElapsed += run.collectAndDeleteSplitDocs.elapsed(TimeUnit.MICROSECONDS);
                this.deleteSplitDocsElapsed += run.deleteSplitDocs.elapsed(TimeUnit.MICROSECONDS);
                this.sortDocIdsElapsed += run.sortDocIds.elapsed(TimeUnit.MICROSECONDS);
                this.updateResurrectedDocumentsElapsed += run.updateResurrectedDocuments.elapsed(TimeUnit.MICROSECONDS);
                this.fullGCDocsElapsed += run.fullGCDocs.elapsed(TimeUnit.MICROSECONDS);
                this.deleteFullGCDocsElapsed += run.deleteFullGCDocs.elapsed(TimeUnit.MICROSECONDS);
                this.collectFullGCElapsed += run.collectFullGC.elapsed(TimeUnit.MICROSECONDS);
                this.collectOrphanNodesElapsed += run.collectOrphanNodes.elapsed(TimeUnit.MICROSECONDS);
                this.collectDeletedPropsElapsed += run.collectDeletedProps.elapsed(TimeUnit.MICROSECONDS);
                this.collectDeletedOldRevsElapsed += run.collectDeletedOldRevs.elapsed(TimeUnit.MICROSECONDS);
                this.collectUnmergedBCElapsed += run.collectUnmergedBC.elapsed(TimeUnit.MICROSECONDS);
            }
        }
    }

    public static class VersionGCInfo {
        public final long lastSuccess;
        public final long oldestRevisionEstimate;
        public final long revisionsCandidateCount;
        public final long collectLimit;
        public final long recommendedCleanupInterval;
        public final long recommendedCleanupTimestamp;
        public final int estimatedIterations;
        public final long oldestFullGCRevisionEstimate;

        VersionGCInfo(long lastSuccess, long oldestRevisionEstimate, long revisionsCandidateCount, long collectLimit, long recommendedCleanupInterval, long recommendedCleanupTimestamp, int estimatedIterations, long oldestFullGCRevisionEstimate) {
            this.lastSuccess = lastSuccess;
            this.oldestRevisionEstimate = oldestRevisionEstimate;
            this.revisionsCandidateCount = revisionsCandidateCount;
            this.collectLimit = collectLimit;
            this.recommendedCleanupInterval = recommendedCleanupInterval;
            this.recommendedCleanupTimestamp = recommendedCleanupTimestamp;
            this.estimatedIterations = estimatedIterations;
            this.oldestFullGCRevisionEstimate = oldestFullGCRevisionEstimate;
        }
    }

    static enum FullGCMode {
        NONE,
        GAP_ORPHANS,
        GAP_ORPHANS_EMPTYPROPS,
        ALL_ORPHANS_EMPTYPROPS,
        ORPHANS_EMPTYPROPS_KEEP_ONE_USER_PROPS,
        ORPHANS_EMPTYPROPS_KEEP_ONE_ALL_PROPS,
        ORPHANS_EMPTYPROPS_UNMERGED_BC,
        ORPHANS_EMPTYPROPS_BETWEEN_CHECKPOINTS_NO_UNMERGED_BC,
        ORPHANS_EMPTYPROPS_BETWEEN_CHECKPOINTS_WITH_UNMERGED_BC;

    }
}

