/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@ObjectClassDefinition(pid={"org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreService"}, name="Apache Jackrabbit Oak Document NodeStore Service", description="NodeStore implementation based on Document model. For configuration option refer to http://jackrabbit.apache.org/oak/docs/osgi_config.html#DocumentNodeStore. Note that for system stability purpose it is advisable to not change these settings at runtime. Instead the config change should be done via file system based config file and this view should ONLY be used to determine which options are supported")
@interface Configuration {
    public static final String PID = "org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreService";
    public static final String PRESET_PID = "org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreServicePreset";

    @AttributeDefinition(name="Mongo URI", description="Mongo connection URI used to connect to Mongo. Refer to http://docs.mongodb.org/manual/reference/connection-string/ for details. Note that this value can be overridden via framework property 'oak.mongo.uri'")
    public String mongouri() default "mongodb://localhost:27017/oak";

    @AttributeDefinition(name="Mongo DB name", description="Name of the database in Mongo. Note that this value can be overridden via framework property 'oak.mongo.db'")
    public String db() default "oak";

    @AttributeDefinition(name="MongoDB socket keep-alive option", description="Whether socket keep-alive should be enabled for connections to MongoDB. Note that this value can be overridden via framework property 'oak.mongo.socketKeepAlive'")
    public boolean socketKeepAlive() default true;

    @AttributeDefinition(name="MongoDB socket timeout for lease update operations", description="Socket timeout for lease update operations in milliseconds. Note that this value can be overridden via framework property 'oak.mongo.leaseSocketTimeout'")
    public int mongoLeaseSocketTimeout() default 30000;

    @AttributeDefinition(name="Cache Size (in MB)", description="Cache size in MB. This is distributed among various caches used in DocumentNodeStore")
    public int cache() default 256;

    @AttributeDefinition(name="NodeState Cache", description="Percentage of cache to be allocated towards Node cache")
    public int nodeCachePercentage() default 34;

    @AttributeDefinition(name="PreviousDocument Cache", description="Percentage of cache to be allocated towards Previous Document cache")
    public int prevDocCachePercentage() default 4;

    @AttributeDefinition(name="NodeState Children Cache", description="Percentage of cache to be allocated towards Children cache")
    public int childrenCachePercentage() default 15;

    @AttributeDefinition(name="Diff Cache", description="Percentage of cache to be allocated towards Diff cache")
    public int diffCachePercentage() default 30;

    @AttributeDefinition(name="PrevNoProp Cache", description="Percentage of cache to be allocated towards PrevNoProp cache. This cache is used to keep non existence of properties in previous documents and can be small.")
    public int prevNoPropCachePercentage() default 4;

    @AttributeDefinition(name="LIRS Cache Segment Count", description="The number of segments in the LIRS cache (default 16, a higher count means higher concurrency but slightly lower cache hit rate)")
    public int cacheSegmentCount() default 16;

    @AttributeDefinition(name="LIRS Cache Stack Move Distance", description="The delay to move entries to the head of the queue in the LIRS cache (default 16, a higher value means higher concurrency but slightly lower cache hit rate)")
    public int cacheStackMoveDistance() default 16;

    @AttributeDefinition(name="Blob Cache Size (in MB)", description="Cache size to store blobs in memory. Used only with default BlobStore (as per DocumentStore type)")
    public int blobCacheSize() default 16;

    @AttributeDefinition(name="Persistent Cache Config", description="Configuration for persistent cache. Refer to http://jackrabbit.apache.org/oak/docs/nodestore/persistent-cache.html for various options")
    public String persistentCache() default "cache";

    @AttributeDefinition(name="Journal Cache Config", description="Configuration for journal cache. Refer to http://jackrabbit.apache.org/oak/docs/nodestore/persistent-cache.html for various options")
    public String journalCache() default "diff-cache";

    @AttributeDefinition(name="Custom BlobStore", description="Boolean value indicating that a custom BlobStore is to be used. By default, for MongoDB, MongoBlobStore is used; for RDB, RDBBlobStore is used.")
    public boolean customBlobStore() default false;

    @AttributeDefinition(name="Journal Garbage Collection Interval (millis)", description="Long value indicating interval (in milliseconds) with which the journal (for external changes) is cleaned up. Default is 300000")
    public long journalGCInterval() default 300000L;

    @AttributeDefinition(name="Maximum Age of Journal Entries (millis)", description="Long value indicating max age (in milliseconds) that journal (for external changes) entries are kept (older ones are candidates for gc). Default is 86400000")
    public long journalGCMaxAge() default 86400000L;

    @AttributeDefinition(name="Pre-fetch external changes", description="Boolean value indicating if external changes should be pre-fetched in a background thread.")
    public boolean prefetchExternalChanges() default false;

    @AttributeDefinition(name="NodeStoreProvider role", description="Property indicating that this component will not register as a NodeStore but as a NodeStoreProvider with given role")
    public String role();

    @AttributeDefinition(name="Version GC Max Age (in secs)", description="Version Garbage Collector (GC) logic will only consider those deleted for GC which are not accessed recently (currentTime - lastModifiedTime > versionGcMaxAgeInSecs). For example as per default only those document which have been *marked* deleted 24 hrs ago will be considered for GC. This also applies how older revision of live document are GC.")
    public long versionGcMaxAgeInSecs() default 86400L;

    @AttributeDefinition(name="Version GC scheduler expression", description="A cron expression that defines when the Version GC is scheduled. If this configuration entry is left empty, the default behaviour is to schedule a run every five seconds (also known as Continuous Revision Garbage Collection). Otherwise, the schedule can be configured with a cron expression. E.g. the following expression triggers a GC run every night at 2 AM: '0 0 2 * * ?'.")
    public String versionGCExpression() default "";

    @AttributeDefinition(name="Time limit for a Version GC run (in sec)", description="A Version GC run is canceled after this number of seconds. The default value is 10800 seconds.")
    public long versionGCTimeLimitInSecs() default 10800L;

    @AttributeDefinition(name="Delay factor for a Version GC run", description="A Version GC run has a gap of this delay factor to reduce continuous load on systemThe default value is 0.0")
    public double versionGCDelayFactor() default 0.0;

    @AttributeDefinition(name="Blob GC Max Age (in secs)", description="Blob Garbage Collector (GC) logic will only consider those blobs for GC which are not accessed recently (currentTime - lastModifiedTime > blobGcMaxAgeInSecs). For example as per default only those blobs which have been created 24 hrs ago will be considered for GC")
    public long blobGcMaxAgeInSecs() default 86400L;

    @AttributeDefinition(name="Blob tracking snapshot interval (in secs)", description="This is the default interval in which the snapshots of locally tracked blob ids willbe taken and synchronized with the blob store. This should be configured to be less than the frequency of blob GC so that deletions during blob GC can be accounted for in the next GC execution.")
    public long blobTrackSnapshotIntervalInSecs() default 43200L;

    @AttributeDefinition(name="Root directory", description="Root directory for local tracking of blob ids. This service will first lookup the 'repository.home' framework property and then a component context property with the same name. If none of them is defined, a sub directory 'repository' relative to the current working directory is used.")
    public String repository_home();

    @AttributeDefinition(name="Max Replication Lag (in secs)", description="Value in seconds. Determines the duration beyond which it can be safely assumed that the state on the secondaries is consistent with the primary, and it is safe to read from them")
    public long maxReplicationLagInSecs() default 21600L;

    @AttributeDefinition(name="DocumentStore Type", description="Type of DocumentStore to use for persistence. Defaults to MONGO", options={@Option(label="MONGO", value="MONGO"), @Option(label="RDB", value="RDB")})
    public String documentStoreType() default "MONGO";

    @AttributeDefinition(name="Bundling Disabled", description="Boolean value indicating that Node bundling is disabled")
    public boolean bundlingDisabled() default false;

    @AttributeDefinition(name="DocumentNodeStore update.limit", description="Number of content updates that need to happen before the updates are automatically purged to the private branch.")
    public int updateLimit() default 100000;

    @AttributeDefinition(name="Persistent Cache Includes", description="Paths which should be cached in persistent cache. This value can be overridden with a system property 'oak.documentstore.persistentCacheIncludes' where paths are separated with '::'. Example: -Doak.documentstore.persistentCacheIncludes=/content::/var")
    public String[] persistentCacheIncludes() default {"/"};

    @AttributeDefinition(name="Full GC Include Paths", description="Paths which should be included in full garbage collection. Include and exclude paths can overlap. Exclude paths will take precedence. Note that this value can be overridden with a system property 'oak.documentstore.fullGCIncludePaths' where paths are separated with '::'. Example: -Doak.documentstore.fullGCIncludePaths=/content::/var")
    public String[] fullGCIncludePaths() default {"/"};

    @AttributeDefinition(name="Full GC Exclude Paths", description="Paths which should be excluded from full Garbage collection. Include and exclude paths can overlap. Exclude paths will take precedence. Note that this value can be overridden with a system property 'oak.documentstore.fullGCExcludePaths' where paths are separated with '::'. Example: -Doak.documentstore.fullGCExcludePaths=/content::/var")
    public String[] fullGCExcludePaths() default {};

    @AttributeDefinition(name="Lease check mode", description="The lease check mode. 'STRICT' is the default and will stop the DocumentNodeStore as soon as the lease expires. 'LENIENT' will give the background lease update a chance to renew the lease even when the lease expired. This mode is only recommended for development, e.g. when debugging an application and the lease may expire when the JVM is stopped at a breakpoint.", options={@Option(label="STRICT", value="STRICT"), @Option(label="LENIENT", value="LENIENT")})
    public String leaseCheckMode() default "STRICT";

    @AttributeDefinition(name="Document Node Store throttling", description="Boolean value indicating whether throttling should be enabled for document node store or not. The Default value is false. Note that this value can be overridden via framework property 'oak.documentstore.throttlingEnabled'")
    public boolean throttlingEnabled() default false;

    @AttributeDefinition(name="Document Node Store Compression", description="Select compressor type for collections. 'Snappy' is the default supported compression.")
    public String collectionCompressionType() default "snappy";

    @AttributeDefinition(name="Commit Suspend timeout", description="Timeout for a suspended commit after it conflicted witha change that is not yet visible. Default: 60000 (milliseconds).")
    public long suspendTimeoutMillis() default 60000L;

    @AttributeDefinition(name="Recovery delay", description="Delay (in milliseconds) before a recovery is done, 0 or negative for no delay. Default: 0 (milliseconds).")
    public long recoveryDelayMillis() default 0L;

    @AttributeDefinition(name="Perflogger Info Millis", description="Minimum duration (in milliseconds) for certain operations that perflogger info will log.  Default: 9223372036854775807 (milliseconds).")
    public long perfLoggerInfoMillis() default 0x7FFFFFFFFFFFFFFFL;

    @AttributeDefinition(name="ClusterId reuse delay after recovery", description="Minimal delay (in milliseconds) before a clusterId can be reused after a recovery, 0 or negative for no delay. Default: 0 (milliseconds).")
    public long clusterIdReuseDelayAfterRecoveryMillis() default 0L;

    @AttributeDefinition(name="Document Node Store Full GC", description="Boolean value indicating whether Full GC should be enabled for document node store or not. The Default value is false. Note that this value can be overridden via framework property 'oak.documentstore.fullGCEnabled'")
    public boolean fullGCEnabled() default false;

    @AttributeDefinition(name="Document Node Store Embedded Verification for Full GC", description="Boolean value indicating whether Embedded Verification (i.e. verify the document after applying changes in memory before any database calls) for Full GC should be enabled for document node store or not. The Default value is true. Note that this value can be overridden via framework property 'oak.documentstore.embeddedVerificationEnabled'")
    public boolean embeddedVerificationEnabled() default true;

    @AttributeDefinition(name="Document Node Store Full GC Mode", description="Integer value indicating which Full GC mode should be enabled for document node store. The Default value is 0. Note that this value can be overridden via framework property 'oak.documentstore.fullGCMode'. FullGC can be entirely enabled / disabled with the variable fullGCEnabled, unless fullGCEnabled is set to true, the fullGCMode will be ignored.")
    public int fullGCMode() default 0;

    @AttributeDefinition(name="Delay factor for a Full GC run", description="A Full GC run has a gap of this delay factor to reduce continuous load on system.It allows the FullGC thread to stop by (fullGC batch run time * delayFactor) period after each batch.The default value is 2.0")
    public double fullGCDelayFactor() default 2.0;

    @AttributeDefinition(name="Batch Size to fetch data for each FullGC cycle", description="Integer value indicating the number of documents to fetch from database in a single query to check for Full GC.It should be a factor of fullGCProgressSize for better performance The default value is 1000")
    public int fullGCBatchSize() default 1000;

    @AttributeDefinition(name="Progress Size for FullGC cycle", description="Integer value indicating the number of documents to check for garbage in each Full GC cycle.The default value is 10000")
    public int fullGCProgressSize() default 10000;
}

