/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.oak.plugins.document.Checkpoints;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.VersionGCOptions;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.util.TimeInterval;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionGCRecommendations {
    private static final Logger log = LoggerFactory.getLogger(VersionGCRecommendations.class);
    private static final long IGNORED_GC_WARNING_INTERVAL_MS = TimeUnit.MINUTES.toMillis(5L);
    private static long lastIgnoreWarning = 0L;
    private final VersionGCSupport vgc;
    private final GCMonitor gcmon;
    final boolean ignoreDueToCheckPoint;
    final boolean ignoreFullGCDueToCheckPoint;
    final TimeInterval scope;
    final TimeInterval scopeFullGC;
    final long maxCollect;
    final long deleteCandidateCount;
    final long lastOldestTimestamp;
    final String fullGCId;
    final long originalCollectLimit;
    private final long precisionMs;
    final long suggestedIntervalMs;
    private final boolean scopeIsComplete;
    private final boolean fullGCScopeIsComplete;
    private final boolean fullGCEnabled;
    private final boolean isFullGCDryRun;

    VersionGCRecommendations(long maxRevisionAgeMs, Checkpoints checkpoints, boolean checkpointCleanup, Clock clock, VersionGCSupport vgc, VersionGCOptions options, GCMonitor gcMonitor, boolean fullGCEnabled, boolean isFullGCDryRun) {
        long oldestPossible;
        long deletedOnceCount = 0L;
        AtomicLong oldestModifiedDocTimeStamp = new AtomicLong();
        AtomicLong oldestModifiedDryRunDocTimeStamp = new AtomicLong();
        long collectLimit = options.collectLimit;
        this.vgc = vgc;
        this.gcmon = gcMonitor;
        this.originalCollectLimit = options.collectLimit;
        this.fullGCEnabled = fullGCEnabled;
        this.isFullGCDryRun = isFullGCDryRun;
        TimeInterval keep = new TimeInterval(clock.getTime() - maxRevisionAgeMs, Long.MAX_VALUE);
        Map<String, Object> settings = this.getVGCSettings();
        this.lastOldestTimestamp = (Long)settings.get("lastOldestTimeStamp");
        if (this.lastOldestTimestamp == 0L) {
            log.info("No lastOldestTimestamp found, querying for the oldest deletedOnce candidate");
            oldestPossible = vgc.getOldestDeletedOnceTimestamp(clock, options.precisionMs) - 1L;
            log.info("lastOldestTimestamp found: {}", (Object)Utils.timestampToString(oldestPossible));
        } else {
            oldestPossible = this.lastOldestTimestamp - 1L;
        }
        TimeInterval scope = new TimeInterval(oldestPossible, Long.MAX_VALUE);
        scope = scope.notLaterThan(keep.fromMs);
        long fullGCTimestamp = (Long)settings.get("fullGCTimeStamp");
        String oldestModifiedDocId = (String)settings.get("fullGCId");
        long fullGCDryRunTimestamp = (Long)settings.get("fullGCDryRunTimeStamp");
        String oldestModifiedDryRunDocId = (String)settings.get("fullGCDryRunId");
        if (log.isDebugEnabled()) {
            if (isFullGCDryRun) {
                log.debug("lastOldestTimestamp: {}, fullGCDryRunTimestamp: {}, oldestModifiedDryRunDocId: {}", new Object[]{Utils.timestampToString(this.lastOldestTimestamp), Utils.timestampToString(fullGCDryRunTimestamp), oldestModifiedDryRunDocId});
            } else {
                log.debug("lastOldestTimestamp: {}, fullGCTimestamp: {}, oldestModifiedDocId: {}", new Object[]{Utils.timestampToString(this.lastOldestTimestamp), Utils.timestampToString(fullGCTimestamp), oldestModifiedDocId});
            }
        }
        if (fullGCEnabled && isFullGCDryRun) {
            if (fullGCDryRunTimestamp == 0L) {
                log.info("No fullGCDryRunTimestamp found, querying for the oldest modified candidate");
                vgc.getOldestModifiedDoc(clock).ifPresentOrElse(d -> oldestModifiedDryRunDocTimeStamp.set(TimeUnit.SECONDS.toMillis(Optional.ofNullable(d.getModified()).orElse(0L))), () -> oldestModifiedDryRunDocTimeStamp.set(0L));
                oldestModifiedDryRunDocId = "0000000";
                log.info("fullGCDryRunTimestamp found: {}", (Object)Utils.timestampToString(oldestModifiedDryRunDocTimeStamp.get()));
            } else {
                oldestModifiedDryRunDocTimeStamp.set(fullGCDryRunTimestamp);
            }
        } else if (fullGCEnabled) {
            if (fullGCTimestamp == 0L) {
                log.info("No fullGCTimestamp found, querying for the oldest modified candidate");
                vgc.getOldestModifiedDoc(clock).ifPresentOrElse(d -> oldestModifiedDocTimeStamp.set(TimeUnit.SECONDS.toMillis(Optional.ofNullable(d.getModified()).orElse(0L))), () -> oldestModifiedDocTimeStamp.set(0L));
                oldestModifiedDocId = "0000000";
                log.info("fullGCTimestamp found: {}", (Object)Utils.timestampToString(oldestModifiedDocTimeStamp.get()));
                this.setVGCSetting(Map.of("fullGCTimeStamp", oldestModifiedDocTimeStamp.get(), "fullGCId", oldestModifiedDocId));
            } else {
                oldestModifiedDocTimeStamp.set(fullGCTimestamp);
            }
        }
        TimeInterval scopeFullGC = new TimeInterval(isFullGCDryRun ? oldestModifiedDryRunDocTimeStamp.get() : oldestModifiedDocTimeStamp.get(), Long.MAX_VALUE);
        scopeFullGC = scopeFullGC.notLaterThan(keep.fromMs);
        long suggestedIntervalMs = (Long)settings.get("recommendedIntervalMs");
        if (suggestedIntervalMs > 0L) {
            if ((suggestedIntervalMs = Math.max(suggestedIntervalMs, options.precisionMs)) < scope.getDurationMs()) {
                scope = scope.startAndDuration(suggestedIntervalMs);
                log.debug("previous runs recommend a {} sec duration, scope now {}", (Object)TimeUnit.MILLISECONDS.toSeconds(suggestedIntervalMs), (Object)scope);
            }
        } else if (scope.getDurationMs() <= options.precisionMs) {
            log.debug("scope <= precision ({} ms)", (Object)options.precisionMs);
        } else {
            try {
                long preferredLimit = Math.min(collectLimit, (long)Math.ceil((double)options.overflowToDiskThreshold * 0.95));
                deletedOnceCount = vgc.getDeletedOnceCount();
                if (deletedOnceCount > preferredLimit) {
                    double chunks = (double)deletedOnceCount / (double)preferredLimit;
                    suggestedIntervalMs = (long)Math.floor((double)(scope.getDurationMs() + maxRevisionAgeMs) / chunks);
                    if (suggestedIntervalMs < scope.getDurationMs()) {
                        scope = scope.startAndDuration(suggestedIntervalMs);
                        log.debug("deletedOnce candidates: {} found, {} preferred, scope now {}", new Object[]{deletedOnceCount, preferredLimit, scope});
                    }
                }
            }
            catch (UnsupportedOperationException ex) {
                log.debug("check on upper bounds of delete candidates not supported, skipped");
            }
        }
        Revision checkpoint = checkpoints.getOldestRevisionToKeep(checkpointCleanup);
        GCResult gcResult = VersionGCRecommendations.getResult(options, checkpoint, clock, GcType.RGC, scope);
        scope = gcResult.gcScope;
        boolean ignoreDueToCheckPoint = gcResult.ignoreGC;
        GCResult fullGCResult = VersionGCRecommendations.getResult(options, checkpoint, clock, GcType.FGC, scopeFullGC);
        scopeFullGC = fullGCResult.gcScope;
        boolean ignoreFullGCDueToCheckPoint = fullGCResult.ignoreGC;
        if (scope.getDurationMs() <= options.precisionMs) {
            collectLimit = 0L;
            log.debug("time interval <= precision ({} ms), disabling collection limits", (Object)options.precisionMs);
        }
        this.precisionMs = options.precisionMs;
        this.ignoreDueToCheckPoint = ignoreDueToCheckPoint;
        this.scope = scope;
        this.ignoreFullGCDueToCheckPoint = ignoreFullGCDueToCheckPoint;
        this.scopeFullGC = scopeFullGC;
        this.fullGCId = isFullGCDryRun ? oldestModifiedDryRunDocId : oldestModifiedDocId;
        this.scopeIsComplete = scope.toMs >= keep.fromMs;
        this.fullGCScopeIsComplete = scopeFullGC.toMs >= keep.fromMs;
        this.maxCollect = collectLimit;
        this.suggestedIntervalMs = suggestedIntervalMs;
        this.deleteCandidateCount = deletedOnceCount;
    }

    public void evaluate(VersionGarbageCollector.VersionGCStats stats) {
        if (stats.limitExceeded && !this.isFullGCDryRun) {
            long nextDuration = Math.max(this.precisionMs, this.scope.getDurationMs() / 2L);
            this.gcmon.info("Limit {} documents exceeded, reducing next collection interval to {} seconds", new Object[]{this.maxCollect, TimeUnit.MILLISECONDS.toSeconds(nextDuration)});
            this.setVGCSetting("recommendedIntervalMs", nextDuration);
            stats.needRepeat = true;
        } else if (!(stats.canceled || stats.ignoredGCDueToCheckPoint || this.isFullGCDryRun)) {
            this.setVGCSetting("lastOldestTimeStamp", this.scope.toMs);
            HashMap<String, Object> updateVGCMap = new HashMap<String, Object>();
            updateVGCMap.put("fullGCTimeStamp", stats.oldestModifiedDocTimeStamp);
            updateVGCMap.put("fullGCId", stats.oldestModifiedDocId);
            this.updateVGCSetting(updateVGCMap);
            int count = stats.deletedDocGCCount - stats.deletedLeafDocGCCount;
            double allowedFraction = 0.66;
            double usedFraction = this.maxCollect <= 0L ? (double)count / (double)this.originalCollectLimit : (double)count / (double)this.maxCollect;
            if (this.scope.getDurationMs() == this.suggestedIntervalMs) {
                if (usedFraction < allowedFraction) {
                    long nextDuration = (long)Math.ceil((double)this.suggestedIntervalMs * 1.5);
                    log.debug("successful run using {}% of limit, raising recommended interval to {} seconds", (Object)((double)Math.round(usedFraction * 1000.0) / 10.0), (Object)TimeUnit.MILLISECONDS.toSeconds(nextDuration));
                    this.setVGCSetting("recommendedIntervalMs", nextDuration);
                } else {
                    log.debug("not increasing limit: collected {} documents ({}% >= {}% limit)", new Object[]{count, usedFraction, allowedFraction});
                }
            } else {
                log.debug("successful run not following recommendations, keeping them");
            }
            boolean bl = stats.needRepeat = !this.scopeIsComplete;
        }
        if (this.fullGCEnabled && !stats.canceled && !stats.ignoredFullGCDueToCheckPoint) {
            if (this.isFullGCDryRun) {
                this.setVGCSetting(Map.of("fullGCDryRunTimeStamp", stats.oldestModifiedDocTimeStamp, "fullGCDryRunId", stats.oldestModifiedDocId));
            } else {
                this.updateVGCSetting(Map.of("fullGCTimeStamp", stats.oldestModifiedDocTimeStamp, "fullGCId", stats.oldestModifiedDocId));
            }
            long scopeEnd = this.scopeFullGC.toMs;
            long actualEnd = stats.oldestModifiedDocTimeStamp;
            stats.needRepeat = actualEnd < scopeEnd ? true : stats.needRepeat | !this.fullGCScopeIsComplete;
        }
    }

    private Map<String, Object> getVGCSettings() {
        Document versionGCDoc = this.vgc.getDocumentStore().find(Collection.SETTINGS, "versionGC", 0);
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("lastOldestTimeStamp", 0L);
        settings.put("recommendedIntervalMs", 0L);
        settings.put("fullGCTimeStamp", 0L);
        settings.put("fullGCId", "0000000");
        settings.put("fullGCDryRunTimeStamp", 0L);
        settings.put("fullGCDryRunId", "0000000");
        if (versionGCDoc != null) {
            for (String k : versionGCDoc.keySet()) {
                Object value = versionGCDoc.get(k);
                if (value instanceof Number) {
                    settings.put(k, ((Number)value).longValue());
                }
                if (!(value instanceof String)) continue;
                settings.put(k, value);
            }
        }
        return settings;
    }

    private void setVGCSetting(String propName, Object val) {
        HashMap<String, Object> vgcMap = new HashMap<String, Object>();
        vgcMap.put(propName, val);
        this.setVGCSetting(vgcMap);
    }

    private void setVGCSetting(Map<String, Object> propValMap) {
        UpdateOp updateOp = new UpdateOp("versionGC", true);
        this.setUpdateOp(propValMap, updateOp);
        this.vgc.getDocumentStore().createOrUpdate(Collection.SETTINGS, updateOp);
    }

    private void setUpdateOp(Map<String, Object> propValMap, UpdateOp updateOp) {
        propValMap.forEach((k, v) -> {
            if (v instanceof Number) {
                updateOp.set((String)k, ((Number)v).longValue());
            }
            if (v instanceof String) {
                updateOp.set((String)k, (String)v);
            }
            if (v instanceof Boolean) {
                updateOp.set((String)k, (Boolean)v);
            }
        });
    }

    private void updateVGCSetting(Map<String, Object> propValMap) {
        UpdateOp updateOp = new UpdateOp("versionGC", false);
        this.setUpdateOp(propValMap, updateOp);
        propValMap.forEach((k, v) -> updateOp.contains((String)k, true));
        this.vgc.getDocumentStore().findAndUpdate(Collection.SETTINGS, updateOp);
    }

    @NotNull
    private static GCResult getResult(VersionGCOptions options, Revision checkpoint, Clock clock, GcType gcType, TimeInterval gcScope) {
        boolean ignoreGC = false;
        if (checkpoint != null && gcScope.endsAfter(checkpoint.getTimestamp())) {
            TimeInterval minimalScope = gcScope.startAndDuration(options.precisionMs);
            if (minimalScope.endsAfter(checkpoint.getTimestamp())) {
                long now = clock.getTime();
                if (now - lastIgnoreWarning > IGNORED_GC_WARNING_INTERVAL_MS) {
                    log.warn("Ignoring [{}] run because a valid checkpoint [{}] exists inside minimal scope {}.", new Object[]{gcType, checkpoint.toReadableString(), minimalScope});
                    lastIgnoreWarning = now;
                }
                ignoreGC = true;
            } else {
                gcScope = gcScope.notLaterThan(checkpoint.getTimestamp() - 1L);
                log.debug("checkpoint at [{}] found, [{}] Scope now {}", new Object[]{Utils.timestampToString(checkpoint.getTimestamp()), gcType, gcScope});
            }
        }
        return new GCResult(ignoreGC, gcScope);
    }

    static enum GcType {
        RGC("Revision GC"),
        FGC("Full GC");

        private final String name;

        private GcType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class GCResult {
        public final boolean ignoreGC;
        public final TimeInterval gcScope;

        public GCResult(boolean ignoreGC, TimeInterval gcScope) {
            this.ignoreGC = ignoreGC;
            this.gcScope = gcScope;
        }
    }
}

