/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.SplitDocumentCleanUp;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionGCSupport {
    private static final Logger LOG = LoggerFactory.getLogger(VersionGCSupport.class);
    private final DocumentStore store;

    public VersionGCSupport(DocumentStore store) {
        this.store = store;
    }

    public Iterable<NodeDocument> getPossiblyDeletedDocs(long fromModified, long toModified) {
        return StreamSupport.stream(Utils.getSelectedDocuments(this.store, "_deletedOnce", 1L).spliterator(), false).filter(input -> input.wasDeletedOnce() && this.modifiedGreaterThanEquals((NodeDocument)input, fromModified) && this.modifiedLessThan((NodeDocument)input, toModified)).collect(Collectors.toList());
    }

    public Iterable<NodeDocument> getModifiedDocs(long fromModified, long toModified, int limit, @NotNull String fromId, @NotNull Set<String> includePaths, @NotNull Set<String> excludePaths) {
        long fromModifiedQuery = "0000000".equals(fromId) ? NodeDocument.getModifiedInSecs(fromModified) : TimeUnit.MILLISECONDS.toSeconds(fromModified);
        Stream<NodeDocument> s1 = StreamSupport.stream(Utils.getSelectedDocuments(this.store, "_modified", 1L, fromId, includePaths, excludePaths).spliterator(), false).filter(input -> this.modifiedEqualsToExactTime((NodeDocument)input, fromModifiedQuery));
        Stream<NodeDocument> s2 = StreamSupport.stream(Utils.getSelectedDocuments(this.store, "_modified", 1L, includePaths, excludePaths).spliterator(), false).filter(input -> this.modifiedGreaterThanExactTime((NodeDocument)input, fromModifiedQuery) && this.modifiedLessThan((NodeDocument)input, toModified));
        return Stream.concat(s1, s2).sorted((o1, o2) -> Comparator.comparing(NodeDocument::getModified).thenComparing(Document::getId).compare((NodeDocument)o1, (NodeDocument)o2)).limit(limit).collect(Collectors.toList());
    }

    private boolean modifiedGreaterThanEquals(NodeDocument doc, long time) {
        Long modified = doc.getModified();
        return modified != null && modified.compareTo(NodeDocument.getModifiedInSecs(time)) >= 0;
    }

    private boolean modifiedGreaterThanExactTime(NodeDocument doc, long time) {
        Long modified = doc.getModified();
        return modified != null && modified.compareTo(time) > 0;
    }

    private boolean modifiedEqualsToExactTime(NodeDocument doc, long time) {
        Long modified = doc.getModified();
        return modified != null && modified.compareTo(time) == 0;
    }

    private boolean modifiedLessThan(NodeDocument doc, long time) {
        Long modified = doc.getModified();
        return modified != null && modified.compareTo(NodeDocument.getModifiedInSecs(time)) < 0;
    }

    private boolean idEquals(NodeDocument doc, String id) {
        return Objects.equals(doc.getId(), id);
    }

    @NotNull
    public DocumentStore getDocumentStore() {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSplitDocuments(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
        SplitDocumentCleanUp cu = this.createCleanUp(gcTypes, sweepRevs, oldestRevTimeStamp, stats);
        try {
            stats.splitDocGCCount += cu.disconnect().deleteSplitDocuments();
        }
        finally {
            Utils.closeIfCloseable(cu);
        }
    }

    protected SplitDocumentCleanUp createCleanUp(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
        return new SplitDocumentCleanUp(this.store, stats, this.identifyGarbage(gcTypes, sweepRevs, oldestRevTimeStamp));
    }

    protected Iterable<NodeDocument> identifyGarbage(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp) {
        return Iterables.filter(Utils.getAllDocuments(this.store), doc -> gcTypes.contains((Object)doc.getSplitDocType()) && doc.hasAllRevisionLessThan(oldestRevTimeStamp) && !VersionGCSupport.isDefaultNoBranchSplitNewerThan(doc, sweepRevs));
    }

    public long getOldestDeletedOnceTimestamp(Clock clock, long precisionMs) {
        long ts = 0L;
        long now = clock.getTime();
        long duration = (now - ts) / 2L;
        while (duration > precisionMs) {
            LOG.debug("find oldest _deletedOnce, check < {}", (Object)Utils.timestampToString(ts + duration));
            Iterable<NodeDocument> docs = this.getPossiblyDeletedDocs(ts, ts + duration);
            if (docs.iterator().hasNext()) {
                duration /= 2L;
            } else {
                ts += duration;
                duration /= 2L;
            }
            Utils.closeIfCloseable(docs);
        }
        LOG.debug("find oldest _deletedOnce to be {}", (Object)Utils.timestampToString(ts));
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<NodeDocument> getOldestModifiedDoc(Clock clock) {
        long now = clock.getTime();
        Iterable<NodeDocument> docs = null;
        try {
            docs = this.getModifiedDocs(0L, now, 1, "0000000", Collections.emptySet(), Collections.emptySet());
            if (docs.iterator().hasNext()) {
                NodeDocument oldestModifiedDoc = docs.iterator().next();
                LOG.info("Oldest modified document is {}", (Object)oldestModifiedDoc);
                Optional<NodeDocument> optional = Optional.ofNullable(oldestModifiedDoc);
                return optional;
            }
        }
        finally {
            Utils.closeIfCloseable(docs);
        }
        LOG.info("No Modified Doc has been found, retuning empty");
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<NodeDocument> getDocument(String id, List<String> fields) {
        Iterable docs;
        block5: {
            NodeDocument doc;
            block6: {
                Optional<NodeDocument> optional;
                docs = null;
                try {
                    docs = StreamSupport.stream(Utils.getSelectedDocuments(this.store, null, 0L, "0000000").spliterator(), false).filter(input -> this.idEquals((NodeDocument)input, id)).limit(1L).collect(Collectors.toList());
                    if (!docs.iterator().hasNext()) break block5;
                    doc = (NodeDocument)docs.iterator().next();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Found Document with id {}", (Object)id);
                    }
                    if (fields != null && !fields.isEmpty()) break block6;
                    optional = Optional.ofNullable(doc);
                }
                catch (Throwable throwable) {
                    Utils.closeIfCloseable(docs);
                    throw throwable;
                }
                Utils.closeIfCloseable(docs);
                return optional;
            }
            HashSet<String> projectedSet = new HashSet<String>(fields);
            projectedSet.add("_id");
            NodeDocument newDoc = Collection.NODES.newDocument(this.store);
            doc.deepCopy(newDoc);
            newDoc.keySet().retainAll(projectedSet);
            Optional<NodeDocument> optional = Optional.of(newDoc);
            Utils.closeIfCloseable(docs);
            return optional;
        }
        Utils.closeIfCloseable(docs);
        if (LOG.isDebugEnabled()) {
            LOG.debug("No Doc has been found with id [{}]", (Object)id);
        }
        return Optional.empty();
    }

    public long getDeletedOnceCount() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getDeletedOnceCount()");
    }

    protected static boolean isDefaultNoBranchSplitNewerThan(NodeDocument doc, RevisionVector sweepRevs) {
        if (doc.getSplitDocType() != NodeDocument.SplitDocType.DEFAULT_NO_BRANCH) {
            return false;
        }
        Revision r = (Revision)Iterables.getFirst(doc.getAllChanges(), null);
        return r != null && sweepRevs.isRevisionNewer(r);
    }
}

