/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.bundlor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Matcher;
import org.apache.jackrabbit.oak.plugins.document.bundlor.PropertyStateWrapper;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public final class BundlorUtils {
    public static final Predicate<PropertyState> NOT_BUNDLOR_PROPS = input -> !input.getName().startsWith(":doc-");

    public static Map<String, PropertyState> getMatchingProperties(Map<String, PropertyState> props, Matcher matcher) {
        if (!matcher.isMatch()) {
            return Collections.emptyMap();
        }
        HashMap<String, PropertyState> result = new HashMap<String, PropertyState>();
        for (Map.Entry<String, PropertyState> e : props.entrySet()) {
            String propertyPath = e.getKey();
            int depth = PathUtils.getDepth((String)propertyPath) - 1;
            if (!propertyPath.startsWith(matcher.getMatchedPath()) || depth != matcher.depth()) continue;
            final String newKey = PathUtils.getName((String)propertyPath);
            PropertyState value = e.getValue();
            if (depth > 0) {
                value = new PropertyStateWrapper(value){

                    @Override
                    @NotNull
                    public String getName() {
                        return newKey;
                    }
                };
            }
            result.put(newKey, value);
        }
        return result;
    }

    public static Set<String> getChildNodeNames(Collection<String> keys, Matcher matcher) {
        HashSet<String> childNodeNames = new HashSet<String>();
        int expectedDepth = matcher.depth() + 1;
        for (String key : keys) {
            List elements = CollectionUtils.toList((Iterable)PathUtils.elements((String)key));
            int depth = elements.size() - 1;
            if (depth != expectedDepth || !key.startsWith(matcher.getMatchedPath()) || !((String)elements.get(elements.size() - 1)).equals(":doc-self-path")) continue;
            childNodeNames.add((String)elements.get(elements.size() - 2));
        }
        return childNodeNames;
    }

    static boolean isBundlingRoot(NodeState state) {
        return state.hasProperty(":doc-pattern");
    }

    static boolean isBundledChild(NodeState state) {
        return state.hasProperty(":doc-self-path");
    }

    static boolean isBundledNode(NodeState state) {
        return BundlorUtils.isBundlingRoot(state) || BundlorUtils.isBundledChild(state);
    }
}

