/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.bundlor;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.apache.jackrabbit.oak.plugins.document.bundlor.IncludeMatcher;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Matcher;

public class Include {
    private static final String STAR = "*";
    private static final String STAR_STAR = "**";
    private final String[] elements;
    private final Directive directive;
    private final String pattern;

    public Include(String pattern) {
        List pathElements = CollectionUtils.toList((Iterable)PathUtils.elements((String)pattern));
        ArrayList<String> elementList = new ArrayList<String>(pathElements.size());
        Directive directive = Directive.NONE;
        for (int i = 0; i < pathElements.size(); ++i) {
            String e = (String)pathElements.get(i);
            int indexOfColon = e.indexOf(";");
            if (indexOfColon > 0) {
                directive = Directive.valueOf(e.substring(indexOfColon + 1).toUpperCase());
                e = e.substring(0, indexOfColon);
            }
            if (STAR_STAR.equals(e)) {
                e = STAR;
                directive = Directive.ALL;
            }
            elementList.add(e);
            if (directive == Directive.NONE || i >= pathElements.size() - 1) continue;
            throw new IllegalArgumentException("Directive can only be specified for last path segment [" + pattern + "]");
        }
        this.elements = elementList.toArray(new String[0]);
        this.directive = directive;
        this.pattern = pattern;
    }

    public boolean match(String relativePath) {
        Matcher m = this.createMatcher();
        for (String e : PathUtils.elements((String)relativePath)) {
            m = m.next(e);
        }
        return m.isMatch();
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    public Matcher createMatcher() {
        return new IncludeMatcher(this);
    }

    Directive getDirective() {
        return this.directive;
    }

    public boolean match(String nodeName, int depth) {
        int elementIndex = depth - 1;
        Preconditions.checkElementIndex((int)elementIndex, (int)this.elements.length);
        String e = this.elements[elementIndex];
        return STAR.equals(e) || nodeName.equals(e);
    }

    public boolean matchAny(int depth) {
        int elementIndex = depth - 1;
        Preconditions.checkElementIndex((int)elementIndex, (int)this.elements.length);
        return STAR.equals(this.elements[elementIndex]);
    }

    public int size() {
        return this.elements.length;
    }

    static enum Directive {
        ALL,
        NONE;

    }
}

