/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteError;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.io.Closeables;
import org.apache.jackrabbit.guava.common.util.concurrent.AtomicDouble;
import org.apache.jackrabbit.guava.common.util.concurrent.UncheckedExecutionException;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.Throttler;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheChangesTracker;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheInvalidationStats;
import org.apache.jackrabbit.oak.plugins.document.cache.ModificationStamp;
import org.apache.jackrabbit.oak.plugins.document.cache.NodeDocumentCache;
import org.apache.jackrabbit.oak.plugins.document.locks.NodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.locks.StripedNodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDBConfig;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDBConnection;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentNodeStoreBuilderBase;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStoreThrottlingMetricsUpdater;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoStatus;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoThrottlerFactory;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoUtils;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.bson.BSONException;
import org.bson.BsonMaximumSizeExceededException;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDocumentStore
implements DocumentStore {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDocumentStore.class);
    private static final PerfLogger PERFLOG = new PerfLogger(LoggerFactory.getLogger((String)(MongoDocumentStore.class.getName() + ".perf")));
    private static final Bson BY_ID_ASC = new BasicDBObject("_id", (Object)1);
    private static final String OPLOG_RS = "oplog.rs";
    public static final int DEFAULT_THROTTLING_THRESHOLD = Integer.getInteger("oak.mongo.throttlingThreshold", 2);
    public static final long DEFAULT_THROTTLING_TIME_MS = Long.getLong("oak.mongo.throttlingTime", 20L);
    private final int nodeNameLimit;
    private Throttler throttler = Throttler.NO_THROTTLING;
    public static final int IN_CLAUSE_BATCH_SIZE = 500;
    private static final Map CONFLICT_ON_INSERT = new BasicDBObject("$setOnInsert", (Object)new BasicDBObject("_id", (Object)"a").append("_id", (Object)"b")).toMap();
    private MongoCollection<BasicDBObject> nodes;
    private final MongoCollection<BasicDBObject> clusterNodes;
    private final MongoCollection<BasicDBObject> settings;
    private final MongoCollection<BasicDBObject> journal;
    private final MongoDBConnection connection;
    private final MongoDBConnection clusterNodesConnection;
    private final Map<String, String> mongoStorageOptions = new HashMap<String, String>();
    private final NodeDocumentCache nodesCache;
    private final NodeDocumentLocks nodeLocks;
    private Clock clock = Clock.SIMPLE;
    private final long maxReplicationLagMillis;
    private final AtomicLong mongoWriteExceptions = new AtomicLong();
    private final long maxDeltaForModTimeIdxSecs = Long.getLong("oak.mongo.maxDeltaForModTimeIdxSecs", 60L);
    private final boolean disableIndexHint = Boolean.getBoolean("oak.mongo.disableIndexHint");
    private final long maxQueryTimeMS = Long.getLong("oak.mongo.maxQueryTimeMS", TimeUnit.MINUTES.toMillis(1L));
    private int bulkSize = Integer.getInteger("oak.mongo.bulkSize", 30);
    private int bulkRetries = Integer.getInteger("oak.mongo.bulkRetries", 0);
    private final int queryRetries = Integer.getInteger("oak.mongo.queryRetries", 2);
    private final int acceptableLagMillis = Integer.getInteger("oak.mongo.acceptableLagMillis", 5000);
    private final int minPrefetch = Integer.getInteger("oak.mongo.minPrefetch", 5);
    private final boolean useClientSession;
    private String lastReadWriteMode;
    private final Map<String, String> metadata;
    private DocumentStoreStatsCollector stats;
    private MongoDocumentStoreThrottlingMetricsUpdater throttlingMetricsUpdater;
    private boolean hasModifiedIdCompoundIndex = true;
    private static final UpdateOp.Key KEY_MODIFIED = new UpdateOp.Key("_modified", null);
    private final boolean readOnly;

    @Override
    public int getNodeNameLimit() {
        return this.nodeNameLimit;
    }

    @Override
    public Throttler throttler() {
        return this.throttler;
    }

    public MongoDocumentStore(MongoClient connection, MongoDatabase db, MongoDocumentNodeStoreBuilderBase<?> builder) {
        this.readOnly = builder.getReadOnlyMode();
        MongoStatus status = builder.getMongoStatus();
        if (status == null) {
            status = new MongoStatus(connection, db.getName());
        }
        status.checkVersion();
        this.metadata = Map.of("type", "mongo", "version", status.getVersion());
        this.nodeNameLimit = MongoUtils.getNodeNameLimit(status);
        this.connection = new MongoDBConnection(connection, db, status, builder.getMongoClock());
        this.clusterNodesConnection = this.getOrCreateClusterNodesConnection(builder);
        this.stats = builder.getDocumentStoreStatsCollector();
        this.nodes = this.connection.getCollection(Collection.NODES.toString());
        this.clusterNodes = this.clusterNodesConnection.getCollection(Collection.CLUSTER_NODES.toString());
        this.settings = this.connection.getCollection(Collection.SETTINGS.toString());
        this.journal = this.connection.getCollection(Collection.JOURNAL.toString());
        this.initializeMongoStorageOptions(builder);
        this.maxReplicationLagMillis = builder.getMaxReplicationLagMillis();
        boolean bl = this.useClientSession = !builder.isClientSessionDisabled() && Boolean.parseBoolean(System.getProperty("oak.mongo.clientSession", "true"));
        if (!this.readOnly) {
            this.ensureIndexes(db, status);
        }
        this.nodeLocks = new StripedNodeDocumentLocks();
        this.nodesCache = builder.buildNodeDocumentCache(this, this.nodeLocks);
        boolean throttlingEnabled = Utils.isThrottlingEnabled(builder);
        if (throttlingEnabled) {
            MongoDatabase localDb = connection.getDatabase("local");
            Optional<String> ol = StreamSupport.stream(localDb.listCollectionNames().spliterator(), false).filter(s -> Objects.equals(OPLOG_RS, s)).findFirst();
            if (ol.isPresent()) {
                AtomicDouble oplogWindow = new AtomicDouble(2.147483647E9);
                this.throttler = MongoThrottlerFactory.exponentialThrottler(DEFAULT_THROTTLING_THRESHOLD, oplogWindow, DEFAULT_THROTTLING_TIME_MS);
                this.throttlingMetricsUpdater = new MongoDocumentStoreThrottlingMetricsUpdater(localDb, oplogWindow);
                this.throttlingMetricsUpdater.scheduleUpdateMetrics();
                LOG.info("Started MongoDB throttling metrics with threshold {}, throttling time {}", (Object)DEFAULT_THROTTLING_THRESHOLD, (Object)DEFAULT_THROTTLING_TIME_MS);
            } else {
                LOG.warn("Connected to MongoDB with replication not detected and hence oplog based throttling is not supported");
            }
        }
        LOG.info("Connected to MongoDB {} with maxReplicationLagMillis {}, maxDeltaForModTimeIdxSecs {}, disableIndexHint {}, leaseSocketTimeout {}, clientSessionSupported {}, clientSessionInUse {}, {}, serverStatus {}, throttlingSupported {}", new Object[]{status.getVersion(), this.maxReplicationLagMillis, this.maxDeltaForModTimeIdxSecs, this.disableIndexHint, builder.getLeaseSocketTimeout(), status.isClientSessionSupported(), this.useClientSession, db.getWriteConcern(), status.getServerDetails(), throttlingEnabled});
    }

    private void initializeMongoStorageOptions(MongoDocumentNodeStoreBuilderBase<?> builder) {
        if (builder.getCollectionCompressionType() != null) {
            this.mongoStorageOptions.put("collectionCompressionType", builder.getCollectionCompressionType());
        }
    }

    @NotNull
    private MongoDBConnection getOrCreateClusterNodesConnection(@NotNull MongoDocumentNodeStoreBuilderBase<?> builder) {
        int leaseSocketTimeout = builder.getLeaseSocketTimeout();
        MongoDBConnection mc = leaseSocketTimeout > 0 ? builder.createMongoDBClient(leaseSocketTimeout) : this.connection;
        return mc;
    }

    private void ensureIndexes(@NotNull MongoDatabase db, @NotNull MongoStatus mongoStatus) {
        boolean emptyNodesCollection = this.execute(session -> MongoUtils.isCollectionEmpty(this.nodes, session), Collection.NODES);
        this.createCollection(db, Collection.NODES.toString(), mongoStatus);
        if (emptyNodesCollection) {
            MongoUtils.createIndex(this.nodes, new String[]{"_modified", "_id"}, new boolean[]{true, true}, false, false);
        } else if (!MongoUtils.hasIndex(this.nodes.withReadPreference(ReadPreference.primary()), "_modified", "_id")) {
            this.hasModifiedIdCompoundIndex = false;
            LOG.warn("Detected an upgrade from Oak version <= 1.2. For optimal performance it is recommended to create a compound index for the 'nodes' collection on {_modified:1, _id:1}.");
        }
        MongoUtils.createIndex(this.nodes, "_bin", true, false, true);
        if (emptyNodesCollection) {
            if (mongoStatus.isVersion(3, 2)) {
                MongoUtils.createPartialIndex(this.nodes, new String[]{"_deletedOnce", "_modified"}, new boolean[]{true, true}, "{_deletedOnce:true}");
            } else {
                MongoUtils.createIndex(this.nodes, "_deletedOnce", true, false, true);
            }
        } else if (!MongoUtils.hasIndex(this.nodes.withReadPreference(ReadPreference.primary()), "_deletedOnce", "_modified")) {
            LOG.warn("Detected an upgrade from Oak version <= 1.6. For optimal Revision GC performance it is recommended to create a partial index for the 'nodes' collection on {_deletedOnce:1, _modified:1} with a partialFilterExpression {_deletedOnce:true}. Partial indexes require MongoDB 3.2 or higher.");
        }
        if (emptyNodesCollection) {
            MongoUtils.createIndex(this.nodes, new String[]{"_sdType", "_sdMaxRevTime"}, new boolean[]{true, true}, false, true);
        } else if (!MongoUtils.hasIndex(this.nodes.withReadPreference(ReadPreference.primary()), "_sdType", "_sdMaxRevTime")) {
            LOG.warn("Detected an upgrade from Oak version <= 1.6. For optimal Revision GC performance it is recommended to create a sparse compound index for the 'nodes' collection on {_sdType:1, _sdMaxRevTime:1}.");
        }
        MongoUtils.createIndex(this.journal, "_modified", true, false, false);
    }

    private void createCollection(MongoDatabase db, String collectionName, MongoStatus mongoStatus) {
        CreateCollectionOptions options = new CreateCollectionOptions();
        if (mongoStatus.isVersion(4, 2)) {
            options.storageEngineOptions(MongoDBConfig.getCollectionStorageOptions(this.mongoStorageOptions));
            if (!Iterables.tryFind((Iterable)db.listCollectionNames(), s -> Objects.equals(collectionName, s)).isPresent()) {
                db.createCollection(collectionName, options);
                LOG.info("Creating Collection {}, with collection storage options", (Object)collectionName);
            }
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    @Override
    public CacheInvalidationStats invalidateCache() {
        InvalidationResult result = new InvalidationResult();
        for (CacheValue key : this.nodesCache.keys()) {
            ++result.invalidationCount;
            this.invalidateCache(Collection.NODES, key.toString());
        }
        return result;
    }

    @Override
    public CacheInvalidationStats invalidateCache(Iterable<String> keys) {
        LOG.debug("invalidateCache: start");
        InvalidationResult result = new InvalidationResult();
        int size = 0;
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            ArrayList<String> ids = new ArrayList<String>(500);
            while (it.hasNext() && ids.size() < 500) {
                String id = it.next();
                if (this.nodesCache.getIfPresent(id) == null) continue;
                ids.add(id);
            }
            size += ids.size();
            if (LOG.isTraceEnabled()) {
                LOG.trace("invalidateCache: batch size: {} of total so far {}", (Object)ids.size(), (Object)size);
            }
            Map<String, ModificationStamp> modStamps = this.getModStamps(ids);
            ++result.queryCount;
            int invalidated = this.nodesCache.invalidateOutdated(modStamps);
            for (String id : Iterables.filter(ids, x -> !modStamps.keySet().contains(x))) {
                this.nodesCache.invalidate(id);
                ++invalidated;
            }
            result.cacheEntriesProcessedCount += ids.size();
            result.invalidationCount += invalidated;
            result.upToDateCount += ids.size() - invalidated;
        }
        result.cacheSize = size;
        LOG.trace("invalidateCache: end. total: {}", (Object)size);
        return result;
    }

    @Override
    public <T extends Document> void invalidateCache(Collection<T> collection, String key) {
        if (collection == Collection.NODES) {
            this.nodesCache.invalidate(key);
        }
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String key) {
        long start = PERFLOG.start();
        T result = this.find(collection, key, true, -1);
        PERFLOG.end(start, 1L, "find: preferCached=true, key={}", (Object)key);
        return result;
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String key, int maxCacheAge) {
        long start = PERFLOG.start();
        T result = this.find(collection, key, false, maxCacheAge);
        PERFLOG.end(start, 1L, "find: preferCached=false, key={}", (Object)key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Document> T find(Collection<T> collection, String key, boolean preferCached, int maxCacheAge) {
        Throwable t;
        NodeDocument doc;
        if (collection != Collection.NODES) {
            DocumentReadPreference readPref = DocumentReadPreference.PRIMARY;
            if (!this.withClientSession()) return this.findUncachedWithRetry(collection, key, readPref);
            readPref = this.getDefaultReadPreference(collection);
            return this.findUncachedWithRetry(collection, key, readPref);
        }
        if ((maxCacheAge > 0 || preferCached) && (doc = this.nodesCache.getIfPresent(key)) != null && (preferCached || this.getTime() - doc.getCreated() < (long)maxCacheAge)) {
            this.stats.doneFindCached(collection, key);
            if (doc != NodeDocument.NULL) return (T)doc;
            return null;
        }
        try {
            Lock lock = this.nodeLocks.acquire(key);
            try {
                if ((maxCacheAge > 0 || preferCached) && (doc = this.nodesCache.getIfPresent(key)) != null && (preferCached || this.getTime() - doc.getCreated() < (long)maxCacheAge)) {
                    this.stats.doneFindCached(collection, key);
                    if (doc == NodeDocument.NULL) {
                        T t2 = null;
                        return t2;
                    }
                    NodeDocument nodeDocument = doc;
                    return (T)nodeDocument;
                }
                final NodeDocument d = (NodeDocument)this.findUncachedWithRetry(collection, key, this.getReadPreference(maxCacheAge));
                this.invalidateCache(collection, key);
                doc = this.nodesCache.get(key, new Callable<NodeDocument>(){

                    @Override
                    public NodeDocument call() throws Exception {
                        return d == null ? NodeDocument.NULL : d;
                    }
                });
            }
            finally {
                lock.unlock();
            }
            if (doc != NodeDocument.NULL) return (T)doc;
            return null;
        }
        catch (UncheckedExecutionException e) {
            t = e.getCause();
            throw this.handleException(t, collection, key);
        }
        catch (ExecutionException e) {
            t = e.getCause();
            throw this.handleException(t, collection, key);
        }
        catch (RuntimeException e) {
            t = e;
        }
        throw this.handleException(t, collection, key);
    }

    @Nullable
    private <T extends Document> T findUncachedWithRetry(Collection<T> collection, String key, DocumentReadPreference docReadPref) {
        if (key.equals("0:/")) {
            LOG.trace("root node");
        }
        int numAttempts = this.queryRetries + 1;
        MongoException ex = null;
        for (int i = 0; i < numAttempts; ++i) {
            if (i > 0) {
                LOG.warn("Retrying read of " + key);
            }
            try {
                return this.findUncached(collection, key, docReadPref);
            }
            catch (MongoException e) {
                ex = e;
                LOG.warn("findUncachedWithRetry : read fails with an exception" + e, (Throwable)e);
                continue;
            }
        }
        if (ex != null) {
            throw this.handleException((Throwable)ex, collection, key);
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected <T extends Document> T findUncached(Collection<T> collection, String key, DocumentReadPreference docReadPref) {
        MongoDocumentStore.log("findUncached", new Object[]{key, docReadPref});
        Stopwatch watch = this.startWatch();
        boolean isSlaveOk = false;
        boolean docFound = true;
        try {
            ReadPreference readPreference = this.getMongoReadPreference(collection, null, docReadPref);
            MongoCollection<BasicDBObject> dbCollection = this.getDBCollection(collection, readPreference);
            if (readPreference.isSlaveOk()) {
                LOG.trace("Routing call to secondary for fetching [{}]", (Object)key);
                isSlaveOk = true;
            }
            ArrayList result = new ArrayList(1);
            this.execute(session -> {
                if (session != null) {
                    dbCollection.find(session, MongoDocumentStore.getByKeyQuery(key)).into((java.util.Collection)result);
                } else {
                    dbCollection.find(MongoDocumentStore.getByKeyQuery(key)).into((java.util.Collection)result);
                }
                return null;
            }, collection);
            if (result.isEmpty()) {
                docFound = false;
                T t = null;
                return t;
            }
            T doc = this.convertFromDBObject(collection, (DBObject)result.get(0));
            if (doc != null) {
                ((Document)doc).seal();
            }
            T t = doc;
            return t;
        }
        finally {
            this.stats.doneFindUncached(watch.elapsed(TimeUnit.NANOSECONDS), collection, key, docFound, isSlaveOk);
        }
    }

    @Override
    @NotNull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, int limit) {
        return this.query(collection, fromKey, toKey, null, 0L, limit);
    }

    @Override
    @NotNull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        return this.query(collection, fromKey, toKey, indexedProperty, startValue, limit, Collections.emptyList());
    }

    @Override
    @NotNull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit, List<String> projection) throws DocumentStoreException {
        return this.queryWithRetry(collection, fromKey, toKey, indexedProperty, startValue, limit, projection, this.maxQueryTimeMS);
    }

    @NotNull
    private <T extends Document> List<T> queryWithRetry(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit, List<String> projection, long maxQueryTime) {
        int numAttempts = this.queryRetries + 1;
        MongoException ex = null;
        for (int i = 0; i < numAttempts; ++i) {
            if (i > 0) {
                LOG.warn("Retrying query, fromKey={}, toKey={}", (Object)fromKey, (Object)toKey);
            }
            try {
                return this.queryInternal(collection, fromKey, toKey, indexedProperty, startValue, limit, projection, maxQueryTime);
            }
            catch (MongoException e) {
                ex = e;
                continue;
            }
        }
        if (ex != null) {
            throw this.handleException((Throwable)ex, collection, List.of(fromKey, toKey));
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected <T extends Document> List<T> queryInternal(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit, List<String> projection, long maxQueryTime) {
        ArrayList<NodeDocument> arrayList;
        int resultSize;
        boolean isSlaveOk;
        Stopwatch watch;
        long lockTime;
        block10: {
            MongoDocumentStore.log("query", fromKey, toKey, indexedProperty, startValue, limit);
            ArrayList<Bson> clauses = new ArrayList<Bson>();
            clauses.add(Filters.gt((String)"_id", (Object)fromKey));
            clauses.add(Filters.lt((String)"_id", (Object)toKey));
            BasicDBObject hint = "_modified".equals(indexedProperty) && this.canUseModifiedTimeIdx(startValue) ? new BasicDBObject("_modified", (Object)1) : new BasicDBObject("_id", (Object)1);
            if (indexedProperty != null) {
                if ("_deletedOnce".equals(indexedProperty)) {
                    if (startValue != 1L) {
                        throw new DocumentStoreException("unsupported value for property _deletedOnce");
                    }
                    clauses.add(Filters.eq((String)indexedProperty, (Object)true));
                } else {
                    clauses.add(Filters.gte((String)indexedProperty, (Object)startValue));
                }
            }
            Bson query = Filters.and(clauses);
            String parentId = Utils.getParentIdFromLowerLimit(fromKey);
            lockTime = -1L;
            watch = this.startWatch();
            isSlaveOk = false;
            resultSize = 0;
            CacheChangesTracker cacheChangesTracker = null;
            if (parentId != null && collection == Collection.NODES && (projection == null || projection.isEmpty())) {
                cacheChangesTracker = this.nodesCache.registerTracker(fromKey, toKey);
            }
            try {
                ReadPreference readPreference = this.getMongoReadPreference(collection, parentId, this.getDefaultReadPreference(collection));
                if (readPreference.isSlaveOk()) {
                    isSlaveOk = true;
                    LOG.trace("Routing call to secondary for fetching children from [{}] to [{}]", (Object)fromKey, (Object)toKey);
                }
                ArrayList<NodeDocument> list = new ArrayList<NodeDocument>();
                MongoCollection<BasicDBObject> dbCollection = this.getDBCollection(collection, readPreference);
                this.execute(arg_0 -> this.lambda$queryInternal$5(dbCollection, query, projection, limit, (Bson)hint, maxQueryTime, collection, list, arg_0), collection);
                resultSize = list.size();
                if (cacheChangesTracker != null) {
                    this.nodesCache.putNonConflictingDocs(cacheChangesTracker, list);
                }
                arrayList = list;
                if (cacheChangesTracker == null) break block10;
                cacheChangesTracker.close();
            }
            catch (Throwable throwable) {
                if (cacheChangesTracker != null) {
                    cacheChangesTracker.close();
                }
                this.stats.doneQuery(watch.elapsed(TimeUnit.NANOSECONDS), collection, fromKey, toKey, indexedProperty != null, resultSize, lockTime, isSlaveOk);
                throw throwable;
            }
        }
        this.stats.doneQuery(watch.elapsed(TimeUnit.NANOSECONDS), collection, fromKey, toKey, indexedProperty != null, resultSize, lockTime, isSlaveOk);
        return arrayList;
    }

    boolean canUseModifiedTimeIdx(long modifiedTimeInSecs) {
        if (this.maxDeltaForModTimeIdxSecs < 0L) {
            return false;
        }
        return NodeDocument.getModifiedInSecs(this.getTime()) - modifiedTimeInSecs <= this.maxDeltaForModTimeIdxSecs;
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, String key) {
        MongoDocumentStore.log("remove", key);
        MongoCollection<BasicDBObject> dbCollection = this.getDBCollection(collection);
        Stopwatch watch = this.startWatch();
        try {
            this.execute(session -> {
                Bson filter = MongoDocumentStore.getByKeyQuery(key);
                if (session != null) {
                    dbCollection.deleteOne(session, filter);
                } else {
                    dbCollection.deleteOne(filter);
                }
                return null;
            }, collection);
        }
        catch (Exception e) {
            throw DocumentStoreException.convert((Throwable)e, "Remove failed for " + key);
        }
        finally {
            this.invalidateCache(collection, key);
            this.stats.doneRemove(watch.elapsed(TimeUnit.NANOSECONDS), collection, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void remove(Collection<T> collection, List<String> keys) {
        MongoDocumentStore.log("remove", keys);
        MongoCollection<BasicDBObject> dbCollection = this.getDBCollection(collection);
        Stopwatch watch = this.startWatch();
        try {
            for (List keyBatch : CollectionUtils.partitionList(keys, (int)500)) {
                Bson query = Filters.in((String)"_id", (Iterable)keyBatch);
                try {
                    this.execute(session -> {
                        if (session != null) {
                            dbCollection.deleteMany(session, query);
                        } else {
                            dbCollection.deleteMany(query);
                        }
                        return null;
                    }, collection);
                }
                catch (Exception e) {
                    throw DocumentStoreException.convert((Throwable)e, "Remove failed for " + keyBatch);
                }
                finally {
                    if (collection != Collection.NODES) continue;
                    for (String key : keyBatch) {
                        this.invalidateCache(collection, key);
                    }
                }
            }
        }
        finally {
            this.stats.doneRemove(watch.elapsed(TimeUnit.NANOSECONDS), collection, keys.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> int remove(Collection<T> collection, Map<String, Long> toRemove) {
        MongoDocumentStore.log("remove", toRemove);
        int num = 0;
        MongoCollection<BasicDBObject> dbCollection = this.getDBCollection(collection);
        Stopwatch watch = this.startWatch();
        try {
            ArrayList<String> batchIds = new ArrayList<String>();
            ArrayList<Bson> batch = new ArrayList<Bson>();
            Iterator<Map.Entry<String, Long>> it = toRemove.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Long> entry = it.next();
                UpdateOp.Condition c = UpdateOp.Condition.newEqualsCondition(entry.getValue());
                Bson clause = MongoDocumentStore.createQueryForUpdate(entry.getKey(), Collections.singletonMap(KEY_MODIFIED, c));
                batchIds.add(entry.getKey());
                batch.add(clause);
                if (it.hasNext() && batch.size() != 500) continue;
                Bson query = Filters.or(batch);
                try {
                    num = (int)((long)num + this.execute(session -> {
                        DeleteResult result = session != null ? dbCollection.deleteMany(session, query) : dbCollection.deleteMany(query);
                        return result.getDeletedCount();
                    }, collection));
                }
                catch (Exception e) {
                    throw DocumentStoreException.convert((Throwable)e, "Remove failed for " + batch);
                }
                finally {
                    if (collection == Collection.NODES) {
                        this.invalidateCache(batchIds);
                    }
                }
                batchIds.clear();
                batch.clear();
            }
        }
        finally {
            this.stats.doneRemove(watch.elapsed(TimeUnit.NANOSECONDS), collection, num);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> int remove(Collection<T> collection, String indexedProperty, long startValue, long endValue) throws DocumentStoreException {
        MongoDocumentStore.log("remove", collection, indexedProperty, startValue, endValue);
        int num = 0;
        MongoCollection<BasicDBObject> dbCollection = this.getDBCollection(collection);
        Stopwatch watch = this.startWatch();
        try {
            Bson query = Filters.and((Bson[])new Bson[]{Filters.gt((String)indexedProperty, (Object)startValue), Filters.lt((String)indexedProperty, (Object)endValue)});
            try {
                num = (int)Math.min(this.execute(session -> {
                    DeleteResult result = session != null ? dbCollection.deleteMany(session, query) : dbCollection.deleteMany(query);
                    return result.getDeletedCount();
                }, collection), Integer.MAX_VALUE);
            }
            catch (Exception e) {
                throw DocumentStoreException.convert((Throwable)e, "Remove failed for " + collection + ": " + indexedProperty + " in (" + startValue + ", " + endValue + ")");
            }
            finally {
                if (collection == Collection.NODES) {
                    this.invalidateCache();
                }
            }
        }
        finally {
            this.stats.doneRemove(watch.elapsed(TimeUnit.NANOSECONDS), collection, num);
        }
        return num;
    }

    @Nullable
    private <T extends Document> T findAndModify(Collection<T> collection, UpdateOp updateOp, boolean upsert, boolean checkConditions) {
        MongoCollection<BasicDBObject> dbCollection = this.getDBCollection(collection);
        updateOp = updateOp.copy();
        BasicDBObject update = MongoDocumentStore.createUpdate(updateOp, !upsert);
        Lock lock = null;
        if (collection == Collection.NODES) {
            lock = this.nodeLocks.acquire(updateOp.getId());
        }
        Stopwatch watch = this.startWatch();
        boolean newEntry = false;
        try {
            FindOneAndUpdateOptions options;
            Bson query;
            UpdateResult result;
            Long modCount = null;
            NodeDocument cachedDoc = null;
            if (collection == Collection.NODES && (cachedDoc = this.nodesCache.getIfPresent(updateOp.getId())) != null) {
                modCount = cachedDoc.getModCount();
            }
            if (modCount != null && (!checkConditions || UpdateUtils.checkConditions(cachedDoc, updateOp.getConditions())) && (result = this.execute(arg_0 -> MongoDocumentStore.lambda$findAndModify$10(dbCollection, query = Filters.and((Bson[])new Bson[]{MongoDocumentStore.createQueryForUpdate(updateOp.getId(), updateOp.getConditions()), Filters.eq((String)"_modCount", (Object)modCount)}), (Bson)update, arg_0), collection)).getModifiedCount() > 0L) {
                NodeDocument newDoc;
                if (collection == Collection.NODES) {
                    newDoc = this.applyChanges(collection, cachedDoc, updateOp);
                    this.nodesCache.put(newDoc);
                }
                newDoc = cachedDoc;
                return (T)newDoc;
            }
            query = MongoDocumentStore.createQueryForUpdate(updateOp.getId(), updateOp.getConditions());
            BasicDBObject oldNode = this.execute(arg_0 -> MongoDocumentStore.lambda$findAndModify$11(dbCollection, query, (Bson)update, options = new FindOneAndUpdateOptions().returnDocument(ReturnDocument.BEFORE).upsert(upsert), arg_0), collection);
            if (oldNode == null && upsert) {
                newEntry = true;
            }
            if (checkConditions && oldNode == null) {
                T t = null;
                return t;
            }
            T oldDoc = this.convertFromDBObject(collection, (DBObject)oldNode);
            if (oldDoc != null) {
                if (collection == Collection.NODES) {
                    NodeDocument newDoc = (NodeDocument)this.applyChanges(collection, oldDoc, updateOp);
                    this.nodesCache.put(newDoc);
                }
                ((Document)oldDoc).seal();
            } else if (upsert) {
                if (collection == Collection.NODES) {
                    NodeDocument doc = (NodeDocument)collection.newDocument(this);
                    UpdateUtils.applyChanges(doc, updateOp);
                    this.nodesCache.putIfAbsent(doc);
                }
            } else if (collection == Collection.NODES) {
                this.nodesCache.invalidate(updateOp.getId());
            }
            T t = oldDoc;
            return t;
        }
        catch (MongoWriteException e) {
            WriteError werr = e.getError();
            LOG.error("Failed to update the document with Id={} with MongoWriteException message = '{}'. Document statistics: {}.", new Object[]{updateOp.getId(), werr.getMessage(), this.produceDiagnostics(collection, updateOp.getId()), e});
            throw this.handleException((Throwable)e, collection, updateOp.getId());
        }
        catch (MongoCommandException e) {
            LOG.error("Failed to update the document with Id={} with MongoCommandException message ='{}'. ", (Object)updateOp.getId(), (Object)e.getMessage());
            throw this.handleException((Throwable)e, collection, updateOp.getId());
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e, collection, updateOp.getId());
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
            this.stats.doneFindAndModify(watch.elapsed(TimeUnit.NANOSECONDS), collection, updateOp.getId(), newEntry, true, 0);
        }
    }

    private <T extends Document> String produceDiagnostics(Collection<T> col, String id) {
        StringBuilder t = new StringBuilder();
        try {
            T doc = this.find(col, id);
            if (doc != null) {
                t.append("_id: " + ((Document)doc).getId() + ", _modCount: " + ((Document)doc).getModCount() + ", memory: " + ((Document)doc).getMemory());
                t.append("; Contents: ");
                t.append(Utils.mapEntryDiagnostics(((Document)doc).entrySet()));
            }
        }
        catch (Throwable thisIsBestEffort) {
            t.append(thisIsBestEffort.getMessage());
        }
        return t.toString();
    }

    @Override
    @NotNull
    public <T extends Document> List<T> findAndUpdate(@NotNull Collection<T> collection, @NotNull List<UpdateOp> updateOps) {
        MongoDocumentStore.log("findAndUpdate", updateOps);
        LinkedHashMap<String, UpdateOp> operationsToCover = new LinkedHashMap<String, UpdateOp>(updateOps.size());
        ArrayList<UpdateOp> duplicates = new ArrayList<UpdateOp>();
        LinkedHashMap<UpdateOp, T> results = new LinkedHashMap<UpdateOp, T>(updateOps.size());
        Stopwatch watch = this.startWatch();
        int retryCount = 0;
        try {
            for (UpdateOp updateOp : updateOps) {
                UpdateOp clone = updateOp.copy();
                if (operationsToCover.containsKey(updateOp.getId())) {
                    duplicates.add(clone);
                } else {
                    operationsToCover.put(updateOp.getId(), clone);
                }
                results.put(clone, null);
            }
            HashMap<String, NodeDocument> oldDocs = new HashMap<String, NodeDocument>(updateOps.size());
            if (collection == Collection.NODES) {
                oldDocs.putAll(this.getCachedNodes(operationsToCover.keySet()));
            }
            for (int i = 0; i <= this.bulkRetries; ++i) {
                retryCount = i;
                if (operationsToCover.size() <= 2) break;
                for (List partition : CollectionUtils.partitionList(new ArrayList(operationsToCover.values()), (int)this.bulkSize)) {
                    Map<UpdateOp, T> successfulUpdates = this.bulkModify(collection, partition, oldDocs);
                    results.putAll(successfulUpdates);
                    operationsToCover.values().removeAll(successfulUpdates.keySet());
                }
            }
            Iterator it = Iterators.concat(operationsToCover.values().iterator(), duplicates.iterator());
            while (it.hasNext()) {
                UpdateOp op = (UpdateOp)it.next();
                it.remove();
                results.put(op, this.findAndUpdate(collection, op));
            }
        }
        catch (MongoException e) {
            throw this.handleException((Throwable)e, collection, Iterables.transform(updateOps, UpdateOp::getId));
        }
        finally {
            this.stats.doneFindAndModify(watch.elapsed(TimeUnit.NANOSECONDS), collection, updateOps.stream().map(UpdateOp::getId).collect(Collectors.toList()), true, retryCount);
        }
        ArrayList resultList = new ArrayList(results.values());
        MongoDocumentStore.log("findAndUpdate returns", resultList);
        return resultList;
    }

    @Override
    @Nullable
    public <T extends Document> T createOrUpdate(Collection<T> collection, UpdateOp update) throws DocumentStoreException {
        MongoDocumentStore.log("createOrUpdate", update);
        UpdateUtils.assertUnconditional(update);
        T doc = this.findAndModify(collection, update, update.isNew(), false);
        MongoDocumentStore.log("createOrUpdate returns ", doc);
        return doc;
    }

    @Override
    @Nullable
    public <T extends Document> List<T> createOrUpdate(Collection<T> collection, List<UpdateOp> updateOps) {
        MongoDocumentStore.log("createOrUpdate", updateOps);
        LinkedHashMap<String, UpdateOp> operationsToCover = new LinkedHashMap<String, UpdateOp>();
        ArrayList<UpdateOp> duplicates = new ArrayList<UpdateOp>();
        LinkedHashMap<UpdateOp, T> results = new LinkedHashMap<UpdateOp, T>();
        Stopwatch watch = this.startWatch();
        try {
            for (UpdateOp updateOp : updateOps) {
                UpdateUtils.assertUnconditional(updateOp);
                UpdateOp clone = updateOp.copy();
                if (operationsToCover.containsKey(updateOp.getId())) {
                    duplicates.add(clone);
                } else {
                    operationsToCover.put(updateOp.getId(), clone);
                }
                results.put(clone, null);
            }
            HashMap<String, NodeDocument> oldDocs = new HashMap<String, NodeDocument>();
            if (collection == Collection.NODES) {
                oldDocs.putAll(this.getCachedNodes(operationsToCover.keySet()));
            }
            for (int i = 0; i <= this.bulkRetries && operationsToCover.size() > 2; ++i) {
                for (List partition : CollectionUtils.partitionList(new ArrayList(operationsToCover.values()), (int)this.bulkSize)) {
                    Map<UpdateOp, T> successfulUpdates = this.bulkUpdate(collection, partition, oldDocs);
                    results.putAll(successfulUpdates);
                    operationsToCover.values().removeAll(successfulUpdates.keySet());
                }
            }
            Iterator it = Iterators.concat(operationsToCover.values().iterator(), duplicates.iterator());
            while (it.hasNext()) {
                UpdateOp op = (UpdateOp)it.next();
                it.remove();
                T oldDoc = this.createOrUpdate(collection, op);
                if (oldDoc == null) continue;
                results.put(op, oldDoc);
            }
        }
        catch (MongoException e) {
            throw this.handleException((Throwable)e, collection, Iterables.transform(updateOps, input -> input.getId()));
        }
        finally {
            this.stats.doneCreateOrUpdate(watch.elapsed(TimeUnit.NANOSECONDS), collection, updateOps.stream().map(UpdateOp::getId).collect(Collectors.toList()));
        }
        ArrayList resultList = new ArrayList(results.values());
        MongoDocumentStore.log("createOrUpdate returns", resultList);
        return resultList;
    }

    private Map<String, NodeDocument> getCachedNodes(Set<String> keys) {
        HashMap<String, NodeDocument> nodes = new HashMap<String, NodeDocument>();
        for (String key : keys) {
            NodeDocument cached = this.nodesCache.getIfPresent(key);
            if (cached == null) continue;
            nodes.put(key, cached);
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private <T extends Document> Map<UpdateOp, T> bulkModify(Collection<T> collection, List<UpdateOp> updateOps, Map<String, T> oldDocs) {
        Map<String, UpdateOp> bulkOperations = MongoDocumentStore.createMap(updateOps);
        Set lackingDocs = CollectionUtils.difference(bulkOperations.keySet(), oldDocs.keySet());
        oldDocs.putAll(this.findDocuments(collection, lackingDocs));
        CacheChangesTracker tracker = null;
        if (collection == Collection.NODES) {
            tracker = this.nodesCache.registerTracker(bulkOperations.keySet());
        }
        try {
            BulkRequestResult bulkResult = this.sendBulkRequest(collection, bulkOperations.values(), oldDocs, false);
            Set potentiallyUpdatedDocsSet = CollectionUtils.difference(bulkOperations.keySet(), bulkResult.failedUpdates);
            HashMap<String, Object> updatedDocsMap = new HashMap<String, Object>(potentiallyUpdatedDocsSet.size());
            ArrayList<NodeDocument> docsToCache = new ArrayList<NodeDocument>();
            if (bulkResult.modifiedCount == potentiallyUpdatedDocsSet.size()) {
                potentiallyUpdatedDocsSet.forEach(key -> {
                    Document oldDoc = (Document)oldDocs.get(key);
                    if (Objects.isNull(oldDoc) || oldDoc == NodeDocument.NULL) {
                        MongoDocumentStore.log("Skipping updating doc cache for ", key);
                        return;
                    }
                    Document newDoc = this.applyChanges(collection, oldDoc, (UpdateOp)bulkOperations.get(key));
                    updatedDocsMap.put(newDoc.getId(), newDoc);
                    if (collection == Collection.NODES) {
                        docsToCache.add((NodeDocument)newDoc);
                    }
                });
            } else {
                updatedDocsMap.putAll(this.findDocuments(collection, potentiallyUpdatedDocsSet));
                updatedDocsMap.forEach((key, value) -> {
                    Document oldDoc = (Document)oldDocs.get(key);
                    if (Objects.isNull(oldDoc) || oldDoc == NodeDocument.NULL || Objects.equals(oldDoc.getModCount(), value.getModCount())) {
                        MongoDocumentStore.log("Skipping updating doc cache for ", key);
                        return;
                    }
                    if (collection == Collection.NODES) {
                        docsToCache.add((NodeDocument)this.applyChanges(collection, oldDoc, (UpdateOp)bulkOperations.get(key)));
                    }
                });
            }
            if (collection == Collection.NODES && docsToCache.size() > 0) {
                this.nodesCache.putNonConflictingDocs(tracker, docsToCache);
            }
            oldDocs.keySet().removeAll(bulkResult.failedUpdates);
            HashMap result = new HashMap(oldDocs.size());
            bulkOperations.entrySet().stream().filter(e -> !bulkResult.failedUpdates.contains(e.getKey())).forEach(e -> {
                Document updated = (Document)updatedDocsMap.get(e.getKey());
                Document oldDoc = (Document)oldDocs.get(e.getKey());
                if (oldDoc == null || oldDoc == NodeDocument.NULL || Objects.equals(oldDoc.getModCount(), updated.getModCount())) {
                    MongoDocumentStore.log(" didn't get updated, returning null.", e.getKey());
                    result.put((UpdateOp)e.getValue(), null);
                } else {
                    oldDoc.seal();
                    result.put((UpdateOp)e.getValue(), oldDoc);
                }
            });
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            if (tracker != null) {
                tracker.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Document> Map<UpdateOp, T> bulkUpdate(Collection<T> collection, List<UpdateOp> updateOperations, Map<String, T> oldDocs) {
        Map<String, UpdateOp> bulkOperations = MongoDocumentStore.createMap(updateOperations);
        Set lackingDocs = CollectionUtils.difference(bulkOperations.keySet(), oldDocs.keySet());
        oldDocs.putAll(this.findDocuments(collection, lackingDocs));
        CacheChangesTracker tracker = null;
        if (collection == Collection.NODES) {
            tracker = this.nodesCache.registerTracker(bulkOperations.keySet());
        }
        try {
            BulkRequestResult bulkResult = this.sendBulkRequest(collection, bulkOperations.values(), oldDocs, true);
            if (collection == Collection.NODES) {
                ArrayList<NodeDocument> docsToCache = new ArrayList<NodeDocument>();
                for (UpdateOp op : CollectionUtils.filterKeys(bulkOperations, bulkResult.upserts::contains).values()) {
                    NodeDocument doc = Collection.NODES.newDocument(this);
                    UpdateUtils.applyChanges(doc, op);
                    docsToCache.add(doc);
                }
                for (String key : CollectionUtils.difference(bulkOperations.keySet(), bulkResult.failedUpdates)) {
                    Document oldDoc = (Document)oldDocs.get(key);
                    if (oldDoc == null || oldDoc == NodeDocument.NULL) continue;
                    NodeDocument newDoc = (NodeDocument)this.applyChanges(collection, oldDoc, bulkOperations.get(key));
                    docsToCache.add(newDoc);
                }
                this.nodesCache.putNonConflictingDocs(tracker, docsToCache);
            }
            oldDocs.keySet().removeAll(bulkResult.failedUpdates);
            HashMap<UpdateOp, Document> result = new HashMap<UpdateOp, Document>();
            for (Map.Entry<String, UpdateOp> entry : bulkOperations.entrySet()) {
                if (bulkResult.failedUpdates.contains(entry.getKey())) continue;
                if (bulkResult.upserts.contains(entry.getKey())) {
                    result.put(entry.getValue(), null);
                    continue;
                }
                result.put(entry.getValue(), (Document)oldDocs.get(entry.getKey()));
            }
            Iterator iterator = result;
            return iterator;
        }
        finally {
            if (tracker != null) {
                tracker.close();
            }
        }
    }

    private static Map<String, UpdateOp> createMap(List<UpdateOp> updateOps) {
        return updateOps.stream().collect(Collectors.toMap(UpdateOp::getId, Function.identity()));
    }

    private <T extends Document> Map<String, T> findDocuments(Collection<T> collection, Set<String> keys) {
        try {
            HashMap docs = new HashMap();
            if (!keys.isEmpty()) {
                MongoCollection dbCollection;
                ArrayList<Bson> conditions = new ArrayList<Bson>(keys.size());
                for (String key : keys) {
                    conditions.add(MongoDocumentStore.getByKeyQuery(key));
                }
                if (this.secondariesWithinAcceptableLag()) {
                    dbCollection = this.getDBCollection(collection);
                } else {
                    this.lagTooHigh();
                    dbCollection = this.getDBCollection(collection).withReadPreference(ReadPreference.primary());
                }
                this.execute(session -> {
                    FindIterable cursor = session != null ? dbCollection.find(session, Filters.or((Iterable)conditions)) : dbCollection.find(Filters.or((Iterable)conditions));
                    for (BasicDBObject doc : cursor) {
                        Object foundDoc = this.convertFromDBObject(collection, (DBObject)doc);
                        docs.put(((Document)foundDoc).getId(), foundDoc);
                    }
                    return null;
                }, collection);
            }
            return docs;
        }
        catch (BSONException ex) {
            LOG.error("trying bulk find, retrying one-by-one", (Throwable)ex);
            return this.findDocumentsOneByOne(collection, keys);
        }
    }

    private <T extends Document> Map<String, T> findDocumentsOneByOne(Collection<T> collection, Set<String> keys) {
        HashMap docs = new HashMap();
        for (String key : keys) {
            MongoCollection dbCollection;
            Bson condition = MongoDocumentStore.getByKeyQuery(key);
            if (this.secondariesWithinAcceptableLag()) {
                dbCollection = this.getDBCollection(collection);
            } else {
                this.lagTooHigh();
                dbCollection = this.getDBCollection(collection).withReadPreference(ReadPreference.primary());
            }
            this.execute(session -> {
                FindIterable cursor = session != null ? dbCollection.find(session, condition) : dbCollection.find(condition);
                for (BasicDBObject doc : cursor) {
                    Object foundDoc = this.convertFromDBObject(collection, (DBObject)doc);
                    docs.put(((Document)foundDoc).getId(), foundDoc);
                }
                return null;
            }, collection);
        }
        return docs;
    }

    @NotNull
    private <T extends Document> BulkRequestResult sendBulkRequest(Collection<T> collection, java.util.Collection<UpdateOp> updateOps, Map<String, T> oldDocs, boolean isUpsert) {
        BulkWriteResult bulkResult;
        MongoCollection<BasicDBObject> dbCollection = this.getDBCollection(collection);
        ArrayList<UpdateOneModel> writes = new ArrayList<UpdateOneModel>(updateOps.size());
        String[] bulkIds = new String[updateOps.size()];
        int i = 0;
        for (UpdateOp updateOp : updateOps) {
            String id = updateOp.getId();
            Bson query = MongoDocumentStore.createQueryForUpdate(id, updateOp.getConditions());
            boolean failInsert = !isUpsert || !updateOp.isNew();
            Document oldDoc = (Document)oldDocs.get(id);
            query = oldDoc == null || oldDoc == NodeDocument.NULL ? Filters.and((Bson[])new Bson[]{query, Filters.exists((String)"_modCount", (boolean)false)}) : Filters.and((Bson[])new Bson[]{query, Filters.eq((String)"_modCount", (Object)oldDoc.getModCount())});
            writes.add(new UpdateOneModel(query, (Bson)MongoDocumentStore.createUpdate(updateOp, failInsert), new UpdateOptions().upsert(isUpsert)));
            bulkIds[i++] = id;
        }
        HashSet<String> failedUpdates = new HashSet<String>();
        HashSet<String> upserts = new HashSet<String>();
        BulkWriteOptions options = new BulkWriteOptions().ordered(false);
        try {
            bulkResult = this.execute(session -> {
                if (session != null) {
                    return dbCollection.bulkWrite(session, writes, options);
                }
                return dbCollection.bulkWrite(writes, options);
            }, collection);
        }
        catch (MongoBulkWriteException e) {
            bulkResult = e.getWriteResult();
            for (BulkWriteError err : e.getWriteErrors()) {
                failedUpdates.add(bulkIds[err.getIndex()]);
            }
        }
        for (BulkWriteUpsert upsert : bulkResult.getUpserts()) {
            upserts.add(bulkIds[upsert.getIndex()]);
        }
        return new BulkRequestResult(failedUpdates, upserts, bulkResult.getModifiedCount());
    }

    @Override
    public <T extends Document> T findAndUpdate(Collection<T> collection, UpdateOp update) throws DocumentStoreException {
        MongoDocumentStore.log("findAndUpdate", update);
        T doc = this.findAndModify(collection, update, false, true);
        MongoDocumentStore.log("findAndUpdate returns ", doc);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> boolean create(Collection<T> collection, List<UpdateOp> updateOps) {
        MongoDocumentStore.log("create", updateOps);
        ArrayList<Iterator<Object>> docs = new ArrayList<Iterator<Object>>();
        ArrayList<BasicDBObject> inserts = new ArrayList<BasicDBObject>(updateOps.size());
        ArrayList<String> ids = new ArrayList<String>(updateOps.size());
        for (UpdateOp update : updateOps) {
            BasicDBObject doc = new BasicDBObject();
            inserts.add(doc);
            doc.put((Object)"_id", (Object)update.getId());
            UpdateUtils.assertUnconditional(update);
            Iterator<Object> target = collection.newDocument(this);
            UpdateUtils.applyChanges(target, update);
            docs.add(target);
            ids.add(update.getId());
            for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> entry : update.getChanges().entrySet()) {
                UpdateOp.Key k = entry.getKey();
                UpdateOp.Operation op = entry.getValue();
                switch (op.type) {
                    case SET: 
                    case MAX: 
                    case INCREMENT: {
                        doc.put((Object)k.toString(), op.value);
                        break;
                    }
                    case SET_MAP_ENTRY: {
                        Revision r = k.getRevision();
                        if (r == null) {
                            throw new IllegalStateException("SET_MAP_ENTRY must not have null revision");
                        }
                        BasicDBObject value = (BasicDBObject)doc.get(k.getName());
                        if (value == null) {
                            value = new BasicDBObject();
                            doc.put((Object)k.getName(), (Object)value);
                        }
                        value.put((Object)r.toString(), op.value);
                        break;
                    }
                }
            }
            if (doc.containsField("_modCount")) continue;
            doc.put((Object)"_modCount", (Object)1L);
            ((Document)((Object)target)).put("_modCount", 1L);
        }
        MongoCollection<BasicDBObject> dbCollection = this.getDBCollection(collection);
        Stopwatch watch = this.startWatch();
        boolean insertSuccess = false;
        try {
            this.execute(session -> {
                if (session != null) {
                    dbCollection.insertMany(session, inserts);
                } else {
                    dbCollection.insertMany(inserts);
                }
                return null;
            }, collection);
            if (collection == Collection.NODES) {
                for (Document bl : docs) {
                    this.nodesCache.putIfAbsent((NodeDocument)bl);
                }
            }
            insertSuccess = true;
            boolean target = true;
            return target;
        }
        catch (BsonMaximumSizeExceededException e) {
            for (Document document : docs) {
                LOG.error("Failed to create one of the documents with BsonMaximumSizeExceededException message = '{}'. The document id={} has estimated size={} in VM.", new Object[]{e.getMessage(), document.getId(), document.getMemory()});
            }
            boolean bl = false;
            return bl;
        }
        catch (MongoException e) {
            LOG.warn("Encountered MongoException while inserting documents: {} - exception: {}", ids, (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.stats.doneCreate(watch.elapsed(TimeUnit.NANOSECONDS), collection, ids, insertSuccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void prefetch(Collection<T> collection, Iterable<String> keysToPrefetch) {
        Throwable t;
        MongoDocumentStore.log("prefetch", keysToPrefetch);
        HashSet<String> keys = new HashSet<String>();
        for (String k : keysToPrefetch) {
            if (this.nodesCache.getIfPresent(k) != null) continue;
            keys.add(k);
        }
        if (keys.size() < this.minPrefetch) {
            return;
        }
        Stopwatch watch = this.startWatch();
        ArrayList<String> resultKeys = new ArrayList<String>(keys.size());
        CacheChangesTracker tracker = null;
        if (collection == Collection.NODES) {
            tracker = this.nodesCache.registerTracker(new HashSet<String>(keys));
        }
        try {
            ReadPreference readPreference = this.getMongoReadPreference(collection, null, this.getDefaultReadPreference(collection));
            MongoCollection<BasicDBObject> dbCollection = this.getDBCollection(collection, readPreference);
            if (readPreference.isSlaveOk()) {
                LOG.trace("Routing call to secondary for prefetching [{}]", keys);
            }
            ArrayList result = new ArrayList(keys.size());
            this.execute(session -> {
                Bson query = Filters.in((String)"_id", (Iterable)keys);
                if (session != null) {
                    dbCollection.find(session, query).into((java.util.Collection)result);
                } else {
                    dbCollection.find(query).into((java.util.Collection)result);
                }
                return null;
            }, collection);
            ArrayList<NodeDocument> docs = new ArrayList<NodeDocument>(keys.size());
            for (BasicDBObject dbObject : result) {
                T d = this.convertFromDBObject(collection, (DBObject)dbObject);
                if (d == null) continue;
                ((Document)d).seal();
                String key = String.valueOf(((Document)d).get("_id"));
                resultKeys.add(key);
                keys.remove(key);
                docs.add((NodeDocument)d);
            }
            if (tracker != null) {
                this.nodesCache.putNonConflictingDocs(tracker, docs);
                for (String id : keys) {
                    Lock lock = this.nodeLocks.acquire(id);
                    try {
                        if (tracker.mightBeenAffected(id)) continue;
                        this.nodesCache.get(id, () -> NodeDocument.NULL);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            return;
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            t = e.getCause();
        }
        catch (RuntimeException e) {
            t = e;
        }
        finally {
            if (tracker != null) {
                tracker.close();
            }
            this.stats.donePrefetch(watch.elapsed(TimeUnit.NANOSECONDS), collection, resultKeys);
        }
        throw this.handleException(t, collection, keysToPrefetch);
    }

    @NotNull
    private Map<String, ModificationStamp> getModStamps(Iterable<String> keys) throws MongoException {
        BasicDBObject fields = new BasicDBObject("_id", (Object)1);
        fields.put((Object)"_modCount", (Object)1);
        fields.put((Object)"_modified", (Object)1);
        HashMap<String, ModificationStamp> modCounts = new HashMap<String, ModificationStamp>();
        this.nodes.withReadPreference(ReadPreference.primary()).find(Filters.in((String)"_id", keys)).projection((Bson)fields).forEach(obj -> {
            Long modified;
            String id = (String)obj.get("_id");
            Long modCount = Utils.asLong((Number)obj.get("_modCount"));
            if (modCount == null) {
                modCount = -1L;
            }
            if ((modified = Utils.asLong((Number)obj.get("_modified"))) == null) {
                modified = -1L;
            }
            modCounts.put(id, new ModificationStamp(modCount, modified));
        });
        return modCounts;
    }

    DocumentReadPreference getReadPreference(int maxCacheAge) {
        if (this.withClientSession()) {
            return DocumentReadPreference.PREFER_SECONDARY;
        }
        if (maxCacheAge >= 0 && (long)maxCacheAge < this.maxReplicationLagMillis) {
            return DocumentReadPreference.PRIMARY;
        }
        if (maxCacheAge == Integer.MAX_VALUE) {
            return DocumentReadPreference.PREFER_SECONDARY;
        }
        return DocumentReadPreference.PREFER_SECONDARY_IF_OLD_ENOUGH;
    }

    DocumentReadPreference getDefaultReadPreference(Collection col) {
        DocumentReadPreference preference = DocumentReadPreference.PRIMARY;
        if (this.withClientSession()) {
            preference = DocumentReadPreference.PREFER_SECONDARY;
        } else if (col == Collection.NODES) {
            preference = DocumentReadPreference.PREFER_SECONDARY_IF_OLD_ENOUGH;
        }
        return preference;
    }

    <T extends Document> ReadPreference getMongoReadPreference(@NotNull Collection<T> collection, @Nullable String parentId, @NotNull DocumentReadPreference preference) {
        switch (preference) {
            case PRIMARY: {
                return ReadPreference.primary();
            }
            case PREFER_PRIMARY: {
                return ReadPreference.primaryPreferred();
            }
            case PREFER_SECONDARY: {
                if (!this.withClientSession() || this.secondariesWithinAcceptableLag()) {
                    return this.getConfiguredReadPreference(collection);
                }
                this.lagTooHigh();
                return ReadPreference.primary();
            }
            case PREFER_SECONDARY_IF_OLD_ENOUGH: {
                boolean secondarySafe;
                if (collection != Collection.NODES) {
                    return ReadPreference.primary();
                }
                if (this.withClientSession() && this.secondariesWithinAcceptableLag()) {
                    secondarySafe = true;
                } else {
                    NodeDocument cachedDoc;
                    long replicationSafeLimit = this.getTime() - this.maxReplicationLagMillis;
                    secondarySafe = parentId == null ? false : (cachedDoc = this.getIfCached(Collection.NODES, parentId)) != null && !cachedDoc.hasBeenModifiedSince(replicationSafeLimit);
                }
                ReadPreference readPreference = secondarySafe ? this.getConfiguredReadPreference(collection) : ReadPreference.primary();
                return readPreference;
            }
        }
        throw new IllegalArgumentException("Unsupported usage " + preference);
    }

    <T extends Document> ReadPreference getConfiguredReadPreference(Collection<T> collection) {
        return this.getDBCollection(collection).getReadPreference();
    }

    @Nullable
    protected <T extends Document> T convertFromDBObject(@NotNull Collection<T> collection, @Nullable DBObject n) {
        Document copy = null;
        if (n != null) {
            copy = (Document)collection.newDocument(this);
            for (String key : n.keySet()) {
                Object o = n.get(key);
                if (o instanceof String) {
                    copy.put(key, o);
                    continue;
                }
                if (o instanceof Number && ("_modified".equals(key) || "_modCount".equals(key))) {
                    copy.put(key, Utils.asLong((Number)o));
                    continue;
                }
                if (o instanceof Long) {
                    copy.put(key, o);
                    continue;
                }
                if (o instanceof Integer) {
                    copy.put(key, o);
                    continue;
                }
                if (o instanceof Boolean) {
                    copy.put(key, o);
                    continue;
                }
                if (!(o instanceof BasicDBObject)) continue;
                copy.put(key, this.convertMongoMap((BasicDBObject)o));
            }
        }
        return (T)copy;
    }

    @NotNull
    private Map<Revision, Object> convertMongoMap(@NotNull BasicDBObject obj) {
        TreeMap<Revision, Object> map = new TreeMap<Revision, Object>(StableRevisionComparator.REVERSE);
        for (Map.Entry entry : obj.entrySet()) {
            map.put(Revision.fromString((String)entry.getKey()), entry.getValue());
        }
        return map;
    }

    <T extends Document> MongoCollection<BasicDBObject> getDBCollection(Collection<T> collection) {
        if (collection == Collection.NODES) {
            return this.nodes;
        }
        if (collection == Collection.CLUSTER_NODES) {
            return this.clusterNodes;
        }
        if (collection == Collection.SETTINGS) {
            return this.settings;
        }
        if (collection == Collection.JOURNAL) {
            return this.journal;
        }
        throw new IllegalArgumentException("Unknown collection: " + collection.toString());
    }

    <T extends Document> MongoCollection<BasicDBObject> getDBCollection(Collection<T> collection, ReadPreference readPreference) {
        return this.getDBCollection(collection).withReadPreference(readPreference);
    }

    MongoDatabase getDatabase() {
        return this.connection.getDatabase();
    }

    MongoClient getClient() {
        return this.connection.getClient();
    }

    private static Bson getByKeyQuery(String key) {
        return Filters.eq((String)"_id", (Object)key);
    }

    @Override
    public void dispose() {
        this.connection.close();
        if (this.clusterNodesConnection != this.connection) {
            this.clusterNodesConnection.close();
        }
        try {
            Closeables.close((Closeable)this.throttlingMetricsUpdater, (boolean)false);
        }
        catch (IOException e) {
            LOG.warn("Error occurred while closing throttlingMetricsUpdater", (Throwable)e);
        }
        try {
            this.nodesCache.close();
        }
        catch (IOException e) {
            LOG.warn("Error occurred while closing nodes cache", (Throwable)e);
        }
    }

    @Override
    public Iterable<CacheStats> getCacheStats() {
        return this.nodesCache.getCacheStats();
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public Map<String, String> getStats() {
        HashMap builder = new HashMap();
        List<MongoCollection<BasicDBObject>> all = List.of(this.nodes, this.clusterNodes, this.settings, this.journal);
        all.forEach(c -> MongoDocumentStore.toMapBuilder(builder, (BasicDBObject)this.connection.getDatabase().runCommand((Bson)new BasicDBObject("collStats", (Object)c.getNamespace().getCollectionName()), BasicDBObject.class), c.getNamespace().getCollectionName()));
        return Collections.unmodifiableMap(builder);
    }

    long getMaxDeltaForModTimeIdxSecs() {
        return this.maxDeltaForModTimeIdxSecs;
    }

    boolean getDisableIndexHint() {
        return this.disableIndexHint;
    }

    private static void log(String message, Object ... args) {
        if (LOG.isDebugEnabled()) {
            Object argList = Arrays.toString(args);
            if (((String)argList).length() > 10000) {
                argList = ((String)argList).length() + ": " + (String)argList;
            }
            LOG.debug(message + (String)argList);
        }
    }

    @Override
    public <T extends Document> T getIfCached(Collection<T> collection, String key) {
        if (collection != Collection.NODES) {
            return null;
        }
        NodeDocument doc = this.nodesCache.getIfPresent(key);
        if (doc == NodeDocument.NULL) {
            doc = null;
        }
        return (T)doc;
    }

    @NotNull
    private static Bson createQueryForUpdate(String key, Map<UpdateOp.Key, UpdateOp.Condition> conditions) {
        Bson query = MongoDocumentStore.getByKeyQuery(key);
        if (conditions.isEmpty()) {
            return query;
        }
        ArrayList<Bson> conditionList = new ArrayList<Bson>(conditions.size() + 1);
        conditionList.add(query);
        for (Map.Entry<UpdateOp.Key, UpdateOp.Condition> entry : conditions.entrySet()) {
            UpdateOp.Key k = entry.getKey();
            UpdateOp.Condition c = entry.getValue();
            switch (c.type) {
                case EXISTS: {
                    conditionList.add(Filters.exists((String)k.toString(), (boolean)Boolean.TRUE.equals(c.value)));
                    break;
                }
                case EQUALS: {
                    conditionList.add(Filters.eq((String)k.toString(), (Object)c.value));
                    break;
                }
                case NOTEQUALS: {
                    conditionList.add(Filters.ne((String)k.toString(), (Object)c.value));
                }
            }
        }
        return Filters.and(conditionList);
    }

    private static BasicDBObject createUpdate(UpdateOp updateOp, boolean failOnInsert) {
        BasicDBObject setUpdates = new BasicDBObject();
        BasicDBObject maxUpdates = new BasicDBObject();
        BasicDBObject incUpdates = new BasicDBObject();
        BasicDBObject unsetUpdates = new BasicDBObject();
        updateOp.increment("_modCount", 1L);
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> entry : updateOp.getChanges().entrySet()) {
            UpdateOp.Key k = entry.getKey();
            UpdateOp.Operation op = entry.getValue();
            switch (op.type) {
                case SET: 
                case SET_MAP_ENTRY: {
                    setUpdates.append(k.toString(), op.value);
                    break;
                }
                case MAX: {
                    maxUpdates.append(k.toString(), op.value);
                    break;
                }
                case INCREMENT: {
                    incUpdates.append(k.toString(), op.value);
                    break;
                }
                case REMOVE: 
                case REMOVE_MAP_ENTRY: {
                    unsetUpdates.append(k.toString(), (Object)"1");
                }
            }
        }
        BasicDBObject update = new BasicDBObject();
        if (!setUpdates.isEmpty()) {
            update.append("$set", (Object)setUpdates);
        }
        if (!maxUpdates.isEmpty()) {
            update.append("$max", (Object)maxUpdates);
        }
        if (!incUpdates.isEmpty()) {
            update.append("$inc", (Object)incUpdates);
        }
        if (!unsetUpdates.isEmpty()) {
            update.append("$unset", (Object)unsetUpdates);
        }
        if (failOnInsert) {
            update.putAll(CONFLICT_ON_INSERT);
        }
        return update;
    }

    @NotNull
    private <T extends Document> T applyChanges(Collection<T> collection, T oldDoc, UpdateOp update) {
        T doc = collection.newDocument(this);
        oldDoc.deepCopy((Document)doc);
        UpdateUtils.applyChanges(doc, update);
        ((Document)doc).seal();
        return doc;
    }

    private Stopwatch startWatch() {
        return Stopwatch.createStarted();
    }

    @Override
    public void setReadWriteMode(String readWriteMode) {
        if (readWriteMode == null || readWriteMode.equals(this.lastReadWriteMode)) {
            return;
        }
        this.lastReadWriteMode = readWriteMode;
        try {
            WriteConcern writeConcern;
            MongoClientURI uri;
            ReadPreference readPref;
            String rwModeUri = readWriteMode;
            if (!readWriteMode.startsWith("mongodb://")) {
                rwModeUri = String.format("mongodb://localhost/?%s", readWriteMode);
            }
            if (!(readPref = (uri = new MongoClientURI(rwModeUri)).getOptions().getReadPreference()).equals(this.nodes.getReadPreference())) {
                this.nodes = this.nodes.withReadPreference(readPref);
                LOG.info("Using ReadPreference {} ", (Object)readPref);
            }
            if (!(writeConcern = uri.getOptions().getWriteConcern()).equals((Object)this.nodes.getWriteConcern())) {
                this.nodes = this.nodes.withWriteConcern(writeConcern);
                LOG.info("Using WriteConcern " + writeConcern);
            }
        }
        catch (Exception e) {
            LOG.error("Error setting readWriteMode " + readWriteMode, (Throwable)e);
        }
    }

    private long getTime() {
        return this.clock.getTime();
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    NodeDocumentCache getNodeDocumentCache() {
        return this.nodesCache;
    }

    public void setStatsCollector(DocumentStoreStatsCollector stats) {
        this.stats = stats;
    }

    @Override
    public long determineServerTimeDifferenceMillis() {
        long start = System.currentTimeMillis();
        try {
            BasicDBObject isMaster = (BasicDBObject)this.getDatabase().runCommand((Bson)new BasicDBObject("isMaster", (Object)1), BasicDBObject.class);
            if (isMaster == null) {
                LOG.warn("determineServerTimeDifferenceMillis: db.isMaster returned null - cannot determine time difference - assuming 0ms.");
                return 0L;
            }
            Date serverLocalTime = isMaster.getDate("localTime");
            if (serverLocalTime == null) {
                LOG.warn("determineServerTimeDifferenceMillis: db.isMaster.localTime returned null - cannot determine time difference - assuming 0ms.");
                return 0L;
            }
            long end = System.currentTimeMillis();
            long midPoint = (start + end) / 2L;
            long serverLocalTimeMillis = serverLocalTime.getTime();
            long diff = midPoint - serverLocalTimeMillis;
            return diff;
        }
        catch (Exception e) {
            LOG.warn("determineServerTimeDifferenceMillis: db.isMaster failed with exception - assuming 0ms. (Result details: server exception=" + e + ", server error message=" + e.getMessage() + ")", (Throwable)e);
            return 0L;
        }
    }

    private <T extends Document> DocumentStoreException handleException(Throwable ex, Collection<T> collection, Iterable<String> ids) {
        if (collection == Collection.NODES) {
            for (String id : ids) {
                this.invalidateCache(collection, id);
            }
        }
        if (ex instanceof MongoWriteException) {
            this.mongoWriteExceptions.incrementAndGet();
        }
        return DocumentStoreException.asDocumentStoreException(ex.getMessage(), ex, MongoUtils.getDocumentStoreExceptionTypeFor(ex), ids);
    }

    public long getAmountOfMongoWriteExceptions() {
        return this.mongoWriteExceptions.get();
    }

    private <T extends Document> DocumentStoreException handleException(Throwable ex, Collection<T> collection, String id) {
        return this.handleException(ex, collection, Collections.singleton(id));
    }

    private static void toMapBuilder(Map<String, String> builder, BasicDBObject stats, String prefix) {
        stats.forEach((k, v) -> {
            if (!(k.equals("wiredTiger") || k.equals("indexDetails") || k.equals("ok"))) {
                String key = prefix + "." + k;
                if (v instanceof BasicDBObject) {
                    MongoDocumentStore.toMapBuilder(builder, (BasicDBObject)v, key);
                } else {
                    builder.put(key, String.valueOf(v));
                }
            }
        });
    }

    private boolean withClientSession() {
        return this.connection.getStatus().isClientSessionSupported() && this.useClientSession;
    }

    private boolean secondariesWithinAcceptableLag() {
        return this.getClient().getReplicaSetStatus() == null || this.connection.getStatus().getReplicaSetLagEstimate() < (long)this.acceptableLagMillis;
    }

    private void lagTooHigh() {
        LOG.debug("Read from secondary is preferred but replication lag is too high. Directing read to primary.");
    }

    private <T> T execute(@NotNull DocumentStoreCallable<T> callable, @NotNull Collection<?> collection) throws DocumentStoreException {
        T result;
        if (this.withClientSession()) {
            try (ClientSession session = this.createClientSession(collection);){
                result = callable.call(session);
            }
        } else {
            result = callable.call(null);
        }
        return result;
    }

    private ClientSession createClientSession(Collection<?> collection) {
        MongoDBConnection dbConnection = Collection.CLUSTER_NODES == collection ? this.clusterNodesConnection : this.connection;
        return dbConnection.createClientSession();
    }

    private static /* synthetic */ BasicDBObject lambda$findAndModify$11(MongoCollection dbCollection, Bson query, Bson update, FindOneAndUpdateOptions options, ClientSession session) throws DocumentStoreException {
        if (session != null) {
            return (BasicDBObject)dbCollection.findOneAndUpdate(session, query, update, options);
        }
        return (BasicDBObject)dbCollection.findOneAndUpdate(query, update, options);
    }

    private static /* synthetic */ UpdateResult lambda$findAndModify$10(MongoCollection dbCollection, Bson query, Bson update, ClientSession session) throws DocumentStoreException {
        if (session != null) {
            return dbCollection.updateOne(session, query, update);
        }
        return dbCollection.updateOne(query, update);
    }

    private /* synthetic */ Object lambda$queryInternal$5(MongoCollection dbCollection, Bson query, List projection, int limit, Bson hint, long maxQueryTime, Collection collection, List list, ClientSession session) throws DocumentStoreException {
        FindIterable result = session != null ? dbCollection.find(session, query) : dbCollection.find(query);
        if (projection != null && !projection.isEmpty()) {
            result.projection(Projections.include((List)projection));
        }
        result.sort(BY_ID_ASC);
        if (limit >= 0) {
            result.limit(limit);
        }
        if (!this.disableIndexHint && !this.hasModifiedIdCompoundIndex) {
            result.hint(hint);
        }
        if (maxQueryTime > 0L) {
            result.maxTime(maxQueryTime, TimeUnit.MILLISECONDS);
        }
        try (MongoCursor cursor = result.iterator();){
            for (int i = 0; i < limit && cursor.hasNext(); ++i) {
                BasicDBObject o = (BasicDBObject)cursor.next();
                Object doc = this.convertFromDBObject(collection, (DBObject)o);
                list.add(doc);
            }
        }
        return null;
    }

    private static class InvalidationResult
    implements CacheInvalidationStats {
        int invalidationCount;
        int upToDateCount;
        int cacheSize;
        int queryCount;
        int cacheEntriesProcessedCount;

        private InvalidationResult() {
        }

        public String toString() {
            return "InvalidationResult{invalidationCount=" + this.invalidationCount + ", upToDateCount=" + this.upToDateCount + ", cacheSize=" + this.cacheSize + ", queryCount=" + this.queryCount + ", cacheEntriesProcessedCount=" + this.cacheEntriesProcessedCount + "}";
        }

        @Override
        public String summaryReport() {
            return this.toString();
        }
    }

    private static class BulkRequestResult {
        private final Set<String> failedUpdates;
        private final Set<String> upserts;
        private final int modifiedCount;

        private BulkRequestResult(Set<String> failedUpdates, Set<String> upserts, int modifiedCount) {
            this.failedUpdates = failedUpdates;
            this.upserts = upserts;
            this.modifiedCount = modifiedCount;
        }
    }

    static interface DocumentStoreCallable<T> {
        public T call(@Nullable ClientSession var1) throws DocumentStoreException;
    }

    static enum DocumentReadPreference {
        PRIMARY,
        PREFER_PRIMARY,
        PREFER_SECONDARY,
        PREFER_SECONDARY_IF_OLD_ENOUGH;

    }
}

