/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.io.Closeable;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.apache.jackrabbit.oak.plugins.blob.CachingBlobStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobStoreDB;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBConnectionHandler;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJDBCTools;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBBlobStore
extends CachingBlobStore
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RDBBlobStore.class);
    private static final PerfLogger PERFLOG = new PerfLogger(LoggerFactory.getLogger((String)(RDBBlobStore.class.getName() + ".perf")));
    protected static final int IDSIZE;
    private Exception callStack;
    protected RDBConnectionHandler ch;
    protected String tnData;
    protected String tnMeta;
    private Set<String> tablesToBeDropped = new HashSet<String>();
    private boolean readOnly;
    private long minLastModified;

    public RDBBlobStore(@NotNull DataSource ds, @Nullable DocumentNodeStoreBuilder<?> builder, @Nullable RDBOptions options) {
        try {
            this.initialize(ds, builder, options == null ? new RDBOptions() : options);
        }
        catch (Exception ex) {
            throw DocumentStoreException.convert((Throwable)ex, "initializing RDB blob store");
        }
    }

    public RDBBlobStore(@NotNull DataSource ds, @Nullable RDBOptions options) {
        this(ds, null, options);
    }

    public RDBBlobStore(@NotNull DataSource ds) {
        this(ds, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object dropped = "";
        if (!this.tablesToBeDropped.isEmpty()) {
            LOG.debug("attempting to drop: " + this.tablesToBeDropped);
            for (String tname : this.tablesToBeDropped) {
                Connection con = null;
                try {
                    con = this.ch.getRWConnection();
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("drop table " + tname);
                        stmt.close();
                        con.commit();
                        dropped = (String)dropped + tname + " ";
                    }
                    catch (SQLException ex) {
                        LOG.debug("attempting to drop: " + tname, (Throwable)ex);
                    }
                    finally {
                        RDBJDBCTools.closeStatement(stmt);
                    }
                }
                catch (SQLException ex) {
                    LOG.debug("attempting to drop: " + tname, (Throwable)ex);
                }
                finally {
                    this.ch.closeConnection(con);
                }
            }
            dropped = ((String)dropped).trim();
        }
        this.ch.close();
        LOG.info("RDBBlobStore (" + Utils.getModuleVersion() + ") closed" + (String)(((String)dropped).isEmpty() ? "" : " (tables dropped: " + (String)dropped + ")"));
    }

    protected void finalize() throws Throwable {
        if (!this.ch.isClosed() && this.callStack != null) {
            LOG.debug("finalizing RDBDocumentStore that was not disposed", (Throwable)this.callStack);
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(DataSource ds, DocumentNodeStoreBuilder<?> builder, RDBOptions options) throws Exception {
        DatabaseMetaData md;
        RDBBlobStoreDB db;
        String versionDiags;
        this.readOnly = builder == null ? false : builder.getReadOnlyMode();
        this.tnData = RDBJDBCTools.createTableName(options.getTablePrefix(), "DATASTORE_DATA");
        this.tnMeta = RDBJDBCTools.createTableName(options.getTablePrefix(), "DATASTORE_META");
        this.ch = new RDBConnectionHandler(ds);
        Connection con = this.ch.getRWConnection();
        int isolation = con.getTransactionIsolation();
        String isolationDiags = RDBJDBCTools.isolationLevelToString(isolation);
        if (isolation != 2) {
            LOG.info("Detected transaction isolation level " + isolationDiags + " is " + (isolation < 2 ? "lower" : "higher") + " than expected " + RDBJDBCTools.isolationLevelToString(2) + " - check datasource configuration");
        }
        if (!(versionDiags = (db = RDBBlobStoreDB.getValue((md = con.getMetaData()).getDatabaseProductName())).checkVersion(md)).isEmpty()) {
            LOG.error(versionDiags);
        }
        String dbDesc = String.format("%s %s (%d.%d)", md.getDatabaseProductName(), md.getDatabaseProductVersion(), md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion()).replaceAll("[\r\n\t]", " ").trim();
        String driverDesc = String.format("%s %s (%d.%d)", md.getDriverName(), md.getDriverVersion(), md.getDriverMajorVersion(), md.getDriverMinorVersion()).replaceAll("[\r\n\t]", " ").trim();
        String dbUrl = md.getURL();
        ArrayList<String> tablesCreated = new ArrayList<String>();
        ArrayList<String> tablesPresent = new ArrayList<String>();
        HashMap<String, String> tableInfo = new HashMap<String, String>();
        Statement createStatement = null;
        try {
            String moreDiags;
            for (String tableName : new String[]{this.tnData, this.tnMeta}) {
                Statement checkStatement = null;
                try {
                    checkStatement = con.createStatement();
                    ResultSet checkResultSet = checkStatement.executeQuery("select * from " + tableName + " where ID = '0'");
                    tableInfo.put(tableName, RDBJDBCTools.dumpResultSetMeta(checkResultSet.getMetaData()));
                    RDBJDBCTools.closeResultSet(checkResultSet);
                    checkStatement = RDBJDBCTools.closeStatement(checkStatement);
                    con.commit();
                    tablesPresent.add(tableName);
                }
                catch (SQLException ex) {
                    String ct;
                    checkStatement = RDBJDBCTools.closeStatement(checkStatement);
                    con.rollback();
                    LOG.debug("trying to read from '" + tableName + "'", (Throwable)ex);
                    if (this.readOnly) {
                        throw new SQLException("Would like to create table '" + tableName + "', but RDBBlobStore has been initialized in 'readonly' mode");
                    }
                    createStatement = con.createStatement();
                    if (this.tnMeta.equals(tableName)) {
                        ct = db.getMetaTableCreationStatement(tableName);
                        createStatement.execute(ct);
                    } else {
                        ct = db.getDataTableCreationStatement(tableName);
                        createStatement.execute(ct);
                    }
                    createStatement.close();
                    createStatement = null;
                    con.commit();
                    ResultSet checkResultSet = null;
                    try {
                        checkStatement = con.createStatement();
                        checkResultSet = checkStatement.executeQuery("select * from " + tableName + " where ID = '0'");
                        tableInfo.put(tableName, RDBJDBCTools.dumpResultSetMeta(checkResultSet.getMetaData()));
                        con.commit();
                    }
                    catch (Throwable throwable) {
                        RDBJDBCTools.closeResultSet(checkResultSet);
                        RDBJDBCTools.closeStatement(checkStatement);
                        throw throwable;
                    }
                    RDBJDBCTools.closeResultSet(checkResultSet);
                    RDBJDBCTools.closeStatement(checkStatement);
                    tablesCreated.add(tableName);
                }
            }
            if (options.isDropTablesOnClose()) {
                this.tablesToBeDropped.addAll(tablesCreated);
            }
            Map<String, String> diag = db.getAdditionalDiagnostics(this.ch, this.tnData);
            LOG.info("RDBBlobStore (" + Utils.getModuleVersion() + ") instantiated for database " + dbDesc + ", using driver: " + driverDesc + ", connecting to: " + dbUrl + (String)(diag.isEmpty() ? "" : ", properties: " + diag.toString()) + ", transaction isolation level: " + isolationDiags + ", " + tableInfo);
            if (!tablesPresent.isEmpty()) {
                LOG.info("Tables present upon startup: " + tablesPresent);
            }
            if (!tablesCreated.isEmpty()) {
                LOG.info("Tables created upon startup: " + tablesCreated + (options.isDropTablesOnClose() ? " (will be dropped on exit)" : ""));
            }
            if ((moreDiags = db.evaluateDiagnostics(diag)) != null) {
                LOG.info(moreDiags);
            }
            this.callStack = LOG.isDebugEnabled() ? new Exception("call stack of RDBBlobStore creation") : null;
        }
        finally {
            RDBJDBCTools.closeStatement(createStatement);
            this.ch.closeConnection(con);
        }
    }

    protected void storeBlock(byte[] digest, int level, byte[] data) throws IOException {
        if (this.readOnly) {
            throw new IOException("RDBBlobStore has been initialized in 'readonly' mode");
        }
        try {
            this.storeBlockInDatabase(digest, level, data);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBlockInDatabase(byte[] digest, int level, byte[] data) throws SQLException {
        block26: {
            String id = StringUtils.convertBytesToHex((byte[])digest);
            this.cache.put((Object)id, (Object)data);
            Connection con = this.ch.getRWConnection();
            try {
                int count;
                long now = System.currentTimeMillis();
                try (PreparedStatement prep = con.prepareStatement("update " + this.tnMeta + " set LASTMOD = ? where ID = ?");){
                    prep.setLong(1, now);
                    prep.setString(2, id);
                    count = prep.executeUpdate();
                }
                if (count != 0) break block26;
                try {
                    prep = con.prepareStatement("insert into " + this.tnData + " (ID, DATA) values(?, ?)");
                    try {
                        prep.setString(1, id);
                        prep.setBytes(2, data);
                        int rows = prep.executeUpdate();
                        LOG.trace("insert-data id={} rows={}", (Object)id, (Object)rows);
                        if (rows != 1) {
                            throw new SQLException("Insert of id " + id + " into " + this.tnData + " failed with result " + rows);
                        }
                    }
                    finally {
                        prep.close();
                    }
                }
                catch (SQLException ex) {
                    this.ch.rollbackConnection(con);
                    prep = con.prepareStatement("select DATA from " + this.tnData + " where ID = ?");
                    ResultSet rs = null;
                    byte[] dbdata = null;
                    try {
                        prep.setString(1, id);
                        rs = prep.executeQuery();
                        if (rs.next()) {
                            dbdata = rs.getBytes(1);
                        }
                    }
                    catch (Throwable throwable) {
                        RDBJDBCTools.closeResultSet(rs);
                        RDBJDBCTools.closeStatement(prep);
                        throw throwable;
                    }
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(prep);
                    if (dbdata == null) {
                        String message = "insert document failed for id " + id + " with length " + data.length + " (check max size of datastore_data.data)";
                        LOG.error(message, (Throwable)ex);
                        throw new SQLException(message, ex);
                    }
                    if (!Arrays.equals(data, dbdata)) {
                        String message = "DATA table already contains blob for id " + id + ", but the actual data differs (lengths: " + data.length + ", " + dbdata.length + ")";
                        LOG.error(message, (Throwable)ex);
                        throw new SQLException(message, ex);
                    }
                    LOG.info("recovered from DB inconsistency for id " + id + ": meta record was missing (impact will be minor performance degradation)");
                }
                try {
                    prep = con.prepareStatement("insert into " + this.tnMeta + " (ID, LVL, LASTMOD) values(?, ?, ?)");
                    try {
                        prep.setString(1, id);
                        prep.setInt(2, level);
                        prep.setLong(3, now);
                        int rows = prep.executeUpdate();
                        LOG.trace("insert-meta id={} rows={}", (Object)id, (Object)rows);
                        if (rows != 1) {
                            throw new SQLException("Insert of id " + id + " into " + this.tnMeta + " failed with result " + rows);
                        }
                    }
                    finally {
                        prep.close();
                    }
                }
                catch (SQLException e) {
                    LOG.debug("inserting meta record for id " + id, (Throwable)e);
                }
            }
            finally {
                con.commit();
                this.ch.closeConnection(con);
            }
        }
    }

    protected byte[] readBlockFromBackend(byte[] digest) throws Exception {
        return this.readBlockFromBackend(StringUtils.convertBytesToHex((byte[])digest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBlockFromBackend(String id) throws Exception {
        byte[] data;
        Connection con = this.ch.getROConnection();
        try {
            long pstart = PERFLOG.start(PERFLOG.isDebugEnabled() ? "reading: " + id : null);
            PreparedStatement prep = con.prepareStatement("select DATA from " + this.tnData + " where ID = ?");
            ResultSet rs = null;
            try {
                prep.setString(1, id);
                rs = prep.executeQuery();
                if (!rs.next()) {
                    PERFLOG.end(pstart, 10L, "read: table={}, id={} -> not found", (Object)this.tnData, (Object)id);
                    throw new IOException("Datastore block " + id + " not found");
                }
                data = rs.getBytes(1);
                PERFLOG.end(pstart, 10L, "read: table={}, id={} -> data={}", new Object[]{this.tnData, id, data == null ? 0 : data.length});
            }
            catch (SQLException ex) {
                try {
                    PERFLOG.end(pstart, 10L, "read: table={} -> exception={}", (Object)this.tnData, (Object)ex.getMessage());
                    throw ex;
                }
                catch (Throwable throwable) {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(prep);
                    throw throwable;
                }
            }
            RDBJDBCTools.closeResultSet(rs);
            RDBJDBCTools.closeStatement(prep);
        }
        finally {
            con.commit();
            this.ch.closeConnection(con);
        }
        return data;
    }

    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId blockId) throws Exception {
        String id = StringUtils.convertBytesToHex((byte[])blockId.getDigest());
        byte[] data = (byte[])this.cache.get((Object)id);
        if (data == null) {
            long start = System.nanoTime();
            data = this.readBlockFromBackend(id);
            this.getStatsCollector().downloaded(id, System.nanoTime() - start, TimeUnit.NANOSECONDS, (long)data.length);
            this.cache.put((Object)id, (Object)data);
        }
        if (blockId.getPos() == 0L) {
            return data;
        }
        int len = (int)((long)data.length - blockId.getPos());
        if (len < 0) {
            return new byte[0];
        }
        byte[] d2 = new byte[len];
        System.arraycopy(data, (int)blockId.getPos(), d2, 0, len);
        return d2;
    }

    public void startMark() throws IOException {
        this.minLastModified = System.currentTimeMillis();
        this.markInUse();
    }

    protected boolean isMarkEnabled() {
        return this.minLastModified != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mark(AbstractBlobStore.BlockId blockId) throws Exception {
        Connection con = this.ch.getRWConnection();
        PreparedStatement prep = null;
        try {
            if (this.minLastModified == 0L) {
                return;
            }
            String id = StringUtils.convertBytesToHex((byte[])blockId.getDigest());
            prep = con.prepareStatement("update " + this.tnMeta + " set LASTMOD = ? where ID = ? and LASTMOD < ?");
            prep.setLong(1, System.currentTimeMillis());
            prep.setString(2, id);
            prep.setLong(3, this.minLastModified);
            prep.executeUpdate();
            prep.close();
        }
        finally {
            RDBJDBCTools.closeStatement(prep);
            con.commit();
            this.ch.closeConnection(con);
        }
    }

    public int sweep() throws IOException {
        try {
            return this.sweepFromDatabase();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sweepFromDatabase() throws SQLException {
        int n;
        Connection con = this.ch.getRWConnection();
        PreparedStatement prepCheck = null;
        PreparedStatement prepDelMeta = null;
        PreparedStatement prepDelData = null;
        ResultSet rs = null;
        try {
            int count = 0;
            prepCheck = con.prepareStatement("select ID from " + this.tnMeta + " where LASTMOD < ?");
            prepCheck.setLong(1, this.minLastModified);
            rs = prepCheck.executeQuery();
            ArrayList<String> ids = new ArrayList<String>();
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
            rs.close();
            rs = null;
            prepCheck.close();
            prepCheck = null;
            prepDelMeta = con.prepareStatement("delete from " + this.tnMeta + " where ID = ?");
            prepDelData = con.prepareStatement("delete from " + this.tnData + " where ID = ?");
            for (String id : ids) {
                prepDelMeta.setString(1, id);
                int mrows = prepDelMeta.executeUpdate();
                LOG.trace("delete-meta id={} rows={}", (Object)id, (Object)mrows);
                prepDelData.setString(1, id);
                int drows = prepDelData.executeUpdate();
                LOG.trace("delete-data id={} rows={}", (Object)id, (Object)drows);
                ++count;
            }
            prepDelMeta.close();
            prepDelMeta = null;
            prepDelData.close();
            prepDelData = null;
            this.minLastModified = 0L;
            n = count;
        }
        catch (Throwable throwable) {
            RDBJDBCTools.closeResultSet(rs);
            RDBJDBCTools.closeStatement(prepCheck);
            RDBJDBCTools.closeStatement(prepDelMeta);
            RDBJDBCTools.closeStatement(prepDelData);
            con.commit();
            this.ch.closeConnection(con);
            throw throwable;
        }
        RDBJDBCTools.closeResultSet(rs);
        RDBJDBCTools.closeStatement(prepCheck);
        RDBJDBCTools.closeStatement(prepDelMeta);
        RDBJDBCTools.closeStatement(prepDelData);
        con.commit();
        this.ch.closeConnection(con);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countDeleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        long count = 0L;
        for (List chunk : CollectionUtils.partitionList(chunkIds, (int)RDBJDBCTools.MAX_IN_CLAUSE)) {
            Connection con = this.ch.getRWConnection();
            PreparedStatement prepMeta = null;
            PreparedStatement prepData = null;
            try {
                RDBJDBCTools.PreparedStatementComponent inClause = RDBJDBCTools.createInStatement("ID", chunk, false);
                StringBuilder metaStatement = new StringBuilder("delete from " + this.tnMeta + " where ").append(inClause.getStatementComponent());
                StringBuilder dataStatement = new StringBuilder("delete from " + this.tnData + " where ").append(inClause.getStatementComponent());
                if (maxLastModifiedTime > 0L) {
                    metaStatement.append(" and LASTMOD <= ?");
                    dataStatement.append(" and not exists(select * from " + this.tnMeta + " where " + this.tnMeta + ".ID = " + this.tnData + ".ID and LASTMOD > ?)");
                }
                prepMeta = con.prepareStatement(metaStatement.toString());
                prepData = con.prepareStatement(dataStatement.toString());
                int mindex = 1;
                int dindex = 1;
                mindex = inClause.setParameters(prepMeta, mindex);
                dindex = inClause.setParameters(prepData, dindex);
                if (maxLastModifiedTime > 0L) {
                    prepMeta.setLong(mindex, maxLastModifiedTime);
                    prepData.setLong(dindex, maxLastModifiedTime);
                }
                int deletedMeta = prepMeta.executeUpdate();
                LOG.trace("delete-meta rows={}", (Object)deletedMeta);
                int deletedData = prepData.executeUpdate();
                LOG.trace("delete-data rows={}", (Object)deletedData);
                if (deletedMeta != deletedData) {
                    String message = String.format("chunk deletion affected different numbers of DATA records (%s) and META records (%s)", deletedData, deletedMeta);
                    LOG.info(message);
                }
                count += (long)deletedMeta;
            }
            finally {
                RDBJDBCTools.closeStatement(prepMeta);
                RDBJDBCTools.closeStatement(prepData);
                con.commit();
                this.ch.closeConnection(con);
            }
        }
        return count;
    }

    public Iterator<String> getAllChunkIds(long maxLastModifiedTime) throws Exception {
        return new ChunkIdIterator(this.ch, maxLastModifiedTime, this.tnMeta);
    }

    static {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            IDSIZE = md.getDigestLength() * 2;
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error("can't determine digest length for blob store", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private static class ChunkIdIterator
    extends AbstractIterator<String> {
        private long maxLastModifiedTime;
        private RDBConnectionHandler ch;
        private static int BATCHSIZE = 65536;
        private List<String> results = new LinkedList<String>();
        private String lastId = null;
        private String metaTable;

        public ChunkIdIterator(RDBConnectionHandler ch, long maxLastModifiedTime, String metaTable) {
            this.maxLastModifiedTime = maxLastModifiedTime;
            this.ch = ch;
            this.metaTable = metaTable;
        }

        protected String computeNext() {
            if (!this.results.isEmpty()) {
                return this.results.remove(0);
            }
            if (this.refill()) {
                return this.computeNext();
            }
            return (String)this.endOfData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean refill() {
            boolean bl;
            StringBuffer query = new StringBuffer();
            query.append("select ID from " + this.metaTable);
            if (this.maxLastModifiedTime > 0L) {
                query.append(" where LASTMOD <= ?");
                if (this.lastId != null) {
                    query.append(" and ID > ?");
                }
            } else if (this.lastId != null) {
                query.append(" where ID > ?");
            }
            query.append(" order by ID");
            Connection connection = null;
            connection = this.ch.getROConnection();
            PreparedStatement prep = null;
            ResultSet rs = null;
            try {
                prep = connection.prepareStatement(query.toString());
                int idx = 1;
                if (this.maxLastModifiedTime > 0L) {
                    prep.setLong(idx++, this.maxLastModifiedTime);
                }
                if (this.lastId != null) {
                    prep.setString(idx, this.lastId);
                }
                prep.setFetchSize(BATCHSIZE);
                rs = prep.executeQuery();
                while (rs.next()) {
                    this.lastId = rs.getString(1);
                    this.results.add(this.lastId);
                }
                rs.close();
                rs = null;
                bl = !this.results.isEmpty();
            }
            catch (Throwable throwable) {
                try {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(prep);
                    connection.commit();
                    this.ch.closeConnection(connection);
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.debug("error executing ID lookup", (Throwable)ex);
                    this.ch.rollbackConnection(connection);
                    this.ch.closeConnection(connection);
                    return false;
                }
            }
            RDBJDBCTools.closeResultSet(rs);
            RDBJDBCTools.closeStatement(prep);
            connection.commit();
            this.ch.closeConnection(connection);
            return bl;
        }
    }
}

