/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJDBCTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBDataSourceFactory {
    static final Logger LOG = LoggerFactory.getLogger(RDBDataSourceFactory.class);

    public static DataSource forJdbcUrl(String url, String username, String passwd, String specifiedDriverName) {
        String driverName = specifiedDriverName;
        if (driverName != null && !driverName.isEmpty()) {
            LOG.info("trying to load specified driver {}", (Object)driverName);
        } else {
            driverName = RDBJDBCTools.driverForDBType(RDBJDBCTools.jdbctype(url));
            if (driverName != null && !driverName.isEmpty()) {
                LOG.info("trying to load defaulted driver {}", (Object)driverName);
            }
        }
        if (driverName != null && !driverName.isEmpty()) {
            try {
                Class.forName(driverName);
            }
            catch (ClassNotFoundException ex) {
                LOG.debug("driver " + driverName + " not loaded", (Throwable)ex);
                LOG.info("driver {} not loaded ({})", (Object)driverName, ex.getClass());
            }
        }
        try {
            LOG.info("Getting driver for {}", (Object)url);
            Driver d = DriverManager.getDriver(url);
            String classname = "org.apache.tomcat.jdbc.pool.DataSource";
            try {
                Class<?> dsclazz = Class.forName(classname);
                DataSource ds = (DataSource)dsclazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                dsclazz.getMethod("setDriverClassName", String.class).invoke((Object)ds, d.getClass().getName());
                dsclazz.getMethod("setUsername", String.class).invoke((Object)ds, username);
                dsclazz.getMethod("setPassword", String.class).invoke((Object)ds, passwd);
                dsclazz.getMethod("setUrl", String.class).invoke((Object)ds, url);
                String interceptors = (String)SystemPropertySupplier.create((String)"org.apache.jackrabbit.oak.plugins.document.rdb.RDBDataSourceFactory.jdbcInterceptors", (Object)"SlowQueryReport(threshold=10000);ConnectionState;StatementCache").loggingTo(LOG).get();
                if (!interceptors.isEmpty()) {
                    dsclazz.getMethod("setJdbcInterceptors", String.class).invoke((Object)ds, interceptors);
                }
                return new CloseableDataSource(ds);
            }
            catch (Exception ex) {
                String message = "trying to create datasource " + classname;
                LOG.debug(message, (Throwable)ex);
                LOG.info(message + " (" + ex.getMessage() + ")");
                throw new DocumentStoreException(message, ex);
            }
        }
        catch (SQLException ex) {
            String message = "failed to to obtain driver for " + url;
            LOG.debug(message, (Throwable)ex);
            LOG.info(message + " (" + ex.getMessage() + ")");
            throw new DocumentStoreException(message, ex);
        }
    }

    public static DataSource forJdbcUrl(String url, String username, String passwd) {
        return RDBDataSourceFactory.forJdbcUrl(url, username, passwd, null);
    }

    private static class CloseableDataSource
    implements DataSource,
    Closeable {
        private DataSource ds;

        public CloseableDataSource(DataSource ds) {
            this.ds = ds;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.ds.getLogWriter();
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.ds.getLoginTimeout();
        }

        @Override
        public void setLogWriter(PrintWriter pw) throws SQLException {
            this.ds.setLogWriter(pw);
        }

        @Override
        public void setLoginTimeout(int t) throws SQLException {
            this.ds.setLoginTimeout(t);
        }

        @Override
        public boolean isWrapperFor(Class<?> c) throws SQLException {
            return c.isInstance(this) || c.isInstance(this.ds) || this.ds.isWrapperFor(c);
        }

        @Override
        public <T> T unwrap(Class<T> c) throws SQLException {
            return (T)(c.isInstance(this) ? this : (c.isInstance(this.ds) ? this.ds : this.ds.unwrap(c)));
        }

        @Override
        public void close() throws IOException {
            Class<?> dsclazz = this.ds.getClass();
            try {
                Method clmethod = dsclazz.getMethod("close", new Class[0]);
                clmethod.invoke((Object)this.ds, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                LOG.debug("Class " + dsclazz + " does not have close() method");
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Class " + dsclazz + " does not have close() method");
            }
            catch (InvocationTargetException e) {
                throw new IOException("trying to close datasource", e);
            }
            catch (IllegalAccessException e) {
                throw new IOException("trying to close datasource", e);
            }
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.ds.getConnection();
        }

        @Override
        public Connection getConnection(String user, String passwd) throws SQLException {
            return this.ds.getConnection(user, passwd);
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException();
        }

        public String toString() {
            return this.getClass().getName() + " wrapping a " + this.ds.toString();
        }
    }
}

