/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum FullGCMode {
    NONE,
    EMPTYPROPS,
    GAP_ORPHANS,
    GAP_ORPHANS_EMPTYPROPS,
    ALL_ORPHANS_EMPTYPROPS,
    ORPHANS_EMPTYPROPS_KEEP_ONE_USER_PROPS,
    ORPHANS_EMPTYPROPS_KEEP_ONE_ALL_PROPS,
    ORPHANS_EMPTYPROPS_UNMERGED_BC,
    ORPHANS_EMPTYPROPS_BETWEEN_CHECKPOINTS_NO_UNMERGED_BC,
    ORPHANS_EMPTYPROPS_BETWEEN_CHECKPOINTS_WITH_UNMERGED_BC;

    private static final Logger log;

    public static FullGCMode getMode(int mode) {
        switch (mode) {
            case 0: {
                return NONE;
            }
            case 1: {
                return EMPTYPROPS;
            }
            case 2: {
                return GAP_ORPHANS;
            }
            case 3: {
                return GAP_ORPHANS_EMPTYPROPS;
            }
            case 4: {
                return ALL_ORPHANS_EMPTYPROPS;
            }
            case 5: {
                return ORPHANS_EMPTYPROPS_KEEP_ONE_USER_PROPS;
            }
            case 6: {
                return ORPHANS_EMPTYPROPS_KEEP_ONE_ALL_PROPS;
            }
            case 7: {
                return ORPHANS_EMPTYPROPS_UNMERGED_BC;
            }
            case 8: {
                return ORPHANS_EMPTYPROPS_BETWEEN_CHECKPOINTS_NO_UNMERGED_BC;
            }
            case 9: {
                return ORPHANS_EMPTYPROPS_BETWEEN_CHECKPOINTS_WITH_UNMERGED_BC;
            }
        }
        log.warn("Unsupported full GC mode configuration value: {}. Resetting to NONE", (Object)mode);
        return NONE;
    }

    static {
        log = LoggerFactory.getLogger(FullGCMode.class);
    }
}

