/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.plugins.document.BackgroundWriteStats;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.PathComparator;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.MapFactory;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnsavedModifications {
    private static final Logger LOG = LoggerFactory.getLogger(UnsavedModifications.class);
    static final int BACKGROUND_MULTI_UPDATE_LIMIT = 100;
    private final ConcurrentMap<Path, Revision> map = MapFactory.getInstance().create();

    UnsavedModifications() {
    }

    @Nullable
    public Revision put(@NotNull Path path, @NotNull Revision revision) {
        block2: {
            Revision previous;
            Objects.requireNonNull(path);
            Objects.requireNonNull(revision);
            while (true) {
                if ((previous = (Revision)this.map.get(path)) == null) {
                    if (this.map.putIfAbsent(path, revision) != null) continue;
                    return null;
                }
                if (previous.compareRevisionTime(revision) >= 0) break block2;
                if (this.map.replace(path, previous, revision)) break;
            }
            return previous;
        }
        return null;
    }

    @Nullable
    public Revision get(Path path) {
        return (Revision)this.map.get(path);
    }

    @NotNull
    public java.util.Collection<Path> getPaths() {
        return this.map.keySet();
    }

    @NotNull
    public Iterable<Path> getPaths(@NotNull Revision start) {
        if (this.map.isEmpty()) {
            return Collections.emptyList();
        }
        return IterableUtils.transform((Iterable)IterableUtils.filter(this.map.entrySet(), input -> start.compareRevisionTime((Revision)input.getValue()) < 1), Map.Entry::getKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundWriteStats persist(@NotNull DocumentStore store, @NotNull Supplier<Revision> sweepRevision, @NotNull Snapshot snapshot, @NotNull Lock lock) {
        Revision sweepRev;
        TreeMap<Path, Revision> pending;
        BackgroundWriteStats stats = new BackgroundWriteStats();
        if (this.map.size() == 0) {
            return stats;
        }
        Objects.requireNonNull(store);
        Objects.requireNonNull(sweepRevision);
        Objects.requireNonNull(snapshot);
        Objects.requireNonNull(lock);
        Stopwatch sw = Stopwatch.createStarted();
        lock.lock();
        stats.lock = sw.elapsed(TimeUnit.MILLISECONDS);
        sw.reset().start();
        try {
            snapshot.acquiring(this.getMostRecentRevision());
            pending = new TreeMap<Path, Revision>(PathComparator.INSTANCE);
            pending.putAll(this.map);
            sweepRev = sweepRevision.get();
        }
        finally {
            lock.unlock();
        }
        stats.num = pending.size();
        ArrayList<UpdateOp> updates = new ArrayList<UpdateOp>();
        HashMap<Path, Revision> pathToRevision = new HashMap<Path, Revision>();
        for (Iterable batch : IterableUtils.partition(pending.entrySet(), (int)100)) {
            for (Map.Entry entry : batch) {
                Path p = (Path)entry.getKey();
                Revision r = (Revision)entry.getValue();
                if (p.isRoot()) continue;
                updates.add(UnsavedModifications.newUpdateOp(p, r));
                pathToRevision.put((Path)entry.getKey(), r);
            }
            if (updates.isEmpty()) continue;
            store.createOrUpdate(Collection.NODES, updates);
            ++stats.calls;
            for (Map.Entry entry : pathToRevision.entrySet()) {
                this.map.remove(entry.getKey(), entry.getValue());
                LOG.debug("Updated _lastRev to {} on {}", entry.getValue(), entry.getKey());
            }
            updates.clear();
            pathToRevision.clear();
        }
        Revision rootRev = (Revision)pending.get(Path.ROOT);
        if (rootRev != null) {
            Revision lastRev;
            UpdateOp rootUpdate = UnsavedModifications.newUpdateOp(Path.ROOT, rootRev);
            if (sweepRev != null) {
                NodeDocument.setSweepRevision(rootUpdate, sweepRev);
                LOG.debug("Updating _sweepRev to {}", (Object)sweepRev);
            }
            if ((lastRev = Utils.getRootDocument(store).getLastRev().get(rootRev.getClusterId())) != null) {
                NodeDocument.hasLastRev(rootUpdate, lastRev);
            }
            if (store.findAndUpdate(Collection.NODES, rootUpdate) == null) {
                throw new DocumentStoreException("Update of root document to _lastRev " + rootRev + " failed. Detected concurrent update");
            }
            ++stats.calls;
            this.map.remove(Path.ROOT, rootRev);
            LOG.debug("Updated _lastRev to {} on {}", (Object)rootRev, (Object)Path.ROOT);
            int n = rootRev.getClusterId();
            UpdateOp update = new UpdateOp(String.valueOf(n), false);
            update.set("lastWrittenRootRev", rootRev.toString());
            store.findAndUpdate(Collection.CLUSTER_NODES, update);
        }
        stats.write = sw.elapsed(TimeUnit.MILLISECONDS);
        return stats;
    }

    public String toString() {
        return this.map.toString();
    }

    private static UpdateOp newUpdateOp(Path path, Revision r) {
        UpdateOp updateOp = Commit.createUpdateOp(path, r, false);
        NodeDocument.setLastRev(updateOp, r);
        return updateOp;
    }

    private Revision getMostRecentRevision() {
        Revision rev = (Revision)this.map.get(Path.ROOT);
        if (rev == null) {
            for (Revision r : this.map.values()) {
                rev = Utils.max(rev, r);
            }
        }
        return rev;
    }

    public static interface Snapshot {
        public static final Snapshot IGNORE = new Snapshot(){

            @Override
            public void acquiring(Revision mostRecent) {
            }
        };

        public void acquiring(Revision var1);
    }
}

