/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.Block;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.FullGcNodeBin;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.SplitDocumentCleanUp;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoFullGcNodeBin;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoUtils;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoVersionGCSupport
extends VersionGCSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MongoVersionGCSupport.class);
    private static final long EXPLAIN_LOG_INTERVAL_MS = TimeUnit.HOURS.toMillis(24L);
    private final MongoDocumentStore store;
    private final BasicDBObject hint;
    private final BasicDBObject modifiedIdHint;
    private long lastExplainLogMs = -1L;
    private RevisionVector lastDefaultNoBranchDeletionRevs;
    private final int batchSize = (Integer)SystemPropertySupplier.create((String)"oak.mongo.queryDeletedDocsBatchSize", (Object)1000).get();
    private final MongoFullGcNodeBin fullGcBin;

    public MongoVersionGCSupport(MongoDocumentStore store) {
        this(store, false);
    }

    public MongoVersionGCSupport(MongoDocumentStore store, boolean fullGcBinEnabled) {
        super(store);
        this.store = store;
        if (MongoUtils.hasIndex(this.getNodeCollection(), "_sdType", "_sdMaxRevTime")) {
            this.hint = new BasicDBObject();
            this.hint.put((Object)"_sdType", (Object)1);
            this.hint.put((Object)"_sdMaxRevTime", (Object)1);
        } else {
            this.hint = null;
        }
        if (MongoUtils.hasIndex(this.getNodeCollection(), "_modified", "_id")) {
            this.modifiedIdHint = new BasicDBObject();
            this.modifiedIdHint.put((Object)"_modified", (Object)1);
            this.modifiedIdHint.put((Object)"_id", (Object)1);
        } else {
            this.modifiedIdHint = null;
        }
        this.fullGcBin = new MongoFullGcNodeBin(store, fullGcBinEnabled);
    }

    public CloseableIterable<NodeDocument> getPossiblyDeletedDocs(long fromModified, long toModified) {
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_deletedOnce", (Object)true), Filters.gte((String)"_modified", (Object)NodeDocument.getModifiedInSecs(fromModified)), Filters.lt((String)"_modified", (Object)NodeDocument.getModifiedInSecs(toModified))});
        FindIterable cursor = this.getNodeCollection().find(query).batchSize(this.batchSize);
        return CloseableIterable.wrap(IterableUtils.transform((Iterable)cursor, input -> this.store.convertFromDBObject(Collection.NODES, (DBObject)input)));
    }

    private Bson withIncludeExcludes(@NotNull Set<String> includes, @NotNull Set<String> excludes, Bson query) {
        Bson inclExcl = null;
        if (!includes.isEmpty()) {
            ArrayList<Bson> ors = new ArrayList<Bson>(includes.size());
            for (String incl : includes) {
                ors.add(Filters.regex((String)"_id", (String)(":" + incl)));
            }
            inclExcl = Filters.or(ors);
        }
        if (!excludes.isEmpty()) {
            ArrayList<Bson> ands = new ArrayList<Bson>(excludes.size());
            for (String excl : excludes) {
                ands.add(Filters.regex((String)"_id", (String)(":(?!" + excl + ")")));
            }
            if (inclExcl != null) {
                ands.add(inclExcl);
            }
            inclExcl = Filters.and(ands);
        }
        if (inclExcl == null) {
            return query;
        }
        return Filters.and((Bson[])new Bson[]{inclExcl, query});
    }

    private void logQueryExplain(String logMsg, @NotNull Bson query, Bson hint) {
        long timeSinceLastLog = System.currentTimeMillis() - this.lastExplainLogMs;
        if (timeSinceLastLog < EXPLAIN_LOG_INTERVAL_MS) {
            return;
        }
        BasicDBObject explainResult = MongoUtils.explain(this.store.getDatabase(), this.getNodeCollection(), query, hint);
        BasicDBObject winningPlan = MongoUtils.getWinningPlan(explainResult);
        BasicDBObject result = winningPlan == null ? explainResult : winningPlan;
        LOG.trace(logMsg, (Object)hint, (Object)result);
        this.lastExplainLogMs = System.currentTimeMillis();
    }

    @Override
    public Iterable<NodeDocument> getModifiedDocs(long fromModified, long toModified, int limit, @NotNull String fromId, @NotNull Set<String> includedPathPrefixes, @NotNull Set<String> excludedPathPrefixes) {
        LOG.info("getModifiedDocs fromModified: {} ({}), toModified: {} ({}), limit: {}, fromId: {}, includedPathPrefixes: {}, excludedPathPrefixes: {}", new Object[]{fromModified, Utils.timestampToString(fromModified), toModified, Utils.timestampToString(toModified), limit, fromId, includedPathPrefixes, excludedPathPrefixes});
        long fromModifiedQuery = "0000000".equals(fromId) ? NodeDocument.getModifiedInSecs(fromModified) : TimeUnit.MILLISECONDS.toSeconds(fromModified);
        Bson query = Filters.or((Bson[])new Bson[]{this.withIncludeExcludes(includedPathPrefixes, excludedPathPrefixes, Filters.and((Bson[])new Bson[]{Filters.eq((String)"_modified", (Object)fromModifiedQuery), Filters.gt((String)"_id", (Object)fromId)})), this.withIncludeExcludes(includedPathPrefixes, excludedPathPrefixes, Filters.and((Bson[])new Bson[]{Filters.gt((String)"_modified", (Object)fromModifiedQuery), Filters.lt((String)"_modified", (Object)NodeDocument.getModifiedInSecs(toModified))}))});
        Bson sort = Sorts.ascending((String[])new String[]{"_modified", "_id"});
        if (LOG.isTraceEnabled()) {
            this.logQueryExplain("fullGC query explain details, hint : {} - explain : {}", query, (Bson)this.modifiedIdHint);
        }
        if (LOG.isDebugEnabled()) {
            BsonDocument bson = query.toBsonDocument(BsonDocument.class, MongoClient.getDefaultCodecRegistry());
            LOG.debug("getModifiedDocs : query is {}", (Object)bson);
        }
        FindIterable cursor = this.getNodeCollection().find(query).hint((Bson)this.modifiedIdHint).sort(sort).limit(limit);
        return CloseableIterable.wrap(IterableUtils.transform((Iterable)cursor, input -> this.store.convertFromDBObject(Collection.NODES, (DBObject)input)));
    }

    @Override
    public Optional<NodeDocument> getDocument(String id, List<String> fields) {
        Optional<NodeDocument> optional;
        block10: {
            Bson query = Filters.eq((String)"_id", (Object)id);
            FindIterable result = this.getNodeCollection().find(query);
            if (fields != null && !fields.isEmpty()) {
                result.projection(Projections.include(fields));
            }
            MongoCursor cur = result.iterator();
            try {
                Optional<NodeDocument> optional2 = optional = cur.hasNext() ? Optional.ofNullable(this.store.convertFromDBObject(Collection.NODES, (DBObject)cur.next())) : Optional.empty();
                if (cur == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (cur != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error("getDocument() <- error while fetching data from Mongo", (Throwable)ex);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No Doc has been found with id [{}], retuning empty", (Object)id);
                    }
                    return Optional.empty();
                }
            }
            cur.close();
        }
        return optional;
    }

    @Override
    public long getDeletedOnceCount() {
        Bson query = Filters.eq((String)"_deletedOnce", (Object)Boolean.TRUE);
        return this.getNodeCollection().countDocuments(query);
    }

    @Override
    protected SplitDocumentCleanUp createCleanUp(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
        return new MongoSplitDocCleanUp(gcTypes, sweepRevs, oldestRevTimeStamp, stats);
    }

    @Override
    protected Iterable<NodeDocument> identifyGarbage(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp) {
        List<Bson> queries = this.createQueries(gcTypes, sweepRevs, oldestRevTimeStamp);
        Iterable<NodeDocument> allResults = Collections.emptyList();
        for (Bson query : queries) {
            Iterable iterable = IterableUtils.filter((Iterable)IterableUtils.transform((Iterable)this.getNodeCollection().find(query).maxTime(15L, TimeUnit.MINUTES).hint((Bson)this.hint), input -> this.store.convertFromDBObject(Collection.NODES, (DBObject)input)), input -> !MongoVersionGCSupport.isDefaultNoBranchSplitNewerThan(input, sweepRevs));
            allResults = IterableUtils.chainedIterable(allResults, (Iterable)iterable);
        }
        return allResults;
    }

    @Override
    public long getOldestDeletedOnceTimestamp(Clock clock, long precisionMs) {
        LOG.debug("getOldestDeletedOnceTimestamp() <- start");
        Bson query = Filters.eq((String)"_deletedOnce", (Object)Boolean.TRUE);
        Bson sort = Sorts.ascending((String[])new String[]{"_modified"});
        final ArrayList<Long> result = new ArrayList<Long>(1);
        this.getNodeCollection().find(query).sort(sort).limit(1).forEach((Block)new Block<BasicDBObject>(){

            public void apply(BasicDBObject document) {
                NodeDocument doc = MongoVersionGCSupport.this.store.convertFromDBObject(Collection.NODES, (DBObject)document);
                long modifiedMs = doc.getModified() * TimeUnit.SECONDS.toMillis(1L);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getOldestDeletedOnceTimestamp() -> {}", (Object)Utils.timestampToString(modifiedMs));
                }
                result.add(modifiedMs);
            }
        });
        if (result.isEmpty()) {
            LOG.debug("getOldestDeletedOnceTimestamp() -> none found, return current time");
            result.add(clock.getTime());
        }
        return (Long)result.get(0);
    }

    @Override
    public Optional<NodeDocument> getOldestModifiedDoc(Clock clock) {
        Optional<NodeDocument> optional;
        block8: {
            Bson query = Filters.exists((String)"_modified");
            Bson sort = Sorts.ascending((String[])new String[]{"_modified", "_id"});
            FindIterable limit = this.getNodeCollection().find(query).sort(sort).limit(1);
            MongoCursor cur = limit.iterator();
            try {
                Optional<NodeDocument> optional2 = optional = cur.hasNext() ? Optional.ofNullable(this.store.convertFromDBObject(Collection.NODES, (DBObject)cur.next())) : Optional.empty();
                if (cur == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cur != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error("getOldestModifiedDoc() <- error while fetching data from Mongo", (Throwable)ex);
                    LOG.info("No Modified Doc has been found, returning empty");
                    return Optional.empty();
                }
            }
            cur.close();
        }
        return optional;
    }

    private List<Bson> createQueries(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp) {
        ArrayList<Bson> result = new ArrayList<Bson>();
        ArrayList<Bson> orClauses = new ArrayList<Bson>();
        for (NodeDocument.SplitDocType type : gcTypes) {
            if (NodeDocument.SplitDocType.DEFAULT_NO_BRANCH != type) {
                orClauses.add(Filters.eq((String)"_sdType", (Object)type.typeCode()));
                continue;
            }
            result.addAll(this.queriesForDefaultNoBranch(sweepRevs, NodeDocument.getModifiedInSecs(oldestRevTimeStamp)));
        }
        result.add(Filters.and((Bson[])new Bson[]{Filters.or(orClauses), Filters.lt((String)"_sdMaxRevTime", (Object)NodeDocument.getModifiedInSecs(oldestRevTimeStamp))}));
        return result;
    }

    @NotNull
    private List<Bson> queriesForDefaultNoBranch(RevisionVector sweepRevs, long maxRevTimeInSecs) {
        ArrayList<Bson> result = new ArrayList<Bson>();
        for (Revision r : sweepRevs) {
            Revision dr;
            if (this.lastDefaultNoBranchDeletionRevs != null && (dr = this.lastDefaultNoBranchDeletionRevs.getRevision(r.getClusterId())) != null && dr.getTimestamp() == r.getTimestamp()) continue;
            String idSuffix = Utils.getPreviousIdFor(Path.ROOT, r, 0);
            idSuffix = idSuffix.substring(idSuffix.lastIndexOf(45));
            Bson idPathClause = Filters.or((Bson[])new Bson[]{Filters.regex((String)"_id", (Pattern)Pattern.compile(".*" + idSuffix)), Filters.and((Bson[])new Bson[]{Filters.regex((String)"_id", (Pattern)Pattern.compile("[^-]*")), Filters.regex((String)"_path", (Pattern)Pattern.compile(".*" + idSuffix))})});
            long minMaxRevTimeInSecs = Math.min(maxRevTimeInSecs, NodeDocument.getModifiedInSecs(r.getTimestamp()));
            result.add(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_sdType", (Object)NodeDocument.SplitDocType.DEFAULT_NO_BRANCH.typeCode()), Filters.lt((String)"_sdMaxRevTime", (Object)minMaxRevTimeInSecs), idPathClause}));
        }
        return result;
    }

    private void logSplitDocIdsTobeDeleted(Bson query) {
        BasicDBObject keys = new BasicDBObject("_id", (Object)1);
        ArrayList ids = new ArrayList();
        this.getNodeCollection().withReadPreference(this.store.getConfiguredReadPreference(Collection.NODES)).find(query).projection((Bson)keys).forEach(doc -> ids.add(MongoVersionGCSupport.getID(doc)));
        StringBuilder sb = new StringBuilder("Split documents with following ids were deleted as part of GC \n");
        sb.append(String.join((CharSequence)System.getProperty("line.separator"), ids));
        LOG.debug(sb.toString());
    }

    @Override
    public FullGcNodeBin getFullGCBin() {
        return this.fullGcBin;
    }

    private static String getID(BasicDBObject document) {
        return String.valueOf(document.get("_id"));
    }

    private MongoCollection<BasicDBObject> getNodeCollection() {
        return this.store.getDBCollection(Collection.NODES);
    }

    private class MongoSplitDocCleanUp
    extends SplitDocumentCleanUp {
        final Set<NodeDocument.SplitDocType> gcTypes;
        final RevisionVector sweepRevs;
        final long oldestRevTimeStamp;

        MongoSplitDocCleanUp(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
            super(MongoVersionGCSupport.this.store, stats, MongoVersionGCSupport.this.identifyGarbage(gcTypes, sweepRevs, oldestRevTimeStamp));
            this.gcTypes = gcTypes;
            this.sweepRevs = sweepRevs;
            this.oldestRevTimeStamp = oldestRevTimeStamp;
        }

        @Override
        protected void collectIdToBeDeleted(String id) {
        }

        @Override
        protected int deleteSplitDocuments() {
            List<Bson> queries = MongoVersionGCSupport.this.createQueries(this.gcTypes, this.sweepRevs, this.oldestRevTimeStamp);
            if (LOG.isDebugEnabled()) {
                for (Bson query : queries) {
                    MongoVersionGCSupport.this.logSplitDocIdsTobeDeleted(query);
                }
            }
            int cnt = 0;
            for (Bson query : queries) {
                cnt = (int)((long)cnt + MongoVersionGCSupport.this.getNodeCollection().deleteMany(query).getDeletedCount());
            }
            HashSet<Revision> deletionRevs = new HashSet<Revision>();
            for (Revision r : this.sweepRevs) {
                if (r.getTimestamp() <= this.oldestRevTimeStamp) {
                    deletionRevs.add(r);
                    continue;
                }
                deletionRevs.add(new Revision(this.oldestRevTimeStamp, 0, r.getClusterId()));
            }
            MongoVersionGCSupport.this.lastDefaultNoBranchDeletionRevs = new RevisionVector((Set<Revision>)deletionRevs);
            return cnt;
        }
    }
}

