/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.util.Set;
import javax.sql.DataSource;
import org.apache.jackrabbit.guava.common.base.Suppliers;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBMissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBVersionGCSupport;
import org.apache.jackrabbit.oak.spi.toggle.Feature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBDocumentNodeStoreBuilder
extends DocumentNodeStoreBuilder<RDBDocumentNodeStoreBuilder> {
    private static final Logger log = LoggerFactory.getLogger(RDBDocumentNodeStoreBuilder.class);

    public static RDBDocumentNodeStoreBuilder newRDBDocumentNodeStoreBuilder() {
        return new RDBDocumentNodeStoreBuilder();
    }

    public RDBDocumentNodeStoreBuilder setRDBConnection(DataSource ds) {
        this.setRDBConnection(ds, new RDBOptions());
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    public RDBDocumentNodeStoreBuilder setRDBConnection(DataSource ds, RDBOptions options) {
        this.setRDBConnection(ds, ds, options);
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    public RDBDocumentNodeStoreBuilder setRDBConnection(DataSource documentStoreDataSource, DataSource blobStoreDataSource) {
        this.setRDBConnection(documentStoreDataSource, blobStoreDataSource, new RDBOptions());
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    public RDBDocumentNodeStoreBuilder setRDBConnection(DataSource documentStoreDataSource, DataSource blobStoreDataSource, RDBOptions options) {
        this.documentStoreSupplier = Suppliers.memoize(() -> new RDBDocumentStore(documentStoreDataSource, this, options));
        if (this.blobStoreSupplier == null) {
            this.blobStoreSupplier = Suppliers.memoize(() -> new RDBBlobStore(blobStoreDataSource, this, options));
        }
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    @Override
    public VersionGCSupport createVersionGCSupport() {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof RDBDocumentStore) {
            return new RDBVersionGCSupport((RDBDocumentStore)store);
        }
        return super.createVersionGCSupport();
    }

    @Override
    public Iterable<ReferencedBlob> createReferencedBlobs(DocumentNodeStore ns) {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof RDBDocumentStore) {
            return () -> new RDBBlobReferenceIterator(ns, (RDBDocumentStore)store);
        }
        return super.createReferencedBlobs(ns);
    }

    @Override
    public MissingLastRevSeeker createMissingLastRevSeeker() {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof RDBDocumentStore) {
            return new RDBMissingLastRevSeeker((RDBDocumentStore)store, this.getClock());
        }
        return super.createMissingLastRevSeeker();
    }

    @Override
    public boolean isFullGCEnabled() {
        return false;
    }

    @Override
    public RDBDocumentNodeStoreBuilder setFullGCEnabled(boolean b) {
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    @Override
    public boolean isFullGCAuditLoggingEnabled() {
        return false;
    }

    @Override
    public RDBDocumentNodeStoreBuilder setFullGCAuditLoggingEnabled(boolean b) {
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    @Override
    public Set<String> getFullGCIncludePaths() {
        return Set.of();
    }

    @Override
    public RDBDocumentNodeStoreBuilder setFullGCIncludePaths(@NotNull String[] includePaths) {
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    @Override
    public Set<String> getFullGCExcludePaths() {
        return Set.of();
    }

    @Override
    public RDBDocumentNodeStoreBuilder setFullGCExcludePaths(@NotNull String[] excludePaths) {
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    @Override
    public RDBDocumentNodeStoreBuilder setFullGCMode(int v) {
        log.warn("FullGC modes are not supported for RDB");
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    @Override
    public int getFullGCMode() {
        return 0;
    }

    @Override
    public RDBDocumentNodeStoreBuilder setFullGcMaxAgeMillis(long v) {
        log.warn("FullGC Max Age is not supported for RDB");
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    @Override
    public long getFullGcMaxAgeMillis() {
        return 0L;
    }

    @Override
    public RDBDocumentNodeStoreBuilder setDocStoreFullGCFeature(@Nullable Feature docStoreFullGC) {
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    @Override
    @Nullable
    public Feature getDocStoreFullGCFeature() {
        return null;
    }

    @Override
    public boolean isEmbeddedVerificationEnabled() {
        return false;
    }

    @Override
    public RDBDocumentNodeStoreBuilder setEmbeddedVerificationEnabled(boolean b) {
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    @Override
    public RDBDocumentNodeStoreBuilder setDocStoreEmbeddedVerificationFeature(@Nullable Feature getDocStoreEmbeddedVerification) {
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    @Override
    @Nullable
    public Feature getDocStoreEmbeddedVerificationFeature() {
        return null;
    }
}

