/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.jackrabbit.guava.common.base.Suppliers;
import org.apache.jackrabbit.guava.common.cache.Cache;
import org.apache.jackrabbit.guava.common.cache.CacheBuilder;
import org.apache.jackrabbit.guava.common.cache.RemovalCause;
import org.apache.jackrabbit.guava.common.cache.RemovalListener;
import org.apache.jackrabbit.guava.common.cache.RemovalNotification;
import org.apache.jackrabbit.guava.common.cache.Weigher;
import org.apache.jackrabbit.guava.common.util.concurrent.MoreExecutors;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.cache.EmpiricalWeigher;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreStats;
import org.apache.jackrabbit.oak.plugins.blob.CachingBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.BlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreStats;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStats;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.JournalPropertyHandlerFactory;
import org.apache.jackrabbit.oak.plugins.document.LeaseCheckMode;
import org.apache.jackrabbit.oak.plugins.document.LocalDiffCache;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.NamePathRev;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.ThrottlingStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.ThrottlingStatsCollectorImpl;
import org.apache.jackrabbit.oak.plugins.document.TieredDiffCache;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.cache.NodeDocumentCache;
import org.apache.jackrabbit.oak.plugins.document.locks.NodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.memory.MemoryDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.EvictionListener;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCacheStats;
import org.apache.jackrabbit.oak.plugins.document.spi.lease.LeaseFailureHandler;
import org.apache.jackrabbit.oak.plugins.document.util.RevisionsKey;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.MemoryBlobStore;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStatsCollector;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.gc.LoggingGCMonitor;
import org.apache.jackrabbit.oak.spi.toggle.Feature;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentNodeStoreBuilder<T extends DocumentNodeStoreBuilder<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentNodeStoreBuilder.class);
    public static final long DEFAULT_MEMORY_CACHE_SIZE = 0x10000000L;
    public static final int DEFAULT_NODE_CACHE_PERCENTAGE = 34;
    public static final int DEFAULT_PREV_NO_PROP_CACHE_PERCENTAGE = 1;
    public static final int DEFAULT_PREV_DOC_CACHE_PERCENTAGE = 4;
    public static final int DEFAULT_CHILDREN_CACHE_PERCENTAGE = 15;
    public static final int DEFAULT_DIFF_CACHE_PERCENTAGE = 30;
    public static final int DEFAULT_CACHE_SEGMENT_COUNT = 16;
    public static final int DEFAULT_CACHE_STACK_MOVE_DISTANCE = 16;
    public static final int DEFAULT_UPDATE_LIMIT = 100000;
    private static final String DEFAULT_PERSISTENT_CACHE_URI = System.getProperty("oak.documentMK.persCache");
    static final int MANY_CHILDREN_THRESHOLD = Integer.getInteger("oak.documentMK.manyChildren", 50);
    private static final boolean LIRS_CACHE = !Boolean.getBoolean("oak.documentMK.guavaCache");
    static final int UPDATE_LIMIT = Integer.getInteger("update.limit", 100000);
    protected Supplier<DocumentStore> documentStoreSupplier = Suppliers.memoize(() -> new MemoryDocumentStore());
    protected Supplier<BlobStore> blobStoreSupplier;
    private DiffCache diffCache;
    private int clusterId = Integer.getInteger("oak.documentMK.clusterId", 0);
    private int asyncDelay = 1000;
    private long clusterIdReuseDelayAfterRecovery = 0L;
    private boolean timing;
    private boolean logging;
    private long recoveryDelayMillis = 0L;
    private long perfloggerInfoMillis = Long.MAX_VALUE;
    private String loggingPrefix;
    private LeaseCheckMode leaseCheck = ClusterNodeInfo.DEFAULT_LEASE_CHECK_MODE;
    private boolean isReadOnlyMode = false;
    private Feature prefetchFeature;
    private Feature docStoreThrottlingFeature;
    private Feature noChildOrderCleanupFeature;
    private Feature cancelInvalidationFeature;
    private Feature docStoreFullGCFeature;
    private Feature docStoreEmbeddedVerificationFeature;
    private Feature docStoreAvoidMergeLockFeature;
    private Feature prevNoPropCacheFeature;
    private Weigher<CacheValue, CacheValue> weigher = new EmpiricalWeigher();
    private long memoryCacheSize = 0x10000000L;
    private int nodeCachePercentage = 34;
    private int prevDocCachePercentage = 4;
    private int prevNoPropCachePercentage = 1;
    private int childrenCachePercentage = 15;
    private int diffCachePercentage = 30;
    private int cacheSegmentCount = 16;
    private int cacheStackMoveDistance = 16;
    private boolean useSimpleRevision;
    private boolean disableBranches;
    private boolean prefetchExternalChanges;
    private Clock clock = Clock.SIMPLE;
    private Executor executor;
    private String persistentCacheURI = DEFAULT_PERSISTENT_CACHE_URI;
    private PersistentCache persistentCache;
    private String journalCacheURI;
    private PersistentCache journalCache;
    private LeaseFailureHandler leaseFailureHandler;
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
    private BlobStoreStats blobStoreStats;
    private CacheStats blobStoreCacheStats;
    private DocumentStoreStatsCollector documentStoreStatsCollector;
    private ThrottlingStatsCollector throttlingStatsCollector;
    private DocumentNodeStoreStatsCollector nodeStoreStatsCollector;
    private Map<String, PersistentCacheStats> persistentCacheStats = new HashMap<String, PersistentCacheStats>();
    private boolean bundlingDisabled;
    private JournalPropertyHandlerFactory journalPropertyHandlerFactory = new JournalPropertyHandlerFactory();
    private int updateLimit = UPDATE_LIMIT;
    private int commitValueCacheSize = 10000;
    private boolean cacheEmptyCommitValue = false;
    private long maxRevisionAgeMillis = 86400000L;
    private long maxRevisionGCAgeMillis = TimeUnit.SECONDS.toMillis(86400L);
    private GCMonitor gcMonitor = new LoggingGCMonitor(LoggerFactory.getLogger(VersionGarbageCollector.class));
    private Predicate<Path> nodeCachePredicate = x -> true;
    private boolean clusterInvisible;
    private boolean throttlingEnabled;
    private int throttlingTimeMillis = 10;
    private int throttlingJobSchedulePeriodSecs = 20;
    private boolean avoidMergeLock;
    private boolean fullGCEnabled;
    private Set<String> fullGCIncludePaths = Set.of();
    private Set<String> fullGCExcludePaths = Set.of();
    private boolean embeddedVerificationEnabled = true;
    private int fullGCMode = 0;
    private long fullGCGeneration = 0L;
    private long fullGcMaxAgeMillis = TimeUnit.SECONDS.toMillis(86400L);
    private int fullGCBatchSize = 1000;
    private int fullGCProgressSize = 10000;
    private double fullGCDelayFactor = 2.0;
    private boolean fullGCAuditLoggingEnabled;
    private long suspendTimeoutMillis = 60000L;

    public static DocumentNodeStoreBuilder<?> newDocumentNodeStoreBuilder() {
        return new DocumentNodeStoreBuilder();
    }

    public DocumentNodeStore build() {
        return new DocumentNodeStore(this);
    }

    protected final T thisBuilder() {
        return (T)this;
    }

    public T setPersistentCache(String persistentCache) {
        this.persistentCacheURI = persistentCache;
        return this.thisBuilder();
    }

    public T setJournalCache(String journalCache) {
        this.journalCacheURI = journalCache;
        return this.thisBuilder();
    }

    public T setTiming(boolean timing) {
        this.timing = timing;
        return this.thisBuilder();
    }

    public boolean getTiming() {
        return this.timing;
    }

    public T setLogging(boolean logging) {
        this.logging = logging;
        return this.thisBuilder();
    }

    public boolean getLogging() {
        return this.logging;
    }

    public T setLoggingPrefix(String prefix) {
        this.loggingPrefix = prefix;
        return this.thisBuilder();
    }

    @Nullable
    String getLoggingPrefix() {
        return this.loggingPrefix;
    }

    @Deprecated
    public T setLeaseCheck(boolean leaseCheck) {
        this.leaseCheck = leaseCheck ? LeaseCheckMode.LENIENT : LeaseCheckMode.DISABLED;
        return this.thisBuilder();
    }

    @Deprecated
    public boolean getLeaseCheck() {
        return this.leaseCheck != LeaseCheckMode.DISABLED;
    }

    public T setLeaseCheckMode(LeaseCheckMode mode) {
        this.leaseCheck = mode;
        return this.thisBuilder();
    }

    LeaseCheckMode getLeaseCheckMode() {
        return this.leaseCheck;
    }

    public T setThrottlingEnabled(boolean b) {
        this.throttlingEnabled = b;
        return this.thisBuilder();
    }

    public boolean isThrottlingEnabled() {
        return this.throttlingEnabled;
    }

    public T setThrottlingTimeMillis(int v) {
        this.throttlingTimeMillis = v;
        return this.thisBuilder();
    }

    public int getThrottlingTimeMillis() {
        return this.throttlingTimeMillis;
    }

    public T setThrottlingJobSchedulePeriodSecs(int v) {
        this.throttlingJobSchedulePeriodSecs = v;
        return this.thisBuilder();
    }

    public int getThrottlingJobSchedulePeriodSecs() {
        return this.throttlingJobSchedulePeriodSecs;
    }

    public T setAvoidMergeLock(boolean b) {
        this.avoidMergeLock = b;
        return this.thisBuilder();
    }

    public boolean avoidMergeLock() {
        return this.avoidMergeLock;
    }

    public T setFullGCEnabled(boolean b) {
        this.fullGCEnabled = b;
        return this.thisBuilder();
    }

    public boolean isFullGCEnabled() {
        return this.fullGCEnabled;
    }

    public T setFullGCAuditLoggingEnabled(boolean b) {
        this.fullGCAuditLoggingEnabled = b;
        return this.thisBuilder();
    }

    public boolean isFullGCAuditLoggingEnabled() {
        return this.fullGCAuditLoggingEnabled;
    }

    public T setFullGCIncludePaths(@Nullable String[] includePaths) {
        this.fullGCIncludePaths = Objects.isNull(includePaths) || includePaths.length == 0 || Arrays.equals(includePaths, new String[]{"/"}) ? Set.of() : Arrays.stream(includePaths).filter(Objects::nonNull).filter(PathUtils::isValid).collect(Collectors.toUnmodifiableSet());
        return this.thisBuilder();
    }

    public Set<String> getFullGCIncludePaths() {
        return this.fullGCIncludePaths;
    }

    public T setFullGCExcludePaths(@Nullable String[] excludePaths) {
        this.fullGCExcludePaths = Objects.isNull(excludePaths) || excludePaths.length == 0 || Arrays.equals(excludePaths, new String[]{""}) ? Set.of() : Arrays.stream(excludePaths).filter(Objects::nonNull).filter(PathUtils::isValid).collect(Collectors.toUnmodifiableSet());
        return this.thisBuilder();
    }

    public Set<String> getFullGCExcludePaths() {
        return this.fullGCExcludePaths;
    }

    public T setEmbeddedVerificationEnabled(boolean b) {
        this.embeddedVerificationEnabled = b;
        return this.thisBuilder();
    }

    public boolean isEmbeddedVerificationEnabled() {
        return this.embeddedVerificationEnabled;
    }

    public T setFullGCMode(int v) {
        this.fullGCMode = v;
        return this.thisBuilder();
    }

    public int getFullGCMode() {
        return this.fullGCMode;
    }

    public T setFullGCGeneration(long v) {
        this.fullGCGeneration = v;
        return this.thisBuilder();
    }

    public long getFullGCGeneration() {
        return this.fullGCGeneration;
    }

    public T setFullGcMaxAgeMillis(long v) {
        this.fullGcMaxAgeMillis = v;
        return this.thisBuilder();
    }

    public long getFullGcMaxAgeMillis() {
        return this.fullGcMaxAgeMillis;
    }

    public T setFullGCBatchSize(int v) {
        this.fullGCBatchSize = v;
        return this.thisBuilder();
    }

    public int getFullGCBatchSize() {
        return this.fullGCBatchSize;
    }

    public T setFullGCProgressSize(int v) {
        this.fullGCProgressSize = v;
        return this.thisBuilder();
    }

    public int getFullGCProgressSize() {
        return this.fullGCProgressSize;
    }

    public T setFullGCDelayFactor(double v) {
        this.fullGCDelayFactor = v;
        return this.thisBuilder();
    }

    public double getFullGCDelayFactor() {
        return this.fullGCDelayFactor;
    }

    public T setReadOnlyMode() {
        this.isReadOnlyMode = true;
        return this.thisBuilder();
    }

    public boolean getReadOnlyMode() {
        return this.isReadOnlyMode;
    }

    public T setPrefetchFeature(@Nullable Feature prefetch) {
        this.prefetchFeature = prefetch;
        return this.thisBuilder();
    }

    @Nullable
    public Feature getPrefetchFeature() {
        return this.prefetchFeature;
    }

    public T setDocStoreThrottlingFeature(@Nullable Feature docStoreThrottling) {
        this.docStoreThrottlingFeature = docStoreThrottling;
        return this.thisBuilder();
    }

    @Nullable
    public Feature getDocStoreThrottlingFeature() {
        return this.docStoreThrottlingFeature;
    }

    public T setNoChildOrderCleanupFeature(@Nullable Feature noChildOrderCleanupFeature) {
        this.noChildOrderCleanupFeature = noChildOrderCleanupFeature;
        return this.thisBuilder();
    }

    @Nullable
    public Feature getNoChildOrderCleanupFeature() {
        return this.noChildOrderCleanupFeature;
    }

    public T setCancelInvalidationFeature(@Nullable Feature cancelInvalidation) {
        this.cancelInvalidationFeature = cancelInvalidation;
        return this.thisBuilder();
    }

    @Nullable
    public Feature getCancelInvalidationFeature() {
        return this.cancelInvalidationFeature;
    }

    public T setDocStoreFullGCFeature(@Nullable Feature docStoreFullGC) {
        this.docStoreFullGCFeature = docStoreFullGC;
        return this.thisBuilder();
    }

    public Feature getDocStoreFullGCFeature() {
        return this.docStoreFullGCFeature;
    }

    public T setDocStoreEmbeddedVerificationFeature(@Nullable Feature getDocStoreEmbeddedVerification) {
        this.docStoreEmbeddedVerificationFeature = getDocStoreEmbeddedVerification;
        return this.thisBuilder();
    }

    @Nullable
    public Feature getDocStoreEmbeddedVerificationFeature() {
        return this.docStoreEmbeddedVerificationFeature;
    }

    public Feature getDocStoreAvoidMergeLockFeature() {
        return this.docStoreAvoidMergeLockFeature;
    }

    public T setDocStoreAvoidMergeLockFeature(@Nullable Feature docStoreAvoidMergeLock) {
        this.docStoreAvoidMergeLockFeature = docStoreAvoidMergeLock;
        return this.thisBuilder();
    }

    public T setPrevNoPropCacheFeature(@Nullable Feature prevNoPropCacheFeature) {
        this.prevNoPropCacheFeature = prevNoPropCacheFeature;
        return this.thisBuilder();
    }

    @Nullable
    public Feature getPrevNoPropCacheFeature() {
        return this.prevNoPropCacheFeature;
    }

    public T setLeaseFailureHandler(LeaseFailureHandler leaseFailureHandler) {
        this.leaseFailureHandler = leaseFailureHandler;
        return this.thisBuilder();
    }

    public LeaseFailureHandler getLeaseFailureHandler() {
        return this.leaseFailureHandler;
    }

    public T setDocumentStore(DocumentStore documentStore) {
        this.documentStoreSupplier = () -> documentStore;
        return this.thisBuilder();
    }

    public DocumentStore getDocumentStore() {
        return this.documentStoreSupplier.get();
    }

    public DiffCache getDiffCache(int clusterId) {
        if (this.diffCache == null) {
            this.diffCache = new TieredDiffCache(this, clusterId);
        }
        return this.diffCache;
    }

    public T setBlobStore(BlobStore blobStore) {
        this.blobStoreSupplier = () -> blobStore;
        return this.thisBuilder();
    }

    public BlobStore getBlobStore() {
        if (this.blobStoreSupplier == null) {
            this.blobStoreSupplier = () -> new MemoryBlobStore();
        }
        BlobStore blobStore = this.blobStoreSupplier.get();
        this.configureBlobStore(blobStore);
        return blobStore;
    }

    public T setClusterId(int clusterId) {
        this.clusterId = clusterId;
        return this.thisBuilder();
    }

    public T setClusterInvisible(boolean invisible) {
        this.clusterInvisible = invisible;
        return this.thisBuilder();
    }

    public T setCacheSegmentCount(int cacheSegmentCount) {
        this.cacheSegmentCount = cacheSegmentCount;
        return this.thisBuilder();
    }

    public T setCacheStackMoveDistance(int cacheSegmentCount) {
        this.cacheStackMoveDistance = cacheSegmentCount;
        return this.thisBuilder();
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public boolean isClusterInvisible() {
        return this.clusterInvisible;
    }

    public T setAsyncDelay(int asyncDelay) {
        this.asyncDelay = asyncDelay;
        return this.thisBuilder();
    }

    public int getAsyncDelay() {
        return this.asyncDelay;
    }

    public T setClusterIdReuseDelayAfterRecovery(long clusterIdReuseDelayAfterRecovery) {
        this.clusterIdReuseDelayAfterRecovery = clusterIdReuseDelayAfterRecovery;
        return this.thisBuilder();
    }

    public long getClusterIdReuseDelayAfterRecovery() {
        return this.clusterIdReuseDelayAfterRecovery;
    }

    public Weigher<CacheValue, CacheValue> getWeigher() {
        return this.weigher;
    }

    public T withWeigher(Weigher<CacheValue, CacheValue> weigher) {
        this.weigher = weigher;
        return this.thisBuilder();
    }

    public T memoryCacheSize(long memoryCacheSize) {
        this.memoryCacheSize = memoryCacheSize;
        return this.thisBuilder();
    }

    public T memoryCacheDistribution(int nodeCachePercentage, int prevDocCachePercentage, int childrenCachePercentage, int diffCachePercentage, int prevNoPropCachePercentage) {
        Validate.checkArgument((nodeCachePercentage >= 0 ? 1 : 0) != 0);
        Validate.checkArgument((prevDocCachePercentage >= 0 ? 1 : 0) != 0);
        Validate.checkArgument((childrenCachePercentage >= 0 ? 1 : 0) != 0);
        Validate.checkArgument((diffCachePercentage >= 0 ? 1 : 0) != 0);
        Validate.checkArgument((prevNoPropCachePercentage >= 0 ? 1 : 0) != 0);
        Validate.checkArgument((nodeCachePercentage + prevDocCachePercentage + childrenCachePercentage + diffCachePercentage + prevNoPropCachePercentage < 100 ? 1 : 0) != 0);
        this.nodeCachePercentage = nodeCachePercentage;
        this.prevDocCachePercentage = prevDocCachePercentage;
        this.childrenCachePercentage = childrenCachePercentage;
        this.diffCachePercentage = diffCachePercentage;
        this.prevNoPropCachePercentage = prevNoPropCachePercentage;
        return this.thisBuilder();
    }

    public long getNodeCacheSize() {
        return this.memoryCacheSize * (long)this.nodeCachePercentage / 100L;
    }

    public long getPrevDocumentCacheSize() {
        return this.memoryCacheSize * (long)this.prevDocCachePercentage / 100L;
    }

    public long getPrevNoPropCacheSize() {
        if (!this.isPrevNoPropCacheEnabled()) {
            return 0L;
        }
        return this.memoryCacheSize * (long)this.prevNoPropCachePercentage / 100L;
    }

    public long getChildrenCacheSize() {
        return this.memoryCacheSize * (long)this.childrenCachePercentage / 100L;
    }

    public long getDocumentCacheSize() {
        return this.memoryCacheSize - this.getNodeCacheSize() - this.getPrevDocumentCacheSize() - this.getChildrenCacheSize() - this.getDiffCacheSize() - this.getPrevNoPropCacheSize();
    }

    public long getDiffCacheSize() {
        return this.memoryCacheSize * (long)this.diffCachePercentage / 100L;
    }

    public long getMemoryDiffCacheSize() {
        return this.getDiffCacheSize() / 2L;
    }

    public long getLocalDiffCacheSize() {
        return this.getDiffCacheSize() / 2L;
    }

    public T setUseSimpleRevision(boolean useSimpleRevision) {
        this.useSimpleRevision = useSimpleRevision;
        return this.thisBuilder();
    }

    public boolean isUseSimpleRevision() {
        return this.useSimpleRevision;
    }

    public Executor getExecutor() {
        if (this.executor == null) {
            return MoreExecutors.newDirectExecutorService();
        }
        return this.executor;
    }

    public T setExecutor(Executor executor) {
        this.executor = executor;
        return this.thisBuilder();
    }

    public T clock(Clock clock) {
        this.clock = clock;
        return this.thisBuilder();
    }

    public T setStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
        return this.thisBuilder();
    }

    public StatisticsProvider getStatisticsProvider() {
        return this.statisticsProvider;
    }

    public DocumentStoreStatsCollector getDocumentStoreStatsCollector() {
        if (this.documentStoreStatsCollector == null) {
            this.documentStoreStatsCollector = new DocumentStoreStats(this.statisticsProvider);
        }
        return this.documentStoreStatsCollector;
    }

    public T setDocumentStoreStatsCollector(DocumentStoreStatsCollector documentStoreStatsCollector) {
        this.documentStoreStatsCollector = documentStoreStatsCollector;
        return this.thisBuilder();
    }

    @NotNull
    public ThrottlingStatsCollector getThrottlingStatsCollector() {
        if (Objects.isNull(this.throttlingStatsCollector)) {
            this.throttlingStatsCollector = new ThrottlingStatsCollectorImpl(this.statisticsProvider);
        }
        return this.throttlingStatsCollector;
    }

    public T setThrottlingStatsCollector(@NotNull ThrottlingStatsCollector throttlingStatsCollector) {
        this.throttlingStatsCollector = throttlingStatsCollector;
        return this.thisBuilder();
    }

    public DocumentNodeStoreStatsCollector getNodeStoreStatsCollector() {
        if (this.nodeStoreStatsCollector == null) {
            this.nodeStoreStatsCollector = new DocumentNodeStoreStats(this.statisticsProvider);
        }
        return this.nodeStoreStatsCollector;
    }

    public T setNodeStoreStatsCollector(DocumentNodeStoreStatsCollector statsCollector) {
        this.nodeStoreStatsCollector = statsCollector;
        return this.thisBuilder();
    }

    @NotNull
    public Map<String, PersistentCacheStats> getPersistenceCacheStats() {
        return this.persistentCacheStats;
    }

    @Nullable
    public BlobStoreStats getBlobStoreStats() {
        return this.blobStoreStats;
    }

    @Nullable
    public CacheStats getBlobStoreCacheStats() {
        return this.blobStoreCacheStats;
    }

    public Clock getClock() {
        return this.clock;
    }

    public T disableBranches() {
        this.disableBranches = true;
        return this.thisBuilder();
    }

    public boolean isDisableBranches() {
        return this.disableBranches;
    }

    public T setBundlingDisabled(boolean enabled) {
        this.bundlingDisabled = enabled;
        return this.thisBuilder();
    }

    public boolean isBundlingDisabled() {
        return this.bundlingDisabled;
    }

    public T setPrefetchExternalChanges(boolean b) {
        this.prefetchExternalChanges = b;
        return this.thisBuilder();
    }

    public boolean isPrefetchExternalChanges() {
        return this.prefetchExternalChanges;
    }

    public T setJournalPropertyHandlerFactory(JournalPropertyHandlerFactory factory) {
        this.journalPropertyHandlerFactory = factory;
        return this.thisBuilder();
    }

    public JournalPropertyHandlerFactory getJournalPropertyHandlerFactory() {
        return this.journalPropertyHandlerFactory;
    }

    public T setUpdateLimit(int limit) {
        this.updateLimit = limit;
        return this.thisBuilder();
    }

    public int getUpdateLimit() {
        return this.updateLimit;
    }

    public T setCommitValueCacheSize(int cacheSize) {
        this.commitValueCacheSize = cacheSize;
        return this.thisBuilder();
    }

    public int getCommitValueCacheSize() {
        return this.commitValueCacheSize;
    }

    public T setCacheEmptyCommitValue(boolean enable) {
        this.cacheEmptyCommitValue = enable;
        return this.thisBuilder();
    }

    public boolean getCacheEmptyCommitValue() {
        return this.cacheEmptyCommitValue;
    }

    public T setJournalGCMaxAge(long maxRevisionAgeMillis) {
        this.maxRevisionAgeMillis = maxRevisionAgeMillis;
        return this.thisBuilder();
    }

    public long getJournalGCMaxAge() {
        return this.maxRevisionAgeMillis;
    }

    public T setRevisionGCMaxAge(long maxRevisionGCAgeMillis) {
        this.maxRevisionGCAgeMillis = maxRevisionGCAgeMillis;
        return this.thisBuilder();
    }

    public long getRevisionGCMaxAge() {
        return this.maxRevisionGCAgeMillis;
    }

    public T setSuspendTimeoutMillis(long suspendTimeoutMillis) {
        this.suspendTimeoutMillis = suspendTimeoutMillis;
        return this.thisBuilder();
    }

    public long getSuspendTimeoutMillis() {
        return this.suspendTimeoutMillis;
    }

    public T setRecoveryDelayMillis(long recoveryDelayMillis) {
        this.recoveryDelayMillis = recoveryDelayMillis;
        return this.thisBuilder();
    }

    public long getRecoveryDelayMillis() {
        return this.recoveryDelayMillis;
    }

    public T setPerfloggerInfoMillis(long perfloggerInfoMillis) {
        this.perfloggerInfoMillis = perfloggerInfoMillis;
        return this.thisBuilder();
    }

    public long getPerfloggerInfoMillis() {
        return this.perfloggerInfoMillis;
    }

    public T setGCMonitor(@NotNull GCMonitor gcMonitor) {
        this.gcMonitor = Objects.requireNonNull(gcMonitor);
        return this.thisBuilder();
    }

    public GCMonitor getGCMonitor() {
        return this.gcMonitor;
    }

    public VersionGCSupport createVersionGCSupport() {
        return new VersionGCSupport(this.getDocumentStore());
    }

    public Iterable<ReferencedBlob> createReferencedBlobs(DocumentNodeStore ns) {
        return () -> new BlobReferenceIterator(ns);
    }

    public MissingLastRevSeeker createMissingLastRevSeeker() {
        return new MissingLastRevSeeker(this.getDocumentStore(), this.getClock());
    }

    public Cache<PathRev, DocumentNodeState> buildNodeCache(DocumentNodeStore store) {
        return this.buildCache(CacheType.NODE, this.getNodeCacheSize(), store, null);
    }

    public Cache<NamePathRev, DocumentNodeState.Children> buildChildrenCache(DocumentNodeStore store) {
        return this.buildCache(CacheType.CHILDREN, this.getChildrenCacheSize(), store, null);
    }

    public Cache<CacheValue, StringValue> buildMemoryDiffCache() {
        return this.buildCache(CacheType.DIFF, this.getMemoryDiffCacheSize(), null, null);
    }

    public Cache<RevisionsKey, LocalDiffCache.Diff> buildLocalDiffCache() {
        return this.buildCache(CacheType.LOCAL_DIFF, this.getLocalDiffCacheSize(), null, null);
    }

    public Cache<CacheValue, NodeDocument> buildDocumentCache(DocumentStore docStore) {
        return this.buildCache(CacheType.DOCUMENT, this.getDocumentCacheSize(), null, docStore);
    }

    public Cache<StringValue, NodeDocument> buildPrevDocumentsCache(DocumentStore docStore) {
        return this.buildCache(CacheType.PREV_DOCUMENT, this.getPrevDocumentCacheSize(), null, docStore);
    }

    public NodeDocumentCache buildNodeDocumentCache(DocumentStore docStore, NodeDocumentLocks locks) {
        Cache<CacheValue, NodeDocument> nodeDocumentsCache = this.buildDocumentCache(docStore);
        CacheStats nodeDocumentsCacheStats = new CacheStats(nodeDocumentsCache, "Document-Documents", this.getWeigher(), this.getDocumentCacheSize());
        Cache<StringValue, NodeDocument> prevDocumentsCache = this.buildPrevDocumentsCache(docStore);
        CacheStats prevDocumentsCacheStats = new CacheStats(prevDocumentsCache, "Document-PrevDocuments", this.getWeigher(), this.getPrevDocumentCacheSize());
        return new NodeDocumentCache(nodeDocumentsCache, nodeDocumentsCacheStats, prevDocumentsCache, prevDocumentsCacheStats, locks);
    }

    private boolean isPrevNoPropCacheEnabled() {
        Feature prevNoPropFeature = this.getPrevNoPropCacheFeature();
        return prevNoPropFeature != null && prevNoPropFeature.isEnabled();
    }

    @Nullable
    public Cache<StringValue, StringValue> buildPrevNoPropCache() {
        if (!this.isPrevNoPropCacheEnabled() || this.getPrevNoPropCacheSize() == 0L) {
            return null;
        }
        return this.buildCache("PREV_NOPROP", this.getPrevNoPropCacheSize(), new CopyOnWriteArraySet());
    }

    @Deprecated
    public T setNodeCachePredicate(Predicate<String> p) {
        this.nodeCachePredicate = input -> input != null && p.test(input.toString());
        return this.thisBuilder();
    }

    @Deprecated
    public Predicate<String> getNodeCachePredicate() {
        return input -> input != null && this.nodeCachePredicate.test(Path.fromString(input));
    }

    public T setNodeCachePathPredicate(Predicate<Path> p) {
        this.nodeCachePredicate = p;
        return this.thisBuilder();
    }

    public Predicate<Path> getNodeCachePathPredicate() {
        return this.nodeCachePredicate;
    }

    private <K extends CacheValue, V extends CacheValue> Cache<K, V> buildCache(CacheType cacheType, long maxWeight, DocumentNodeStore docNodeStore, DocumentStore docStore) {
        CopyOnWriteArraySet<EvictionListener<K, V>> listeners = new CopyOnWriteArraySet<EvictionListener<K, V>>();
        Cache<K, V> cache = this.buildCache(cacheType.name(), maxWeight, listeners);
        PersistentCache p = null;
        if (cacheType == CacheType.DIFF || cacheType == CacheType.LOCAL_DIFF) {
            p = this.getJournalCache();
        }
        if (p == null) {
            p = this.getPersistentCache();
        }
        if (p != null) {
            PersistentCacheStats stats;
            if ((cache = p.wrap(docNodeStore, docStore, cache, cacheType, this.statisticsProvider)) instanceof EvictionListener) {
                listeners.add((EvictionListener)cache);
            }
            if ((stats = PersistentCache.getPersistentCacheStats(cache)) != null) {
                this.persistentCacheStats.put(cacheType.name(), stats);
            }
        }
        return cache;
    }

    public PersistentCache getPersistentCache() {
        if (this.persistentCacheURI == null) {
            return null;
        }
        if (this.persistentCache == null) {
            try {
                this.persistentCache = new PersistentCache(this.persistentCacheURI);
            }
            catch (Throwable e) {
                LOG.warn("Persistent cache not available; please disable the configuration", e);
                throw new IllegalArgumentException(e);
            }
        }
        return this.persistentCache;
    }

    PersistentCache getJournalCache() {
        if (this.journalCacheURI == null) {
            return null;
        }
        if (this.journalCache == null) {
            try {
                this.journalCache = new PersistentCache(this.journalCacheURI);
            }
            catch (Throwable e) {
                LOG.warn("Journal cache not available; please disable the configuration", e);
                throw new IllegalArgumentException(e);
            }
        }
        return this.journalCache;
    }

    private <K extends CacheValue, V extends CacheValue> Cache<K, V> buildCache(String module, long maxWeight, final Set<EvictionListener<K, V>> listeners) {
        if (LIRS_CACHE && maxWeight > 0L) {
            return CacheLIRS.newBuilder().module(module).weigher(new Weigher<K, V>(){

                public int weigh(K key, V value) {
                    return DocumentNodeStoreBuilder.this.weigher.weigh(key, value);
                }
            }).averageWeight(2000).maximumWeight(maxWeight).segmentCount(this.cacheSegmentCount).stackMoveDistance(this.cacheStackMoveDistance).recordStats().evictionCallback(new CacheLIRS.EvictionCallback<K, V>(){

                public void evicted(K key, V value, RemovalCause cause) {
                    for (EvictionListener l : listeners) {
                        l.evicted(key, value, cause);
                    }
                }
            }).build();
        }
        return CacheBuilder.newBuilder().concurrencyLevel(this.cacheSegmentCount).weigher(this.weigher).maximumWeight(maxWeight).recordStats().removalListener(new RemovalListener<K, V>(){

            public void onRemoval(RemovalNotification<K, V> notification) {
                for (EvictionListener l : listeners) {
                    l.evicted((CacheValue)notification.getKey(), (CacheValue)notification.getValue(), notification.getCause());
                }
            }
        }).build();
    }

    private void configureBlobStore(BlobStore blobStore) {
        if (blobStore instanceof AbstractBlobStore) {
            this.blobStoreStats = new BlobStoreStats(this.statisticsProvider);
            ((AbstractBlobStore)blobStore).setStatsCollector((BlobStatsCollector)this.blobStoreStats);
        }
        if (blobStore instanceof CachingBlobStore) {
            this.blobStoreCacheStats = ((CachingBlobStore)blobStore).getCacheStats();
        }
    }
}

