/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ServerAddress;
import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.TransactionBody;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.session.ServerSession;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoClock;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.jetbrains.annotations.NotNull;

class MongoSessionFactory {
    private final MongoClient client;
    private final ClientSessionOptions options;
    private final MongoClock clock;
    private BsonDocument clusterTime;
    private BsonTimestamp operationTime;

    MongoSessionFactory(@NotNull MongoClient client, @NotNull MongoClock clock) {
        this.client = client;
        this.clock = clock;
        this.options = ClientSessionOptions.builder().causallyConsistent(true).build();
    }

    ClientSession createClientSession() {
        ClientSession s = this.client.startSession(this.options);
        this.clock.advanceSession(s);
        return new TrackingClientSession(s);
    }

    private class TrackingClientSession
    implements ClientSession {
        private final ClientSession session;

        TrackingClientSession(ClientSession session) {
            this.session = session;
        }

        public ClientSessionOptions getOptions() {
            return this.session.getOptions();
        }

        public boolean isCausallyConsistent() {
            return this.session.isCausallyConsistent();
        }

        public Object getOriginator() {
            return this.session.getOriginator();
        }

        public ServerSession getServerSession() {
            return this.session.getServerSession();
        }

        public BsonTimestamp getOperationTime() {
            return this.session.getOperationTime();
        }

        public void advanceOperationTime(BsonTimestamp operationTime) {
            this.session.advanceOperationTime(operationTime);
        }

        public void advanceClusterTime(BsonDocument clusterTime) {
            this.session.advanceClusterTime(clusterTime);
        }

        public BsonDocument getClusterTime() {
            return this.session.getClusterTime();
        }

        public boolean hasActiveTransaction() {
            return this.session.hasActiveTransaction();
        }

        public boolean notifyMessageSent() {
            return this.session.notifyMessageSent();
        }

        @NotNull
        public TransactionOptions getTransactionOptions() {
            return this.session.getTransactionOptions();
        }

        public void startTransaction() {
            this.session.startTransaction();
        }

        public void startTransaction(@NotNull TransactionOptions options) {
            this.session.startTransaction(options);
        }

        public void commitTransaction() {
            this.session.commitTransaction();
        }

        public void abortTransaction() {
            this.session.abortTransaction();
        }

        public ServerAddress getPinnedServerAddress() {
            return this.session.getPinnedServerAddress();
        }

        @NotNull
        public <T> T withTransaction(@NotNull TransactionBody<T> transactionBody) {
            return (T)this.session.withTransaction(transactionBody);
        }

        @NotNull
        public <T> T withTransaction(@NotNull TransactionBody<T> transactionBody, @NotNull TransactionOptions options) {
            return (T)this.session.withTransaction(transactionBody, options);
        }

        public BsonDocument getRecoveryToken() {
            return this.session.getRecoveryToken();
        }

        public void setRecoveryToken(BsonDocument recoveryToken) {
            this.session.setRecoveryToken(recoveryToken);
        }

        public void close() {
            MongoSessionFactory.this.clock.advanceSessionAndClock(this.session);
            this.session.close();
        }

        public Object getTransactionContext() {
            return this.session.getTransactionContext();
        }

        public void setTransactionContext(ServerAddress address, Object transactionContext) {
            this.session.setTransactionContext(address, transactionContext);
        }

        public void clearTransactionContext() {
            this.session.clearTransactionContext();
        }

        public void setSnapshotTimestamp(BsonTimestamp snapshotTimestamp) {
            this.session.setSnapshotTimestamp(snapshotTimestamp);
        }

        public BsonTimestamp getSnapshotTimestamp() {
            return this.session.getSnapshotTimestamp();
        }

        public TimeoutContext getTimeoutContext() {
            return this.session.getTimeoutContext();
        }

        public void notifyOperationInitiated(Object operation) {
            this.session.notifyOperationInitiated(operation);
        }
    }
}

